/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.fx;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.svg.PresentationAttributes;
import org.eclipse.fx.formats.svg.svg.SpreadMethod;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PresentationAttributesUtil {
    private Supplier<SvgDefsElement> defSupplier;

    public PresentationAttributesUtil(Supplier<SvgDefsElement> defSupplier) {
        this.defSupplier = defSupplier;
    }

    public List<SvgElement> createBorder(Border b, final Region r) {
        boolean _equals = Objects.equal((Object)b, null);
        if (_equals) {
            return Collections.emptyList();
        }
        List _strokes = b.getStrokes();
        Functions.Function1<BorderStroke, List<SvgElement>> _function = new Functions.Function1<BorderStroke, List<SvgElement>>(){

            public List<SvgElement> apply(BorderStroke it) {
                return PresentationAttributesUtil.this.createBorderStroke(it, r);
            }
        };
        List _map = ListExtensions.map((List)_strokes, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toList((Iterable)_flatten);
    }

    public List<SvgElement> createBorderStroke(BorderStroke s, Region r) {
        boolean st;
        boolean w = s.getWidths().getBottom() == s.getWidths().getLeft() && s.getWidths().getBottom() == s.getWidths().getRight() && s.getWidths().getBottom() == s.getWidths().getTop();
        boolean c = Objects.equal((Object)s.getBottomStroke(), (Object)s.getLeftStroke()) && Objects.equal((Object)s.getBottomStroke(), (Object)s.getRightStroke()) && Objects.equal((Object)s.getBottomStroke(), (Object)s.getTopStroke());
        boolean bl = st = Objects.equal((Object)s.getBottomStyle(), (Object)s.getLeftStyle()) && Objects.equal((Object)s.getBottomStyle(), (Object)s.getRightStyle()) && Objects.equal((Object)s.getBottomStyle(), (Object)s.getTopStyle());
        if (w && c && st && PresentationAttributesUtil.checkRadii(s.getRadii())) {
            SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
            rv.setFill("transparent");
            Bounds _layoutBounds = r.getLayoutBounds();
            double _minX = _layoutBounds.getMinX();
            Insets _insets = s.getInsets();
            double _left = _insets.getLeft();
            double _plus = _minX + _left;
            String _string = Double.valueOf(_plus).toString();
            rv.setX(_string);
            Bounds _layoutBounds_1 = r.getLayoutBounds();
            double _minY = _layoutBounds_1.getMinY();
            Insets _insets_1 = s.getInsets();
            double _top = _insets_1.getTop();
            double _plus_1 = _minY + _top;
            String _string_1 = Double.valueOf(_plus_1).toString();
            rv.setY(_string_1);
            Bounds _layoutBounds_2 = r.getLayoutBounds();
            double _width = _layoutBounds_2.getWidth();
            Insets _insets_2 = s.getInsets();
            double _left_1 = _insets_2.getLeft();
            double _minus = _width - _left_1;
            Insets _insets_3 = s.getInsets();
            double _right = _insets_3.getRight();
            double _minus_1 = _minus - _right;
            String _string_2 = Double.valueOf(_minus_1).toString();
            rv.setWidth(_string_2);
            Bounds _layoutBounds_3 = r.getLayoutBounds();
            double _height = _layoutBounds_3.getHeight();
            Insets _insets_4 = s.getInsets();
            double _top_1 = _insets_4.getTop();
            double _minus_2 = _height - _top_1;
            Insets _insets_5 = s.getInsets();
            double _bottom = _insets_5.getBottom();
            double _minus_3 = _minus_2 - _bottom;
            String _string_3 = Double.valueOf(_minus_3).toString();
            rv.setHeight(_string_3);
            BorderWidths _widths = s.getWidths();
            double _bottom_1 = _widths.getBottom();
            String _string_4 = Double.valueOf(_bottom_1).toString();
            rv.setStroke_width(_string_4);
            Paint _bottomStroke = s.getBottomStroke();
            this.applyStroke(rv, _bottomStroke);
            return Collections.singletonList(rv);
        }
        InputOutput.println((Object)"====> Dup actions");
        return Collections.emptyList();
    }

    public static boolean checkRadii(CornerRadii r) {
        boolean ry;
        boolean rx = r.getBottomLeftHorizontalRadius() == r.getBottomRightHorizontalRadius() && r.getBottomLeftHorizontalRadius() == r.getTopLeftHorizontalRadius() && r.getBottomLeftHorizontalRadius() == r.getTopRightHorizontalRadius();
        boolean bl = ry = r.getBottomLeftVerticalRadius() == r.getBottomRightVerticalRadius() && r.getBottomLeftVerticalRadius() == r.getTopLeftVerticalRadius() && r.getBottomLeftVerticalRadius() == r.getTopRightVerticalRadius();
        return rx && ry;
    }

    public SvgElement createBackgroundFill(BackgroundFill f, Region r) {
        CornerRadii _radii = f.getRadii();
        boolean _checkRadii = PresentationAttributesUtil.checkRadii(_radii);
        if (_checkRadii) {
            SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
            CornerRadii _radii_1 = f.getRadii();
            double _bottomLeftHorizontalRadius = _radii_1.getBottomLeftHorizontalRadius();
            String _string = Double.valueOf(_bottomLeftHorizontalRadius).toString();
            rv.setRx(_string);
            CornerRadii _radii_2 = f.getRadii();
            double _bottomLeftVerticalRadius = _radii_2.getBottomLeftVerticalRadius();
            String _string_1 = Double.valueOf(_bottomLeftVerticalRadius).toString();
            rv.setRy(_string_1);
            Insets _insets = f.getInsets();
            double _left = _insets.getLeft();
            String _string_2 = Double.valueOf(_left).toString();
            rv.setX(_string_2);
            Insets _insets_1 = f.getInsets();
            double _top = _insets_1.getTop();
            String _string_3 = Double.valueOf(_top).toString();
            rv.setY(_string_3);
            Bounds _layoutBounds = r.getLayoutBounds();
            double _width = _layoutBounds.getWidth();
            Insets _insets_2 = f.getInsets();
            double _left_1 = _insets_2.getLeft();
            double _minus = _width - _left_1;
            Insets _insets_3 = f.getInsets();
            double _right = _insets_3.getRight();
            double _minus_1 = _minus - _right;
            String _string_4 = Double.valueOf(_minus_1).toString();
            rv.setWidth(_string_4);
            Bounds _layoutBounds_1 = r.getLayoutBounds();
            double _height = _layoutBounds_1.getHeight();
            Insets _insets_4 = f.getInsets();
            double _top_1 = _insets_4.getTop();
            double _minus_2 = _height - _top_1;
            Insets _insets_5 = f.getInsets();
            double _bottom = _insets_5.getBottom();
            double _minus_3 = _minus_2 - _bottom;
            String _string_5 = Double.valueOf(_minus_3).toString();
            rv.setHeight(_string_5);
            rv.setFill("transparent");
            Paint _fill = f.getFill();
            this.applyFill(rv, _fill);
            String _plus = r + " ===> ";
            String _fill_1 = rv.getFill();
            String _plus_1 = String.valueOf(_plus) + _fill_1;
            String _plus_2 = String.valueOf(_plus_1) + "; ";
            Paint _fill_2 = f.getFill();
            String _plus_3 = String.valueOf(_plus_2) + _fill_2;
            InputOutput.println((Object)_plus_3);
            return rv;
        }
        SvgPathElement rv_1 = SvgFactory.eINSTANCE.createSvgPathElement();
        return rv_1;
    }

    protected void _applyFill(PresentationAttributes e, Color p) {
        boolean _notEquals;
        String _rGBHex = FXToSvgUtils.toRGBHex(p);
        e.setFill(_rGBHex);
        double _opacity = p.getOpacity();
        boolean bl = _notEquals = _opacity != 1.0;
        if (_notEquals) {
            double _opacity_1 = p.getOpacity();
            String _string = Double.valueOf(_opacity_1).toString();
            e.setFill_opacity(_string);
        }
    }

    protected void _applyFill(PresentationAttributes e, ImagePattern p) {
        System.err.println("ImagePattern not yet supported");
    }

    protected void _applyFill(PresentationAttributes e, LinearGradient p) {
        SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
        String _generateUUID = EcoreUtil.generateUUID();
        l.setId(_generateUUID);
        String _xifexpression = null;
        boolean _isProportional = p.isProportional();
        if (_isProportional) {
            double _startX = p.getStartX();
            _xifexpression = FXToSvgUtils.toProportion(_startX);
        } else {
            double _startX_1 = p.getStartX();
            _xifexpression = Double.valueOf(_startX_1).toString();
        }
        l.setX1(_xifexpression);
        String _xifexpression_1 = null;
        boolean _isProportional_1 = p.isProportional();
        if (_isProportional_1) {
            double _endX = p.getEndX();
            _xifexpression_1 = FXToSvgUtils.toProportion(_endX);
        } else {
            double _endX_1 = p.getEndX();
            _xifexpression_1 = Double.valueOf(_endX_1).toString();
        }
        l.setX2(_xifexpression_1);
        String _xifexpression_2 = null;
        boolean _isProportional_2 = p.isProportional();
        if (_isProportional_2) {
            double _startY = p.getStartY();
            _xifexpression_2 = FXToSvgUtils.toProportion(_startY);
        } else {
            double _startY_1 = p.getStartY();
            _xifexpression_2 = Double.valueOf(_startY_1).toString();
        }
        l.setY1(_xifexpression_2);
        String _xifexpression_3 = null;
        boolean _isProportional_3 = p.isProportional();
        if (_isProportional_3) {
            double _endY = p.getEndY();
            _xifexpression_3 = FXToSvgUtils.toProportion(_endY);
        } else {
            double _endY_1 = p.getEndY();
            _xifexpression_3 = Double.valueOf(_endY_1).toString();
        }
        l.setY2(_xifexpression_3);
        CycleMethod _cycleMethod = p.getCycleMethod();
        SpreadMethod _spread = PresentationAttributesUtil.toSpread(_cycleMethod);
        l.setSpreadMethod(_spread);
        List _stops = p.getStops();
        for (Stop s : _stops) {
            EList _children = l.getChildren();
            SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
            _children.add((Object)_stop);
        }
        SvgDefsElement _get = this.defSupplier.get();
        EList _children_1 = _get.getChildren();
        _children_1.add((Object)l);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("url(#");
        String _id = l.getId();
        _builder.append(_id, "");
        _builder.append(")");
        e.setFill(_builder.toString());
    }

    protected void _applyFill(PresentationAttributes e, RadialGradient p) {
        System.err.println("RadialGradient not yet supported");
    }

    protected void _applyStroke(PresentationAttributes e, Color p) {
        boolean _notEquals;
        String _rGBHex = FXToSvgUtils.toRGBHex(p);
        e.setStroke(_rGBHex);
        double _opacity = p.getOpacity();
        boolean bl = _notEquals = _opacity != 0.0;
        if (_notEquals) {
            double _opacity_1 = p.getOpacity();
            String _string = Double.valueOf(_opacity_1).toString();
            e.setStroke_opacity(_string);
        }
    }

    protected void _applyStroke(PresentationAttributes e, ImagePattern p) {
        System.err.println("ImagePattern not yet supported");
    }

    protected void _applyStroke(PresentationAttributes e, LinearGradient p) {
        SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
        String _generateUUID = EcoreUtil.generateUUID();
        l.setId(_generateUUID);
        String _xifexpression = null;
        boolean _isProportional = p.isProportional();
        if (_isProportional) {
            double _startX = p.getStartX();
            _xifexpression = FXToSvgUtils.toProportion(_startX);
        } else {
            double _startX_1 = p.getStartX();
            _xifexpression = Double.valueOf(_startX_1).toString();
        }
        l.setX1(_xifexpression);
        String _xifexpression_1 = null;
        boolean _isProportional_1 = p.isProportional();
        if (_isProportional_1) {
            double _endX = p.getEndX();
            _xifexpression_1 = FXToSvgUtils.toProportion(_endX);
        } else {
            double _endX_1 = p.getEndX();
            _xifexpression_1 = Double.valueOf(_endX_1).toString();
        }
        l.setX2(_xifexpression_1);
        String _xifexpression_2 = null;
        boolean _isProportional_2 = p.isProportional();
        if (_isProportional_2) {
            double _startY = p.getStartY();
            _xifexpression_2 = FXToSvgUtils.toProportion(_startY);
        } else {
            double _startY_1 = p.getStartY();
            _xifexpression_2 = Double.valueOf(_startY_1).toString();
        }
        l.setY1(_xifexpression_2);
        String _xifexpression_3 = null;
        boolean _isProportional_3 = p.isProportional();
        if (_isProportional_3) {
            double _endY = p.getEndY();
            _xifexpression_3 = FXToSvgUtils.toProportion(_endY);
        } else {
            double _endY_1 = p.getEndY();
            _xifexpression_3 = Double.valueOf(_endY_1).toString();
        }
        l.setY2(_xifexpression_3);
        CycleMethod _cycleMethod = p.getCycleMethod();
        SpreadMethod _spread = PresentationAttributesUtil.toSpread(_cycleMethod);
        l.setSpreadMethod(_spread);
        List _stops = p.getStops();
        for (Stop s : _stops) {
            EList _children = l.getChildren();
            SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
            _children.add((Object)_stop);
        }
        SvgDefsElement _get = this.defSupplier.get();
        EList _children_1 = _get.getChildren();
        _children_1.add((Object)l);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("url(#");
        String _id = l.getId();
        _builder.append(_id, "");
        _builder.append(")");
        e.setStroke(_builder.toString());
    }

    protected void _applyStroke(PresentationAttributes e, RadialGradient p) {
        System.err.println("RadialGradient not yet supported");
    }

    public static SvgStopElement toStop(Stop s) {
        SvgStopElement e = SvgFactory.eINSTANCE.createSvgStopElement();
        Color _color = s.getColor();
        String _rGBHex = FXToSvgUtils.toRGBHex(_color);
        e.setStop_color(_rGBHex);
        double _offset = s.getOffset();
        String _string = Double.valueOf(_offset).toString();
        e.setOffset(_string);
        return e;
    }

    public static SpreadMethod toSpread(CycleMethod cm) {
        SpreadMethod _switchResult = null;
        if (cm != null) {
            switch (cm) {
                case NO_CYCLE: {
                    _switchResult = SpreadMethod.PAD;
                    break;
                }
                case REFLECT: {
                    _switchResult = SpreadMethod.REFLECT;
                    break;
                }
                case REPEAT: {
                    _switchResult = SpreadMethod.REPEAT;
                    break;
                }
            }
        }
        return _switchResult;
    }

    public void applyFill(PresentationAttributes e, Paint p) {
        if (p instanceof Color) {
            this._applyFill(e, (Color)p);
            return;
        }
        if (p instanceof ImagePattern) {
            this._applyFill(e, (ImagePattern)p);
            return;
        }
        if (p instanceof LinearGradient) {
            this._applyFill(e, (LinearGradient)p);
            return;
        }
        if (p instanceof RadialGradient) {
            this._applyFill(e, (RadialGradient)p);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, p).toString());
    }

    public void applyStroke(PresentationAttributes e, Paint p) {
        if (p instanceof Color) {
            this._applyStroke(e, (Color)p);
            return;
        }
        if (p instanceof ImagePattern) {
            this._applyStroke(e, (ImagePattern)p);
            return;
        }
        if (p instanceof LinearGradient) {
            this._applyStroke(e, (LinearGradient)p);
            return;
        }
        if (p instanceof RadialGradient) {
            this._applyStroke(e, (RadialGradient)p);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, p).toString());
    }
}

