/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.fx.PresentationAttributesUtil;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.fx.formats.svg.svg.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FXToSvg {
    private SvgSvgElement root;
    private SvgDefsElement defs;
    private Scene s;
    private Parent p;
    @Extension
    private PresentationAttributesUtil e = new PresentationAttributesUtil(new Supplier<SvgDefsElement>(){

        @Override
        public SvgDefsElement get() {
            return FXToSvg.this.getDefs();
        }
    });

    public FXToSvg(Scene s) {
        this.s = s;
    }

    public FXToSvg(Parent p) {
        this.p = p;
    }

    public SvgDefsElement getDefs() {
        boolean _equals = Objects.equal((Object)this.defs, null);
        if (_equals) {
            SvgDefsElement _createSvgDefsElement;
            this.defs = _createSvgDefsElement = SvgFactory.eINSTANCE.createSvgDefsElement();
            EList _children = this.root.getChildren();
            _children.add(0, (Object)this.defs);
        }
        return this.defs;
    }

    public SvgSvgElement getSvgRoot() {
        boolean _equals = Objects.equal((Object)this.root, null);
        if (_equals) {
            boolean _notEquals;
            SvgSvgElement _createSvgSvgElement;
            this.root = _createSvgSvgElement = SvgFactory.eINSTANCE.createSvgSvgElement();
            boolean bl = _notEquals = !Objects.equal((Object)this.s, null);
            if (_notEquals) {
                boolean _notEquals_1;
                double _width = this.s.getWidth();
                String _string = Double.valueOf(_width).toString();
                this.root.setWidth(_string);
                double _height = this.s.getHeight();
                String _string_1 = Double.valueOf(_height).toString();
                this.root.setHeight(_string_1);
                Paint _fill = this.s.getFill();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_fill, null);
                if (_notEquals_1) {
                    Paint _fill_1 = this.s.getFill();
                    this.e.applyFill(this.root, _fill_1);
                }
                EList _children = this.root.getChildren();
                Parent _root = this.s.getRoot();
                SvgElement _transform = this.transform((Node)_root);
                _children.add((Object)_transform);
            } else {
                SvgSvgElement _createSvgSvgElement_1;
                this.root = _createSvgSvgElement_1 = SvgFactory.eINSTANCE.createSvgSvgElement();
                Bounds _layoutBounds = this.p.getLayoutBounds();
                double _width_1 = _layoutBounds.getWidth();
                String _string_2 = Double.valueOf(_width_1).toString();
                this.root.setWidth(_string_2);
                Bounds _layoutBounds_1 = this.p.getLayoutBounds();
                double _height_1 = _layoutBounds_1.getHeight();
                String _string_3 = Double.valueOf(_height_1).toString();
                this.root.setHeight(_string_3);
                SvgElement _transform_1 = this.transform((Node)this.p);
                SvgGElement rr = (SvgGElement)_transform_1;
                rr.setTransform(null);
                EList _children_1 = this.root.getChildren();
                _children_1.add((Object)rr);
            }
        }
        return this.root;
    }

    protected SvgElement _transform(final Region r) {
        boolean _notEquals_5;
        boolean _notEquals;
        SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
        boolean _isVisible = r.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        e.setVisibility(_visibility);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("translate(");
        Bounds _boundsInParent = r.getBoundsInParent();
        double _minX = _boundsInParent.getMinX();
        _builder.append((Object)_minX, "");
        _builder.append(",");
        Bounds _boundsInParent_1 = r.getBoundsInParent();
        double _minY = _boundsInParent_1.getMinY();
        _builder.append((Object)_minY, "");
        _builder.append(")");
        e.setTransform(_builder.toString());
        Shape _shape = r.getShape();
        boolean bl = _notEquals = !Objects.equal((Object)_shape, null);
        if (_notEquals) {
            Border _border;
            boolean _notEquals_2;
            boolean _notEquals_1;
            SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
            String _generateUUID = EcoreUtil.generateUUID();
            cp.setId(_generateUUID);
            EList _children = cp.getChildren();
            Shape _shape_1 = r.getShape();
            SvgElement _transform = this.transform((Node)_shape_1);
            _children.add((Object)_transform);
            SvgDefsElement _defs = this.getDefs();
            EList _children_1 = _defs.getChildren();
            _children_1.add((Object)cp);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("url(#");
            String _id = cp.getId();
            _builder_1.append(_id, "");
            _builder_1.append(")");
            e.setClip_path(_builder_1.toString());
            Background _background = r.getBackground();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_background, null);
            if (_notEquals_1) {
                EList _children_2 = e.getChildren();
                Background _background_1 = r.getBackground();
                List _fills = _background_1.getFills();
                Functions.Function1<BackgroundFill, SvgElement> _function = new Functions.Function1<BackgroundFill, SvgElement>(){

                    public SvgElement apply(BackgroundFill it) {
                        return FXToSvg.this.e.createBackgroundFill(it, r);
                    }
                };
                List _map = ListExtensions.map((List)_fills, (Functions.Function1)_function);
                List _list = IterableExtensions.toList((Iterable)_map);
                Iterables.addAll((Collection)_children_2, (Iterable)_list);
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_border = r.getBorder()), null);
            if (_notEquals_2) {
                EList _children_3 = e.getChildren();
                Border _border_1 = r.getBorder();
                List<SvgElement> _createBorder = this.e.createBorder(_border_1, r);
                Iterables.addAll((Collection)_children_3, _createBorder);
            }
        } else {
            Border _border_2;
            boolean _notEquals_4;
            boolean _notEquals_3;
            Background _background_2 = r.getBackground();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_background_2, null);
            if (_notEquals_3) {
                EList _children_4 = e.getChildren();
                Background _background_3 = r.getBackground();
                List _fills_1 = _background_3.getFills();
                Functions.Function1<BackgroundFill, SvgElement> _function_1 = new Functions.Function1<BackgroundFill, SvgElement>(){

                    public SvgElement apply(BackgroundFill it) {
                        return FXToSvg.this.e.createBackgroundFill(it, r);
                    }
                };
                List _map_1 = ListExtensions.map((List)_fills_1, (Functions.Function1)_function_1);
                List _list_1 = IterableExtensions.toList((Iterable)_map_1);
                Iterables.addAll((Collection)_children_4, (Iterable)_list_1);
            }
            boolean bl5 = _notEquals_4 = !Objects.equal((Object)(_border_2 = r.getBorder()), null);
            if (_notEquals_4) {
                EList _children_5 = e.getChildren();
                Border _border_3 = r.getBorder();
                List<SvgElement> _createBorder_1 = this.e.createBorder(_border_3, r);
                Iterables.addAll((Collection)_children_5, _createBorder_1);
            }
        }
        EList _children_6 = e.getChildren();
        ObservableList _childrenUnmodifiable = r.getChildrenUnmodifiable();
        Functions.Function1<Node, Boolean> _function_2 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return it.isVisible();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_childrenUnmodifiable, (Functions.Function1)_function_2);
        Functions.Function1<Node, SvgElement> _function_3 = new Functions.Function1<Node, SvgElement>(){

            public SvgElement apply(Node it) {
                return FXToSvg.this.transform(it);
            }
        };
        Iterable _map_2 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_3);
        List _list_2 = IterableExtensions.toList((Iterable)_map_2);
        Iterables.addAll((Collection)_children_6, (Iterable)_list_2);
        Node _clip = r.getClip();
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)_clip, null);
        if (_notEquals_5) {
            Node _clip_1 = r.getClip();
            String _plus = "Region-Clip " + _clip_1;
            InputOutput.println((Object)_plus);
            SvgClipPathElement cp_1 = SvgFactory.eINSTANCE.createSvgClipPathElement();
            String _generateUUID_1 = EcoreUtil.generateUUID();
            cp_1.setId(_generateUUID_1);
            EList _children_7 = cp_1.getChildren();
            Node _clip_2 = r.getClip();
            SvgElement _transform_1 = this.transform(_clip_2);
            _children_7.add((Object)_transform_1);
            SvgDefsElement _defs_1 = this.getDefs();
            EList _children_8 = _defs_1.getChildren();
            _children_8.add((Object)cp_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("url(#");
            String _id_1 = cp_1.getId();
            _builder_2.append(_id_1, "");
            _builder_2.append(")");
            e.setClip_path(_builder_2.toString());
        }
        return e;
    }

    protected SvgElement _transform(Group g) {
        boolean _notEquals;
        SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
        boolean _isVisible = g.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        e.setVisibility(_visibility);
        EList _children = e.getChildren();
        ObservableList _childrenUnmodifiable = g.getChildrenUnmodifiable();
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return it.isVisible();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_childrenUnmodifiable, (Functions.Function1)_function);
        Functions.Function1<Node, SvgElement> _function_1 = new Functions.Function1<Node, SvgElement>(){

            public SvgElement apply(Node it) {
                return FXToSvg.this.transform(it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        List _list = IterableExtensions.toList((Iterable)_map);
        Iterables.addAll((Collection)_children, (Iterable)_list);
        Node _clip = g.getClip();
        boolean bl = _notEquals = !Objects.equal((Object)_clip, null);
        if (_notEquals) {
            Node _clip_1 = g.getClip();
            String _plus = "Group-CLIP: " + _clip_1;
            InputOutput.println((Object)_plus);
            SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
            String _generateUUID = EcoreUtil.generateUUID();
            cp.setId(_generateUUID);
            EList _children_1 = cp.getChildren();
            Node _clip_2 = g.getClip();
            SvgElement _transform = this.transform(_clip_2);
            _children_1.add((Object)_transform);
            SvgDefsElement _defs = this.getDefs();
            EList _children_2 = _defs.getChildren();
            _children_2.add((Object)cp);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("url(#");
            String _id = cp.getId();
            _builder.append(_id, "");
            _builder.append(")");
            e.setClip_path(_builder.toString());
        }
        return e;
    }

    protected SvgElement _transform(ImageView v) {
        SvgImageElement e = SvgFactory.eINSTANCE.createSvgImageElement();
        boolean _isVisible = v.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        e.setVisibility(_visibility);
        return e;
    }

    protected SvgElement _transform(Arc a) {
        SvgPathElement e = FXToSvgUtils.createPath((Shape)a);
        boolean _isVisible = a.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        e.setVisibility(_visibility);
        Paint _fill = a.getFill();
        this.e.applyFill(e, _fill);
        return e;
    }

    protected SvgElement _transform(Circle c) {
        InputOutput.print((Object)"Circle arc");
        return null;
    }

    protected SvgElement _transform(Ellipse e) {
        InputOutput.print((Object)"Ellipse arc");
        return null;
    }

    protected SvgElement _transform(Line e) {
        InputOutput.print((Object)"Line arc");
        return null;
    }

    protected SvgElement _transform(Path p) {
        boolean _notEquals;
        SvgPathElement e = FXToSvgUtils.createPath((Shape)p);
        boolean _isVisible = p.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        e.setVisibility(_visibility);
        Paint _fill = p.getFill();
        this.e.applyFill(e, _fill);
        Node _clip = p.getClip();
        boolean bl = _notEquals = !Objects.equal((Object)_clip, null);
        if (_notEquals) {
            Node _clip_1 = p.getClip();
            String _plus = "PATH_CLIP:" + _clip_1;
            InputOutput.println((Object)_plus);
            SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
            String _generateUUID = EcoreUtil.generateUUID();
            cp.setId(_generateUUID);
            EList _children = cp.getChildren();
            Node _clip_2 = p.getClip();
            SvgElement _transform = this.transform(_clip_2);
            _children.add((Object)_transform);
            SvgDefsElement _defs = this.getDefs();
            EList _children_1 = _defs.getChildren();
            _children_1.add((Object)cp);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("url(#");
            String _id = cp.getId();
            _builder.append(_id, "");
            _builder.append(")");
            e.setClip_path(_builder.toString());
        }
        return e;
    }

    protected SvgElement _transform(Polygon e) {
        InputOutput.print((Object)"Polygon arc");
        return null;
    }

    protected SvgElement _transform(Polyline e) {
        InputOutput.print((Object)"Polyline arc");
        return null;
    }

    protected SvgElement _transform(QuadCurve e) {
        InputOutput.print((Object)"QuadCurve arc");
        return null;
    }

    protected SvgElement _transform(Rectangle e) {
        SvgRectElement r = SvgFactory.eINSTANCE.createSvgRectElement();
        double _x = e.getX();
        String _string = Double.valueOf(_x).toString();
        r.setX(_string);
        double _y = e.getY();
        String _string_1 = Double.valueOf(_y).toString();
        r.setY(_string_1);
        double _width = e.getWidth();
        String _string_2 = Double.valueOf(_width).toString();
        r.setWidth(_string_2);
        double _height = e.getHeight();
        String _string_3 = Double.valueOf(_height).toString();
        r.setHeight(_string_3);
        boolean _isVisible = e.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        r.setVisibility(_visibility);
        Paint _fill = e.getFill();
        this.e.applyFill(r, _fill);
        return r;
    }

    protected SvgElement _transform(SVGPath e) {
        SvgPathElement p = SvgFactory.eINSTANCE.createSvgPathElement();
        String _content = e.getContent();
        p.setD(_content);
        return p;
    }

    protected SvgElement _transform(Text e) {
        SvgPathElement p = FXToSvgUtils.createPath((Shape)e);
        boolean _isVisible = e.isVisible();
        Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
        p.setVisibility(_visibility);
        Paint _fill = e.getFill();
        this.e.applyFill(p, _fill);
        SvgGElement g = SvgFactory.eINSTANCE.createSvgGElement();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("translate(");
        Bounds _boundsInParent = e.getBoundsInParent();
        double _minX = _boundsInParent.getMinX();
        _builder.append((Object)_minX, "");
        _builder.append(",");
        Bounds _boundsInParent_1 = e.getBoundsInParent();
        double _minY = _boundsInParent_1.getMinY();
        double _baselineOffset = e.getBaselineOffset();
        double _plus = _minY + _baselineOffset;
        _builder.append((Object)_plus, "");
        _builder.append(")");
        g.setTransform(_builder.toString());
        EList _children = g.getChildren();
        _children.add((Object)p);
        return g;
    }

    public SvgElement transform(Node g) {
        if (g instanceof Group) {
            return this._transform((Group)g);
        }
        if (g instanceof Region) {
            return this._transform((Region)g);
        }
        if (g instanceof Arc) {
            return this._transform((Arc)g);
        }
        if (g instanceof Circle) {
            return this._transform((Circle)g);
        }
        if (g instanceof Ellipse) {
            return this._transform((Ellipse)g);
        }
        if (g instanceof Line) {
            return this._transform((Line)g);
        }
        if (g instanceof Path) {
            return this._transform((Path)g);
        }
        if (g instanceof Polygon) {
            return this._transform((Polygon)g);
        }
        if (g instanceof Polyline) {
            return this._transform((Polyline)g);
        }
        if (g instanceof QuadCurve) {
            return this._transform((QuadCurve)g);
        }
        if (g instanceof Rectangle) {
            return this._transform((Rectangle)g);
        }
        if (g instanceof SVGPath) {
            return this._transform((SVGPath)g);
        }
        if (g instanceof Text) {
            return this._transform((Text)g);
        }
        if (g instanceof ImageView) {
            return this._transform((ImageView)g);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(g).toString());
    }
}

