/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.ldef.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.code.editor.ldef.lDef.CodeIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.Codegeneration;
import org.eclipse.fx.code.editor.ldef.lDef.ConfigValue;
import org.eclipse.fx.code.editor.ldef.lDef.E4CodeGeneration;
import org.eclipse.fx.code.editor.ldef.lDef.Integration;
import org.eclipse.fx.code.editor.ldef.lDef.JavaCodeGeneration;
import org.eclipse.fx.code.editor.ldef.lDef.JavaFXIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.LanguageDef;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalHighlighting;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Paritioning;
import org.eclipse.fx.code.editor.ldef.lDef.Partition;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_SingleLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Partitioner;
import org.eclipse.fx.code.editor.ldef.lDef.Partitioner_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_CharacterRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_PatternRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_SingleLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Token;
import org.eclipse.fx.code.editor.ldef.lDef.WhitespaceRule;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaFXCodeGenerator {
    public Object generate(LanguageDef model, IFileSystemAccess access) {
        boolean _notEquals;
        Object _xblockexpression = null;
        Integration _integration = model.getIntegration();
        EList<CodeIntegration> _codeIntegrationList = _integration.getCodeIntegrationList();
        Iterable _filter = Iterables.filter(_codeIntegrationList, JavaFXIntegration.class);
        JavaFXIntegration javaFXIntegration = (JavaFXIntegration)IterableExtensions.head((Iterable)_filter);
        Object _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)javaFXIntegration, null);
        if (_notEquals) {
            boolean _notEquals_2;
            boolean _notEquals_1;
            Object _xblockexpression_1 = null;
            EList<Codegeneration> _codegenerationList = javaFXIntegration.getCodegenerationList();
            Iterable _filter_1 = Iterables.filter(_codegenerationList, JavaCodeGeneration.class);
            JavaCodeGeneration javaCodeGen = (JavaCodeGeneration)IterableExtensions.head((Iterable)_filter_1);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)javaCodeGen, null);
            if (_notEquals_1) {
                String project = this.findProjectResource(javaCodeGen);
                String _xifexpression_1 = null;
                boolean _equals = Objects.equal((Object)project, null);
                _xifexpression_1 = _equals ? "" : "/" + project + "/src/";
                String prefix = _xifexpression_1;
                String basePackage = javaCodeGen.getName();
                String _replace = basePackage.replace(".", "/");
                String _plus = String.valueOf(prefix) + _replace;
                String _plus_1 = String.valueOf(_plus) + "/";
                String _name = model.getName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                String _plus_2 = String.valueOf(_plus_1) + _firstUpper;
                String _plus_3 = String.valueOf(_plus_2) + "PartitionScanner.java";
                CharSequence _generateRulePartitioner = this.generateRulePartitioner(model, basePackage);
                access.generateFile(_plus_3, _generateRulePartitioner);
                String _replace_1 = basePackage.replace(".", "/");
                String _plus_4 = String.valueOf(prefix) + _replace_1;
                String _plus_5 = String.valueOf(_plus_4) + "/";
                String _name_1 = model.getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
                String _plus_6 = String.valueOf(_plus_5) + _firstUpper_1;
                String _plus_7 = String.valueOf(_plus_6) + "Partitioner.java";
                CharSequence _generatePartitioner = this.generatePartitioner(model, basePackage);
                access.generateFile(_plus_7, _generatePartitioner);
                String _replace_2 = basePackage.replace(".", "/");
                String _plus_8 = String.valueOf(prefix) + _replace_2;
                String _plus_9 = String.valueOf(_plus_8) + "/";
                String _name_2 = model.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
                String _plus_10 = String.valueOf(_plus_9) + _firstUpper_2;
                String _plus_11 = String.valueOf(_plus_10) + "PresentationReconciler.java";
                CharSequence _generatePresentationReconciler = this.generatePresentationReconciler(model, basePackage);
                access.generateFile(_plus_11, _generatePresentationReconciler);
                LexicalHighlighting _lexicalHighlighting = model.getLexicalHighlighting();
                EList<LexicalPartitionHighlighting> _list = _lexicalHighlighting.getList();
                for (LexicalPartitionHighlighting h : _list) {
                    if (!(h instanceof LexicalPartitionHighlighting_Rule)) continue;
                    String _replace_3 = basePackage.replace(".", "/");
                    String _plus_12 = String.valueOf(prefix) + _replace_3;
                    String _plus_13 = String.valueOf(_plus_12) + "/";
                    String _name_3 = model.getName();
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_3);
                    String _plus_14 = String.valueOf(_plus_13) + _firstUpper_3;
                    Partition _partition = ((LexicalPartitionHighlighting_Rule)h).getPartition();
                    String _name_4 = _partition.getName();
                    String _plus_15 = String.valueOf(_plus_14) + _name_4;
                    String _plus_16 = String.valueOf(_plus_15) + ".java";
                    CharSequence _generateScanner = this.generateScanner(model, (LexicalPartitionHighlighting_Rule)h, basePackage);
                    access.generateFile(_plus_16, _generateScanner);
                }
            }
            EList<Codegeneration> _codegenerationList_1 = javaFXIntegration.getCodegenerationList();
            Iterable _filter_2 = Iterables.filter(_codegenerationList_1, E4CodeGeneration.class);
            E4CodeGeneration e4CodeGen = (E4CodeGeneration)IterableExtensions.head((Iterable)_filter_2);
            Object _xifexpression_2 = null;
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)e4CodeGen, null);
            if (_notEquals_2) {
                boolean _notEquals_3;
                Object _xifexpression_3 = null;
                boolean bl4 = _notEquals_3 = !Objects.equal((Object)javaCodeGen, null);
                if (_notEquals_3) {
                    String basePackage_1 = e4CodeGen.getName();
                    String javaBasePackage = javaCodeGen.getName();
                    String project_1 = this.findProjectResource(e4CodeGen);
                    String _xifexpression_4 = null;
                    boolean _equals_1 = Objects.equal((Object)project_1, null);
                    _xifexpression_4 = _equals_1 ? "" : "/" + project_1 + "/src/";
                    String prefix_1 = _xifexpression_4;
                    String _replace_4 = basePackage_1.replace(".", "/");
                    String _plus_17 = String.valueOf(prefix_1) + _replace_4;
                    String _plus_18 = String.valueOf(_plus_17) + "/";
                    String _name_5 = model.getName();
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_5);
                    String _plus_19 = String.valueOf(_plus_18) + _firstUpper_4;
                    String _plus_20 = String.valueOf(_plus_19) + "DocumentPartitionerTypeProvider.java";
                    CharSequence _generateDocumentPartitionerTypeProvider = this.generateDocumentPartitionerTypeProvider(model, basePackage_1, javaBasePackage);
                    access.generateFile(_plus_20, _generateDocumentPartitionerTypeProvider);
                    String _replace_5 = basePackage_1.replace(".", "/");
                    String _plus_21 = String.valueOf(prefix_1) + _replace_5;
                    String _plus_22 = String.valueOf(_plus_21) + "/";
                    String _name_6 = model.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_6);
                    String _plus_23 = String.valueOf(_plus_22) + _firstUpper_5;
                    String _plus_24 = String.valueOf(_plus_23) + "PresentationReconcilerTypeProvider.java";
                    CharSequence _generatePresentationReconcilerTypeProvider = this.generatePresentationReconcilerTypeProvider(model, basePackage_1, javaBasePackage);
                    access.generateFile(_plus_24, _generatePresentationReconcilerTypeProvider);
                } else {
                    _xifexpression_3 = null;
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String findProjectResource(Codegeneration codeGen) {
        EList<ConfigValue> _configValue = codeGen.getConfigValue();
        Functions.Function1<ConfigValue, Boolean> _function = new Functions.Function1<ConfigValue, Boolean>(){

            public Boolean apply(ConfigValue it) {
                String _key = it.getKey();
                return Objects.equal((Object)_key, (Object)"project");
            }
        };
        ConfigValue _findFirst = (ConfigValue)IterableExtensions.findFirst(_configValue, (Functions.Function1)_function);
        String _simpleValue = null;
        if (_findFirst != null) {
            _simpleValue = _findFirst.getSimpleValue();
        }
        return _simpleValue;
    }

    public CharSequence generateDocumentPartitionerTypeProvider(LanguageDef model, String basePackage, String javaBasePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)basePackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"@org.osgi.service.component.annotations.Component");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"DocumentPartitionerTypeProvider implements org.eclipse.fx.code.editor.services.DocumentPartitionerTypeProvider {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Class<? extends org.eclipse.jface.text.IDocumentPartitioner> getType(org.eclipse.fx.code.editor.Input<?> s) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        _builder.append((Object)javaBasePackage, "\t\t");
        _builder.append((Object)".");
        String _name_1 = model.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)"Partitioner.class;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean test(org.eclipse.fx.code.editor.Input<?> t) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (t instanceof org.eclipse.fx.code.editor.services.URIProvider) && ((org.eclipse.fx.code.editor.services.URIProvider)t).getURI().lastSegment().endsWith(\".");
        String _name_2 = model.getName();
        _builder.append((Object)_name_2, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePresentationReconcilerTypeProvider(LanguageDef model, String basePackage, String javaBasePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)basePackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"@org.osgi.service.component.annotations.Component");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"PresentationReconcilerTypeProvider implements org.eclipse.fx.code.editor.fx.services.PresentationReconcilerTypeProvider {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Class<? extends org.eclipse.jface.text.presentation.PresentationReconciler> getType(org.eclipse.fx.code.editor.Input<?> s) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        _builder.append((Object)javaBasePackage, "\t\t");
        _builder.append((Object)".");
        String _name_1 = model.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t\t");
        _builder.append((Object)"PresentationReconciler.class;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean test(org.eclipse.fx.code.editor.Input<?> t) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (t instanceof org.eclipse.fx.code.editor.services.URIProvider) && ((org.eclipse.fx.code.editor.services.URIProvider)t).getURI().lastSegment().endsWith(\".dart\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePartitioner(LanguageDef model, String basePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)basePackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"Partitioner extends org.eclipse.jface.text.rules.FastPartitioner {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = model.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t");
        _builder.append((Object)"Partitioner() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(new ");
        String _name_2 = model.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "\t\t");
        _builder.append((Object)"PartitionScanner(), new String[] {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        Paritioning _paritioning = model.getParitioning();
        EList<Partition> _partitions = _paritioning.getPartitions();
        Functions.Function1<Partition, String> _function = new Functions.Function1<Partition, String>(){

            public String apply(Partition it) {
                return it.getName();
            }
        };
        List _map = ListExtensions.map(_partitions, (Functions.Function1)_function);
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _equals = it.equals("__dftl_partition_content_type");
                return !_equals;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return "\"" + it + "\"";
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_2);
        String _join = IterableExtensions.join((Iterable)_map_1, (CharSequence)",");
        _builder.append((Object)_join, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateRulePartitioner(LanguageDef model, String basePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)basePackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"PartitionScanner extends org.eclipse.jface.text.rules.RuleBasedPartitionScanner {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = model.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t");
        _builder.append((Object)"PartitionScanner() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.jface.text.rules.IPredicateRule[] pr = new org.eclipse.jface.text.rules.IPredicateRule[");
        Paritioning _paritioning = model.getParitioning();
        Partitioner _partitioner = _paritioning.getPartitioner();
        EList<Partition_Rule> _ruleList = ((Partitioner_Rule)_partitioner).getRuleList();
        int _size = _ruleList.size();
        _builder.append((Object)_size, "\t\t");
        _builder.append((Object)"];");
        _builder.newLineIfNotEmpty();
        Paritioning _paritioning_1 = model.getParitioning();
        Partitioner _partitioner_1 = _paritioning_1.getPartitioner();
        EList<Partition_Rule> _ruleList_1 = ((Partitioner_Rule)_partitioner_1).getRuleList();
        Iterable _indexed = IterableExtensions.indexed(_ruleList_1);
        for (Pair r : _indexed) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"pr[");
            Integer _key = (Integer)r.getKey();
            _builder.append((Object)_key, "\t\t");
            _builder.append((Object)"] = ");
            Partition_Rule _value = (Partition_Rule)r.getValue();
            CharSequence _generatePartitionRule = this.generatePartitionRule(_value);
            _builder.append((Object)_generatePartitionRule, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setPredicateRules(pr);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePresentationReconciler(LanguageDef model, String basePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)basePackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"PresentationReconciler extends org.eclipse.jface.text.presentation.PresentationReconciler {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = model.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t");
        _builder.append((Object)"PresentationReconciler() {");
        _builder.newLineIfNotEmpty();
        LexicalHighlighting _lexicalHighlighting = model.getLexicalHighlighting();
        EList<LexicalPartitionHighlighting> _list = _lexicalHighlighting.getList();
        for (LexicalPartitionHighlighting h : _list) {
            if (h instanceof LexicalPartitionHighlighting_Rule) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"org.eclipse.jface.text.rules.DefaultDamagerRepairer ");
                Partition _partition = ((LexicalPartitionHighlighting_Rule)h).getPartition();
                String _name_2 = _partition.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)"DamageRepairer = new org.eclipse.jface.text.rules.DefaultDamagerRepairer(new ");
                String _name_3 = model.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_2, "\t\t");
                Partition _partition_1 = ((LexicalPartitionHighlighting_Rule)h).getPartition();
                String _name_4 = _partition_1.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"//FIXME Need to generate JS-Damager");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"setDamager(");
            Partition _partition_2 = h.getPartition();
            String _name_5 = _partition_2.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)"DamageRepairer, \"");
            Partition _partition_3 = h.getPartition();
            String _name_6 = _partition_3.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"setRepairer(");
            Partition _partition_4 = h.getPartition();
            String _name_7 = _partition_4.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)"DamageRepairer, \"");
            Partition _partition_5 = h.getPartition();
            String _name_8 = _partition_5.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)"\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateScanner(LanguageDef model, LexicalPartitionHighlighting_Rule highlighter, String basePackage) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)basePackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = model.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        Partition _partition = highlighter.getPartition();
        String _name_1 = _partition.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" extends org.eclipse.jface.text.rules.RuleBasedScanner {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = model.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_1, "\t");
        Partition _partition_1 = highlighter.getPartition();
        String _name_3 = _partition_1.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"org.eclipse.jface.text.rules.Token ");
            String _name_4 = t.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"Token = new org.eclipse.jface.text.rules.Token(new org.eclipse.jface.text.TextAttribute(\"");
            String _name_5 = model.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)".");
            String _name_6 = t.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"\"));");
            _builder.newLineIfNotEmpty();
            boolean _isDefault = t.isDefault();
            if (!_isDefault) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"setDefaultReturnToken(");
            String _name_7 = t.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)"Token);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.jface.text.rules.IRule[] rules = new org.eclipse.jface.text.rules.IRule[");
        int _countRules = JavaFXCodeGenerator.countRules(highlighter);
        int _addKeywordGroup = JavaFXCodeGenerator.addKeywordGroup(_countRules, highlighter);
        WhitespaceRule _whitespace = highlighter.getWhitespace();
        int _addWhitespaceRule = JavaFXCodeGenerator.addWhitespaceRule(_addKeywordGroup, _whitespace);
        _builder.append((Object)_addWhitespaceRule, "\t\t");
        _builder.append((Object)"];");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        int count = 0;
        _builder.newLineIfNotEmpty();
        EList<Token> _tokenList_1 = highlighter.getTokenList();
        for (Token t_1 : _tokenList_1) {
            EList<Scanner> _scannerList = t_1.getScannerList();
            Functions.Function1<Scanner, Boolean> _function = new Functions.Function1<Scanner, Boolean>(){

                public Boolean apply(Scanner s) {
                    return s instanceof Scanner_Rule;
                }
            };
            Iterable _filter = IterableExtensions.filter(_scannerList, (Functions.Function1)_function);
            for (Scanner s : _filter) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"rules[");
                int _plusPlus = count++;
                _builder.append((Object)_plusPlus, "\t\t");
                _builder.append((Object)"] = ");
                CharSequence _generateScannerRule = this.generateScannerRule(t_1, (Scanner_Rule)s);
                _builder.append((Object)_generateScannerRule, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        WhitespaceRule _whitespace_1 = highlighter.getWhitespace();
        boolean bl = _notEquals = !Objects.equal((Object)_whitespace_1, null);
        if (_notEquals) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"rules[");
            int _plusPlus_1 = count++;
            _builder.append((Object)_plusPlus_1, "\t\t");
            _builder.append((Object)"] = ");
            WhitespaceRule _whitespace_2 = highlighter.getWhitespace();
            CharSequence _generateWhitespaceRule = this.generateWhitespaceRule(_whitespace_2);
            _builder.append((Object)_generateWhitespaceRule, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _hasKeywordGroup = JavaFXCodeGenerator.hasKeywordGroup(highlighter);
        if (_hasKeywordGroup) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"org.eclipse.jface.text.source.JavaLikeWordDetector wordDetector= new org.eclipse.jface.text.source.JavaLikeWordDetector();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"org.eclipse.jface.text.rules.CombinedWordRule combinedWordRule= new org.eclipse.jface.text.rules.CombinedWordRule(wordDetector, ");
            EList<Token> _tokenList_2 = highlighter.getTokenList();
            Functions.Function1<Token, Boolean> _function_1 = new Functions.Function1<Token, Boolean>(){

                public Boolean apply(Token t) {
                    return t.isDefault();
                }
            };
            Token _findFirst = (Token)IterableExtensions.findFirst(_tokenList_2, (Functions.Function1)_function_1);
            String _name_8 = _findFirst.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)"Token);");
            _builder.newLineIfNotEmpty();
            EList<Token> _tokenList_3 = highlighter.getTokenList();
            for (Token t_2 : _tokenList_3) {
                EList<Scanner> _scannerList_1 = t_2.getScannerList();
                Functions.Function1<Scanner, Boolean> _function_2 = new Functions.Function1<Scanner, Boolean>(){

                    public Boolean apply(Scanner s) {
                        return s instanceof Scanner_Keyword;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter(_scannerList_1, (Functions.Function1)_function_2);
                for (Scanner kw : _filter_1) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"org.eclipse.jface.text.rules.CombinedWordRule.WordMatcher ");
                    String _name_9 = t_2.getName();
                    _builder.append((Object)_name_9, "\t\t");
                    _builder.append((Object)"WordRule = new org.eclipse.jface.text.rules.CombinedWordRule.WordMatcher();");
                    _builder.newLineIfNotEmpty();
                    EList<Keyword> _keywords = ((Scanner_Keyword)kw).getKeywords();
                    for (Keyword w : _keywords) {
                        _builder.append((Object)"\t\t");
                        String _name_10 = t_2.getName();
                        _builder.append((Object)_name_10, "\t\t");
                        _builder.append((Object)"WordRule.addWord(\"");
                        String _name_11 = w.getName();
                        _builder.append((Object)_name_11, "\t\t");
                        _builder.append((Object)"\", ");
                        String _name_12 = t_2.getName();
                        _builder.append((Object)_name_12, "\t\t");
                        _builder.append((Object)"Token);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"combinedWordRule.addWordMatcher(");
                    String _name_13 = t_2.getName();
                    _builder.append((Object)_name_13, "\t\t");
                    _builder.append((Object)"WordRule);");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"rules[");
            int _plusPlus_2 = count++;
            _builder.append((Object)_plusPlus_2, "\t\t");
            _builder.append((Object)"] = combinedWordRule;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setRules(rules);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public static boolean hasKeywordGroup(LexicalPartitionHighlighting_Rule highlighter) {
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            boolean _notEquals;
            Functions.Function1<Scanner, Boolean> _function;
            EList<Scanner> _scannerList = t.getScannerList();
            Iterable _filter = IterableExtensions.filter(_scannerList, (Functions.Function1)(_function = new Functions.Function1<Scanner, Boolean>(){

                public Boolean apply(Scanner s) {
                    return s instanceof Scanner_Keyword;
                }
            }));
            Scanner _head = (Scanner)IterableExtensions.head((Iterable)_filter);
            boolean bl = _notEquals = !Objects.equal((Object)_head, null);
            if (!_notEquals) continue;
            return true;
        }
        return false;
    }

    public static int addKeywordGroup(int count, LexicalPartitionHighlighting_Rule highlighter) {
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            boolean _notEquals;
            Functions.Function1<Scanner, Boolean> _function;
            EList<Scanner> _scannerList = t.getScannerList();
            Iterable _filter = IterableExtensions.filter(_scannerList, (Functions.Function1)(_function = new Functions.Function1<Scanner, Boolean>(){

                public Boolean apply(Scanner s) {
                    return s instanceof Scanner_Keyword;
                }
            }));
            Scanner _head = (Scanner)IterableExtensions.head((Iterable)_filter);
            boolean bl = _notEquals = !Objects.equal((Object)_head, null);
            if (!_notEquals) continue;
            return count + 1;
        }
        return count;
    }

    public static int addWhitespaceRule(int count, WhitespaceRule r) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)r, null);
        if (_notEquals) {
            return count + 1;
        }
        return count;
    }

    public static int countRules(LexicalPartitionHighlighting_Rule highlighter) {
        int c = 0;
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            int _c = c;
            EList<Scanner> _scannerList = t.getScannerList();
            Functions.Function1<Scanner, Boolean> _function = new Functions.Function1<Scanner, Boolean>(){

                public Boolean apply(Scanner s) {
                    return s instanceof Scanner_Rule;
                }
            };
            Iterable _filter = IterableExtensions.filter(_scannerList, (Functions.Function1)_function);
            int _length = ((Object[])Conversions.unwrapArray((Object)_filter, Object.class)).length;
            c = _c + _length;
        }
        return c;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_SingleLineRule r) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new org.eclipse.jface.text.rules.SingleLineRule(");
        _builder.newLine();
        _builder.append((Object)"\t  ");
        _builder.append((Object)"\"");
        String _startSeq = r.getStartSeq();
        String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
        _builder.append((Object)_escapeString, "\t  ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", \"");
        String _endSeq = r.getEndSeq();
        String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
        _builder.append((Object)_escapeString_1, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", ");
        String _name = t.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"Token");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl = _notEquals = !Objects.equal((Object)_escapeSeq, null);
        if (_notEquals) {
            _builder.append((Object)", '");
            String _escapeSeq_1 = r.getEscapeSeq();
            char _charAt = _escapeSeq_1.charAt(0);
            _builder.append((Object)Character.valueOf(_charAt), "\t");
            _builder.append((Object)"'");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_MultiLineRule r) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new org.eclipse.jface.text.rules.MultiLineRule(");
        _builder.newLine();
        _builder.append((Object)"\t  ");
        _builder.append((Object)"\"");
        String _startSeq = r.getStartSeq();
        String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
        _builder.append((Object)_escapeString, "\t  ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", \"");
        String _endSeq = r.getEndSeq();
        String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
        _builder.append((Object)_escapeString_1, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", ");
        String _name = t.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"Token");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl = _notEquals = !Objects.equal((Object)_escapeSeq, null);
        if (_notEquals) {
            _builder.append((Object)", '");
            String _escapeSeq_1 = r.getEscapeSeq();
            char _charAt = _escapeSeq_1.charAt(0);
            _builder.append((Object)Character.valueOf(_charAt), "\t");
            _builder.append((Object)"'");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateWhitespaceRule(WhitespaceRule r) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isJavawhitespace = r.isJavawhitespace();
        if (_isJavawhitespace) {
            _builder.append((Object)"new org.eclipse.jface.text.rules.WhitespaceRule(Character::isWhitespace);");
            _builder.newLine();
        } else {
            _builder.append((Object)"new org.eclipse.jface.text.rules.WhitespaceRule(new org.eclipse.jface.text.rules.FixedCharacterWSDetector(new char[] {");
            EList<String> _characters = r.getCharacters();
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    String _escapeChar = JavaFXCodeGenerator.escapeChar(it);
                    String _plus = "'" + _escapeChar;
                    return String.valueOf(_plus) + "'";
                }
            };
            List _map = ListExtensions.map(_characters, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
            _builder.append((Object)_join, "");
            _builder.append((Object)"}));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_CharacterRule r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new org.eclipse.jface.text.source.CharacterRule(");
        String _name = t.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Token, new char[] {");
        EList<String> _characters = r.getCharacters();
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                String _escapeChar = JavaFXCodeGenerator.escapeChar(it);
                String _plus = "'" + _escapeChar;
                return String.valueOf(_plus) + "'";
            }
        };
        List _map = ListExtensions.map(_characters, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
        _builder.append((Object)_join, "");
        _builder.append((Object)"});");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_PatternRule r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new org.eclipse.fx.text.RegexRule(");
        String _name = t.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Token, java.util.regex.Pattern.compile(\"");
        String _startPattern = r.getStartPattern();
        String _replace = _startPattern.replace("\\", "\\\\");
        _builder.append((Object)_replace, "");
        _builder.append((Object)"\"),");
        int _length = r.getLength();
        int _max = Math.max(1, _length);
        _builder.append((Object)_max, "");
        _builder.append((Object)",java.util.regex.Pattern.compile(\"");
        String _contentPattern = r.getContentPattern();
        String _replace_1 = _contentPattern.replace("\\", "\\\\");
        _builder.append((Object)_replace_1, "");
        _builder.append((Object)"\"));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generatePartitionRule(Partition_SingleLineRule r) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new org.eclipse.jface.text.rules.SingleLineRule(");
        _builder.newLine();
        _builder.append((Object)"\t  ");
        _builder.append((Object)"\"");
        String _startSeq = r.getStartSeq();
        String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
        _builder.append((Object)_escapeString, "\t  ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", \"");
        String _endSeq = r.getEndSeq();
        String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
        _builder.append((Object)_escapeString_1, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", new org.eclipse.jface.text.rules.Token(\"");
        Partition _parition = r.getParition();
        String _name = _parition.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl = _notEquals = !Objects.equal((Object)_escapeSeq, null);
        if (_notEquals) {
            _builder.append((Object)", '");
            String _escapeSeq_1 = r.getEscapeSeq();
            char _charAt = _escapeSeq_1.charAt(0);
            _builder.append((Object)Character.valueOf(_charAt), "\t");
            _builder.append((Object)"'");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generatePartitionRule(Partition_MultiLineRule r) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"new org.eclipse.jface.text.rules.MultiLineRule(");
        _builder.newLine();
        _builder.append((Object)"\t  ");
        _builder.append((Object)"\"");
        String _startSeq = r.getStartSeq();
        String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
        _builder.append((Object)_escapeString, "\t  ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", \"");
        String _endSeq = r.getEndSeq();
        String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
        _builder.append((Object)_escapeString_1, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)", new org.eclipse.jface.text.rules.Token(\"");
        Partition _parition = r.getParition();
        String _name = _parition.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl = _notEquals = !Objects.equal((Object)_escapeSeq, null);
        if (_notEquals) {
            _builder.append((Object)", '");
            String _escapeSeq_1 = r.getEscapeSeq();
            char _charAt = _escapeSeq_1.charAt(0);
            _builder.append((Object)Character.valueOf(_charAt), "\t");
            _builder.append((Object)"'");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String escapeString(String data) {
        return data.replaceAll("\"", "\\\\\"");
    }

    public static String escapeChar(String data) {
        boolean _equals = Objects.equal((Object)data, (Object)"\\");
        if (_equals) {
            return "\\\\";
        }
        boolean _equals_1 = Objects.equal((Object)data, (Object)"'");
        if (_equals_1) {
            return "\\'";
        }
        return data;
    }

    public CharSequence generateScannerRule(Token t, Scanner_Rule r) {
        if (r instanceof Scanner_CharacterRule) {
            return this._generateScannerRule(t, (Scanner_CharacterRule)r);
        }
        if (r instanceof Scanner_MultiLineRule) {
            return this._generateScannerRule(t, (Scanner_MultiLineRule)r);
        }
        if (r instanceof Scanner_PatternRule) {
            return this._generateScannerRule(t, (Scanner_PatternRule)r);
        }
        if (r instanceof Scanner_SingleLineRule) {
            return this._generateScannerRule(t, (Scanner_SingleLineRule)r);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, r).toString());
    }

    public CharSequence generatePartitionRule(Partition_Rule r) {
        if (r instanceof Partition_MultiLineRule) {
            return this._generatePartitionRule((Partition_MultiLineRule)r);
        }
        if (r instanceof Partition_SingleLineRule) {
            return this._generatePartitionRule((Partition_SingleLineRule)r);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(r).toString());
    }
}

