/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.pde.ui.e4.project.boot;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.ide.pde.ui.e4.project.boot.AppBundleProjectData;
import org.eclipse.fx.ide.pde.ui.e4.project.boot.GeneratorConfigurationPage;
import org.eclipse.fx.ide.pde.ui.wizard.BundleConfigurationPage;
import org.eclipse.fx.ide.rrobot.RRobot;
import org.eclipse.fx.ide.rrobot.dsl.FileLoader;
import org.eclipse.fx.ide.rrobot.model.task.RobotTask;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class NewProjectStructureWizard
extends Wizard
implements INewWizard {
    private AppBundleProjectData data;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.data = new AppBundleProjectData();
        this.data.setJemmyTest(this.isJemmyAvailable());
        this.data.setTychoIntegration(true);
        this.data.setNativeExport(true);
        this.data.setVersion("1.0.0.qualifier");
    }

    private boolean isJemmyAvailable() {
        return PDECore.getDefault().getModelManager().findModel("at.bestsolution.efxclipse.jemmy") != null;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new BundleConfigurationPage(this.data, "bundle.page", "New e4 FX application"){

            protected String getBundleIdLabel() {
                return "Bundle-ID-Prefix";
            }
        });
        this.addPage((IWizardPage)new GeneratorConfigurationPage(this.data, "generator.page", "New e4 FX application"));
    }

    public boolean performFinish() {
        Bundle b = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        BundleContext ctx = b.getBundleContext();
        ServiceReference ref = ctx.getServiceReference(RRobot.class);
        final RRobot r = (RRobot)ctx.getService(ref);
        FileLoader loader = FileLoader.createLoader();
        final RobotTask task = loader.loadTask(URI.createPlatformPluginURI((String)"/org.eclipse.fx.ide.pde.ui.e4/generator-tasks/e4App.rtask", (boolean)true));
        final HashMap<String, Object> additionalData = new HashMap<String, Object>();
        additionalData.put("Maven_GroupId", this.data.getSymbolicname());
        additionalData.put("BundleProject_bundleVendor", this.data.getVendor());
        additionalData.put("BundleProject_productName", this.data.getProductName());
        additionalData.put("BundleProject_bundleVersion", this.data.getVersion());
        additionalData.put("BundleProject_EE", this.data.getEEnv());
        additionalData.put("TychoIntegration", this.data.isTychoIntegration());
        additionalData.put("NativeExport", this.data.isNativeExport());
        additionalData.put("JemmyTest", this.data.isJemmyTest());
        WorkspaceModifyOperation w = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                r.executeTask(monitor, task, additionalData);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)w);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }
}

