/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Overflow implements Enumerator
{
    VISIBLE(0, "visible", "visible"),
    HIDDEN(1, "hidden", "hidden"),
    SCROLL(2, "scroll", "scroll"),
    AUTO(3, "auto", "auto"),
    INHERIT(4, "inherit", "inherit");

    public static final int VISIBLE_VALUE = 0;
    public static final int HIDDEN_VALUE = 1;
    public static final int SCROLL_VALUE = 2;
    public static final int AUTO_VALUE = 3;
    public static final int INHERIT_VALUE = 4;
    private static final Overflow[] VALUES_ARRAY;
    public static final List<Overflow> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Overflow[]{VISIBLE, HIDDEN, SCROLL, AUTO, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Overflow get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Overflow result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Overflow getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Overflow result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Overflow get(int value) {
        switch (value) {
            case 0: {
                return VISIBLE;
            }
            case 1: {
                return HIDDEN;
            }
            case 2: {
                return SCROLL;
            }
            case 3: {
                return AUTO;
            }
            case 4: {
                return INHERIT;
            }
        }
        return null;
    }

    private Overflow(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

