/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.configurator;

import java.io.Serializable;
import org.apache.maven.plugin.MojoExecution;

public class MojoExecutionKey
implements Serializable {
    private static final long serialVersionUID = -2074582830199438890L;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String goal;
    private final String executionId;
    private final String lifecyclePhase;

    public MojoExecutionKey(MojoExecution mojoExecution) {
        this.groupId = mojoExecution.getGroupId();
        this.artifactId = mojoExecution.getArtifactId();
        this.version = mojoExecution.getVersion();
        this.goal = mojoExecution.getGoal();
        this.executionId = mojoExecution.getExecutionId();
        this.lifecyclePhase = mojoExecution.getLifecyclePhase();
    }

    public MojoExecutionKey(String groupId, String artifactId, String version, String goal, String lifecyclePhase, String executionId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.goal = goal;
        this.lifecyclePhase = lifecyclePhase;
        this.executionId = executionId;
    }

    public int hashCode() {
        int hash = this.groupId.hashCode();
        hash = 17 * hash + this.artifactId.hashCode();
        hash = 17 * hash + this.version.hashCode();
        hash = 17 * hash + this.goal.hashCode();
        hash = 17 * hash + (this.executionId != null ? this.executionId.hashCode() : 0);
        hash = 17 * hash + (this.lifecyclePhase != null ? this.lifecyclePhase.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MojoExecutionKey)) {
            return false;
        }
        MojoExecutionKey other = (MojoExecutionKey)obj;
        return MojoExecutionKey.eq(this.groupId, other.groupId) && MojoExecutionKey.eq(this.artifactId, other.artifactId) && MojoExecutionKey.eq(this.version, other.version) && MojoExecutionKey.eq(this.goal, other.goal) && MojoExecutionKey.eq(this.executionId, other.executionId) && MojoExecutionKey.eq(this.lifecyclePhase, other.lifecyclePhase);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    public String getKeyString() {
        return String.valueOf(this.groupId) + ":" + this.artifactId + ":" + this.version + ":" + this.goal + ":" + this.executionId + ":" + this.lifecyclePhase;
    }

    public String toString() {
        return String.valueOf(this.groupId) + ":" + this.artifactId + ":" + this.version + ":" + this.goal + " (execution: " + this.executionId + ", phase: " + this.lifecyclePhase + ")";
    }

    public boolean match(MojoExecution mojoExecution) {
        if (mojoExecution == null) {
            return false;
        }
        return this.groupId.equals(mojoExecution.getGroupId()) && this.artifactId.equals(mojoExecution.getArtifactId()) && this.version.equals(mojoExecution.getVersion()) && this.goal.equals(mojoExecution.getGoal()) && this.executionId.equals(mojoExecution.getExecutionId());
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

