/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.markers;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingConfigurationException;
import org.eclipse.m2e.core.internal.markers.SourceLocation;

public class MavenProblemInfo {
    private final SourceLocation location;
    private String message;
    private final int severity;

    public MavenProblemInfo(int line, Throwable error) {
        this(new SourceLocation(line, 0, 0), error);
    }

    public MavenProblemInfo(SourceLocation location, Throwable error) {
        this.location = location;
        this.message = this.getErrorMessage(error);
        this.severity = 2;
    }

    public MavenProblemInfo(MavenProject mavenProject, LifecycleMappingConfigurationException error) {
        SourceLocation errorLocation = error.getLocation();
        this.location = errorLocation != null ? (mavenProject.getFile().getAbsolutePath().equals(errorLocation.getResourcePath()) ? new SourceLocation(errorLocation.getLineNumber(), errorLocation.getColumnStart(), errorLocation.getColumnEnd()) : new SourceLocation(1, 1, 1, errorLocation)) : new SourceLocation(1, 0, 0);
        this.message = error.getMessage();
        this.severity = 2;
    }

    public MavenProblemInfo(int line, String message) {
        this.location = new SourceLocation(line, 0, 0);
        this.message = message;
        this.severity = 2;
    }

    public MavenProblemInfo(String message, SourceLocation location) {
        this(message, 2, location);
    }

    public MavenProblemInfo(String message, int severity, SourceLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("MarkerLocation.location cannot be null");
        }
        this.message = message;
        this.severity = severity;
        this.location = location;
    }

    protected MavenProblemInfo(SourceLocation location) {
        this(null, 2, location);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void processMarker(IMarker marker) throws CoreException {
        marker.setAttribute("lineNumber", this.location.getLineNumber());
        marker.setAttribute("columnStart", this.location.getColumnStart());
        marker.setAttribute("columnEnd", this.location.getColumnEnd());
        if (this.location.getLinkedLocation() != null) {
            marker.setAttribute("causeResourcePath", (Object)this.location.getLinkedLocation().getResourcePath());
            marker.setAttribute("causeResourceId", (Object)this.location.getLinkedLocation().getResourceId());
            marker.setAttribute("causeLineNumber", this.location.getLinkedLocation().getLineNumber());
            marker.setAttribute("causeColumnStart", this.location.getLinkedLocation().getColumnStart());
            marker.setAttribute("causeColumnEnd", this.location.getLinkedLocation().getColumnEnd());
        }
    }

    public String toString() {
        return this.message;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    private String getErrorMessage(Throwable e) {
        StringBuilder message = new StringBuilder();
        while (e != null) {
            if (e.getMessage() != null && message.indexOf(e.getMessage()) < 0) {
                if (message.length() > 0) {
                    message.append(": ");
                }
                message.append(e.getClass().getSimpleName()).append(": ").append(e.getMessage());
            }
            e = e.getCause();
        }
        return message.toString();
    }
}

