/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.databinding.internal;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.fx.core.databinding.internal.FXBeanPropertyHelper;
import org.eclipse.fx.core.databinding.internal.FXBeanPropertyListener;

public class FXBeanValueProperty
extends SimpleValueProperty {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<?> valueType;

    public FXBeanValueProperty(PropertyDescriptor propertyDescriptor, Class<?> valueType) {
        this.propertyDescriptor = propertyDescriptor;
        this.valueType = valueType == null ? propertyDescriptor.getPropertyType() : valueType;
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected Object doGetValue(Object source) {
        return FXBeanPropertyHelper.readProperty(source, this.propertyDescriptor);
    }

    protected void doSetValue(Object source, Object value) {
        FXBeanPropertyHelper.writeProperty(source, this.propertyDescriptor, value);
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new FXBeanPropertyListener((IProperty)this, this.propertyDescriptor, listener){

            @Override
            protected IDiff computeDiff(Object oldValue, Object newValue) {
                return Diffs.createValueDiff((Object)oldValue, (Object)newValue);
            }
        };
    }

    public String toString() {
        String s = FXBeanPropertyHelper.propertyName(this.propertyDescriptor);
        if (this.valueType != null) {
            s = String.valueOf(s) + "<" + FXBeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

