/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.text;

import org.eclipse.fx.core.text.TextContent;

public class TextChangedEvent {
    public final TextContent source;
    public final int offset;
    public final int replaceCharCount;
    public final int replaceLineCount;
    public final String newText;
    public final int newCharCount;
    public final int newLineCount;

    private TextChangedEvent(TextContent source, int offset, int replaceCharCount, int replaceLineCount, String newText, int newCharCount, int newLineCount) {
        this.source = source;
        this.offset = offset;
        this.replaceCharCount = replaceCharCount;
        this.replaceLineCount = replaceLineCount;
        this.newText = newText;
        this.newCharCount = newCharCount;
        this.newLineCount = newLineCount;
    }

    public static TextChangedEvent textChanged(TextContent source) {
        return new TextChangedEvent(source, 0, 0, 0, null, 0, 0);
    }

    public static TextChangedEvent textChanged(TextContent source, int offset, int replaceLength, String newText) {
        return new TextChangedEvent(source, offset, replaceLength, -1, newText, newText.length(), -1);
    }

    public static TextChangedEvent textSet(TextContent source) {
        return new TextChangedEvent(source, 0, 0, 0, null, 0, 0);
    }

    public String toString() {
        return "TextChangedEvent(offset=" + this.offset + ", replaceCharCount=" + this.replaceCharCount + ", replaceText=" + (this.newText == null ? "null" : "\"" + this.newText + "\"") + ")";
    }
}

