package org.eclipse.fx.formats.svg.fx;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.svg.PresentationAttributes;
import org.eclipse.fx.formats.svg.svg.SpreadMethod;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class PresentationAttributesUtil {
  private Supplier<SvgDefsElement> defSupplier;
  
  public PresentationAttributesUtil(final Supplier<SvgDefsElement> defSupplier) {
    this.defSupplier = defSupplier;
  }
  
  public List<SvgElement> createBorder(final Border b, final Region r) {
    boolean _equals = Objects.equal(b, null);
    if (_equals) {
      return Collections.<SvgElement>emptyList();
    } else {
      List<BorderStroke> _strokes = b.getStrokes();
      final Function1<BorderStroke, List<SvgElement>> _function = new Function1<BorderStroke, List<SvgElement>>() {
        @Override
        public List<SvgElement> apply(final BorderStroke it) {
          return PresentationAttributesUtil.this.createBorderStroke(it, r);
        }
      };
      List<List<SvgElement>> _map = ListExtensions.<BorderStroke, List<SvgElement>>map(_strokes, _function);
      Iterable<SvgElement> _flatten = Iterables.<SvgElement>concat(_map);
      return IterableExtensions.<SvgElement>toList(_flatten);
    }
  }
  
  public List<SvgElement> createBorderStroke(final BorderStroke s, final Region r) {
    final boolean w = (((s.getWidths().getBottom() == s.getWidths().getLeft()) && (s.getWidths().getBottom() == s.getWidths().getRight())) && (s.getWidths().getBottom() == s.getWidths().getTop()));
    final boolean c = ((Objects.equal(s.getBottomStroke(), s.getLeftStroke()) && Objects.equal(s.getBottomStroke(), s.getRightStroke())) && Objects.equal(s.getBottomStroke(), s.getTopStroke()));
    final boolean st = ((Objects.equal(s.getBottomStyle(), s.getLeftStyle()) && Objects.equal(s.getBottomStyle(), s.getRightStyle())) && Objects.equal(s.getBottomStyle(), s.getTopStyle()));
    if ((((w && c) && st) && PresentationAttributesUtil.checkRadii(s.getRadii()))) {
      final SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
      rv.setFill("transparent");
      Bounds _layoutBounds = r.getLayoutBounds();
      double _minX = _layoutBounds.getMinX();
      Insets _insets = s.getInsets();
      double _left = _insets.getLeft();
      double _plus = (_minX + _left);
      String _string = Double.valueOf(_plus).toString();
      rv.setX(_string);
      Bounds _layoutBounds_1 = r.getLayoutBounds();
      double _minY = _layoutBounds_1.getMinY();
      Insets _insets_1 = s.getInsets();
      double _top = _insets_1.getTop();
      double _plus_1 = (_minY + _top);
      String _string_1 = Double.valueOf(_plus_1).toString();
      rv.setY(_string_1);
      Bounds _layoutBounds_2 = r.getLayoutBounds();
      double _width = _layoutBounds_2.getWidth();
      Insets _insets_2 = s.getInsets();
      double _left_1 = _insets_2.getLeft();
      double _minus = (_width - _left_1);
      Insets _insets_3 = s.getInsets();
      double _right = _insets_3.getRight();
      double _minus_1 = (_minus - _right);
      String _string_2 = Double.valueOf(_minus_1).toString();
      rv.setWidth(_string_2);
      Bounds _layoutBounds_3 = r.getLayoutBounds();
      double _height = _layoutBounds_3.getHeight();
      Insets _insets_4 = s.getInsets();
      double _top_1 = _insets_4.getTop();
      double _minus_2 = (_height - _top_1);
      Insets _insets_5 = s.getInsets();
      double _bottom = _insets_5.getBottom();
      double _minus_3 = (_minus_2 - _bottom);
      String _string_3 = Double.valueOf(_minus_3).toString();
      rv.setHeight(_string_3);
      BorderWidths _widths = s.getWidths();
      double _bottom_1 = _widths.getBottom();
      String _string_4 = Double.valueOf(_bottom_1).toString();
      rv.setStroke_width(_string_4);
      Paint _bottomStroke = s.getBottomStroke();
      this.applyStroke(rv, _bottomStroke);
      return Collections.<SvgElement>singletonList(rv);
    } else {
      InputOutput.<String>println("====> Dup actions");
    }
    return Collections.<SvgElement>emptyList();
  }
  
  public static boolean checkRadii(final CornerRadii r) {
    final boolean rx = (((r.getBottomLeftHorizontalRadius() == r.getBottomRightHorizontalRadius()) && (r.getBottomLeftHorizontalRadius() == r.getTopLeftHorizontalRadius())) && (r.getBottomLeftHorizontalRadius() == r.getTopRightHorizontalRadius()));
    final boolean ry = (((r.getBottomLeftVerticalRadius() == r.getBottomRightVerticalRadius()) && (r.getBottomLeftVerticalRadius() == r.getTopLeftVerticalRadius())) && (r.getBottomLeftVerticalRadius() == r.getTopRightVerticalRadius()));
    return (rx && ry);
  }
  
  public SvgElement createBackgroundFill(final BackgroundFill f, final Region r) {
    CornerRadii _radii = f.getRadii();
    boolean _checkRadii = PresentationAttributesUtil.checkRadii(_radii);
    if (_checkRadii) {
      final SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
      CornerRadii _radii_1 = f.getRadii();
      double _bottomLeftHorizontalRadius = _radii_1.getBottomLeftHorizontalRadius();
      String _string = Double.valueOf(_bottomLeftHorizontalRadius).toString();
      rv.setRx(_string);
      CornerRadii _radii_2 = f.getRadii();
      double _bottomLeftVerticalRadius = _radii_2.getBottomLeftVerticalRadius();
      String _string_1 = Double.valueOf(_bottomLeftVerticalRadius).toString();
      rv.setRy(_string_1);
      Insets _insets = f.getInsets();
      double _left = _insets.getLeft();
      String _string_2 = Double.valueOf(_left).toString();
      rv.setX(_string_2);
      Insets _insets_1 = f.getInsets();
      double _top = _insets_1.getTop();
      String _string_3 = Double.valueOf(_top).toString();
      rv.setY(_string_3);
      Bounds _layoutBounds = r.getLayoutBounds();
      double _width = _layoutBounds.getWidth();
      Insets _insets_2 = f.getInsets();
      double _left_1 = _insets_2.getLeft();
      double _minus = (_width - _left_1);
      Insets _insets_3 = f.getInsets();
      double _right = _insets_3.getRight();
      double _minus_1 = (_minus - _right);
      String _string_4 = Double.valueOf(_minus_1).toString();
      rv.setWidth(_string_4);
      Bounds _layoutBounds_1 = r.getLayoutBounds();
      double _height = _layoutBounds_1.getHeight();
      Insets _insets_4 = f.getInsets();
      double _top_1 = _insets_4.getTop();
      double _minus_2 = (_height - _top_1);
      Insets _insets_5 = f.getInsets();
      double _bottom = _insets_5.getBottom();
      double _minus_3 = (_minus_2 - _bottom);
      String _string_5 = Double.valueOf(_minus_3).toString();
      rv.setHeight(_string_5);
      rv.setFill("transparent");
      Paint _fill = f.getFill();
      this.applyFill(rv, _fill);
      String _plus = (r + " ===> ");
      String _fill_1 = rv.getFill();
      String _plus_1 = (_plus + _fill_1);
      String _plus_2 = (_plus_1 + "; ");
      Paint _fill_2 = f.getFill();
      String _plus_3 = (_plus_2 + _fill_2);
      InputOutput.<String>println(_plus_3);
      return rv;
    } else {
      final SvgPathElement rv_1 = SvgFactory.eINSTANCE.createSvgPathElement();
      return rv_1;
    }
  }
  
  protected void _applyFill(final PresentationAttributes e, final Color p) {
    String _rGBHex = FXToSvgUtils.toRGBHex(p);
    e.setFill(_rGBHex);
    double _opacity = p.getOpacity();
    boolean _notEquals = (_opacity != 1.0);
    if (_notEquals) {
      double _opacity_1 = p.getOpacity();
      String _string = Double.valueOf(_opacity_1).toString();
      e.setFill_opacity(_string);
    }
  }
  
  protected void _applyFill(final PresentationAttributes e, final ImagePattern p) {
    System.err.println("ImagePattern not yet supported");
  }
  
  protected void _applyFill(final PresentationAttributes e, final LinearGradient p) {
    SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
    String _generateUUID = EcoreUtil.generateUUID();
    l.setId(_generateUUID);
    String _xifexpression = null;
    boolean _isProportional = p.isProportional();
    if (_isProportional) {
      double _startX = p.getStartX();
      _xifexpression = FXToSvgUtils.toProportion(_startX);
    } else {
      double _startX_1 = p.getStartX();
      _xifexpression = Double.valueOf(_startX_1).toString();
    }
    l.setX1(_xifexpression);
    String _xifexpression_1 = null;
    boolean _isProportional_1 = p.isProportional();
    if (_isProportional_1) {
      double _endX = p.getEndX();
      _xifexpression_1 = FXToSvgUtils.toProportion(_endX);
    } else {
      double _endX_1 = p.getEndX();
      _xifexpression_1 = Double.valueOf(_endX_1).toString();
    }
    l.setX2(_xifexpression_1);
    String _xifexpression_2 = null;
    boolean _isProportional_2 = p.isProportional();
    if (_isProportional_2) {
      double _startY = p.getStartY();
      _xifexpression_2 = FXToSvgUtils.toProportion(_startY);
    } else {
      double _startY_1 = p.getStartY();
      _xifexpression_2 = Double.valueOf(_startY_1).toString();
    }
    l.setY1(_xifexpression_2);
    String _xifexpression_3 = null;
    boolean _isProportional_3 = p.isProportional();
    if (_isProportional_3) {
      double _endY = p.getEndY();
      _xifexpression_3 = FXToSvgUtils.toProportion(_endY);
    } else {
      double _endY_1 = p.getEndY();
      _xifexpression_3 = Double.valueOf(_endY_1).toString();
    }
    l.setY2(_xifexpression_3);
    CycleMethod _cycleMethod = p.getCycleMethod();
    SpreadMethod _spread = PresentationAttributesUtil.toSpread(_cycleMethod);
    l.setSpreadMethod(_spread);
    List<Stop> _stops = p.getStops();
    for (final Stop s : _stops) {
      EList<SvgElement> _children = l.getChildren();
      SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
      _children.add(_stop);
    }
    SvgDefsElement _get = this.defSupplier.get();
    EList<SvgElement> _children_1 = _get.getChildren();
    _children_1.add(l);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("url(#");
    String _id = l.getId();
    _builder.append(_id, "");
    _builder.append(")");
    e.setFill(_builder.toString());
  }
  
  protected void _applyFill(final PresentationAttributes e, final RadialGradient p) {
    System.err.println("RadialGradient not yet supported");
  }
  
  protected void _applyStroke(final PresentationAttributes e, final Color p) {
    String _rGBHex = FXToSvgUtils.toRGBHex(p);
    e.setStroke(_rGBHex);
    double _opacity = p.getOpacity();
    boolean _notEquals = (_opacity != 0.0);
    if (_notEquals) {
      double _opacity_1 = p.getOpacity();
      String _string = Double.valueOf(_opacity_1).toString();
      e.setStroke_opacity(_string);
    }
  }
  
  protected void _applyStroke(final PresentationAttributes e, final ImagePattern p) {
    System.err.println("ImagePattern not yet supported");
  }
  
  protected void _applyStroke(final PresentationAttributes e, final LinearGradient p) {
    SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
    String _generateUUID = EcoreUtil.generateUUID();
    l.setId(_generateUUID);
    String _xifexpression = null;
    boolean _isProportional = p.isProportional();
    if (_isProportional) {
      double _startX = p.getStartX();
      _xifexpression = FXToSvgUtils.toProportion(_startX);
    } else {
      double _startX_1 = p.getStartX();
      _xifexpression = Double.valueOf(_startX_1).toString();
    }
    l.setX1(_xifexpression);
    String _xifexpression_1 = null;
    boolean _isProportional_1 = p.isProportional();
    if (_isProportional_1) {
      double _endX = p.getEndX();
      _xifexpression_1 = FXToSvgUtils.toProportion(_endX);
    } else {
      double _endX_1 = p.getEndX();
      _xifexpression_1 = Double.valueOf(_endX_1).toString();
    }
    l.setX2(_xifexpression_1);
    String _xifexpression_2 = null;
    boolean _isProportional_2 = p.isProportional();
    if (_isProportional_2) {
      double _startY = p.getStartY();
      _xifexpression_2 = FXToSvgUtils.toProportion(_startY);
    } else {
      double _startY_1 = p.getStartY();
      _xifexpression_2 = Double.valueOf(_startY_1).toString();
    }
    l.setY1(_xifexpression_2);
    String _xifexpression_3 = null;
    boolean _isProportional_3 = p.isProportional();
    if (_isProportional_3) {
      double _endY = p.getEndY();
      _xifexpression_3 = FXToSvgUtils.toProportion(_endY);
    } else {
      double _endY_1 = p.getEndY();
      _xifexpression_3 = Double.valueOf(_endY_1).toString();
    }
    l.setY2(_xifexpression_3);
    CycleMethod _cycleMethod = p.getCycleMethod();
    SpreadMethod _spread = PresentationAttributesUtil.toSpread(_cycleMethod);
    l.setSpreadMethod(_spread);
    List<Stop> _stops = p.getStops();
    for (final Stop s : _stops) {
      EList<SvgElement> _children = l.getChildren();
      SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
      _children.add(_stop);
    }
    SvgDefsElement _get = this.defSupplier.get();
    EList<SvgElement> _children_1 = _get.getChildren();
    _children_1.add(l);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("url(#");
    String _id = l.getId();
    _builder.append(_id, "");
    _builder.append(")");
    e.setStroke(_builder.toString());
  }
  
  protected void _applyStroke(final PresentationAttributes e, final RadialGradient p) {
    System.err.println("RadialGradient not yet supported");
  }
  
  public static SvgStopElement toStop(final Stop s) {
    SvgStopElement e = SvgFactory.eINSTANCE.createSvgStopElement();
    Color _color = s.getColor();
    String _rGBHex = FXToSvgUtils.toRGBHex(_color);
    e.setStop_color(_rGBHex);
    double _offset = s.getOffset();
    String _string = Double.valueOf(_offset).toString();
    e.setOffset(_string);
    return e;
  }
  
  public static SpreadMethod toSpread(final CycleMethod cm) {
    SpreadMethod _switchResult = null;
    if (cm != null) {
      switch (cm) {
        case NO_CYCLE:
          _switchResult = SpreadMethod.PAD;
          break;
        case REFLECT:
          _switchResult = SpreadMethod.REFLECT;
          break;
        case REPEAT:
          _switchResult = SpreadMethod.REPEAT;
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  public void applyFill(final PresentationAttributes e, final Paint p) {
    if (p instanceof Color) {
      _applyFill(e, (Color)p);
      return;
    } else if (p instanceof ImagePattern) {
      _applyFill(e, (ImagePattern)p);
      return;
    } else if (p instanceof LinearGradient) {
      _applyFill(e, (LinearGradient)p);
      return;
    } else if (p instanceof RadialGradient) {
      _applyFill(e, (RadialGradient)p);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(e, p).toString());
    }
  }
  
  public void applyStroke(final PresentationAttributes e, final Paint p) {
    if (p instanceof Color) {
      _applyStroke(e, (Color)p);
      return;
    } else if (p instanceof ImagePattern) {
      _applyStroke(e, (ImagePattern)p);
      return;
    } else if (p instanceof LinearGradient) {
      _applyStroke(e, (LinearGradient)p);
      return;
    } else if (p instanceof RadialGradient) {
      _applyStroke(e, (RadialGradient)p);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(e, p).toString());
    }
  }
}
