/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di.interopt;

import java.awt.Component;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javax.swing.JPanel;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.swt.widgets.Composite;

@org.osgi.service.component.annotations.Component(service={IContextFunction.class}, property={"service.context.key:String=javafx.scene.layout.BorderPane"})
public class InteroptContextFunction
extends ContextFunction {
    public Object compute(IEclipseContext context) {
        Object comp = context.get("org.eclipse.swt.widgets.Composite");
        if (comp != null) {
            BorderPane pane = new BorderPane();
            FXCanvas canvas = new FXCanvas((Composite)comp, 0);
            Scene scene = new Scene((Parent)pane);
            InteroptContextFunction.integrateInToTheme(context, scene);
            canvas.setScene(scene);
            return pane;
        }
        JPanel jpanel = (JPanel)context.get("javax.swing.JPanel");
        if (jpanel != null) {
            BorderPane pane = new BorderPane();
            JFXPanel fxPanel = new JFXPanel();
            Scene scene = new Scene((Parent)pane);
            InteroptContextFunction.integrateInToTheme(context, scene);
            fxPanel.setScene(scene);
            jpanel.add((Component)fxPanel);
            return pane;
        }
        return null;
    }

    private static void integrateInToTheme(IEclipseContext context, Scene scene) {
        Object object = context.get("org.eclipse.fx.ui.services.theme.ThemeManager");
        if (object != null) {
            ThemeManager mgr = (ThemeManager)object;
            mgr.registerScene(scene);
            if (mgr.getCurrentTheme() == null && System.getProperty("javafx.theme") != null) {
                mgr.setCurrentThemeId(((Theme)mgr.getAvailableThemes().get((Object)System.getProperty("javafx.theme"))).getId());
            }
        }
    }
}

