/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fx.core.KeyValueStore;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.event.Event;
import org.eclipse.fx.core.event.EventBus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.EventHandler;

@Component(service={IContextFunction.class}, property={"service.context.key=org.eclipse.fx.core.event.EventBus"})
public class EventSystemContextFunction
extends ContextFunction {
    public Object compute(IEclipseContext context) {
        return new EventSytemImpl((IEventBroker)context.get(IEventBroker.class));
    }

    static class EventSytemImpl
    implements EventBus {
        private final IEventBroker eventBroker;

        public EventSytemImpl(IEventBroker eventBroker) {
            this.eventBroker = eventBroker;
        }

        public <T> void publish(Event<T> event, boolean synchronous) {
            HashMap<String, Object> properties = new HashMap<String, Object>(event.getProperties().toMap());
            properties.put("org.eclipse.e4.data", event.getData());
            if (synchronous) {
                this.eventBroker.send(event.getTopic(), properties);
            } else {
                this.eventBroker.post(event.getTopic(), properties);
            }
        }

        public void publish(String topic, Object data, boolean synchronous) {
            Map<String, Object> d = data;
            if (data instanceof Map || data instanceof Dictionary) {
                d = Collections.singletonMap("org.eclipse.e4.data", data);
            }
            if (synchronous) {
                this.eventBroker.send(topic, d);
            } else {
                this.eventBroker.post(topic, d);
            }
        }

        public <T> Subscription subscribe(String topic, Consumer<Event<T>> consumer) {
            EventHandler eventHandler = event -> {
                if (event.containsProperty("org.eclipse.e4.data")) {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object instanceof Event) {
                        consumer.accept((Event)object);
                    } else {
                        consumer.accept(new Event(topic, object, (KeyValueStore)new KeyValueStore<String, Object>(){

                            public Object get(String key) throws IllegalArgumentException {
                                Object property = event.getProperty(key);
                                if (property == null && this.contains(key)) {
                                    throw new IllegalArgumentException("The key '" + key + "' is not known.");
                                }
                                return property;
                            }

                            public boolean contains(String key) {
                                return event.containsProperty(key);
                            }

                            public Set<String> getKeys() {
                                return new HashSet<String>(Arrays.asList(event.getPropertyNames()));
                            }

                            public Collection<Object> getValues() {
                                ArrayList<Object> data = new ArrayList<Object>(event.getPropertyNames().length);
                                String[] stringArray = event.getPropertyNames();
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String d = stringArray[n2];
                                    data.add(d);
                                    ++n2;
                                }
                                return data;
                            }
                        }));
                    }
                } else {
                    consumer.accept(new Event(topic, null, (KeyValueStore)new KeyValueStore<String, Object>(){

                        public Object get(String key) throws IllegalArgumentException {
                            Object property = event.getProperty(key);
                            if (property == null && this.contains(key)) {
                                throw new IllegalArgumentException("The key '" + key + "' is not known.");
                            }
                            return property;
                        }

                        public boolean contains(String key) {
                            return event.containsProperty(key);
                        }

                        public Set<String> getKeys() {
                            return new HashSet<String>(Arrays.asList(event.getPropertyNames()));
                        }

                        public Collection<Object> getValues() {
                            ArrayList<Object> data = new ArrayList<Object>(event.getPropertyNames().length);
                            String[] stringArray = event.getPropertyNames();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String d = stringArray[n2];
                                data.add(d);
                                ++n2;
                            }
                            return data;
                        }
                    }));
                }
            };
            this.eventBroker.subscribe(topic, eventHandler);
            return () -> {
                boolean bl = this.eventBroker.unsubscribe(eventHandler);
            };
        }
    }
}

