/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.image.Image;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.function.BiDoubleFunction;
import org.eclipse.fx.ui.controls.image.MultiDimensionImage;

public class DelegatingMultiDimensionImage
implements MultiDimensionImage {
    private final ReadOnlyDoubleWrapper ratio = new ReadOnlyDoubleWrapper((Object)this, "ratio", 1.0);
    private final ReadOnlyObjectWrapper<Image> image = new ReadOnlyObjectWrapper((Object)this, "image");
    private final BiDoubleFunction<CompletableFuture<Optional<Image>>> asyncImageProvider;
    private final BiDoubleFunction<Optional<Image>> syncImageProvider;
    private final ThreadSynchronize threadSync;
    private CompletableFuture<Optional<Image>> currentLoading;

    DelegatingMultiDimensionImage(BiDoubleFunction<Optional<Image>> syncImageProvider, ThreadSynchronize threadSync, BiDoubleFunction<CompletableFuture<Optional<Image>>> asyncImageProvider) {
        this.syncImageProvider = syncImageProvider;
        this.asyncImageProvider = asyncImageProvider;
        this.threadSync = threadSync;
    }

    @Override
    public double getRatio() {
        return this.ratio.get();
    }

    @Override
    public ReadOnlyDoubleProperty ratioProperty() {
        return this.ratio.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyObjectProperty<Image> imageProperty() {
        return this.image.getReadOnlyProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDimension(double w, double h) {
        if (this.syncImageProvider != null) {
            ((Optional)this.syncImageProvider.apply(w, h)).ifPresent(i -> {
                double newValue = i.getWidth() / i.getHeight();
                this.ratio.set(newValue);
                this.image.set(i);
            });
        } else {
            DelegatingMultiDimensionImage delegatingMultiDimensionImage = this;
            synchronized (delegatingMultiDimensionImage) {
                if (this.currentLoading != null) {
                    this.currentLoading.cancel(false);
                }
                this.currentLoading = (CompletableFuture)this.asyncImageProvider.apply(w, h);
                this.currentLoading.thenAccept(oi -> oi.ifPresent(i -> this.threadSync.asyncExec(() -> {
                    this.ratio.set(i.getWidth() / i.getHeight());
                    this.image.set(i);
                })));
            }
        }
    }

    public static DelegatingMultiDimensionImage async(ThreadSynchronize threadSync, BiDoubleFunction<CompletableFuture<Optional<Image>>> imageProvider) {
        Objects.requireNonNull(threadSync, "You need to provide a strategy to synchronize back to the ui thread");
        Objects.requireNonNull(imageProvider, "You need to provide a function who is responsible to load the image");
        return new DelegatingMultiDimensionImage(null, threadSync, imageProvider);
    }

    public static DelegatingMultiDimensionImage sync(BiDoubleFunction<Optional<Image>> imageProvider) {
        Objects.requireNonNull(imageProvider, "You need to provide a function who is responsible to load the image");
        return new DelegatingMultiDimensionImage(imageProvider, null, null);
    }
}

