/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.arguments;

import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.VarArgsFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class VarArgFeatureCallArguments
extends StandardFeatureCallArguments {
    public VarArgFeatureCallArguments(List<XExpression> arguments, List<JvmFormalParameter> parameters, boolean hasReceiver, ITypeReferenceOwner owner) {
        super(arguments, parameters, hasReceiver, owner);
    }

    @Override
    protected LightweightTypeReference internalGetParameterTypeForLambda(int idx) {
        if (idx >= this.arguments.size()) {
            throw new IndexOutOfBoundsException("Cannot read type for argument that is not present.");
        }
        if (idx >= this.parameters.size()) {
            idx = this.parameters.size() - 1;
        }
        LightweightTypeReference result = super.internalGetParameterTypeForLambda(idx);
        return VarArgFeatureCallArguments.getComponentTypeIfLast(result, this.parameters, idx);
    }

    protected static LightweightTypeReference getComponentTypeIfLast(LightweightTypeReference type, List<JvmFormalParameter> parameter, int idx) {
        LightweightTypeReference componentType;
        if (type != null && idx >= parameter.size() - 1 && (componentType = type.getComponentType()) != null) {
            return componentType;
        }
        return type;
    }

    @Override
    public IFeatureCallArgumentSlot getNextUnprocessedArgumentSlot() {
        if (!this.hasUnprocessedArguments()) {
            throw new NoSuchElementException();
        }
        if (this.nextUnprocessedArgument < this.parameters.size() - 1) {
            return new StandardFeatureCallArgumentSlot(this, this.nextUnprocessedArgument);
        }
        return new VarArgsFeatureCallArgumentSlot(this, this.nextUnprocessedArgument);
    }

    @Override
    public boolean hasEmptyTrailingVarArg() {
        return this.arguments.size() < this.parameters.size();
    }
}

