/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.e4.addons;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.SourceFileChange;
import org.eclipse.fx.code.editor.SourceFileInput;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.eclipse.fx.core.event.Event;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.event.Topic;

public class DirtyStateTrackingAddon {
    private EModelService modelService;
    private MApplication application;
    private final EventBus broker;
    private final Topic<MApplicationElement> TOPIC_DIRTY = new Topic("org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*");
    private final Topic<String> TOPIC_REQUEST_ENABLEMENT_UPDATE_STRING = new Topic("org/eclipse/e4/ui/renderer/requestEnablementUpdate");

    @Inject
    public DirtyStateTrackingAddon(EventBus broker, EModelService modelService, MApplication application) {
        this.broker = broker;
        this.modelService = modelService;
        this.application = application;
    }

    @PostConstruct
    void init() {
        this.broker.subscribe(Constants.TOPIC_SOURCE_FILE_INPUT_MODIFIED, this::handleDocumentModified);
        this.broker.subscribe(Constants.TOPIC_SOURCE_FILE_INPUT_SAVED, this::handleDocumentSaved);
        this.broker.subscribe(this.TOPIC_DIRTY, this::handlePartDirty);
    }

    void handlePartDirty(Event<MApplicationElement> event) {
        Object element = event.getData();
        if (element == null) {
            element = event.getProperties().get((Object)"ChangedElement");
        }
        if (element instanceof MContext) {
            ((MContext)element).getContext().set("code-editor-dirty", event.getProperties().get((Object)"NewValue"));
            this.broker.publish(this.TOPIC_REQUEST_ENABLEMENT_UPDATE_STRING, (Object)"ALL", true);
        }
    }

    void handleDocumentSaved(Event<SourceFileInput> event) {
        String tmpUri;
        Input input = (Input)event.getData();
        String uri = tmpUri = ((URIProvider)input).getURI();
        this.modelService.findElements((MApplicationElement)this.application, MPart.class, 29, e -> {
            if (e instanceof MPart) {
                return ((MPart)e).getContext() != null && uri.equals(((MPart)e).getContext().getLocal("documentUrl"));
            }
            return false;
        }).forEach(e -> e.setDirty(false));
    }

    void handleDocumentModified(Event<SourceFileChange> event) {
        String uri = ((SourceFileChange)event.getData()).input.getURI();
        this.modelService.findElements((MApplicationElement)this.application, MPart.class, 29, e -> {
            if (e instanceof MPart) {
                return ((MPart)e).getContext() != null && uri.equals(((MPart)e).getContext().getLocal("documentUrl"));
            }
            return false;
        }).forEach(e -> e.setDirty(true));
    }
}

