/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log4j;

import jakarta.inject.Provider;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.fx.core.RankedService;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={LoggerFactory.class}, property={"service.ranking:Integer=1"})
public class Log4JLoggerFactory
implements LoggerFactory,
Provider<LoggerFactory>,
RankedService {
    public Log4JLoggerFactory() {
        String properties = System.getProperty("efxclipse.log4.properties");
        if (properties != null) {
            PropertyConfigurator.configure((String)properties);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void registerAppender(Appender appender) {
        org.apache.log4j.Logger.getRootLogger().addAppender(appender);
    }

    public void unregisterAppender(Appender appender) {
        org.apache.log4j.Logger.getRootLogger().addAppender(appender);
    }

    public int getRanking() {
        return 1;
    }

    public LoggerFactory get() {
        return this;
    }

    public Logger createLogger(String name) {
        return new LoggerImpl(name);
    }

    static class LoggerImpl
    implements Logger {
        private org.apache.log4j.Logger logger;
        private String name;
        private static final @NonNull String FQN = LoggerImpl.class.getCanonicalName();

        public LoggerImpl(String name) {
            this.name = name;
        }

        private org.apache.log4j.Logger getLogger() {
            if (this.logger == null) {
                this.logger = org.apache.log4j.Logger.getLogger((String)this.name);
            }
            return this.logger;
        }

        private static Level toLog4JLevel(Logger.Level level) {
            switch (level) {
                case DEBUG: {
                    return Level.DEBUG;
                }
                case ERROR: {
                    return Level.ERROR;
                }
                case FATAL: {
                    return Level.FATAL;
                }
                case INFO: {
                    return Level.INFO;
                }
                case TRACE: {
                    return Level.TRACE;
                }
                case WARNING: {
                    return Level.WARN;
                }
            }
            return Level.ERROR;
        }

        public void log(Logger.Level level, String message) {
            this.log(FQN, level, message, null);
        }

        public void log(Logger.Level level, String message, Throwable t) {
            this.log(FQN, level, message, t);
        }

        public void log(String wrapperClass, Logger.Level level, CharSequence message, @Nullable Throwable t) {
            this.getLogger().log(wrapperClass, (Priority)LoggerImpl.toLog4JLevel(level), (Object)message, t);
        }

        public void log(@NonNull String wrapperClass, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Logger.Level level, @NonNull CharSequence message) {
            this.getLogger().log(wrapperClass, (Priority)LoggerImpl.toLog4JLevel(level), (Object)message, null);
        }

        public void logf(Logger.Level level, String pattern, Object ... args) {
            this.logf(FQN, level, pattern, args);
        }

        public void logf(Logger.Level level, String pattern, Throwable t, Object ... args) {
            this.logf(FQN, level, pattern, t, args);
        }

        public void logf(String wrapperClass, Logger.Level level, String pattern, Object ... args) {
            Level log4jLevel = LoggerImpl.toLog4JLevel(level);
            if (this.getLogger().isEnabledFor((Priority)log4jLevel)) {
                this.getLogger().log(wrapperClass, (Priority)log4jLevel, (Object)String.format(pattern, args), null);
            }
        }

        public void logf(String wrapperClass, Logger.Level level, String pattern, Throwable t, Object ... args) {
            Level log4jLevel = LoggerImpl.toLog4JLevel(level);
            if (this.getLogger().isEnabledFor((Priority)log4jLevel)) {
                this.getLogger().log(wrapperClass, (Priority)log4jLevel, (Object)String.format(pattern, args), t);
            }
        }

        public void trace(String message) {
            this.log(Logger.Level.TRACE, message);
        }

        public void debug(String message) {
            this.log(Logger.Level.DEBUG, message);
        }

        public void info(String message) {
            this.log(Logger.Level.INFO, message);
        }

        public void warning(String message) {
            this.log(Logger.Level.WARNING, message);
        }

        public void error(String message) {
            this.log(Logger.Level.ERROR, message);
        }

        public void fatal(String message) {
            this.log(Logger.Level.FATAL, message);
        }

        public void trace(String message, Throwable t) {
            this.log(Logger.Level.TRACE, message, t);
        }

        public void debug(String message, Throwable t) {
            this.log(Logger.Level.DEBUG, message, t);
        }

        public void info(String message, Throwable t) {
            this.log(Logger.Level.INFO, message, t);
        }

        public void warning(String message, Throwable t) {
            this.log(Logger.Level.WARNING, message, t);
        }

        public void error(String message, Throwable t) {
            this.log(Logger.Level.ERROR, message, t);
        }

        public void fatal(String message, Throwable t) {
            this.log(Logger.Level.FATAL, message, t);
        }

        public void tracef(String pattern, Object ... args) {
            this.logf(Logger.Level.TRACE, pattern, args);
        }

        public void debugf(String pattern, Object ... args) {
            this.logf(Logger.Level.DEBUG, pattern, args);
        }

        public void infof(String pattern, Object ... args) {
            this.logf(Logger.Level.INFO, pattern, args);
        }

        public void warningf(String pattern, Object ... args) {
            this.logf(Logger.Level.WARNING, pattern, args);
        }

        public void errorf(String pattern, Object ... args) {
            this.logf(Logger.Level.ERROR, pattern, args);
        }

        public void fatalf(String pattern, Object ... args) {
            this.logf(Logger.Level.FATAL, pattern, args);
        }

        public void tracef(String pattern, Throwable t, Object ... args) {
            this.logf(Logger.Level.TRACE, pattern, t, args);
        }

        public void debugf(String pattern, Throwable t, Object ... args) {
            this.logf(Logger.Level.DEBUG, pattern, t, args);
        }

        public void infof(String pattern, Throwable t, Object ... args) {
            this.logf(Logger.Level.INFO, pattern, t, args);
        }

        public void warningf(String pattern, Throwable t, Object ... args) {
            this.logf(Logger.Level.WARNING, pattern, t, args);
        }

        public void errorf(String pattern, Throwable t, Object ... args) {
            this.logf(Logger.Level.ERROR, pattern, t, args);
        }

        public void fatalf(String pattern, Throwable t, Object ... args) {
            this.logf(Logger.Level.FATAL, pattern, t, args);
        }

        public boolean isEnabled(Logger.Level level) {
            return this.getLogger().isEnabledFor((Priority)LoggerImpl.toLog4JLevel(level));
        }
    }
}

