/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.addons.MinMaxAddonUtil;
import org.eclipse.fx.ui.workbench.renderers.base.addons.TrimStackIdHelper;
import org.eclipse.fx.ui.workbench.renderers.base.services.PartialRestoreMinMaxService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;

public class MinMaxAddonWithPartialRestore {
    private static final String MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG = "MinMaximizeableChildrenArea";
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    private static final String MINIMIZED = "Minimized";
    private static final String MAXIMIZED = "Maximized";
    private static final String MINIMIZED_BY_ZOOM = "MinimizedByZoom";
    private final IEventBroker eventBroker;
    final EModelService modelService;
    private final IEclipseContext context;
    private final PartialRestoreMinMaxService minMaxRestoreService;
    private boolean ignoreTagChanges = false;
    final MAddon minMaxAddon;
    @Inject
    @Log
    private Logger logger;

    @Inject
    MinMaxAddonWithPartialRestore(IEventBroker eventBroker, EModelService modelService, IEclipseContext context, PartialRestoreMinMaxService minMaxRestoreService, MAddon minMaxAddon) {
        this.eventBroker = eventBroker;
        this.modelService = modelService;
        this.context = context;
        this.minMaxRestoreService = minMaxRestoreService;
        this.minMaxAddon = minMaxAddon;
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this::subscribeTopicWidget);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::subscribeTopicChildren);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this::subscribeTopicSelectedElement);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this::subscribeTopicTagsChanged);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*", this::subscribeTopicElementId);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/perpSaved", this::subscribeTopicPerspSaved);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/perspReset", this::subscribeTopicPerspReset);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/perspOpened", this::subscribeTopicPerspOpened);
    }

    private static void setState(MUIElement element, String state) {
        if (MINIMIZED.equals(state)) {
            element.getTags().remove(MAXIMIZED);
            element.getTags().add(MINIMIZED);
        } else if (MAXIMIZED.equals(state)) {
            element.getTags().remove(MINIMIZED);
            element.getTags().add(MAXIMIZED);
        } else {
            element.getTags().remove(MINIMIZED);
            element.getTags().remove(MAXIMIZED);
        }
    }

    private void subscribeTopicWidget(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
            return;
        }
        WMinMaxableWidget ctf = this.getCTFFor(changedElement);
        if (ctf == null) {
            return;
        }
        MUIElement stateElement = changedElement;
        if (changedElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)changedElement;
            MArea area = MinMaxAddonUtil.getAreaFor(stack);
            if (area != null && !(area.getWidget() instanceof WMinMaxableWidget)) {
                stateElement = area.getCurSharedRef();
            }
        } else if (changedElement instanceof MArea) {
            stateElement = changedElement.getCurSharedRef();
        }
        this.adjustCTFButtons(stateElement);
        MUIElement fStateElement = stateElement;
        ctf.setMinMaxCallback(param -> {
            if (param == WMinMaxableWidget.WMinMaxState.TOGGLE) {
                this.handleMinMaxToggle(fStateElement);
            } else if (param == WMinMaxableWidget.WMinMaxState.MINIMIZE) {
                MinMaxAddonWithPartialRestore.setState(fStateElement, MINIMIZED);
            } else if (param == WMinMaxableWidget.WMinMaxState.RESTORE) {
                MinMaxAddonWithPartialRestore.setState(fStateElement, null);
            }
            return null;
        });
    }

    private void handleMinMaxToggle(MUIElement fStateElement) {
        if (!fStateElement.getTags().contains(MAXIMIZED)) {
            if (this.minMaxRestoreService.isMaximizable(fStateElement)) {
                MinMaxAddonWithPartialRestore.setState(fStateElement, MAXIMIZED);
            }
        } else {
            MinMaxAddonWithPartialRestore.setState(fStateElement, null);
        }
    }

    private void subscribeTopicChildren(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MWindow window = this.modelService.getTopLevelWindowFor(changedElement);
        if (!(changedElement instanceof MPerspectiveStack) || window == null || !(window instanceof MTrimmedWindow)) {
            return;
        }
        if (UIEvents.isREMOVE((Event)event)) {
            for (Object removedElement : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                MUIElement removed = (MUIElement)removedElement;
                if (removed == null) continue;
                String perspectiveId = removed.getElementId();
                MTrimBar bar = this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MUIElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    }

    private void subscribeTopicSelectedElement(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPerspectiveStack)) {
            return;
        }
        MPerspectiveStack ps = (MPerspectiveStack)changedElement;
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)ps);
        List tcList = this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
        MPerspective curPersp = (MPerspective)ps.getSelectedElement();
        if (curPersp != null) {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(MINIMIZED);
            List minimizedElements = this.modelService.findElements((MUIElement)curPersp, null, MUIElement.class, tags);
            for (MUIElement ele : minimizedElements) {
                String fullId = TrimStackIdHelper.createTrimStackId(ele, curPersp, window);
                for (MToolControl tc : tcList) {
                    if (!fullId.equals(tc.getElementId())) continue;
                    tc.setToBeRendered(true);
                }
            }
            MUIElement eaPlaceholder = this.modelService.find(ID_EDITOR_AREA, (MUIElement)curPersp);
            this.adjustCTFButtons(eaPlaceholder);
        }
        if (event.getProperty("OldValue") instanceof MPerspective) {
            MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
            String perspId = "(" + oldPersp.getElementId() + ")";
            for (MToolControl tc : tcList) {
                if (!(tc.getObject() instanceof PartialRestoreMinMaxService.TrimStack) || !tc.getElementId().contains(perspId)) continue;
                PartialRestoreMinMaxService.TrimStack ts = (PartialRestoreMinMaxService.TrimStack)tc.getObject();
                ts.showStack(false);
                tc.setToBeRendered(false);
            }
        }
    }

    private void subscribeTopicTagsChanged(Event event) {
        if (this.ignoreTagChanges) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MUIElement)) {
            return;
        }
        MUIElement changedElement = (MUIElement)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MINIMIZED)) {
                this.minimize(changedElement);
            } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MAXIMIZED)) {
                this.maximize(changedElement);
            }
        } else if (UIEvents.isREMOVE((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MINIMIZED)) {
                this.restore(changedElement);
            } else if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MAXIMIZED)) {
                this.unzoom(changedElement);
            }
        }
    }

    private void subscribeTopicElementId(Event event) {
        Object changedObject = event.getProperty("ChangedElement");
        if (!(changedObject instanceof MPerspective)) {
            return;
        }
        MPerspective perspective = (MPerspective)changedObject;
        Object newID = (String)event.getProperty("NewValue");
        Object oldID = (String)event.getProperty("OldValue");
        newID = "(" + (String)newID + ")";
        oldID = "(" + (String)oldID + ")";
        MWindow perspWin = this.modelService.getTopLevelWindowFor((MUIElement)perspective);
        if (perspWin == null) {
            return;
        }
        List trimStacks = this.modelService.findElements((MUIElement)perspWin, null, MToolControl.class, null);
        for (MToolControl trimStack : trimStacks) {
            if (!this.getTrimStackContributionURI().equals(trimStack.getContributionURI())) continue;
            trimStack.setElementId(trimStack.getElementId().replace((CharSequence)oldID, (CharSequence)newID));
        }
    }

    private String getTrimStackContributionURI() {
        Class<? extends PartialRestoreMinMaxService.TrimStack> type = this.minMaxRestoreService.getTrimStackType();
        Bundle bundle = FrameworkUtil.getBundle(type);
        return "bundleclass://" + bundle.getSymbolicName() + "/" + type.getName();
    }

    @Inject
    @Optional
    private void subscribeTopicPerspSaved(Event event) {
        MPerspective savedPersp = (MPerspective)event.getProperty("ChangedElement");
        String cache = this.getTrimCache(savedPersp);
        this.minMaxAddon.getPersistedState().put(savedPersp.getElementId(), cache);
    }

    private String getTrimCache(MPerspective savedPersp) {
        MWindow topWin = this.modelService.getTopLevelWindowFor((MUIElement)savedPersp);
        StringBuilder cache = new StringBuilder(this.getWinCache(topWin, savedPersp));
        for (MWindow dw : savedPersp.getWindows()) {
            cache.append(this.getWinCache(dw, savedPersp));
        }
        return cache.toString();
    }

    private String getWinCache(MWindow win, MPerspective perspective) {
        StringBuilder winStrBuilder = new StringBuilder();
        List stackList = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null);
        for (MPartStack stack : stackList) {
            winStrBuilder.append(this.getStackTrimLoc(stack, perspective));
        }
        return winStrBuilder.toString();
    }

    private String getStackTrimLoc(MPartStack stack, MPerspective perspective) {
        MWindow stackWin = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        MUIElement tcElement = this.modelService.find(TrimStackIdHelper.createTrimStackId((MUIElement)stack, perspective, stackWin), (MUIElement)stackWin);
        if (tcElement == null) {
            return "";
        }
        MTrimBar bar = (MTrimBar)tcElement.getParent();
        int sideVal = bar.getSide().getValue();
        int index = bar.getChildren().indexOf(tcElement);
        return stack.getElementId() + " " + sideVal + " " + index + "#";
    }

    private void subscribeTopicPerspReset(Event event) {
        MPerspective resetPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)resetPersp, null, MUIElement.class, Arrays.asList(MINIMIZED));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
    }

    private void subscribeTopicPerspOpened(Event event) {
        MPerspective openedPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)openedPersp, null, MUIElement.class, Arrays.asList(MINIMIZED));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
    }

    private void setCTFButtons(WMinMaxableWidget ctf, MUIElement stateElement, boolean hideButtons) {
        if (!this.minMaxRestoreService.isMaximizable(stateElement)) {
            ctf.setMinMaxState(WMinMaxableWidget.WMinMaxWidgetState.NONE);
        } else if (stateElement.getTags().contains(MINIMIZED)) {
            ctf.setMinMaxState(WMinMaxableWidget.WMinMaxWidgetState.MINIMIZED);
        } else if (stateElement.getTags().contains(MAXIMIZED)) {
            ctf.setMinMaxState(WMinMaxableWidget.WMinMaxWidgetState.MAXIMIZED);
        } else {
            ctf.setMinMaxState(WMinMaxableWidget.WMinMaxWidgetState.DEFAULT);
        }
    }

    void adjustCTFButtons(MUIElement element) {
        if (!(element instanceof MPartStack) && !(element instanceof MPlaceholder)) {
            return;
        }
        WMinMaxableWidget ctf = this.getCTFFor(element);
        if (ctf == null) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.setCTFButtons(ctf, element, false);
        } else {
            MArea area = MinMaxAddonUtil.getAreaFor((MPartStack)element);
            if (area == null) {
                this.setCTFButtons(ctf, element, false);
            } else if (area.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
                this.setCTFButtons(ctf, element, false);
            }
        }
    }

    private WMinMaxableWidget getCTFFor(MUIElement element) {
        if (element instanceof MArea) {
            if (element.getWidget() instanceof WMinMaxableWidget) {
                return (WMinMaxableWidget)element.getWidget();
            }
            List stacks = this.modelService.findElements(element, null, MPartStack.class, null);
            for (MPartStack stack : stacks) {
                if (!(stack.getWidget() instanceof WMinMaxableWidget)) continue;
                return (WMinMaxableWidget)stack.getWidget();
            }
        } else {
            MPlaceholder ph;
            if (element.getWidget() instanceof WMinMaxableWidget) {
                return (WMinMaxableWidget)element.getWidget();
            }
            if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() instanceof MArea) {
                return this.getCTFFor(ph.getRef());
            }
        }
        return null;
    }

    static boolean isEmptyPerspectiveStack(MUIElement element) {
        if (!(element instanceof MPerspectiveStack)) {
            return false;
        }
        MPerspectiveStack ps = (MPerspectiveStack)element;
        return ps.getChildren().isEmpty();
    }

    void minimize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (MinMaxAddonWithPartialRestore.isEmptyPerspectiveStack(element)) {
            element.setVisible(false);
            return;
        }
        this.createTrim(element);
        element.setVisible(false);
        this.adjustCTFButtons(element);
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        EPartService partService = (EPartService)win.getContext().get(EPartService.class);
        partService.requestActivation();
    }

    void restore(MUIElement element) {
        MWindow window = this.modelService.getTopLevelWindowFor(element);
        String trimId = this.getTrimId(element, MinMaxAddonUtil.getWindowFor(element));
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (!(trimStack != null && trimStack.getObject() != null || (trimStack = (MToolControl)this.modelService.find(trimId = TrimStackIdHelper.createTrimStackId(element, this.modelService.getPerspectiveFor(element), null), (MUIElement)window)) != null && trimStack.getObject() != null)) {
            if (element instanceof MPerspectiveStack) {
                element.setVisible(true);
            }
            return;
        }
        PartialRestoreMinMaxService.TrimStack ts = (PartialRestoreMinMaxService.TrimStack)trimStack.getObject();
        ts.restoreStack();
        this.adjustCTFButtons(element);
        ArrayList<String> maximizeTag = new ArrayList<String>();
        maximizeTag.add(MAXIMIZED);
        List curMax = this.modelService.findElements((MUIElement)window, null, MUIElement.class, maximizeTag, 11);
        MinMaxAddonUtil.ignoreChildrenOfMinMaxChildrenArea(this.modelService, element, curMax);
        if (curMax.size() > 0) {
            MUIElement maxElement = (MUIElement)curMax.get(0);
            List<MUIElement> elementsLeftToRestore = this.getElementsToRestore(maxElement);
            boolean unMax = true;
            for (MUIElement toRestore : elementsLeftToRestore) {
                if (toRestore.isVisible()) continue;
                unMax = false;
            }
            if (unMax) {
                maxElement.getTags().remove(MAXIMIZED);
            }
        }
        MinMaxAddonUtil.restoreStacksOfMinMaxChildrenArea(this, element, maximizeTag);
    }

    void executeWithIgnoredTagChanges(Runnable runnable) {
        this.ignoreTagChanges = true;
        try {
            runnable.run();
        }
        finally {
            this.ignoreTagChanges = false;
        }
    }

    void maximize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        List<MUIElement> elementsToMinimize = this.getElementsToMinimize(element);
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        this.restoreMaximizedElement(element, win);
        for (MUIElement toMinimize : elementsToMinimize) {
            toMinimize.getTags().add(MINIMIZED);
            toMinimize.getTags().add(MINIMIZED_BY_ZOOM);
        }
        this.adjustCTFButtons(element);
        MinMaxAddonUtil.maximizeMinMaxChildrenArea(this, element);
    }

    private List<MUIElement> getElementsToMinimize(MUIElement element) {
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToMinimize = new ArrayList<MUIElement>();
        int loc = this.modelService.getElementLocation(element);
        if ((loc & 1) != 0) {
            List pStacks;
            List<MPartStack> partStacksToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)win, null, MPartStack.class, 1, false);
            elementsToMinimize.addAll(partStacksToMinimize);
            Object perspStack = null;
            perspStack = persp == null ? ((pStacks = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() > 0 ? (MUIElement)pStacks.get(0) : null) : persp.getParent();
            if (perspStack != null) {
                if (perspStack.getElementId() == null || perspStack.getElementId().length() == 0) {
                    perspStack.setElementId("PerspectiveStack");
                }
                elementsToMinimize.add((MUIElement)perspStack);
            }
            List<MPlaceholder> placeholderToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)win, ID_EDITOR_AREA, MPlaceholder.class, 1, true);
            elementsToMinimize.addAll(placeholderToMinimize);
        } else {
            List<MPartStack> partStacksToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)(persp == null ? win : persp), null, MPartStack.class, 11, false);
            elementsToMinimize.addAll(partStacksToMinimize);
            ArrayList<String> standaloneTag = new ArrayList<String>();
            standaloneTag.add("Standalone");
            List standaloneViews = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPlaceholder.class, standaloneTag, 11);
            for (MPlaceholder part : standaloneViews) {
                if (!part.isToBeRendered()) continue;
                elementsToMinimize.add((MUIElement)part);
            }
            List<MPlaceholder> placeholderToMinimize = this.findValidElementsToMinimize(element, win, (MUIElement)win, ID_EDITOR_AREA, MPlaceholder.class, 11, true);
            elementsToMinimize.addAll(placeholderToMinimize);
        }
        MinMaxAddonUtil.handleMinimizeOfMinMaxChildrenArea(this.modelService, element, win, persp, elementsToMinimize);
        return elementsToMinimize;
    }

    private <T extends MUIElement> List<T> findValidElementsToMinimize(MUIElement elementToMaximize, MWindow currentWindow, MUIElement searchRoot, String id, Class<T> clazz, int searchFlag, boolean allowSharedArea) {
        ArrayList<MUIElement> elementsToMinimize = new ArrayList<MUIElement>();
        List elements = this.modelService.findElements(searchRoot, id, clazz, null, searchFlag);
        for (MUIElement element : elements) {
            boolean validLocation;
            if (element == null || element == elementToMaximize || !element.isToBeRendered() || MinMaxAddonUtil.getWindowFor(element) != currentWindow) continue;
            int loc = this.modelService.getElementLocation(element);
            boolean inSharedArea = loc == 8;
            boolean bl = validLocation = allowSharedArea || !inSharedArea;
            if (validLocation && element.getWidget() != null && element.isVisible() && !element.getTags().contains(MINIMIZED)) {
                elementsToMinimize.add(element);
                continue;
            }
            this.logger.debugf("Skipping: %s", new Object[]{element});
        }
        return elementsToMinimize;
    }

    private void restoreMaximizedElement(MUIElement element, MWindow win) {
        MPerspective elePersp = this.modelService.getPerspectiveFor(element);
        ArrayList<String> maxTag = new ArrayList<String>();
        maxTag.add(MAXIMIZED);
        List curMax = this.modelService.findElements((MUIElement)win, null, MUIElement.class, maxTag);
        if (curMax.size() > 0) {
            for (MUIElement maxElement : curMax) {
                MPerspective maxPersp;
                if (MinMaxAddonUtil.getWindowFor(maxElement) != win || (maxPersp = this.modelService.getPerspectiveFor(maxElement)) != elePersp || maxElement == element || MinMaxAddonUtil.isPartOfMinMaxChildrenArea(maxElement)) continue;
                this.ignoreTagChanges = true;
                try {
                    maxElement.getTags().remove(MAXIMIZED);
                }
                finally {
                    this.ignoreTagChanges = false;
                }
            }
        }
    }

    void unzoom(MUIElement element) {
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        List<MUIElement> elementsToRestore = this.getElementsToRestore(element);
        for (MUIElement toRestore : elementsToRestore) {
            toRestore.getTags().remove(MINIMIZED_BY_ZOOM);
            toRestore.getTags().remove(MINIMIZED);
        }
        this.adjustCTFButtons(element);
        MinMaxAddonUtil.unzoomStackOfMinMaxChildrenArea(this, element);
        EPartService partService = (EPartService)win.getContext().get(EPartService.class);
        partService.requestActivation();
    }

    private List<MUIElement> getElementsToRestore(MUIElement element) {
        MPerspectiveStack perspStack;
        List psList;
        int loc;
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToRestore = new ArrayList<MUIElement>();
        ArrayList<String> minTag = new ArrayList<String>();
        minTag.add(MINIMIZED_BY_ZOOM);
        boolean outsidePerspectives = (this.modelService.getElementLocation(element) & 1) != 0;
        List stacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, minTag, 11);
        for (MPartStack theStack : stacks) {
            int stackLoc;
            if (theStack.getWidget() == null || outsidePerspectives && ((stackLoc = this.modelService.getElementLocation((MUIElement)theStack)) & 1) == 0 || MinMaxAddonUtil.getWindowFor((MUIElement)theStack) != win) continue;
            elementsToRestore.add((MUIElement)theStack);
        }
        List views = this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, minTag, 11);
        for (MPlaceholder ph : views) {
            if (ph.getWidget() == null || MinMaxAddonUtil.getWindowFor((MUIElement)ph) != win) continue;
            elementsToRestore.add((MUIElement)ph);
        }
        MPlaceholder eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)(persp == null ? win : persp));
        if (element != eaPlaceholder && eaPlaceholder != null && eaPlaceholder.getTags().contains(MINIMIZED_BY_ZOOM)) {
            elementsToRestore.add((MUIElement)eaPlaceholder);
        }
        if (((loc = this.modelService.getElementLocation(element)) & 1) != 0 && (psList = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() == 1 && element != (perspStack = (MPerspectiveStack)psList.get(0)) && perspStack != null && perspStack.getTags().contains(MINIMIZED_BY_ZOOM)) {
            elementsToRestore.add((MUIElement)perspStack);
        }
        MinMaxAddonUtil.addChildrenOfMinMaxChildrenAreaToRestoreList(this.modelService, element, win, persp, elementsToRestore);
        return elementsToRestore;
    }

    private void createTrim(MUIElement element) {
        MWindow win = MinMaxAddonUtil.getWindowFor(element);
        if (!(win instanceof MTrimmedWindow)) {
            return;
        }
        MTrimmedWindow window = (MTrimmedWindow)win;
        WWindow winShell = (WWindow)window.getWidget();
        String trimId = this.getTrimId(element, (MWindow)window);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(this.getTrimStackContributionURI());
            trimStack.getTags().add("TrimStack");
            trimStack.getTags().add("Container:StackPane");
            MTrimBar bar = this.minMaxRestoreService.findTrimBarForElement(this.modelService, element, window);
            bar.getChildren().add(trimStack);
            bar.setVisible(true);
            if (bar.getWidget() == null) {
                bar.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)bar, (Object)winShell, window.getContext());
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
            trimStack.setToBeRendered(true);
        }
    }

    private String getTrimId(MUIElement element, MWindow window) {
        String trimId = MinMaxAddonUtil.isPartOfMinMaxChildrenArea(element) ? TrimStackIdHelper.createTrimStackId(element, null, window) : TrimStackIdHelper.createTrimStackId(element, this.modelService.getPerspectiveFor(element), window);
        return trimId;
    }
}

