/*******************************************************************************
 * Copyright (c) 2000, 2024 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

/* Note: This file was auto-generated by org.eclipse.swt.tools.internal.JNIGenerator */
/* DO NOT EDIT - your changes will be lost. */

#include "swt.h"
#include "gtk3_structs.h"
#include "gtk3_stats.h"
#include "os_structs.h"

#ifndef GTK3_NATIVE
#define GTK3_NATIVE(func) Java_org_eclipse_swt_internal_gtk3_GTK3_##func
#endif

#ifdef _WIN32
  /* Many methods don't use their 'env' and 'that' arguments */
  #pragma warning (disable: 4100)
#endif

#ifndef NO_GTK_1IS_1MENU_1ITEM
JNIEXPORT jboolean JNICALL GTK3_NATIVE(GTK_1IS_1MENU_1ITEM)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, GTK_1IS_1MENU_1ITEM_FUNC);
	rc = (jboolean)GTK_IS_MENU_ITEM(arg0);
	GTK3_NATIVE_EXIT(env, that, GTK_1IS_1MENU_1ITEM_FUNC);
	return rc;
}
#endif

#ifndef NO_GTK_1TYPE_1MENU
JNIEXPORT jlong JNICALL GTK3_NATIVE(GTK_1TYPE_1MENU)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, GTK_1TYPE_1MENU_FUNC);
	rc = (jlong)GTK_TYPE_MENU;
	GTK3_NATIVE_EXIT(env, that, GTK_1TYPE_1MENU_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEventButton_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEventButton_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEventButton_1sizeof_FUNC);
	rc = (jint)GdkEventButton_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEventButton_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEventCrossing_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEventCrossing_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEventCrossing_1sizeof_FUNC);
	rc = (jint)GdkEventCrossing_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEventCrossing_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEventFocus_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEventFocus_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEventFocus_1sizeof_FUNC);
	rc = (jint)GdkEventFocus_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEventFocus_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEventKey_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEventKey_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEventKey_1sizeof_FUNC);
	rc = (jint)GdkEventKey_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEventKey_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEventMotion_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEventMotion_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEventMotion_1sizeof_FUNC);
	rc = (jint)GdkEventMotion_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEventMotion_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEventWindowState_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEventWindowState_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEventWindowState_1sizeof_FUNC);
	rc = (jint)GdkEventWindowState_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEventWindowState_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkEvent_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkEvent_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkEvent_1sizeof_FUNC);
	rc = (jint)GdkEvent_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkEvent_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkGeometry_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkGeometry_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkGeometry_1sizeof_FUNC);
	rc = (jint)GdkGeometry_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkGeometry_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdkWindowAttr_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GdkWindowAttr_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GdkWindowAttr_1sizeof_FUNC);
	rc = (jint)GdkWindowAttr_sizeof();
	GTK3_NATIVE_EXIT(env, that, GdkWindowAttr_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GtkTargetEntry_1sizeof
JNIEXPORT jint JNICALL GTK3_NATIVE(GtkTargetEntry_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, GtkTargetEntry_1sizeof_FUNC);
	rc = (jint)GtkTargetEntry_sizeof();
	GTK3_NATIVE_EXIT(env, that, GtkTargetEntry_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_gdk_1window_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gdk_1window_1new)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	GdkWindowAttr _arg1, *lparg1=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gdk_1window_1new_FUNC);
	if (arg1) if ((lparg1 = getGdkWindowAttrFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jlong)gdk_window_new((GdkWindow *)arg0, lparg1, arg2);
fail:
	GTK3_NATIVE_EXIT(env, that, gdk_1window_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1accel_1label_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1accel_1label_1new)
	(JNIEnv *env, jclass that, jbyteArray arg0)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1accel_1label_1new_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_accel_label_new((const gchar *)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1accel_1label_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1accel_1label_1set_1accel
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1accel_1label_1set_1accel)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1accel_1label_1set_1accel_FUNC);
	gtk_accel_label_set_accel((GtkAccelLabel *)arg0, (guint)arg1, (GdkModifierType)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1accel_1label_1set_1accel_FUNC);
}
#endif

#ifndef NO_gtk_1accel_1label_1set_1accel_1widget
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1accel_1label_1set_1accel_1widget)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1accel_1label_1set_1accel_1widget_FUNC);
	gtk_accel_label_set_accel_widget((GtkAccelLabel *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1accel_1label_1set_1accel_1widget_FUNC);
}
#endif

#ifndef NO_gtk_1accessible_1get_1widget
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1accessible_1get_1widget)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1accessible_1get_1widget_FUNC);
	rc = (jlong)gtk_accessible_get_widget((GtkAccessible *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1accessible_1get_1widget_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1bin_1get_1child
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1bin_1get_1child)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1bin_1get_1child_FUNC);
	rc = (jlong)gtk_bin_get_child((GtkBin *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1bin_1get_1child_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1box_1pack_1end
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1box_1pack_1end)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jboolean arg2, jboolean arg3, jint arg4)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1box_1pack_1end_FUNC);
	gtk_box_pack_end((GtkBox *)arg0, (GtkWidget *)arg1, (gboolean)arg2, (gboolean)arg3, (guint)arg4);
	GTK3_NATIVE_EXIT(env, that, gtk_1box_1pack_1end_FUNC);
}
#endif

#ifndef NO_gtk_1box_1reorder_1child
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1box_1reorder_1child)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1box_1reorder_1child_FUNC);
	gtk_box_reorder_child((GtkBox *)arg0, (GtkWidget *)arg1, (gint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1box_1reorder_1child_FUNC);
}
#endif

#ifndef NO_gtk_1box_1set_1child_1packing
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1box_1set_1child_1packing)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jboolean arg2, jboolean arg3, jint arg4, jint arg5)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1box_1set_1child_1packing_FUNC);
	gtk_box_set_child_packing((GtkBox *)arg0, (GtkWidget *)arg1, arg2, arg3, arg4, arg5);
	GTK3_NATIVE_EXIT(env, that, gtk_1box_1set_1child_1packing_FUNC);
}
#endif

#ifndef NO_gtk_1button_1set_1image
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1button_1set_1image)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1button_1set_1image_FUNC);
	gtk_button_set_image((GtkButton *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1button_1set_1image_FUNC);
}
#endif

#ifndef NO_gtk_1calendar_1get_1date
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1calendar_1get_1date)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1calendar_1get_1date_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	gtk_calendar_get_date((GtkCalendar *)arg0, (guint *)lparg1, (guint *)lparg2, (guint *)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1calendar_1get_1date_FUNC);
}
#endif

#ifndef NO_gtk_1calendar_1select_1day
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1calendar_1select_1day)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1calendar_1select_1day_FUNC);
	gtk_calendar_select_day((GtkCalendar *)arg0, (guint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1calendar_1select_1day_FUNC);
}
#endif

#ifndef NO_gtk_1calendar_1select_1month
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1calendar_1select_1month)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1calendar_1select_1month_FUNC);
	gtk_calendar_select_month((GtkCalendar *)arg0, (guint)arg1, (guint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1calendar_1select_1month_FUNC);
}
#endif

#ifndef NO_gtk_1calendar_1set_1display_1options
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1calendar_1set_1display_1options)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1calendar_1set_1display_1options_FUNC);
	gtk_calendar_set_display_options((GtkCalendar *)arg0, (GtkCalendarDisplayOptions)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1calendar_1set_1display_1options_FUNC);
}
#endif

#ifndef NO_gtk_1check_1menu_1item_1get_1active
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1check_1menu_1item_1get_1active)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1check_1menu_1item_1get_1active_FUNC);
	rc = (jboolean)gtk_check_menu_item_get_active((GtkCheckMenuItem *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1check_1menu_1item_1get_1active_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1check_1menu_1item_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1check_1menu_1item_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1check_1menu_1item_1new_FUNC);
	rc = (jlong)gtk_check_menu_item_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1check_1menu_1item_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1check_1menu_1item_1set_1active
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1check_1menu_1item_1set_1active)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1check_1menu_1item_1set_1active_FUNC);
	gtk_check_menu_item_set_active((GtkCheckMenuItem *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1check_1menu_1item_1set_1active_FUNC);
}
#endif

#ifndef NO_gtk_1clipboard_1clear
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1clipboard_1clear)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1clipboard_1clear_FUNC);
	gtk_clipboard_clear((GtkClipboard *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1clipboard_1clear_FUNC);
}
#endif

#ifndef NO_gtk_1clipboard_1get
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1clipboard_1get)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1clipboard_1get_FUNC);
	rc = (jlong)gtk_clipboard_get((GdkAtom)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1clipboard_1get_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1clipboard_1set_1can_1store
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1clipboard_1set_1can_1store)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1clipboard_1set_1can_1store_FUNC);
	gtk_clipboard_set_can_store((GtkClipboard *)arg0, (const GtkTargetEntry *)arg1, (gint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1clipboard_1set_1can_1store_FUNC);
}
#endif

#ifndef NO_gtk_1clipboard_1set_1with_1owner
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1clipboard_1set_1with_1owner)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4, jlong arg5)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1clipboard_1set_1with_1owner_FUNC);
	rc = (jboolean)gtk_clipboard_set_with_owner((GtkClipboard *)arg0, (const GtkTargetEntry *)arg1, (guint)arg2, (GtkClipboardGetFunc)arg3, (GtkClipboardClearFunc)arg4, (GObject *)arg5);
	GTK3_NATIVE_EXIT(env, that, gtk_1clipboard_1set_1with_1owner_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1clipboard_1store
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1clipboard_1store)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1clipboard_1store_FUNC);
	gtk_clipboard_store((GtkClipboard *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1clipboard_1store_FUNC);
}
#endif

#ifndef NO_gtk_1clipboard_1wait_1for_1contents
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1clipboard_1wait_1for_1contents)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1clipboard_1wait_1for_1contents_FUNC);
	rc = (jlong)gtk_clipboard_wait_for_contents((GtkClipboard *)arg0, (GdkAtom)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1clipboard_1wait_1for_1contents_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1combo_1box_1get_1wrap_1width
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1combo_1box_1get_1wrap_1width)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1combo_1box_1get_1wrap_1width_FUNC);
	rc = (jint)gtk_combo_box_get_wrap_width((GtkComboBox *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1combo_1box_1get_1wrap_1width_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1combo_1box_1set_1wrap_1width
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1combo_1box_1set_1wrap_1width)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1combo_1box_1set_1wrap_1width_FUNC);
	gtk_combo_box_set_wrap_width((GtkComboBox *)arg0, (gint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1combo_1box_1set_1wrap_1width_FUNC);
}
#endif

#ifndef NO_gtk_1container_1add
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1container_1add)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1add_FUNC);
	gtk_container_add((GtkContainer *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1add_FUNC);
}
#endif

#ifndef NO_gtk_1container_1forall
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1container_1forall)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1forall_FUNC);
	gtk_container_forall((GtkContainer *)arg0, (GtkCallback)arg1, (gpointer)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1forall_FUNC);
}
#endif

#ifndef NO_gtk_1container_1get_1border_1width
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1container_1get_1border_1width)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1get_1border_1width_FUNC);
	rc = (jint)gtk_container_get_border_width((GtkContainer *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1get_1border_1width_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1container_1get_1children
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1container_1get_1children)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1get_1children_FUNC);
	rc = (jlong)gtk_container_get_children((GtkContainer *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1get_1children_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1container_1propagate_1draw
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1container_1propagate_1draw)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1propagate_1draw_FUNC);
	gtk_container_propagate_draw((GtkContainer *)arg0, (GtkWidget *)arg1, (cairo_t *)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1propagate_1draw_FUNC);
}
#endif

#ifndef NO_gtk_1container_1remove
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1container_1remove)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1remove_FUNC);
	gtk_container_remove((GtkContainer *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1remove_FUNC);
}
#endif

#ifndef NO_gtk_1container_1set_1border_1width
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1container_1set_1border_1width)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1container_1set_1border_1width_FUNC);
	gtk_container_set_border_width((GtkContainer *)arg0, (guint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1container_1set_1border_1width_FUNC);
}
#endif

#ifndef NO_gtk_1css_1provider_1load_1from_1data
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1css_1provider_1load_1from_1data)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2, jlongArray arg3)
{
	jbyte *lparg1=NULL;
	jlong *lparg3=NULL;
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1css_1provider_1load_1from_1data_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jboolean)gtk_css_provider_load_from_data((GtkCssProvider *)arg0, (const gchar *)lparg1, (gssize)arg2, (GError **)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1css_1provider_1load_1from_1data_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1dialog_1run
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1dialog_1run)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1dialog_1run_FUNC);
	rc = (jint)gtk_dialog_run((GtkDialog *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1dialog_1run_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1drag_1begin_1with_1coordinates
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1drag_1begin_1with_1coordinates)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jlong arg4, jint arg5, jint arg6)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1begin_1with_1coordinates_FUNC);
	rc = (jlong)gtk_drag_begin_with_coordinates((GtkWidget *)arg0, (GtkTargetList *)arg1, (GdkDragAction)arg2, (gint)arg3, (GdkEvent *)arg4, (gint)arg5, (gint)arg6);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1begin_1with_1coordinates_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1drag_1check_1threshold
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1drag_1check_1threshold)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1check_1threshold_FUNC);
	rc = (jboolean)gtk_drag_check_threshold((GtkWidget *)arg0, (gint)arg1, (gint)arg2, (gint)arg3, (gint)arg4);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1check_1threshold_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1drag_1dest_1set
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1drag_1dest_1set)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jint arg3, jint arg4)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1dest_1set_FUNC);
	gtk_drag_dest_set((GtkWidget *)arg0, (GtkDestDefaults)arg1, (const GtkTargetEntry *)arg2, (gint)arg3, (GdkDragAction)arg4);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1dest_1set_FUNC);
}
#endif

#ifndef NO_gtk_1drag_1dest_1unset
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1drag_1dest_1unset)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1dest_1unset_FUNC);
	gtk_drag_dest_unset((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1dest_1unset_FUNC);
}
#endif

#ifndef NO_gtk_1drag_1finish
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1drag_1finish)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1, jboolean arg2, jint arg3)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1finish_FUNC);
	gtk_drag_finish((GdkDragContext *)arg0, (gboolean)arg1, (gboolean)arg2, (guint32)arg3);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1finish_FUNC);
}
#endif

#ifndef NO_gtk_1drag_1get_1data
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1drag_1get_1data)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jint arg3)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1get_1data_FUNC);
	gtk_drag_get_data((GtkWidget *)arg0, (GdkDragContext *)arg1, (GdkAtom)arg2, (guint32)arg3);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1get_1data_FUNC);
}
#endif

#ifndef NO_gtk_1drag_1set_1icon_1surface
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1drag_1set_1icon_1surface)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1drag_1set_1icon_1surface_FUNC);
	gtk_drag_set_icon_surface((GdkDragContext *)arg0, (cairo_surface_t *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1drag_1set_1icon_1surface_FUNC);
}
#endif

#ifndef NO_gtk_1editable_1copy_1clipboard
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1editable_1copy_1clipboard)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1editable_1copy_1clipboard_FUNC);
	gtk_editable_copy_clipboard((GtkEditable *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1editable_1copy_1clipboard_FUNC);
}
#endif

#ifndef NO_gtk_1editable_1cut_1clipboard
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1editable_1cut_1clipboard)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1editable_1cut_1clipboard_FUNC);
	gtk_editable_cut_clipboard((GtkEditable *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1editable_1cut_1clipboard_FUNC);
}
#endif

#ifndef NO_gtk_1editable_1paste_1clipboard
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1editable_1paste_1clipboard)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1editable_1paste_1clipboard_FUNC);
	gtk_editable_paste_clipboard((GtkEditable *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1editable_1paste_1clipboard_FUNC);
}
#endif

#ifndef NO_gtk_1entry_1get_1layout
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1entry_1get_1layout)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1entry_1get_1layout_FUNC);
	rc = (jlong)gtk_entry_get_layout((GtkEntry *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1entry_1get_1layout_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1entry_1get_1layout_1offsets
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1entry_1get_1layout_1offsets)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1entry_1get_1layout_1offsets_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	gtk_entry_get_layout_offsets((GtkEntry *)arg0, (gint *)lparg1, (gint *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1entry_1get_1layout_1offsets_FUNC);
}
#endif

#ifndef NO_gtk_1entry_1get_1text
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1entry_1get_1text)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1entry_1get_1text_FUNC);
	rc = (jlong)gtk_entry_get_text((GtkEntry *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1entry_1get_1text_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1entry_1set_1text
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1entry_1set_1text)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1entry_1set_1text_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_entry_set_text((GtkEntry *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1entry_1set_1text_FUNC);
}
#endif

#ifndef NO_gtk_1entry_1set_1width_1chars
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1entry_1set_1width_1chars)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1entry_1set_1width_1chars_FUNC);
	gtk_entry_set_width_chars((GtkEntry *)arg0, (gint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1entry_1set_1width_1chars_FUNC);
}
#endif

#ifndef NO_gtk_1entry_1text_1index_1to_1layout_1index
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1entry_1text_1index_1to_1layout_1index)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1entry_1text_1index_1to_1layout_1index_FUNC);
	rc = (jint)gtk_entry_text_index_to_layout_index((GtkEntry *)arg0, (gint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1entry_1text_1index_1to_1layout_1index_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1event_1box_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1event_1box_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1event_1box_1new_FUNC);
	rc = (jlong)gtk_event_box_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1event_1box_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1event_1controller_1handle_1event
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1event_1controller_1handle_1event)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1event_1controller_1handle_1event_FUNC);
	gtk_event_controller_handle_event((GtkEventController *)arg0, (const GdkEvent *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1event_1controller_1handle_1event_FUNC);
}
#endif

#ifndef NO_gtk_1events_1pending
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1events_1pending)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1events_1pending_FUNC);
	rc = (jboolean)gtk_events_pending();
	GTK3_NATIVE_EXIT(env, that, gtk_1events_1pending_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1add_1filter
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1add_1filter)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1add_1filter_FUNC);
	gtk_file_chooser_add_filter((GtkFileChooser *)arg0, (GtkFileFilter *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1add_1filter_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1get_1filename
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1file_1chooser_1get_1filename)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1get_1filename_FUNC);
	rc = (jlong)gtk_file_chooser_get_filename((GtkFileChooser *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1get_1filename_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1get_1filenames
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1file_1chooser_1get_1filenames)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1get_1filenames_FUNC);
	rc = (jlong)gtk_file_chooser_get_filenames((GtkFileChooser *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1get_1filenames_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1get_1filter
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1file_1chooser_1get_1filter)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1get_1filter_FUNC);
	rc = (jlong)gtk_file_chooser_get_filter((GtkFileChooser *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1get_1filter_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1get_1uri
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1file_1chooser_1get_1uri)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1get_1uri_FUNC);
	rc = (jlong)gtk_file_chooser_get_uri((GtkFileChooser *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1get_1uri_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1get_1uris
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1file_1chooser_1get_1uris)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1get_1uris_FUNC);
	rc = (jlong)gtk_file_chooser_get_uris((GtkFileChooser *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1get_1uris_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1native_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1file_1chooser_1native_1new)
	(JNIEnv *env, jclass that, jbyteArray arg0, jlong arg1, jint arg2, jbyteArray arg3, jbyteArray arg4)
{
	jbyte *lparg0=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1native_1new_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetByteArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetByteArrayElements(env, arg4, NULL)) == NULL) goto fail;
/*
	rc = (jlong)gtk_file_chooser_native_new((const gchar *)lparg0, (GtkWindow *)arg1, arg2, (const gchar *)lparg3, (const gchar *)lparg4);
*/
	{
		GTK3_LOAD_FUNCTION(fp, gtk_file_chooser_native_new)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(const gchar *, GtkWindow *, jint, const gchar *, const gchar *))fp)((const gchar *)lparg0, (GtkWindow *)arg1, arg2, (const gchar *)lparg3, (const gchar *)lparg4);
		}
	}
fail:
	if (arg4 && lparg4) (*env)->ReleaseByteArrayElements(env, arg4, lparg4, JNI_ABORT);
	if (arg3 && lparg3) (*env)->ReleaseByteArrayElements(env, arg3, lparg3, JNI_ABORT);
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, JNI_ABORT);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1native_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1current_1folder
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1current_1folder)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1current_1folder_FUNC);
	gtk_file_chooser_set_current_folder((GtkFileChooser *)arg0, (const gchar *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1current_1folder_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1current_1folder_1uri
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1current_1folder_1uri)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1current_1folder_1uri_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_file_chooser_set_current_folder_uri((GtkFileChooser *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1current_1folder_1uri_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1current_1name
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1current_1name)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1current_1name_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_file_chooser_set_current_name((GtkFileChooser *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1current_1name_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1do_1overwrite_1confirmation
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1do_1overwrite_1confirmation)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1do_1overwrite_1confirmation_FUNC);
	gtk_file_chooser_set_do_overwrite_confirmation((GtkFileChooser *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1do_1overwrite_1confirmation_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1extra_1widget
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1extra_1widget)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1extra_1widget_FUNC);
	gtk_file_chooser_set_extra_widget((GtkFileChooser *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1extra_1widget_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1filename
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1filename)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1filename_FUNC);
	gtk_file_chooser_set_filename((GtkFileChooser *)arg0, (const gchar *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1filename_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1filter
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1filter)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1filter_FUNC);
	gtk_file_chooser_set_filter((GtkFileChooser *)arg0, (GtkFileFilter *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1filter_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1local_1only
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1local_1only)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1local_1only_FUNC);
	gtk_file_chooser_set_local_only((GtkFileChooser *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1local_1only_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1select_1multiple
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1select_1multiple)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1select_1multiple_FUNC);
	gtk_file_chooser_set_select_multiple((GtkFileChooser *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1select_1multiple_FUNC);
}
#endif

#ifndef NO_gtk_1file_1chooser_1set_1uri
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1file_1chooser_1set_1uri)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1file_1chooser_1set_1uri_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_file_chooser_set_uri((GtkFileChooser *)arg0, (const char *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1file_1chooser_1set_1uri_FUNC);
}
#endif

#ifndef NO_gtk_1frame_1set_1shadow_1type
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1frame_1set_1shadow_1type)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1frame_1set_1shadow_1type_FUNC);
	gtk_frame_set_shadow_type((GtkFrame *)arg0, (GtkShadowType)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1frame_1set_1shadow_1type_FUNC);
}
#endif

#ifndef NO_gtk_1gesture_1drag_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1gesture_1drag_1new)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1gesture_1drag_1new_FUNC);
	rc = (jlong)gtk_gesture_drag_new((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1gesture_1drag_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1gesture_1rotate_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1gesture_1rotate_1new)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1gesture_1rotate_1new_FUNC);
	rc = (jlong)gtk_gesture_rotate_new((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1gesture_1rotate_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1gesture_1zoom_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1gesture_1zoom_1new)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1gesture_1zoom_1new_FUNC);
	rc = (jlong)gtk_gesture_zoom_new((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1gesture_1zoom_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1get_1current_1event
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1get_1current_1event)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1get_1current_1event_FUNC);
	rc = (jlong)gtk_get_current_event();
	GTK3_NATIVE_EXIT(env, that, gtk_1get_1current_1event_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1get_1current_1event_1state
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1get_1current_1event_1state)
	(JNIEnv *env, jclass that, jintArray arg0)
{
	jint *lparg0=NULL;
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1get_1current_1event_1state_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetIntArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jboolean)gtk_get_current_event_state((GdkModifierType*)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseIntArrayElements(env, arg0, lparg0, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1get_1current_1event_1state_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1get_1event_1widget
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1get_1event_1widget)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1get_1event_1widget_FUNC);
	rc = (jlong)gtk_get_event_widget((GdkEvent *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1get_1event_1widget_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1grab_1add
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1grab_1add)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1grab_1add_FUNC);
	gtk_grab_add((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1grab_1add_FUNC);
}
#endif

#ifndef NO_gtk_1grab_1get_1current
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1grab_1get_1current)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1grab_1get_1current_FUNC);
	rc = (jlong)gtk_grab_get_current();
	GTK3_NATIVE_EXIT(env, that, gtk_1grab_1get_1current_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1grab_1remove
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1grab_1remove)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1grab_1remove_FUNC);
	gtk_grab_remove((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1grab_1remove_FUNC);
}
#endif

#ifndef NO_gtk_1hsv_1to_1rgb
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1hsv_1to_1rgb)
	(JNIEnv *env, jclass that, jdouble arg0, jdouble arg1, jdouble arg2, jdoubleArray arg3, jdoubleArray arg4, jdoubleArray arg5)
{
	jdouble *lparg3=NULL;
	jdouble *lparg4=NULL;
	jdouble *lparg5=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1hsv_1to_1rgb_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetDoubleArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetDoubleArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetDoubleArrayElements(env, arg5, NULL)) == NULL) goto fail;
	gtk_hsv_to_rgb((gdouble)arg0, (gdouble)arg1, (gdouble)arg2, (gdouble *)lparg3, (gdouble *)lparg4, (gdouble *)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseDoubleArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseDoubleArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseDoubleArrayElements(env, arg3, lparg3, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1hsv_1to_1rgb_FUNC);
}
#endif

#ifndef NO_gtk_1icon_1info_1load_1icon
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1icon_1info_1load_1icon)
	(JNIEnv *env, jclass that, jlong arg0, jlongArray arg1)
{
	jlong *lparg1=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1icon_1info_1load_1icon_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_icon_info_load_icon((GtkIconInfo *)arg0, (GError **)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1icon_1info_1load_1icon_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1icon_1theme_1get_1default
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1icon_1theme_1get_1default)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1icon_1theme_1get_1default_FUNC);
	rc = (jlong)gtk_icon_theme_get_default();
	GTK3_NATIVE_EXIT(env, that, gtk_1icon_1theme_1get_1default_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1icon_1theme_1load_1icon
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1icon_1theme_1load_1icon)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jint arg2, jint arg3, jlong arg4)
{
	jbyte *lparg1=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1icon_1theme_1load_1icon_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_icon_theme_load_icon((GtkIconTheme *)arg0, (const gchar *)lparg1, (gint)arg2, (GtkIconLookupFlags)arg3, (GError **)arg4);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1icon_1theme_1load_1icon_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1icon_1theme_1lookup_1by_1gicon
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1icon_1theme_1lookup_1by_1gicon)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1icon_1theme_1lookup_1by_1gicon_FUNC);
	rc = (jlong)gtk_icon_theme_lookup_by_gicon((GtkIconTheme *)arg0, (GIcon *)arg1, (gint)arg2, (GtkIconLookupFlags)arg3);
	GTK3_NATIVE_EXIT(env, that, gtk_1icon_1theme_1lookup_1by_1gicon_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1im_1context_1filter_1keypress
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1im_1context_1filter_1keypress)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1im_1context_1filter_1keypress_FUNC);
	rc = (jboolean)gtk_im_context_filter_keypress((GtkIMContext *)arg0, (GdkEventKey *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1im_1context_1filter_1keypress_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1image_1new_1from_1icon_1name
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1image_1new_1from_1icon_1name)
	(JNIEnv *env, jclass that, jbyteArray arg0, jint arg1)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1image_1new_1from_1icon_1name_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_image_new_from_icon_name((const gchar *)lparg0, (GtkIconSize)arg1);
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1image_1new_1from_1icon_1name_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1image_1new_1from_1surface
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1image_1new_1from_1surface)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1image_1new_1from_1surface_FUNC);
	rc = (jlong)gtk_image_new_from_surface((cairo_surface_t *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1image_1new_1from_1surface_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1image_1set_1from_1icon_1name
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1image_1set_1from_1icon_1name)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jint arg2)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1image_1set_1from_1icon_1name_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_image_set_from_icon_name((GtkImage *)arg0, (const gchar *)lparg1, (GtkIconSize)arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1image_1set_1from_1icon_1name_FUNC);
}
#endif

#ifndef NO_gtk_1image_1set_1from_1surface
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1image_1set_1from_1surface)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1image_1set_1from_1surface_FUNC);
	gtk_image_set_from_surface((GtkImage *)arg0, (cairo_surface_t *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1image_1set_1from_1surface_FUNC);
}
#endif

#ifndef NO_gtk_1init_1check
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1init_1check)
	(JNIEnv *env, jclass that, jlongArray arg0, jlongArray arg1)
{
	jlong *lparg0=NULL;
	jlong *lparg1=NULL;
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1init_1check_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetLongArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)gtk_init_check((int *)lparg0, (char ***)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseLongArrayElements(env, arg0, lparg0, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1init_1check_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1label_1set_1line_1wrap
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1label_1set_1line_1wrap)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1label_1set_1line_1wrap_FUNC);
	gtk_label_set_line_wrap((GtkLabel *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1label_1set_1line_1wrap_FUNC);
}
#endif

#ifndef NO_gtk_1label_1set_1line_1wrap_1mode
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1label_1set_1line_1wrap_1mode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1label_1set_1line_1wrap_1mode_FUNC);
	gtk_label_set_line_wrap_mode((GtkLabel *)arg0, (PangoWrapMode)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1label_1set_1line_1wrap_1mode_FUNC);
}
#endif

#ifndef NO_gtk_1main_1do_1event
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1main_1do_1event)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1main_1do_1event_FUNC);
	gtk_main_do_event((GdkEvent *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1main_1do_1event_FUNC);
}
#endif

#ifndef NO_gtk_1main_1iteration_1do
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1main_1iteration_1do)
	(JNIEnv *env, jclass that, jboolean arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1main_1iteration_1do_FUNC);
	rc = (jboolean)gtk_main_iteration_do(arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1main_1iteration_1do_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1menu_1bar_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1menu_1bar_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1bar_1new_FUNC);
	rc = (jlong)gtk_menu_bar_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1bar_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1menu_1item_1get_1submenu
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1menu_1item_1get_1submenu)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1item_1get_1submenu_FUNC);
	rc = (jlong)gtk_menu_item_get_submenu((GtkMenuItem *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1item_1get_1submenu_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1menu_1item_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1menu_1item_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1item_1new_FUNC);
	rc = (jlong)gtk_menu_item_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1item_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1menu_1item_1set_1submenu
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1item_1set_1submenu)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1item_1set_1submenu_FUNC);
	gtk_menu_item_set_submenu((GtkMenuItem *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1item_1set_1submenu_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1menu_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1new_FUNC);
	rc = (jlong)gtk_menu_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1menu_1popdown
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1popdown)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1popdown_FUNC);
	gtk_menu_popdown((GtkMenu *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1popdown_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1popup_1at_1pointer
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1popup_1at_1pointer)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1popup_1at_1pointer_FUNC);
	gtk_menu_popup_at_pointer((GtkMenu *)arg0, (const GdkEvent*)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1popup_1at_1pointer_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1popup_1at_1rect
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1popup_1at_1rect)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2, jint arg3, jint arg4, jlong arg5)
{
	GdkRectangle _arg2, *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1popup_1at_1rect_FUNC);
	if (arg2) if ((lparg2 = getGdkRectangleFields(env, arg2, &_arg2)) == NULL) goto fail;
	gtk_menu_popup_at_rect((GtkMenu *)arg0, (GdkWindow *)arg1, (GdkRectangle *)lparg2, (GdkGravity)arg3, (GdkGravity)arg4, (const GdkEvent *)arg5);
fail:
	if (arg2 && lparg2) setGdkRectangleFields(env, arg2, lparg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1popup_1at_1rect_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1shell_1deactivate
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1shell_1deactivate)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1shell_1deactivate_FUNC);
	gtk_menu_shell_deactivate((GtkMenuShell *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1shell_1deactivate_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1shell_1insert
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1shell_1insert)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1shell_1insert_FUNC);
	gtk_menu_shell_insert((GtkMenuShell *)arg0, (GtkWidget *)arg1, (gint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1shell_1insert_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1shell_1set_1take_1focus
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1menu_1shell_1set_1take_1focus)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1shell_1set_1take_1focus_FUNC);
	gtk_menu_shell_set_take_focus((GtkMenuShell *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1shell_1set_1take_1focus_FUNC);
}
#endif

#ifndef NO_gtk_1menu_1tool_1button_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1menu_1tool_1button_1new)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1menu_1tool_1button_1new_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_menu_tool_button_new((GtkWidget *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1menu_1tool_1button_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1native_1dialog_1run
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1native_1dialog_1run)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1native_1dialog_1run_FUNC);
	rc = (jint)gtk_native_dialog_run((GtkNativeDialog *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1native_1dialog_1run_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1radio_1button_1get_1group
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1radio_1button_1get_1group)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1radio_1button_1get_1group_FUNC);
	rc = (jlong)gtk_radio_button_get_group((GtkRadioButton *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1radio_1button_1get_1group_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1radio_1button_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1radio_1button_1new)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1radio_1button_1new_FUNC);
	rc = (jlong)gtk_radio_button_new((GSList *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1radio_1button_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1radio_1menu_1item_1get_1group
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1radio_1menu_1item_1get_1group)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1radio_1menu_1item_1get_1group_FUNC);
	rc = (jlong)gtk_radio_menu_item_get_group((GtkRadioMenuItem *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1radio_1menu_1item_1get_1group_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1radio_1menu_1item_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1radio_1menu_1item_1new)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1radio_1menu_1item_1new_FUNC);
	rc = (jlong)gtk_radio_menu_item_new((GSList *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1radio_1menu_1item_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1rgb_1to_1hsv
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1rgb_1to_1hsv)
	(JNIEnv *env, jclass that, jdouble arg0, jdouble arg1, jdouble arg2, jdoubleArray arg3, jdoubleArray arg4, jdoubleArray arg5)
{
	jdouble *lparg3=NULL;
	jdouble *lparg4=NULL;
	jdouble *lparg5=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1rgb_1to_1hsv_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetDoubleArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetDoubleArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetDoubleArrayElements(env, arg5, NULL)) == NULL) goto fail;
	gtk_rgb_to_hsv((gdouble)arg0, (gdouble)arg1, (gdouble)arg2, (gdouble *)lparg3, (gdouble *)lparg4, (gdouble *)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseDoubleArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseDoubleArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseDoubleArrayElements(env, arg3, lparg3, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1rgb_1to_1hsv_FUNC);
}
#endif

#ifndef NO_gtk_1scrolled_1window_1get_1shadow_1type
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1scrolled_1window_1get_1shadow_1type)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1scrolled_1window_1get_1shadow_1type_FUNC);
	rc = (jint)gtk_scrolled_window_get_shadow_type((GtkScrolledWindow *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1scrolled_1window_1get_1shadow_1type_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1scrolled_1window_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1scrolled_1window_1new)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1scrolled_1window_1new_FUNC);
	rc = (jlong)gtk_scrolled_window_new((GtkAdjustment *)arg0, (GtkAdjustment *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1scrolled_1window_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1scrolled_1window_1set_1shadow_1type
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1scrolled_1window_1set_1shadow_1type)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1scrolled_1window_1set_1shadow_1type_FUNC);
	gtk_scrolled_window_set_shadow_type((GtkScrolledWindow *)arg0, (GtkShadowType)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1scrolled_1window_1set_1shadow_1type_FUNC);
}
#endif

#ifndef NO_gtk_1selection_1data_1free
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1selection_1data_1free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1free_FUNC);
	gtk_selection_data_free((GtkSelectionData *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1free_FUNC);
}
#endif

#ifndef NO_gtk_1selection_1data_1get_1data
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1selection_1data_1get_1data)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1get_1data_FUNC);
	rc = (jlong)gtk_selection_data_get_data((GtkSelectionData *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1get_1data_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1selection_1data_1get_1data_1type
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1selection_1data_1get_1data_1type)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1get_1data_1type_FUNC);
	rc = (jlong)gtk_selection_data_get_data_type((GtkSelectionData *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1get_1data_1type_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1selection_1data_1get_1format
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1selection_1data_1get_1format)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1get_1format_FUNC);
	rc = (jint)gtk_selection_data_get_format((GtkSelectionData *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1get_1format_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1selection_1data_1get_1length
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1selection_1data_1get_1length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1get_1length_FUNC);
	rc = (jint)gtk_selection_data_get_length((GtkSelectionData *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1get_1length_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1selection_1data_1get_1target
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1selection_1data_1get_1target)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1get_1target_FUNC);
	rc = (jlong)gtk_selection_data_get_target((GtkSelectionData *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1get_1target_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1selection_1data_1set
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1selection_1data_1set)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlong arg3, jint arg4)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1selection_1data_1set_FUNC);
	gtk_selection_data_set((GtkSelectionData *)arg0, (GdkAtom)arg1, (gint)arg2, (const guchar *)arg3, (gint)arg4);
	GTK3_NATIVE_EXIT(env, that, gtk_1selection_1data_1set_FUNC);
}
#endif

#ifndef NO_gtk_1separator_1menu_1item_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1separator_1menu_1item_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1separator_1menu_1item_1new_FUNC);
	rc = (jlong)gtk_separator_menu_item_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1separator_1menu_1item_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1separator_1tool_1item_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1separator_1tool_1item_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1separator_1tool_1item_1new_FUNC);
	rc = (jlong)gtk_separator_tool_item_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1separator_1tool_1item_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1separator_1tool_1item_1set_1draw
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1separator_1tool_1item_1set_1draw)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1separator_1tool_1item_1set_1draw_FUNC);
	gtk_separator_tool_item_set_draw((GtkSeparatorToolItem *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1separator_1tool_1item_1set_1draw_FUNC);
}
#endif

#ifndef NO_gtk_1status_1icon_1get_1geometry
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1status_1icon_1get_1geometry)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2, jlong arg3)
{
	GdkRectangle _arg2, *lparg2=NULL;
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1status_1icon_1get_1geometry_FUNC);
	if (arg2) if ((lparg2 = getGdkRectangleFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)gtk_status_icon_get_geometry((GtkStatusIcon*)arg0, (GdkScreen**)arg1, (GdkRectangle*)lparg2, (GtkOrientation*)arg3);
fail:
	if (arg2 && lparg2) setGdkRectangleFields(env, arg2, lparg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1status_1icon_1get_1geometry_FUNC);
	return rc;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1status_1icon_1get_1visible
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1status_1icon_1get_1visible)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1status_1icon_1get_1visible_FUNC);
	rc = (jboolean)gtk_status_icon_get_visible((GtkStatusIcon*)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1status_1icon_1get_1visible_FUNC);
	return rc;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1status_1icon_1new
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1status_1icon_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1status_1icon_1new_FUNC);
	rc = (jlong)gtk_status_icon_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1status_1icon_1new_FUNC);
	return rc;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1status_1icon_1set_1from_1pixbuf
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1status_1icon_1set_1from_1pixbuf)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1status_1icon_1set_1from_1pixbuf_FUNC);
	gtk_status_icon_set_from_pixbuf((GtkStatusIcon*)arg0, (GdkPixbuf*)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1status_1icon_1set_1from_1pixbuf_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1status_1icon_1set_1tooltip_1text
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1status_1icon_1set_1tooltip_1text)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1status_1icon_1set_1tooltip_1text_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_status_icon_set_tooltip_text((GtkStatusIcon *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1status_1icon_1set_1tooltip_1text_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1status_1icon_1set_1visible
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1status_1icon_1set_1visible)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1status_1icon_1set_1visible_FUNC);
	gtk_status_icon_set_visible((GtkStatusIcon*)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1status_1icon_1set_1visible_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1style_1context_1add_1provider_1for_1screen
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1style_1context_1add_1provider_1for_1screen)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1add_1provider_1for_1screen_FUNC);
	gtk_style_context_add_provider_for_screen((GdkScreen *)arg0, (GtkStyleProvider *)arg1, (guint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1add_1provider_1for_1screen_FUNC);
}
#endif

#ifndef NO_gtk_1style_1context_1get
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1style_1context_1get)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jbyteArray arg2, jlongArray arg3, jlong arg4)
{
	jbyte *lparg2=NULL;
	jlong *lparg3=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1get_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
	gtk_style_context_get((GtkStyleContext *)arg0, (GtkStateFlags)arg1, (const gchar *)lparg2, lparg3, (const gchar *)NULL);
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, JNI_ABORT);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1get_FUNC);
}
#endif

#ifndef NO_gtk_1style_1context_1get_1border
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1style_1context_1get_1border)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	GtkBorder _arg2, *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1get_1border_FUNC);
	if (arg2) if ((lparg2 = &_arg2) == NULL) goto fail;
	gtk_style_context_get_border((GtkStyleContext *)arg0, (GtkStateFlags)arg1, (GtkBorder *)lparg2);
fail:
	if (arg2 && lparg2) setGtkBorderFields(env, arg2, lparg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1get_1border_FUNC);
}
#endif

#ifndef NO_gtk_1style_1context_1get_1color
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1style_1context_1get_1color)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	GdkRGBA _arg2, *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1get_1color_FUNC);
	if (arg2) if ((lparg2 = getGdkRGBAFields(env, arg2, &_arg2)) == NULL) goto fail;
	gtk_style_context_get_color((GtkStyleContext *)arg0, (GtkStateFlags)arg1, (GdkRGBA *)lparg2);
fail:
	if (arg2 && lparg2) setGdkRGBAFields(env, arg2, lparg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1get_1color_FUNC);
}
#endif

#ifndef NO_gtk_1style_1context_1get_1font
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1style_1context_1get_1font)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1get_1font_FUNC);
	rc = (jlong)gtk_style_context_get_font((GtkStyleContext *)arg0, (GtkStateFlags)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1get_1font_FUNC);
	return rc;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1style_1context_1get_1padding
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1style_1context_1get_1padding)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	GtkBorder _arg2, *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1get_1padding_FUNC);
	if (arg2) if ((lparg2 = &_arg2) == NULL) goto fail;
	gtk_style_context_get_padding((GtkStyleContext *)arg0, (GtkStateFlags)arg1, (GtkBorder *)lparg2);
fail:
	if (arg2 && lparg2) setGtkBorderFields(env, arg2, lparg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1get_1padding_FUNC);
}
#endif

#ifndef NO_gtk_1style_1context_1get_1parent
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1style_1context_1get_1parent)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1get_1parent_FUNC);
	rc = (jlong)gtk_style_context_get_parent((GtkStyleContext *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1get_1parent_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1style_1context_1invalidate
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1style_1context_1invalidate)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1style_1context_1invalidate_FUNC);
	gtk_style_context_invalidate((GtkStyleContext *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1style_1context_1invalidate_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1target_1list_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1target_1list_1new)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1target_1list_1new_FUNC);
	rc = (jlong)gtk_target_list_new((const GtkTargetEntry *)arg0, (guint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1target_1list_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1target_1list_1unref
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1target_1list_1unref)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1target_1list_1unref_FUNC);
	gtk_target_list_unref((GtkTargetList *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1target_1list_1unref_FUNC);
}
#endif

#ifndef NO_gtk_1text_1view_1get_1window
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1text_1view_1get_1window)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1text_1view_1get_1window_FUNC);
	rc = (jlong)gtk_text_view_get_window((GtkTextView *)arg0, (GtkTextWindowType)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1text_1view_1get_1window_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1toggle_1button_1set_1inconsistent
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1toggle_1button_1set_1inconsistent)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1toggle_1button_1set_1inconsistent_FUNC);
	gtk_toggle_button_set_inconsistent((GtkToggleButton *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1toggle_1button_1set_1inconsistent_FUNC);
}
#endif

#ifndef NO_gtk_1toggle_1tool_1button_1get_1active
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1toggle_1tool_1button_1get_1active)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1toggle_1tool_1button_1get_1active_FUNC);
	rc = (jboolean)gtk_toggle_tool_button_get_active((GtkToggleToolButton *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1toggle_1tool_1button_1get_1active_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1toggle_1tool_1button_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1toggle_1tool_1button_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1toggle_1tool_1button_1new_FUNC);
	rc = (jlong)gtk_toggle_tool_button_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1toggle_1tool_1button_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1toggle_1tool_1button_1set_1active
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1toggle_1tool_1button_1set_1active)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1toggle_1tool_1button_1set_1active_FUNC);
	gtk_toggle_tool_button_set_active((GtkToggleToolButton *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1toggle_1tool_1button_1set_1active_FUNC);
}
#endif

#ifndef NO_gtk_1tool_1button_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1tool_1button_1new)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1button_1new_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_tool_button_new((GtkWidget *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1button_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1tool_1button_1set_1icon_1widget
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tool_1button_1set_1icon_1widget)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1button_1set_1icon_1widget_FUNC);
	gtk_tool_button_set_icon_widget((GtkToolButton *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1button_1set_1icon_1widget_FUNC);
}
#endif

#ifndef NO_gtk_1tool_1button_1set_1label_1widget
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tool_1button_1set_1label_1widget)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1button_1set_1label_1widget_FUNC);
	gtk_tool_button_set_label_widget((GtkToolButton *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1button_1set_1label_1widget_FUNC);
}
#endif

#ifndef NO_gtk_1tool_1button_1set_1use_1underline
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tool_1button_1set_1use_1underline)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1button_1set_1use_1underline_FUNC);
	gtk_tool_button_set_use_underline((GtkToolButton *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1button_1set_1use_1underline_FUNC);
}
#endif

#ifndef NO_gtk_1tool_1item_1get_1proxy_1menu_1item
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1tool_1item_1get_1proxy_1menu_1item)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1item_1get_1proxy_1menu_1item_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)gtk_tool_item_get_proxy_menu_item((GtkToolItem *)arg0, (const gchar *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1item_1get_1proxy_1menu_1item_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1tool_1item_1retrieve_1proxy_1menu_1item
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1tool_1item_1retrieve_1proxy_1menu_1item)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1item_1retrieve_1proxy_1menu_1item_FUNC);
	rc = (jlong)gtk_tool_item_retrieve_proxy_menu_item((GtkToolItem *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1item_1retrieve_1proxy_1menu_1item_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1tool_1item_1set_1homogeneous
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tool_1item_1set_1homogeneous)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1item_1set_1homogeneous_FUNC);
	gtk_tool_item_set_homogeneous((GtkToolItem *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1item_1set_1homogeneous_FUNC);
}
#endif

#ifndef NO_gtk_1tool_1item_1set_1is_1important
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tool_1item_1set_1is_1important)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1item_1set_1is_1important_FUNC);
	gtk_tool_item_set_is_important((GtkToolItem *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1item_1set_1is_1important_FUNC);
}
#endif

#ifndef NO_gtk_1tool_1item_1set_1proxy_1menu_1item
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tool_1item_1set_1proxy_1menu_1item)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1tool_1item_1set_1proxy_1menu_1item_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_tool_item_set_proxy_menu_item((GtkToolItem *)arg0, (const gchar *)lparg1, (GtkWidget *)arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1tool_1item_1set_1proxy_1menu_1item_FUNC);
}
#endif

#ifndef NO_gtk_1toolbar_1insert
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1toolbar_1insert)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1toolbar_1insert_FUNC);
	gtk_toolbar_insert((GtkToolbar *)arg0, (GtkToolItem *)arg1, arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1toolbar_1insert_FUNC);
}
#endif

#ifndef NO_gtk_1toolbar_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1toolbar_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1toolbar_1new_FUNC);
	rc = (jlong)gtk_toolbar_new();
	GTK3_NATIVE_EXIT(env, that, gtk_1toolbar_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1toolbar_1set_1icon_1size
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1toolbar_1set_1icon_1size)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1toolbar_1set_1icon_1size_FUNC);
	gtk_toolbar_set_icon_size((GtkToolbar *)arg0, arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1toolbar_1set_1icon_1size_FUNC);
}
#endif

#ifndef NO_gtk_1toolbar_1set_1show_1arrow
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1toolbar_1set_1show_1arrow)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1toolbar_1set_1show_1arrow_FUNC);
	gtk_toolbar_set_show_arrow((GtkToolbar *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1toolbar_1set_1show_1arrow_FUNC);
}
#endif

#ifndef NO_gtk_1toolbar_1set_1style
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1toolbar_1set_1style)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1toolbar_1set_1style_FUNC);
	gtk_toolbar_set_style((GtkToolbar *)arg0, (GtkToolbarStyle)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1toolbar_1set_1style_FUNC);
}
#endif

#ifndef NO_gtk_1tree_1view_1column_1cell_1get_1size
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1tree_1view_1column_1cell_1get_1size)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jintArray arg2, jintArray arg3, jintArray arg4, jintArray arg5)
{
	GdkRectangle _arg1, *lparg1=NULL;
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1tree_1view_1column_1cell_1get_1size_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	gtk_tree_view_column_cell_get_size((GtkTreeViewColumn *)arg0, (GdkRectangle *)lparg1, (gint *)lparg2, (gint *)lparg3, (gint *)lparg4, (gint *)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) setGdkRectangleFields(env, arg1, lparg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1tree_1view_1column_1cell_1get_1size_FUNC);
}
#endif

#ifndef NO_gtk_1tree_1view_1get_1bin_1window
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1tree_1view_1get_1bin_1window)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1tree_1view_1get_1bin_1window_FUNC);
	rc = (jlong)gtk_tree_view_get_bin_window((GtkTreeView *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1tree_1view_1get_1bin_1window_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1viewport_1set_1shadow_1type
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1viewport_1set_1shadow_1type)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1viewport_1set_1shadow_1type_FUNC);
	gtk_viewport_set_shadow_type((GtkViewport *)arg0, (GtkShadowType)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1viewport_1set_1shadow_1type_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1add_1accelerator
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1add_1accelerator)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2, jint arg3, jint arg4, jint arg5)
{
	jbyte *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1add_1accelerator_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	gtk_widget_add_accelerator((GtkWidget *)arg0, (const gchar *)lparg1, (GtkAccelGroup *)arg2, (guint)arg3, (GdkModifierType)arg4, arg5);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1add_1accelerator_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1add_1events
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1add_1events)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1add_1events_FUNC);
	gtk_widget_add_events((GtkWidget *)arg0, (gint)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1add_1events_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1destroy
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1destroy)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1destroy_FUNC);
	gtk_widget_destroy((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1destroy_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1draw
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1draw)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1draw_FUNC);
	gtk_widget_draw((GtkWidget *)arg0, (cairo_t *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1draw_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1event
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1widget_1event)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1event_FUNC);
	rc = (jboolean)gtk_widget_event((GtkWidget *)arg0, (GdkEvent *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1event_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1accessible
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1widget_1get_1accessible)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1accessible_FUNC);
	rc = (jlong)gtk_widget_get_accessible((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1accessible_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1can_1default
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1widget_1get_1can_1default)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1can_1default_FUNC);
	rc = (jboolean)gtk_widget_get_can_default((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1can_1default_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1clip
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1get_1clip)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	GtkAllocation _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1clip_FUNC);
	if (arg1) if ((lparg1 = getGtkAllocationFields(env, arg1, &_arg1)) == NULL) goto fail;
	gtk_widget_get_clip((GtkWidget *)arg0, lparg1);
fail:
	if (arg1 && lparg1) setGtkAllocationFields(env, arg1, lparg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1clip_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1get_1events
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1widget_1get_1events)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1events_FUNC);
	rc = (jint)gtk_widget_get_events((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1events_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1has_1window
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1widget_1get_1has_1window)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1has_1window_FUNC);
	rc = (jboolean)gtk_widget_get_has_window((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1has_1window_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1preferred_1height
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1get_1preferred_1height)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1preferred_1height_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	gtk_widget_get_preferred_height((GtkWidget *)arg0, (gint *)lparg1, (gint *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1preferred_1height_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1get_1preferred_1height_1for_1width
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1get_1preferred_1height_1for_1width)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1preferred_1height_1for_1width_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	gtk_widget_get_preferred_height_for_width((GtkWidget *)arg0, (gint)arg1, (gint *)lparg2, (gint *)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1preferred_1height_1for_1width_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1get_1preferred_1width_1for_1height
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1get_1preferred_1width_1for_1height)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1preferred_1width_1for_1height_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	gtk_widget_get_preferred_width_for_height((GtkWidget *)arg0, (gint)arg1, (gint *)lparg2, (gint *)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1preferred_1width_1for_1height_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1get_1screen
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1widget_1get_1screen)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1screen_FUNC);
	rc = (jlong)gtk_widget_get_screen((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1screen_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1toplevel
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1widget_1get_1toplevel)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1toplevel_FUNC);
	rc = (jlong)gtk_widget_get_toplevel((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1toplevel_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1get_1window
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1widget_1get_1window)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1get_1window_FUNC);
	rc = (jlong)gtk_widget_get_window((GtkWidget *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1get_1window_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1widget_1input_1shape_1combine_1region
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1input_1shape_1combine_1region)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1input_1shape_1combine_1region_FUNC);
	gtk_widget_input_shape_combine_region((GtkWidget *)arg0, (cairo_region_t *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1input_1shape_1combine_1region_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1override_1font
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1override_1font)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1override_1font_FUNC);
	gtk_widget_override_font((GtkWidget *)arg0, (const PangoFontDescription *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1override_1font_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1widget_1remove_1accelerator
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1remove_1accelerator)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1remove_1accelerator_FUNC);
	gtk_widget_remove_accelerator((GtkWidget *)arg0, (GtkAccelGroup *)arg1, (guint)arg2, (GdkModifierType)arg3);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1remove_1accelerator_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1reparent
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1reparent)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1reparent_FUNC);
	gtk_widget_reparent((GtkWidget *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1reparent_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1widget_1set_1allocation
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1allocation)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	GtkAllocation _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1allocation_FUNC);
	if (arg1) if ((lparg1 = getGtkAllocationFields(env, arg1, &_arg1)) == NULL) goto fail;
	gtk_widget_set_allocation((GtkWidget *)arg0, (GtkAllocation *)lparg1);
fail:
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1allocation_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1set_1can_1default
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1can_1default)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1can_1default_FUNC);
	gtk_widget_set_can_default((GtkWidget *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1can_1default_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1set_1clip
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1clip)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	GtkAllocation _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1clip_FUNC);
	if (arg1) if ((lparg1 = getGtkAllocationFields(env, arg1, &_arg1)) == NULL) goto fail;
	gtk_widget_set_clip((GtkWidget *)arg0, lparg1);
fail:
	if (arg1 && lparg1) setGtkAllocationFields(env, arg1, lparg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1clip_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1set_1double_1buffered
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1double_1buffered)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1double_1buffered_FUNC);
	gtk_widget_set_double_buffered((GtkWidget *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1double_1buffered_FUNC);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif

#ifndef NO_gtk_1widget_1set_1has_1window
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1has_1window)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1has_1window_FUNC);
	gtk_widget_set_has_window((GtkWidget *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1has_1window_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1set_1parent_1window
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1parent_1window)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1parent_1window_FUNC);
	gtk_widget_set_parent_window((GtkWidget *)arg0, (GdkWindow *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1parent_1window_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1set_1redraw_1on_1allocate
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1set_1redraw_1on_1allocate)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1set_1redraw_1on_1allocate_FUNC);
	gtk_widget_set_redraw_on_allocate((GtkWidget *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1set_1redraw_1on_1allocate_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1shape_1combine_1region
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1shape_1combine_1region)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1shape_1combine_1region_FUNC);
	gtk_widget_shape_combine_region((GtkWidget *)arg0, (cairo_region_t *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1shape_1combine_1region_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1size_1allocate
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1size_1allocate)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	GtkAllocation _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1size_1allocate_FUNC);
	if (arg1) if ((lparg1 = getGtkAllocationFields(env, arg1, &_arg1)) == NULL) goto fail;
	gtk_widget_size_allocate((GtkWidget *)arg0, (GtkAllocation *)lparg1);
fail:
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1size_1allocate_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1style_1get__J_3B_3IJ
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1style_1get__J_3B_3IJ)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jintArray arg2, jlong arg3)
{
	jbyte *lparg1=NULL;
	jint *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1style_1get__J_3B_3IJ_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	gtk_widget_style_get((GtkWidget *)arg0, (const gchar *)lparg1, lparg2, (const gchar *)NULL);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1style_1get__J_3B_3IJ_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1style_1get__J_3B_3JJ
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1widget_1style_1get__J_3B_3JJ)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlongArray arg2, jlong arg3)
{
	jbyte *lparg1=NULL;
	jlong *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1style_1get__J_3B_3JJ_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
	gtk_widget_style_get((GtkWidget *)arg0, (const gchar *)lparg1, lparg2, (const gchar *)NULL);
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1style_1get__J_3B_3JJ_FUNC);
}
#endif

#ifndef NO_gtk_1widget_1translate_1coordinates
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1widget_1translate_1coordinates)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jintArray arg4, jintArray arg5)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1widget_1translate_1coordinates_FUNC);
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	rc = (jboolean)gtk_widget_translate_coordinates((GtkWidget *)arg0, (GtkWidget *)arg1, arg2, arg3, (gint *)lparg4, (gint *)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1widget_1translate_1coordinates_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1window_1activate_1default
JNIEXPORT jboolean JNICALL GTK3_NATIVE(gtk_1window_1activate_1default)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1activate_1default_FUNC);
	rc = (jboolean)gtk_window_activate_default((GtkWindow *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1activate_1default_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1window_1add_1accel_1group
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1add_1accel_1group)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1add_1accel_1group_FUNC);
	gtk_window_add_accel_group((GtkWindow *)arg0, (GtkAccelGroup *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1add_1accel_1group_FUNC);
}
#endif

#ifndef NO_gtk_1window_1deiconify
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1deiconify)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1deiconify_FUNC);
	gtk_window_deiconify((GtkWindow *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1deiconify_FUNC);
}
#endif

#ifndef NO_gtk_1window_1get_1icon_1list
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1window_1get_1icon_1list)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1get_1icon_1list_FUNC);
	rc = (jlong)gtk_window_get_icon_list((GtkWindow *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1get_1icon_1list_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1window_1get_1mnemonic_1modifier
JNIEXPORT jint JNICALL GTK3_NATIVE(gtk_1window_1get_1mnemonic_1modifier)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1get_1mnemonic_1modifier_FUNC);
	rc = (jint)gtk_window_get_mnemonic_modifier((GtkWindow *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1get_1mnemonic_1modifier_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1window_1get_1position
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1get_1position)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1get_1position_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	gtk_window_get_position((GtkWindow *)arg0, (gint *)lparg1, (gint *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1get_1position_FUNC);
}
#endif

#ifndef NO_gtk_1window_1get_1size
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1get_1size)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1get_1size_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	gtk_window_get_size((GtkWindow *)arg0, (gint *)lparg1, (gint *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1get_1size_FUNC);
}
#endif

#ifndef NO_gtk_1window_1iconify
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1iconify)
	(JNIEnv *env, jclass that, jlong arg0)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1iconify_FUNC);
	gtk_window_iconify((GtkWindow *)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1iconify_FUNC);
}
#endif

#ifndef NO_gtk_1window_1move
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1move)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1move_FUNC);
	gtk_window_move((GtkWindow *)arg0, (gint)arg1, (gint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1move_FUNC);
}
#endif

#ifndef NO_gtk_1window_1new
JNIEXPORT jlong JNICALL GTK3_NATIVE(gtk_1window_1new)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1new_FUNC);
	rc = (jlong)gtk_window_new((GtkWindowType)arg0);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_gtk_1window_1remove_1accel_1group
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1remove_1accel_1group)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1remove_1accel_1group_FUNC);
	gtk_window_remove_accel_group((GtkWindow *)arg0, (GtkAccelGroup *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1remove_1accel_1group_FUNC);
}
#endif

#ifndef NO_gtk_1window_1resize
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1resize)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1resize_FUNC);
	gtk_window_resize((GtkWindow *)arg0, (gint)arg1, (gint)arg2);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1resize_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1attached_1to
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1attached_1to)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1attached_1to_FUNC);
	gtk_window_set_attached_to((GtkWindow *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1attached_1to_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1default
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1default)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1default_FUNC);
	gtk_window_set_default((GtkWindow *)arg0, (GtkWidget *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1default_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1geometry_1hints
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1geometry_1hints)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2, jint arg3)
{
	GdkGeometry _arg2, *lparg2=NULL;
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1geometry_1hints_FUNC);
	if (arg2) if ((lparg2 = getGdkGeometryFields(env, arg2, &_arg2)) == NULL) goto fail;
	gtk_window_set_geometry_hints((GtkWindow *)arg0, (GtkWidget *)arg1, lparg2, arg3);
fail:
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1geometry_1hints_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1icon_1list
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1icon_1list)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1icon_1list_FUNC);
	gtk_window_set_icon_list((GtkWindow *)arg0, (GList *)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1icon_1list_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1keep_1above
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1keep_1above)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1keep_1above_FUNC);
	gtk_window_set_keep_above((GtkWindow *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1keep_1above_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1skip_1taskbar_1hint
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1skip_1taskbar_1hint)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1skip_1taskbar_1hint_FUNC);
	gtk_window_set_skip_taskbar_hint((GtkWindow *)arg0, (gboolean)arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1skip_1taskbar_1hint_FUNC);
}
#endif

#ifndef NO_gtk_1window_1set_1type_1hint
JNIEXPORT void JNICALL GTK3_NATIVE(gtk_1window_1set_1type_1hint)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	GTK3_NATIVE_ENTER(env, that, gtk_1window_1set_1type_1hint_FUNC);
	gtk_window_set_type_hint((GtkWindow *)arg0, arg1);
	GTK3_NATIVE_EXIT(env, that, gtk_1window_1set_1type_1hint_FUNC);
}
#endif

#ifndef NO_memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventButton_2J
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventButton_2J)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2)
{
	GdkEventButton _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventButton_2J_FUNC);
	if (arg1) if ((lparg1 = getGdkEventButtonFields(env, arg1, &_arg1)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	GTK3_NATIVE_EXIT(env, that, memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventButton_2J_FUNC);
}
#endif

#ifndef NO_memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventKey_2J
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventKey_2J)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2)
{
	GdkEventKey _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventKey_2J_FUNC);
	if (arg1) if ((lparg1 = getGdkEventKeyFields(env, arg1, &_arg1)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	GTK3_NATIVE_EXIT(env, that, memmove__JLorg_eclipse_swt_internal_gtk3_GdkEventKey_2J_FUNC);
}
#endif

#ifndef NO_memmove__JLorg_eclipse_swt_internal_gtk3_GtkTargetEntry_2J
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__JLorg_eclipse_swt_internal_gtk3_GtkTargetEntry_2J)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2)
{
	GtkTargetEntry _arg1, *lparg1=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__JLorg_eclipse_swt_internal_gtk3_GtkTargetEntry_2J_FUNC);
	if (arg1) if ((lparg1 = getGtkTargetEntryFields(env, arg1, &_arg1)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	GTK3_NATIVE_EXIT(env, that, memmove__JLorg_eclipse_swt_internal_gtk3_GtkTargetEntry_2J_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventButton_2JJ
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventButton_2JJ)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	GdkEventButton _arg0, *lparg0=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventButton_2JJ_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setGdkEventButtonFields(env, arg0, lparg0);
	GTK3_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventButton_2JJ_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventCrossing_2JJ
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventCrossing_2JJ)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	GdkEventCrossing _arg0, *lparg0=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventCrossing_2JJ_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setGdkEventCrossingFields(env, arg0, lparg0);
	GTK3_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventCrossing_2JJ_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventFocus_2JJ
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventFocus_2JJ)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	GdkEventFocus _arg0, *lparg0=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventFocus_2JJ_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setGdkEventFocusFields(env, arg0, lparg0);
	GTK3_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventFocus_2JJ_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventKey_2JJ
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventKey_2JJ)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	GdkEventKey _arg0, *lparg0=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventKey_2JJ_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setGdkEventKeyFields(env, arg0, lparg0);
	GTK3_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventKey_2JJ_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventMotion_2JJ
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventMotion_2JJ)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	GdkEventMotion _arg0, *lparg0=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventMotion_2JJ_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setGdkEventMotionFields(env, arg0, lparg0);
	GTK3_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventMotion_2JJ_FUNC);
}
#endif

#ifndef NO_memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventWindowState_2JJ
JNIEXPORT void JNICALL GTK3_NATIVE(memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventWindowState_2JJ)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	GdkEventWindowState _arg0, *lparg0=NULL;
	GTK3_NATIVE_ENTER(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventWindowState_2JJ_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setGdkEventWindowStateFields(env, arg0, lparg0);
	GTK3_NATIVE_EXIT(env, that, memmove__Lorg_eclipse_swt_internal_gtk3_GdkEventWindowState_2JJ_FUNC);
}
#endif

