/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceServiceProvider;

@ImplementedBy(value=ResourceServiceProviderImpl.class)
public interface IGlobalServiceProvider {
    public <T> T findService(URI var1, Class<T> var2);

    public <T> T findService(EObject var1, Class<T> var2);

    public static class ResourceServiceProviderImpl
    implements IGlobalServiceProvider {
        private IResourceServiceProvider.Registry registry;
        private IResourceServiceProvider thisLanguageServiceProvider;

        @Inject
        public ResourceServiceProviderImpl(IResourceServiceProvider.Registry registry, IResourceServiceProvider thisLanguageServiceProvider) {
            this.registry = registry;
            this.thisLanguageServiceProvider = thisLanguageServiceProvider;
        }

        @Override
        public <T> T findService(URI uri, Class<T> serviceClazz) {
            if (this.thisLanguageServiceProvider.canHandle(uri)) {
                return this.thisLanguageServiceProvider.get(serviceClazz);
            }
            IResourceServiceProvider serviceProvider = this.registry.getResourceServiceProvider(uri);
            if (serviceProvider == null) {
                return null;
            }
            T result = serviceProvider.get(serviceClazz);
            return result;
        }

        @Override
        public <T> T findService(EObject eObject, Class<T> serviceClazz) {
            if (eObject.eIsProxy()) {
                return this.findService(((InternalEObject)eObject).eProxyURI(), serviceClazz);
            }
            Resource eResource = eObject.eResource();
            if (eResource != null) {
                return this.findService(eResource.getURI(), serviceClazz);
            }
            return null;
        }
    }
}

