/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentWrapper;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.ui.workbench.base.internal.EFX_ModelFragmentComparator;

public class EFX_ModelAssembler
extends ModelAssembler {
    @Inject
    private Logger logger;
    @Inject
    private MApplication application;
    @Inject
    private IEclipseContext context;
    @Inject
    private IExtensionRegistry registry;
    private static final String extensionPointID = "org.eclipse.e4.workbench.model";
    private static final String INITIAL = "initial";
    private static final String NOTEXISTS = "notexists";

    public void processModel(boolean initial) {
        IExtensionPoint extPoint = this.registry.getExtensionPoint(extensionPointID);
        IExtension[] extensions = (IExtension[])new ExtensionsSort().sort((Object[])extPoint.getExtensions());
        this.runProcessors(extensions, initial, false);
        this.processFragments(extensions, initial);
        this.runProcessors(extensions, initial, true);
    }

    private void processFragments(IExtension[] extensions, boolean initial) {
        ArrayList<ModelFragmentWrapper> wrappers = new ArrayList<ModelFragmentWrapper>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                MModelFragments fragmentsContainer;
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if ("fragment".equals(ce.getName()) && (initial || !INITIAL.equals(ce.getAttribute("apply"))) && (fragmentsContainer = this.getFragmentsContainer(ce)) != null) {
                    for (MModelFragment fragment : fragmentsContainer.getFragments()) {
                        boolean checkExist = !initial && NOTEXISTS.equals(ce.getAttribute("apply"));
                        wrappers.add(new ModelFragmentWrapper(fragmentsContainer, fragment, ce.getContributor().getName(), URIHelper.constructPlatformURI((IContributor)ce.getContributor()), checkExist));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.processFragmentWrappers(wrappers);
    }

    public void processFragmentWrappers(Collection<ModelFragmentWrapper> wrappers) {
        LinkedHashMap<String, Bucket> elementIdToBucket = new LinkedHashMap<String, Bucket>();
        LinkedHashMap<String, Bucket> parentIdToBuckets = new LinkedHashMap<String, Bucket>();
        for (ModelFragmentWrapper fragmentWrapper : wrappers) {
            MModelFragment fragment = fragmentWrapper.getModelFragment();
            String parentId = ((MStringModelFragment)MStringModelFragment.class.cast(fragment)).getParentElementId();
            if (!parentIdToBuckets.containsKey(parentId)) {
                parentIdToBuckets.put(parentId, new Bucket());
            }
            Bucket b = (Bucket)parentIdToBuckets.get(parentId);
            if (elementIdToBucket.containsKey(parentId)) {
                Bucket parentBucket = (Bucket)elementIdToBucket.get(parentId);
                parentBucket.dependencies.add(b);
                b.dependentOn = parentBucket;
            }
            b.wrapper.add(fragmentWrapper);
            for (MApplicationElement e : fragment.getElements()) {
                if (parentId == e.getElementId()) continue;
                elementIdToBucket.put(e.getElementId(), b);
                b.containedElementIds.add(e.getElementId());
                if (!parentIdToBuckets.containsKey(e.getElementId())) continue;
                Bucket childBucket = (Bucket)parentIdToBuckets.get(e.getElementId());
                b.dependencies.add(childBucket);
                childBucket.dependentOn = b;
            }
        }
        this.processFragments(this.createUnifiedFragmentList(elementIdToBucket));
    }

    private List<ModelFragmentWrapper> createUnifiedFragmentList(Map<String, Bucket> elementIdToBucket) {
        ArrayList<ModelFragmentWrapper> fragmentList = new ArrayList<ModelFragmentWrapper>();
        LinkedHashSet<String> checkedElementIds = new LinkedHashSet<String>();
        for (String elementId : elementIdToBucket.keySet()) {
            if (checkedElementIds.contains(elementId)) continue;
            Bucket bucket = elementIdToBucket.get(elementId);
            while (bucket.dependentOn != null) {
                bucket = bucket.dependentOn;
            }
            this.addAllBucketFragmentWrapper(bucket, fragmentList, checkedElementIds);
        }
        return fragmentList;
    }

    private void addAllBucketFragmentWrapper(Bucket bucket, List<ModelFragmentWrapper> fragmentList, Set<String> checkedElementIds) {
        for (ModelFragmentWrapper wrapper : bucket.wrapper) {
            fragmentList.add(wrapper);
        }
        checkedElementIds.addAll(bucket.containedElementIds);
        for (Bucket child : bucket.dependencies) {
            this.addAllBucketFragmentWrapper(child, fragmentList, checkedElementIds);
        }
    }

    public void processFragments(Collection<ModelFragmentWrapper> fragmentList) {
        for (ModelFragmentWrapper fragmentWrapper : fragmentList) {
            this.processFragment(fragmentWrapper.getFragmentContainer(), fragmentWrapper.getModelFragment(), fragmentWrapper.getContributorName(), fragmentWrapper.getContributorURI(), fragmentWrapper.isCheckExists());
        }
    }

    public void processFragment(MModelFragments fragmentsContainer, MModelFragment fragment, String contributorName, String contributorURI, boolean checkExist) {
        List<MApplicationElement> merged;
        ArrayList<MApplicationElement> addedElements = new ArrayList<MApplicationElement>();
        if (fragmentsContainer == null) {
            return;
        }
        boolean evalImports = false;
        Diagnostic validationResult = Diagnostician.INSTANCE.validate((EObject)fragment);
        int severity = validationResult.getSeverity();
        if (severity == 4) {
            this.logger.error("Fragment from \"uri.toString()\" of \"" + contributorName + "\" could not be validated and was not merged \"{0}\"", (Object)fragment.toString());
        }
        if ((merged = this.processModelFragment(fragment, contributorURI, checkExist)).size() > 0) {
            evalImports = true;
            addedElements.addAll(merged);
        } else {
            this.logger.debug("Nothing to merge for fragment \"{0}\" of \"{1}\"", (Object)contributorURI, (Object)contributorName);
        }
        if (evalImports && fragmentsContainer.getImports().size() > 0) {
            this.resolveImports(fragmentsContainer.getImports(), addedElements);
        }
    }

    private MModelFragments getFragmentsContainer(IConfigurationElement ce) {
        Resource resource;
        URI uri;
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        ResourceSet resourceSet = applicationResource.getResourceSet();
        IContributor contributor = ce.getContributor();
        String attrURI = ce.getAttribute("uri");
        String bundleName = contributor.getName();
        if (attrURI == null) {
            this.logger.warn("Unable to find location for the model extension \"{0}\"", (Object)bundleName);
            return null;
        }
        try {
            if (URIHelper.isPlatformURI((String)attrURI)) {
                uri = URI.createURI((String)attrURI);
            } else {
                String path = bundleName + "/" + attrURI;
                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            }
        }
        catch (RuntimeException e) {
            this.logger.warn((Throwable)e, "Invalid location \"" + attrURI + "\" of model extension \"" + bundleName + "\"");
            return null;
        }
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException e) {
            this.logger.warn((Throwable)e, "Unable to read model extension from \"" + uri.toString() + "\" of \"" + bundleName + "\"");
            return null;
        }
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            return null;
        }
        Object extensionRoot = contents.get(0);
        if (!(extensionRoot instanceof MModelFragments)) {
            this.logger.warn("Unable to create model extension \"{0}\"", (Object)bundleName);
            return null;
        }
        return (MModelFragments)extensionRoot;
    }

    public List<MApplicationElement> processModelFragment(MModelFragment fragment, String contributorURI, boolean checkExist) {
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        List elements = fragment.getElements();
        if (elements.size() == 0) {
            return new ArrayList<MApplicationElement>();
        }
        for (MApplicationElement el : elements) {
            EObject o = (EObject)el;
            E4XMIResource r = (E4XMIResource)o.eResource();
            if (checkExist && applicationResource.getIDToEObjectMap().containsKey(r.getID(o))) continue;
            applicationResource.setID(o, r.getID(o));
            if (contributorURI != null) {
                el.setContributorURI(contributorURI);
            }
            TreeIterator treeIt = EcoreUtil.getAllContents((EObject)o, (boolean)true);
            while (treeIt.hasNext()) {
                EObject eObj = (EObject)treeIt.next();
                r = (E4XMIResource)eObj.eResource();
                if (contributorURI != null && eObj instanceof MApplicationElement) {
                    ((MApplicationElement)eObj).setContributorURI(contributorURI);
                }
                applicationResource.setID(eObj, r.getInternalId(eObj));
            }
        }
        return fragment.merge(this.application);
    }

    public void runProcessors(IExtension[] extensions, boolean initial, boolean afterFragments) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                boolean parseBoolean = Boolean.parseBoolean(ce.getAttribute("beforefragment"));
                if ("processor".equals(ce.getName()) && afterFragments != parseBoolean && (initial || !INITIAL.equals(ce.getAttribute("apply")))) {
                    this.runProcessor(ce);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void runProcessor(IConfigurationElement ce) {
        IEclipseContext localContext = EclipseContextFactory.create();
        IContributionFactory factory = (IContributionFactory)this.context.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren("element");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ceEl = iConfigurationElementArray[n2];
            String id = ceEl.getAttribute("id");
            if (id == null) {
                this.logger.warn("No element id given");
            } else {
                MApplicationElement el;
                String key = ceEl.getAttribute("contextKey");
                if (key == null) {
                    key = id;
                }
                if ((el = ModelUtils.findElementById((MApplicationElement)this.application, (String)id)) == null) {
                    this.logger.warn("Could not find element with id '" + id + "'");
                }
                localContext.set(key, (Object)el);
            }
            ++n2;
        }
        try {
            Object o = factory.create("bundleclass://" + ce.getContributor().getName() + "/" + ce.getAttribute("class"), this.context, localContext);
            if (o == null) {
                this.logger.warn("Unable to create processor " + ce.getAttribute("class") + " from " + ce.getContributor().getName());
            } else {
                ContextInjectionFactory.invoke((Object)o, Execute.class, (IEclipseContext)this.context, (Object)localContext);
            }
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Could not run processor");
        }
    }

    public void resolveImports(List<MApplicationElement> imports, List<MApplicationElement> addedElements) {
        if (imports.isEmpty()) {
            return;
        }
        HashMap<MApplicationElement, MApplicationElement> importMaps = new HashMap<MApplicationElement, MApplicationElement>();
        for (MApplicationElement importedElement : imports) {
            MApplicationElement mApplicationElement = ModelUtils.findElementById((MApplicationElement)this.application, (String)importedElement.getElementId());
            if (mApplicationElement == null) {
                this.logger.warn("Could not resolve an import element for '" + String.valueOf(mApplicationElement) + "'");
            }
            importMaps.put(importedElement, mApplicationElement);
        }
        TreeIterator it = EcoreUtil.getAllContents(addedElements);
        ArrayList<1> commands = new ArrayList<1>();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject importObject = (EObject)featureIterator.next();
                if (importObject.eContainmentFeature() != FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS) continue;
                EStructuralFeature feature = featureIterator.feature();
                MApplicationElement el = null;
                if (importObject instanceof MApplicationElement) {
                    el = (MApplicationElement)importMaps.get((MApplicationElement)importObject);
                }
                if (el == null) {
                    this.logger.warn("Could not resolve import for " + String.valueOf(el));
                }
                final EObject interalTarget = eObject;
                final EStructuralFeature internalFeature = feature;
                final MApplicationElement internalElment = el;
                final EObject internalImportObject = importObject;
                commands.add(new Runnable(){

                    @Override
                    public void run() {
                        if (internalFeature.isMany()) {
                            EFX_ModelAssembler.this.logger.error("Replacing");
                            List l = (List)interalTarget.eGet(internalFeature);
                            int index = l.indexOf(internalImportObject);
                            if (index >= 0) {
                                l.set(index, internalElment);
                            }
                        } else {
                            interalTarget.eSet(internalFeature, (Object)internalElment);
                        }
                    }
                });
            }
        }
        for (Runnable runnable : commands) {
            runnable.run();
        }
    }

    private class Bucket {
        SortedSet<ModelFragmentWrapper> wrapper;
        Bucket dependentOn;
        Set<Bucket> dependencies;
        Set<String> containedElementIds;

        private Bucket() {
            this.wrapper = new TreeSet<ModelFragmentWrapper>(new EFX_ModelFragmentComparator(EFX_ModelAssembler.this.application));
            this.dependencies = new LinkedHashSet<Bucket>();
            this.containedElementIds = new LinkedHashSet<String>();
        }
    }
}

