/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.rules;

import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class RegexRule
implements IRule {
    private final IToken token;
    private final int startLength;
    private final Pattern startPattern;
    private final Pattern containmentPattern;
    private final Pattern leadCharPattern;

    public RegexRule(IToken token, Pattern startPattern, int startLength, Pattern containmentPattern) {
        this(token, null, startPattern, startLength, containmentPattern);
    }

    public RegexRule(IToken token, Pattern leadCharPattern, Pattern startPattern, int startLength, Pattern containmentPattern) {
        this.token = token;
        this.leadCharPattern = leadCharPattern;
        this.startLength = startLength;
        this.startPattern = startPattern;
        this.containmentPattern = containmentPattern;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        if (this.leadCharPattern != null && scanner.getColumn() > 0) {
            scanner.unread();
            int c2 = scanner.read();
            if (!this.leadCharPattern.matcher(String.valueOf((char)c2)).matches()) {
                return Token.UNDEFINED;
            }
        }
        StringBuilder b = new StringBuilder();
        int readCount = 0;
        int i = 0;
        while (i < this.startLength) {
            ++readCount;
            c = scanner.read();
            if (c == -1) break;
            b.append((char)c);
            ++i;
        }
        if (this.startPattern.matcher(b.toString()).matches()) {
            String input;
            do {
                ++readCount;
                c = scanner.read();
                if (c != -1 && c != 10 && c != 13) continue;
                return this.token;
            } while (this.containmentPattern.matcher(input = String.valueOf((char)c)).matches());
            scanner.unread();
            return this.token;
        }
        i = 0;
        while (i < readCount) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }
}

