/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javafx.scene.control.Button;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.eclipse.fx.ui.preferences.page.StringFieldEditor;

public class FileFieldEditor
extends StringFieldEditor {
    public static final String FILE_EDITOR_STYLE = "file-field-container";
    private Collection<FileChooser.ExtensionFilter> extensionFilters;

    public FileFieldEditor(String name, String label) {
        super(name, label);
        Button browse = new Button("...");
        this.getTextContainer().getChildren().add((Object)browse);
        this.getTextContainer().getStyleClass().add((Object)FILE_EDITOR_STYLE);
        browse.setOnAction(event -> this.browse(browse.getScene().getWindow()));
    }

    private void browse(Window parent) {
        FileChooser chooser = new FileChooser();
        chooser.setInitialDirectory(this.getCurrentFolder());
        chooser.setInitialFileName(this.getCurrentFileName());
        chooser.getExtensionFilters().setAll(this.getExtensionFilters());
        File result = chooser.showOpenDialog(parent);
        if (result != null) {
            this.setCurrentFolder(result);
        }
    }

    private Collection<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters == null ? Collections.emptyList() : this.extensionFilters;
    }

    public void setExtensionFilters(String ... filters) {
        this.extensionFilters = Arrays.stream(filters).map(f -> new FileChooser.ExtensionFilter(f, new String[]{f})).collect(Collectors.toList());
    }

    public void setExtensionFilters(FileChooser.ExtensionFilter ... filters) {
        this.extensionFilters = Arrays.asList(filters);
    }

    private String getCurrentFileName() {
        String textValue = this.getTextField().getText();
        if (textValue == null) {
            return null;
        }
        File file = new File(textValue);
        return file.getName();
    }

    private void setCurrentFolder(File result) {
        this.getTextField().setText(result.getPath());
    }

    private File getCurrentFolder() {
        String textValue = this.getTextField().getText();
        if (textValue == null) {
            return null;
        }
        File folder = new File(textValue);
        while (folder != null && !folder.isDirectory()) {
            folder = folder.getParentFile();
        }
        return folder;
    }

    public FileFieldEditor(String name) {
        this(name, null);
    }
}

