/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.ui.controls.image.GraphicNodeProvider;
import org.eclipse.fx.ui.controls.image.ImageCache;

public class GraphicNode
extends StackPane {
    private static CustomProtocolConverter CONVERTER = new CustomProtocolConverter();
    static final CssMetaData<GraphicNode, String> GRAPHIC = new CssMetaData<GraphicNode, String>("-fx-graphic", (StyleConverter)CONVERTER){

        public boolean isSettable(GraphicNode n) {
            return n.graphic == null || !n.graphic.isBound();
        }

        public StyleableProperty<String> getStyleableProperty(GraphicNode n) {
            return (StyleableProperty)n.graphicProperty();
        }
    };
    ObjectProperty<String> graphic;
    ObjectProperty<Node> graphicNode = new SimpleObjectProperty((Object)this, "graphicNode");
    private static List<GraphicNodeProvider> NODE_PROVIDER_LIST = new ArrayList<GraphicNodeProvider>();
    static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    static {
        NODE_PROVIDER_LIST = ServiceUtils.getServiceList(GraphicNode.class, GraphicNodeProvider.class);
        ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
        Collections.addAll(styleables, GRAPHIC);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public GraphicNode() {
        this.getStyleClass().add((Object)"graphic-node");
        if (this.graphicNode.get() != null) {
            this.getChildren().setAll((Object[])new Node[]{(Node)this.graphicNode.get()});
        }
        this.graphicNode.addListener((o, ol, ne) -> {
            if (ne == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Object[])new Node[]{ne});
            }
        });
    }

    public final ObjectProperty<String> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleStyleableObjectProperty(GRAPHIC, (Object)this, "graphic", null);
            this.graphic.addListener((o, ol, ne) -> {
                if (ne != null) {
                    Image img;
                    ImageCache.CachedImage cachedImage = null;
                    if (this.graphicNode.get() instanceof ImageView && (img = ((ImageView)this.graphicNode.get()).getImage()) instanceof ImageCache.CachedImage) {
                        cachedImage = (ImageCache.CachedImage)img;
                    }
                    this.graphicNode.set((Object)NODE_PROVIDER_LIST.stream().filter(np -> np.handles((String)ne)).findFirst().map(np -> np.getGraphicNode((String)ne)).orElseGet(() -> new ImageView((Image)ImageCache.getInstance().getImage((String)ne))));
                    if (cachedImage != null) {
                        cachedImage.releaseLazy();
                    }
                } else {
                    this.graphicNode.set(null);
                }
            });
        }
        return this.graphic;
    }

    public final String getGraphic() {
        return (String)this.graphicProperty().get();
    }

    public final void setGraphic(String graphic) {
        this.graphicProperty().set((Object)graphic);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GraphicNode.getClassCssMetaData();
    }

    static class CustomProtocolConverter
    extends StyleConverter<Object, String> {
        CustomProtocolConverter() {
        }

        public String convert(ParsedValue<Object, String> value, Font font) {
            if (value.getValue() instanceof String) {
                String valueString = value.getValue().toString();
                return valueString;
            }
            return (String)StyleConverter.getUrlConverter().convert(value, font);
        }
    }
}

