/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class PluginExecutionFilter
implements Serializable,
Cloneable {
    private String groupId;
    private String artifactId;
    private String versionRange;
    private Set<String> goals;
    private Map parameters;
    private transient VersionRange parsedVersionRange;

    public void addGoal(String string) {
        this.getGoals().add(string);
    }

    public void addParameter(Object key, String value) {
        this.getParameters().put(key, value);
    }

    public PluginExecutionFilter clone() {
        try {
            PluginExecutionFilter copy = (PluginExecutionFilter)super.clone();
            if (this.goals != null) {
                copy.goals = new HashSet<String>();
                copy.goals.addAll(this.goals);
            }
            if (this.parameters != null) {
                copy.parameters = new HashMap();
                copy.parameters.clear();
                copy.parameters.putAll(this.parameters);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginExecutionFilter)) {
            return false;
        }
        PluginExecutionFilter that = (PluginExecutionFilter)other;
        boolean result = true;
        boolean bl = result && (this.getGroupId() == null ? that.getGroupId() == null : this.getGroupId().equals(that.getGroupId())) ? true : (result = false);
        boolean bl2 = result && (this.getArtifactId() == null ? that.getArtifactId() == null : this.getArtifactId().equals(that.getArtifactId())) ? true : (result = false);
        boolean bl3 = result && (this.getVersionRange() == null ? that.getVersionRange() == null : this.getVersionRange().equals(that.getVersionRange())) ? true : (result = false);
        result = result && (this.getGoals() == null ? that.getGoals() == null : this.getGoals().equals(that.getGoals()));
        return result;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Set<String> getGoals() {
        if (this.goals == null) {
            this.goals = new HashSet<String>();
        }
        return this.goals;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Map getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        return this.parameters;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
        result = 37 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 37 * result + (this.versionRange != null ? this.versionRange.hashCode() : 0);
        result = 37 * result + (this.goals != null ? this.goals.hashCode() : 0);
        return result;
    }

    public void removeGoal(String string) {
        this.getGoals().remove(string);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGoals(Set<String> goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("groupId = '");
        buf.append(this.getGroupId());
        buf.append("'");
        buf.append("\n");
        buf.append("artifactId = '");
        buf.append(this.getArtifactId());
        buf.append("'");
        buf.append("\n");
        buf.append("versionRange = '");
        buf.append(this.getVersionRange());
        buf.append("'");
        buf.append("\n");
        buf.append("goals = '");
        buf.append(this.getGoals());
        buf.append("'");
        return buf.toString();
    }

    public PluginExecutionFilter() {
    }

    public PluginExecutionFilter(String groupId, String artifactId, String versionRange, Set<String> goals) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.setVersionRange(versionRange);
        this.goals = goals;
    }

    public PluginExecutionFilter(String groupId, String artifactId, String versionRange, String goals) {
        this(groupId, artifactId, versionRange, new LinkedHashSet<String>(Arrays.asList(goals.split(","))));
    }

    public void setVersionRange(String versionRange) {
        this.versionRange = versionRange;
        try {
            this.parsedVersionRange = VersionRange.createFromVersionSpec((String)versionRange);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Cannot parse version range: " + versionRange, e);
        }
    }

    private void checkAllFieldsSet() {
        if (this.groupId == null || this.artifactId == null || this.versionRange == null || this.goals == null || this.goals.isEmpty()) {
            throw new IllegalArgumentException("Missing parameter for pluginExecutionFilter. groupId, artifactId, versionRange and goals must be specificed, but found: " + this);
        }
    }

    public boolean match(MojoExecutionKey mojoExecution) {
        this.checkAllFieldsSet();
        if (!this.getGroupId().equals(mojoExecution.getGroupId()) || !this.getArtifactId().equals(mojoExecution.getArtifactId())) {
            return false;
        }
        DefaultArtifactVersion version = new DefaultArtifactVersion(mojoExecution.getVersion());
        if (this.parsedVersionRange == null) {
            try {
                this.parsedVersionRange = VersionRange.createFromVersionSpec((String)this.versionRange);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("Cannot parse version range: " + this.versionRange, e);
            }
        }
        if (!this.parsedVersionRange.containsVersion((ArtifactVersion)version)) {
            return false;
        }
        return this.getGoals().contains(mojoExecution.getGoal());
    }
}

