/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javax.annotation.PostConstruct;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.MultiStatus;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.command.Command;
import org.eclipse.fx.core.observable.FXObservableUtil;
import org.eclipse.fx.ui.preferences.page.BasePreferencePage;
import org.eclipse.fx.ui.preferences.page.FieldEditor;

public abstract class FieldEditorPreferencePage
extends BasePreferencePage {
    public static final String PAGE_GRID_STYLE = "field-editor-grid";
    public static final String PAGE_ACTIONS_STYLE = "field-editor-actions";
    public static final String ERROR_MESSAGE_STYLE = "field-editor-error";
    public static final PseudoClass WARNING_STYLE = PseudoClass.getPseudoClass((String)"warning");
    public static final PseudoClass ERROR_STYLE = PseudoClass.getPseudoClass((String)"error");
    private BorderPane parent;
    private GridPane grid;
    private HBox actions = new HBox();
    private List<FieldEditor<?>> editors = new ArrayList();
    private Label errorMessage = new Label();
    private Command<Void> persistCommand = new PersistCommand();

    public FieldEditorPreferencePage(Memento memento, BorderPane parent) {
        super(memento);
        this.grid = new GridPane(){

            public String getUserAgentStylesheet() {
                return FieldEditorPreferencePage.this.getUserAgentStylesheet();
            }
        };
        this.errorMessage.getStyleClass().add((Object)ERROR_MESSAGE_STYLE);
        this.parent = parent;
        this.parent.setTop((Node)this.errorMessage);
        this.parent.setCenter((Node)this.grid);
        this.parent.setBottom((Node)this.actions);
        this.actions.setAlignment(Pos.BASELINE_RIGHT);
        this.grid.getStyleClass().add((Object)PAGE_GRID_STYLE);
        this.actions.getStyleClass().add((Object)PAGE_ACTIONS_STYLE);
        this.actions.setMinWidth(Double.NEGATIVE_INFINITY);
        this.grid.setMinWidth(Double.NEGATIVE_INFINITY);
        this.grid.setMinHeight(Double.NEGATIVE_INFINITY);
    }

    protected String getUserAgentStylesheet() {
        return null;
    }

    @Override
    public Command<Void> persist() {
        return this.persistCommand;
    }

    @Override
    public Optional<Command<Void>> restoreDefault() {
        return Optional.of(Command.createCommand(() -> this.editors.forEach(FieldEditor::restoreDefaults)));
    }

    @PostConstruct
    void initFieldEditors() {
        this.createFieldEditors();
        this.createActionButtons();
        this.bindErrorMessages();
        this.reset().execute();
    }

    private void bindErrorMessages() {
        ObservableValue<Status> pageStatus = this.getPageStatus();
        this.errorMessage.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ((Status)pageStatus.getValue()).getMessage(), (Observable[])new Observable[]{pageStatus}));
        this.errorMessage.managedProperty().bind((ObservableValue)this.errorMessage.visibleProperty());
        this.errorMessage.visibleProperty().bind((ObservableValue)this.errorMessage.textProperty().isNotEmpty());
        FXObservableUtil.onChange(pageStatus, status -> {
            boolean isWarning = status.getState() == Status.State.WARNING;
            boolean isError = status.getState() == Status.State.ERROR;
            this.errorMessage.pseudoClassStateChanged(WARNING_STYLE, isWarning);
            this.errorMessage.pseudoClassStateChanged(ERROR_STYLE, isError);
        });
    }

    private ObservableValue<Status> getPageStatus() {
        List<ObservableValue<Status>> allStatuses = this.getAllStatuses();
        Callable<Status> toMultistatus = () -> (Status)allStatuses.stream().map(ObservableValue::getValue).filter(Objects::nonNull).filter(Status::isNotOk).collect(MultiStatus.toMultiStatus((String)this.getMessage(allStatuses), (int)-1));
        return Bindings.createObjectBinding(toMultistatus, (Observable[])((Observable[])allStatuses.toArray(new ObservableValue[0])));
    }

    private List<ObservableValue<Status>> getAllStatuses() {
        return this.editors.stream().map(FieldEditor::statusProperty).collect(Collectors.toList());
    }

    private String getMessage(List<ObservableValue<Status>> allStatuses) {
        return allStatuses.stream().map(ObservableValue::getValue).filter(s -> s != null && !s.isOk()).map(Status::getMessage).filter(m -> m != null && !m.isEmpty()).collect(Collectors.joining("\n"));
    }

    protected abstract void createFieldEditors();

    protected void createActionButtons() {
        this.addButton("Restore Defaults", this.restoreDefault());
        this.addButton("Apply", Optional.of(this.persist()));
    }

    protected void addButton(String label, Optional<Command<Void>> restoreDefault) {
        Button action = new Button(label);
        this.actions.getChildren().add((Object)action);
        if (restoreDefault.isPresent()) {
            Command<Void> command = restoreDefault.get();
            action.disableProperty().bind((ObservableValue)command.enabledProperty().not());
            action.setOnAction(event -> {
                command.evaluate();
                if (command.isEnabled()) {
                    command.execute();
                }
            });
        } else {
            action.setDisable(true);
        }
    }

    @Override
    public Command<Void> reset() {
        return Command.createCommand(this::doReset);
    }

    void doReset() {
        this.editors.forEach(FieldEditor::load);
    }

    public void addField(FieldEditor<?> editor) {
        int editorColumn = 0;
        int editorSpan = 2;
        if (editor.displayLabel()) {
            Label l = new Label();
            GridPane.setValignment((Node)l, (VPos)VPos.TOP);
            l.textProperty().bind((ObservableValue)editor.labelProperty());
            l.setMinWidth(Double.NEGATIVE_INFINITY);
            this.grid.add((Node)l, 0, this.editors.size());
            editorColumn = 1;
            editorSpan = 1;
        }
        this.grid.add(editor, editorColumn, this.editors.size(), editorSpan, 1);
        GridPane.setHgrow(editor, (Priority)Priority.ALWAYS);
        this.editors.add(editor);
        editor.setMemento(this.memento);
    }

    private class PersistCommand
    implements Command<Void> {
        ObservableMap<String, String> parameters = FXCollections.observableHashMap();

        private PersistCommand() {
        }

        public ReadOnlyBooleanProperty enabledProperty() {
            List<ObservableValue> allStatuses = FieldEditorPreferencePage.this.editors.stream().map(FieldEditor::statusProperty).collect(Collectors.toList());
            SimpleBooleanProperty enabled = new SimpleBooleanProperty();
            enabled.bind((ObservableValue)Bindings.createBooleanBinding(this::isEnabled, (Observable[])((Observable[])allStatuses.toArray(new ObservableValue[0]))));
            return enabled;
        }

        public boolean isEnabled() {
            return FieldEditorPreferencePage.this.editors.stream().map(FieldEditor::statusProperty).noneMatch(obs -> ((Status)obs.getValue()).getState() == Status.State.ERROR);
        }

        public Optional<Void> execute() {
            if (this.isEnabled()) {
                FieldEditorPreferencePage.this.editors.forEach(FieldEditor::persist);
            }
            return null;
        }

        public ObservableMap<String, String> parameters() {
            return this.parameters;
        }

        public void evaluate() {
        }
    }
}

