/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.xtext.ui.editor.hover.AbstractHover;

public abstract class AbstractProblemHover
extends AbstractHover {
    @Inject
    private DefaultMarkerAnnotationAccess markerAnnotationAccess;

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            int lineNumber = textViewer.getDocument().getLineOfOffset(offset);
            return this.getHoverRegionInternal(lineNumber, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected abstract IRegion getHoverRegionInternal(int var1, int var2);

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            int lineNumber = this.getLineNumber(textViewer, hoverRegion);
            return this.getHoverInfoInternal(textViewer, lineNumber, hoverRegion.getOffset());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected abstract Object getHoverInfoInternal(ITextViewer var1, int var2, int var3);

    protected IAnnotationModel getAnnotationModel() {
        return this.sourceViewer.getAnnotationModel();
    }

    public List<Annotation> getAnnotations(int lineNumber, int offset) {
        if (this.getAnnotationModel() == null) {
            return Collections.emptyList();
        }
        Iterator iterator = this.getAnnotationModel().getAnnotationIterator();
        ArrayList result = Lists.newArrayList();
        ArrayList lineDiffs = Lists.newArrayList();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!this.isHandled(annotation) || this.isLineDiffInfo(annotation) || (position = this.getAnnotationModel().getPosition(annotation)) == null) continue;
            int start = position.getOffset();
            int end = start + position.getLength();
            if (offset >= 0 && (start > offset || offset > end)) continue;
            try {
                int lineDiff = Math.abs(lineNumber - this.getDocument().getLineOfOffset(start));
                if (lineDiff != 0 && offset < 0) continue;
                int index = lineDiffs.size();
                while (index > 0 && (Integer)lineDiffs.get(index - 1) > lineDiff) {
                    --index;
                }
                result.add(index, annotation);
                lineDiffs.add(index, lineDiff);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected List<Annotation> sortBySeverity(List<Annotation> annotations) {
        if (annotations == null) {
            return Collections.emptyList();
        }
        if (annotations.size() <= 1) {
            return annotations;
        }
        ArrayList sorted = Lists.newArrayList(annotations);
        Collections.sort(sorted, Comparator.comparing(this::isError).reversed().thenComparing(Comparator.comparing(this::isWarning).reversed()));
        return sorted;
    }

    protected boolean isLineDiffInfo(Annotation annotation) {
        return annotation instanceof ILineDiffInfo;
    }

    protected boolean isHandled(Annotation annotation) {
        return annotation != null && !annotation.isMarkedDeleted() && (this.isError(annotation) || this.isWarning(annotation) || this.isInfo(annotation) || this.isBookmark(annotation) || this.isSpelling(annotation));
    }

    protected boolean isError(Annotation annotation) {
        return this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.error");
    }

    protected boolean isWarning(Annotation annotation) {
        return this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.warning");
    }

    protected boolean isInfo(Annotation annotation) {
        return this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.info");
    }

    protected boolean isBookmark(Annotation annotation) {
        return this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.bookmark");
    }

    protected boolean isSpelling(Annotation annotation) {
        return this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.spelling");
    }
}

