/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.util.ASTHelper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;
    public static final int IS_RVALUE_GUESSED = 3;

    private Checks() {
    }

    public static RefactoringStatus checkIfConstructorName(IMethod method, String newMethodName, String newTypeName) {
        if (!newMethodName.equals(newTypeName)) {
            return null;
        }
        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.Checks_constructor_name, new Object[]{JavaElementUtil.createMethodSignature(method), JavaElementLabelsCore.getElementLabel((IJavaElement)method.getDeclaringType(), 2235681801344L)}));
    }

    public static RefactoringStatus checkFieldName(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validateFieldName(name, context));
    }

    public static RefactoringStatus checkModuleName(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validateModuleName(name, context));
    }

    public static RefactoringStatus checkTypeParameterName(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validateTypeVariableName(name, context));
    }

    public static RefactoringStatus checkIdentifier(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validateIdentifier(name, context));
    }

    public static RefactoringStatus checkMethodName(String name, IJavaElement context) {
        RefactoringStatus status = Checks.checkName(name, JavaConventionsUtil.validateMethodName(name, context));
        if (status.isOK() && !Checks.startsWithLowerCase(name)) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        return status;
    }

    public static RefactoringStatus checkTypeName(String name, IJavaElement context) {
        if (name.contains(".")) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_no_dot);
        }
        return Checks.checkName(name, JavaConventionsUtil.validateJavaTypeName(name, context));
    }

    public static RefactoringStatus checkPackageName(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validatePackageName(name, context));
    }

    public static RefactoringStatus checkCompilationUnitName(String name, IJavaElement context) {
        return Checks.checkName(name, JavaConventionsUtil.validateCompilationUnitName(name, context));
    }

    public static RefactoringStatus checkCompilationUnitNewName(ICompilationUnit cu, String newBareName) {
        String newCUName = JavaModelUtil.getRenamedCUName(cu, newBareName);
        IPath renamedResourcePath = cu.getParent().getPath().append(newCUName);
        if (Checks.resourceExists(renamedResourcePath)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, BasicElementLabels.getResourceName(newCUName)));
        }
        return new RefactoringStatus();
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        switch (s) {
            case "": {
                return false;
            }
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isTopLevel(IType type) {
        return type.getDeclaringType() == null;
    }

    public static boolean isAnonymous(IType type) throws JavaModelException {
        return type.isAnonymous();
    }

    public static boolean isTopLevelType(IMember member) {
        return member.getElementType() == 7 && Checks.isTopLevel((IType)member);
    }

    public static boolean isInsideLocalType(IType type) throws JavaModelException {
        while (type != null) {
            if (type.isLocal()) {
                return true;
            }
            type = type.getDeclaringType();
        }
        return false;
    }

    public static boolean isAlreadyNamed(IJavaElement element, String name) {
        return name.equals(element.getElementName());
    }

    public static RefactoringStatus checkForMainAndNativeMethods(ICompilationUnit cu) throws JavaModelException {
        return Checks.checkForMainAndNativeMethods(cu.getTypes());
    }

    public static RefactoringStatus checkForMainAndNativeMethods(IType[] types) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.merge(Checks.checkForMainAndNativeMethods(type));
            ++n2;
        }
        return result;
    }

    public static RefactoringStatus checkForMainAndNativeMethods(IType type) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkForMainAndNativeMethods(type.getMethods()));
        result.merge(Checks.checkForMainAndNativeMethods(type.getTypes()));
        return result;
    }

    private static RefactoringStatus checkForMainAndNativeMethods(IMethod[] methods) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JdtFlags.isNative((IMember)method)) {
                String typeName = JavaElementLabelsCore.getElementLabel((IJavaElement)method.getDeclaringType(), 2235681801344L);
                String methodName = JavaElementLabelsCore.getElementLabel((IJavaElement)method, 0x200009L);
                String msg = Messages.format(RefactoringCoreMessages.Checks_method_native, new String[]{typeName, methodName, "UnsatisfiedLinkError"});
                result.addEntry(3, msg, JavaStatusContext.create((IMember)method), JavaManipulation.getPreferenceNodeId(), 192);
            }
            if (method.isMainMethod()) {
                String msg = Messages.format(RefactoringCoreMessages.Checks_has_main, JavaElementLabelsCore.getElementLabel((IJavaElement)method.getDeclaringType(), 2235681801344L));
                result.addEntry(2, msg, JavaStatusContext.create((IMember)method), JavaManipulation.getPreferenceNodeId(), 193);
            }
            ++n2;
        }
        return result;
    }

    public static RefactoringStatus checkMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        RefactoringStatus result = new RefactoringStatus();
        IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            if (method.isConstructor()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.Checks_methodName_constructor, new Object[]{BasicElementLabels.getJavaElementName(type.getName())}));
            } else {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_exists, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(type.getName())}), JavaStatusContext.create(method));
            }
        }
        return result;
    }

    public static RefactoringStatus checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters) {
        RefactoringStatus result = new RefactoringStatus();
        IMethodBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(dc.getName())}), JavaStatusContext.create(method));
            } else if (method.isConstructor()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.Checks_methodName_constructor, new Object[]{BasicElementLabels.getJavaElementName(dc.getName())}));
            } else {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{BasicElementLabels.getJavaElementName(methodName), BasicElementLabels.getJavaElementName(dc.getName())}), JavaStatusContext.create(method));
            }
        }
        return result;
    }

    public static boolean isExtractableExpression(ASTNode[] selectedNodes, ASTNode coveringNode) {
        ASTNode node = coveringNode;
        if (Checks.isEnumCase(node)) {
            return false;
        }
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        return Checks.isExtractableExpression(node);
    }

    public static boolean isEnumCase(ASTNode node) {
        if (node instanceof SwitchCase) {
            SwitchCase caze = (SwitchCase)node;
            if (ASTHelper.isSwitchCaseExpressionsSupportedInAST(node.getAST())) {
                List expressions = caze.expressions();
                boolean isEnumConst = true;
                for (Expression expression : expressions) {
                    boolean bl = isEnumConst = isEnumConst && Checks.isEnumConst(expression);
                }
                return isEnumConst;
            }
            Expression expression = caze.getExpression();
            return Checks.isEnumConst(expression);
        }
        return false;
    }

    private static boolean isEnumConst(Expression expression) {
        Name name;
        IBinding binding;
        if (expression instanceof Name && (binding = (name = (Name)expression).resolveBinding()) instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return variableBinding.isEnumConstant();
        }
        return false;
    }

    public static boolean isExtractableExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return false;
        }
        if (node instanceof Name) {
            IBinding binding = ((Name)node).resolveBinding();
            return binding == null || binding instanceof IVariableBinding;
        }
        return true;
    }

    public static boolean isInsideJavadoc(ASTNode node) {
        do {
            if (node.getNodeType() != 29) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static IMethod findMethod(String name, int parameterCount, boolean isConstructor, IType type) throws JavaModelException {
        return Checks.findMethod(name, parameterCount, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(IMethod method, IType type) throws JavaModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), type.getMethods());
    }

    public static IMethod findMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), methods);
    }

    public static IMethod findMethod(String name, int parameters, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            IMethod curr = methods[i];
            if (name.equals(curr.getElementName()) && isConstructor == curr.isConstructor() && parameters == curr.getParameterTypes().length) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IMethod findSimilarMethod(IMethod method, IType type) throws JavaModelException {
        return Checks.findSimilarMethod(method, type.getMethods());
    }

    public static IMethod findSimilarMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        boolean isConstructor = method.isConstructor();
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod otherMethod = iMethodArray[n2];
            if (otherMethod.isConstructor() == isConstructor && method.isSimilar(otherMethod)) {
                return otherMethod;
            }
            ++n2;
        }
        return null;
    }

    public static boolean compareParamTypes(String[] paramTypes1, String[] paramTypes2) {
        if (paramTypes1.length == paramTypes2.length) {
            int i = 0;
            while (i < paramTypes1.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes1[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)paramTypes2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static RefactoringStatus checkIfCuBroken(IMember member) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)member.getCompilationUnit().getResource());
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static SearchResultGroup[] excludeCompilationUnits(SearchResultGroup[] grouped, RefactoringStatus status) throws JavaModelException {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        boolean wasEmpty = grouped.length == 0;
        SearchResultGroup[] searchResultGroupArray = grouped;
        int n = grouped.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup g = searchResultGroupArray[n2];
            IResource resource = g.getResource();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
                if (!cu.isStructureKnown()) {
                    status.addError(Messages.format(RefactoringCoreMessages.Checks_cannot_be_parsed, BasicElementLabels.getPathLabel(cu.getPath(), false)));
                } else {
                    result.add(g);
                }
            }
            ++n2;
        }
        if (!wasEmpty && result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.Checks_all_excluded);
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] grouped) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        SearchResultGroup[] searchResultGroupArray = grouped;
        int n = grouped.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup g = searchResultGroupArray[n2];
            Checks.checkCompileErrorsInAffectedFile(result, g.getResource());
            ++n2;
        }
        return result;
    }

    public static void checkCompileErrorsInAffectedFile(RefactoringStatus result, IResource resource) throws JavaModelException {
        if (Checks.hasCompileErrors(resource)) {
            result.addWarning(Messages.format(RefactoringCoreMessages.Checks_cu_has_compile_errors, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
        }
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] references, IResource declaring) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        SearchResultGroup[] searchResultGroupArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup reference = searchResultGroupArray[n2];
            IResource resource = reference.getResource();
            if (resource.equals((Object)declaring)) {
                declaring = null;
            }
            Checks.checkCompileErrorsInAffectedFile(result, resource);
            ++n2;
        }
        if (declaring != null) {
            Checks.checkCompileErrorsInAffectedFile(result, declaring);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCompileErrors(IResource resource) throws JavaModelException {
        try {
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker problemMarker = iMarkerArray[n2];
                if (problemMarker.getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public static boolean isReadOnly(Object element) throws JavaModelException {
        if (element instanceof IResource) {
            return Checks.isReadOnly((IResource)element);
        }
        if (element instanceof IJavaElement) {
            if (element instanceof IPackageFragmentRoot && Checks.isClasspathDelete((IPackageFragmentRoot)element)) {
                return false;
            }
            return Checks.isReadOnly(((IJavaElement)element).getResource());
        }
        Assert.isTrue((boolean)false, (String)"not expected to get here");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadOnly(IResource res) throws JavaModelException {
        ResourceAttributes attributes = res.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return true;
        }
        if (!(res instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)res;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource child = iResourceArray[n2];
                if (Checks.isReadOnly(child)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public static boolean isClasspathDelete(IPackageFragmentRoot pkgRoot) {
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        if (res.getParent() != null && pkgRoot.isArchive() && !res.getParent().equals((Object)definingProject)) {
            return true;
        }
        IProject occurringProject = pkgRoot.getJavaProject().getProject();
        return !definingProject.equals((Object)occurringProject);
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context, IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            boolean autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
            if (autoRefresh) {
                IFile[] iFileArray = filesToModify;
                int n = filesToModify.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile resource = iFileArray[n2];
                    resource.refreshLocal(2, pm);
                    ++n2;
                }
                status = Resources.checkInSync((IResource[])filesToModify);
            }
            if (!status.isOK()) {
                result.merge(RefactoringStatus.create((IStatus)status));
            }
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static void addModifiedFilesToChecker(IFile[] filesToModify, CheckConditionsContext context) {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        IFile[] iFileArray = filesToModify;
        int n = filesToModify.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            deltaFactory.change(file);
            ++n2;
        }
    }

    public static RefactoringStatus validateEdit(ICompilationUnit unit, Object context, IProgressMonitor pm) throws CoreException {
        IResource resource = unit.getPrimary().getResource();
        RefactoringStatus result = new RefactoringStatus();
        if (resource == null) {
            return result;
        }
        IStatus status = Resources.checkInSync(resource);
        if (!status.isOK()) {
            boolean autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
            if (autoRefresh) {
                resource.refreshLocal(2, pm);
                status = Resources.checkInSync(resource);
            }
            if (!status.isOK()) {
                result.merge(RefactoringStatus.create((IStatus)status));
            }
        }
        if (!(status = Resources.makeCommittable(resource, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus checkAvailability(IJavaElement javaElement) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (!javaElement.exists()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_not_in_model, Checks.getJavaElementName(javaElement)));
        }
        if (javaElement.isReadOnly()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_read_only, Checks.getJavaElementName(javaElement)));
        }
        if (javaElement.exists() && !javaElement.isStructureKnown()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_unknown_structure, Checks.getJavaElementName(javaElement)));
        }
        if (javaElement instanceof IMember && ((IMember)javaElement).isBinary()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_binary, Checks.getJavaElementName(javaElement)));
        }
        return result;
    }

    private static String getJavaElementName(IJavaElement element) {
        return JavaElementLabelsCore.getElementLabel(element, 0x200009L);
    }

    public static boolean isAvailable(IJavaElement javaElement) throws JavaModelException {
        if (javaElement == null) {
            return false;
        }
        if (!javaElement.exists()) {
            return false;
        }
        if (javaElement.isReadOnly()) {
            return false;
        }
        if (!(javaElement instanceof IJavaProject || javaElement instanceof ILocalVariable || javaElement.isStructureKnown())) {
            return false;
        }
        return !(javaElement instanceof IMember) || !((IMember)javaElement).isBinary();
    }

    public static IType findTypeInPackage(IPackageFragment pack, String elementName) throws JavaModelException {
        Assert.isTrue((boolean)pack.exists());
        Assert.isTrue((!pack.isReadOnly() ? 1 : 0) != 0);
        String packageName = pack.getElementName();
        elementName = packageName.length() > 0 ? packageName + "." + elementName : elementName;
        return pack.getJavaProject().findType(elementName, null);
    }

    public static RefactoringStatus checkTempName(String newName, IJavaElement context) {
        RefactoringStatus result = Checks.checkIdentifier(newName, context);
        if (result.hasFatalError()) {
            return result;
        }
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return result;
    }

    public static RefactoringStatus checkEnumConstantName(String newName, IJavaElement context) {
        RefactoringStatus result = Checks.checkFieldName(newName, context);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.RenameEnumConstRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkConstantName(String newName, IJavaElement context) {
        RefactoringStatus result = Checks.checkFieldName(newName, context);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.ExtractConstantRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean isException(IType iType, IProgressMonitor pm) throws JavaModelException {
        try {
            IType[] superTypes;
            if (!iType.isClass()) {
                return false;
            }
            IType[] iTypeArray = superTypes = iType.newSupertypeHierarchy(pm).getAllSupertypes(iType);
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType superType = iTypeArray[n2];
                if ("java.lang.Throwable".equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        finally {
            pm.done();
        }
    }

    public static int checkExpressionIsRValue(Expression e) {
        if (e instanceof Name && !(((Name)e).resolveBinding() instanceof IVariableBinding)) {
            return 1;
        }
        if (e instanceof Annotation) {
            return 1;
        }
        ITypeBinding tb = e.resolveTypeBinding();
        boolean guessingRequired = false;
        if (tb == null) {
            guessingRequired = true;
            tb = ASTResolving.guessBindingForReference((ASTNode)e);
        }
        if (tb == null) {
            return 1;
        }
        if ("void".equals(tb.getName())) {
            return 2;
        }
        return guessingRequired ? 3 : 0;
    }

    public static boolean isDeclaredIn(VariableDeclaration tempDeclaration, Class<? extends ASTNode> astNodeClass) {
        ASTNode initializer = ASTNodes.getParent((ASTNode)tempDeclaration, astNodeClass);
        if (initializer == null) {
            return false;
        }
        AnonymousClassDeclaration anonymous = ASTNodes.getParent((ASTNode)tempDeclaration, AnonymousClassDeclaration.class);
        if (anonymous == null) {
            return true;
        }
        return !ASTNodes.isParent((ASTNode)anonymous, initializer);
    }
}

