/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.regpot_desktop.ui.sirius.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.efbt.regdna.model.regdna.ELAttribute;
import org.eclipse.efbt.regdna.model.regdna.ELClass;
import org.eclipse.efbt.regdna.model.regdna.ELOperation;
import org.eclipse.efbt.regdna.model.regdna.SelectColumnAttributeAs;
import org.eclipse.efbt.regdna.model.regdna.SelectDerivedColumnAs;
import org.eclipse.efbt.regpot_desktop.ui.sirius.core.ClassAndFeaturePair;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;

public class Services {
    public static Path logFilePath = Path.of("logfile.txt", new String[0]);
    public static boolean debug = false;

    public String getInvokedOperation(EOperation self, DSemanticDiagram diagram, DDiagramElement view) {
        String result;
        block19: {
            DDiagramElement container = (DDiagramElement)view.eContainer();
            if (debug) {
                try {
                    Files.writeString(logFilePath, (CharSequence)(" container " + container), StandardOpenOption.CREATE);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            EObject containersTarget = container.getTarget();
            if (debug) {
                try {
                    Files.writeString(logFilePath, (CharSequence)(" container target " + containersTarget), StandardOpenOption.APPEND);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            EObject viewTarget = view.getTarget();
            if (debug) {
                try {
                    Files.writeString(logFilePath, (CharSequence)(" viewTarget " + viewTarget), StandardOpenOption.APPEND);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            result = "def";
            try {
                result = containersTarget.eInvoke((EOperation)viewTarget, null).toString();
            }
            catch (InvocationTargetException e) {
                if (debug) {
                    try {
                        Files.writeString(logFilePath, (CharSequence)(" InvocationTargetException e " + e.toString()), StandardOpenOption.APPEND);
                        StringWriter writer = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(writer);
                        e.printStackTrace(printWriter);
                        printWriter.flush();
                        String stackTrace = writer.toString();
                        Files.writeString(logFilePath, (CharSequence)(" InvocationTargetException e " + stackTrace), StandardOpenOption.APPEND);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (Exception e1) {
                if (!debug) break block19;
                try {
                    Files.writeString(logFilePath, (CharSequence)(" Exception e " + e1.toString()), StandardOpenOption.APPEND);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        try {
            Files.writeString(logFilePath, (CharSequence)(" result " + result), StandardOpenOption.APPEND);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    public String getAttributeValue(EAttribute self, DSemanticDiagram diagram, DDiagramElement view) {
        DDiagramElement container = (DDiagramElement)view.eContainer();
        System.out.println(" container " + container);
        EObject containersTarget = container.getTarget();
        System.out.println(" container target " + containersTarget);
        EObject viewTarget = view.getTarget();
        String result = "abc";
        result = containersTarget.eGet((EStructuralFeature)((EAttribute)viewTarget), true).toString();
        return result;
    }

    public EList<EObject> getReferencedObjects(EObject self) {
        return this.getReferencedObjectsList((EList<EObject>)self.eCrossReferences());
    }

    public EList<EOperation> getPublicOperations(EObject self) {
        BasicEList returnList = new BasicEList();
        EList operations = self.eClass().getEOperations();
        for (EOperation eOperation : operations) {
            if (eOperation.getName().endsWith("_private")) continue;
            returnList.add((Object)eOperation);
        }
        return returnList;
    }

    public EList<EObject> getReferencedObjectsList(EList<EObject> eObjects) {
        BasicEList list = new BasicEList();
        for (EObject eObject : eObjects) {
            list.add((Object)eObject);
            list.addAll(this.getReferencedObjects(eObject));
        }
        return list;
    }

    public EList<ELAttribute> getUsedAttributes(ELClass self, DSemanticDiagram diagram) {
        EObject target = diagram.getTarget();
        BasicEList returnList = new BasicEList();
        TreeIterator contents = target.eAllContents();
        while (contents.hasNext()) {
            ELAttribute attr;
            EObject eObject = (EObject)contents.next();
            if (!(eObject instanceof SelectColumnAttributeAs) || !(attr = ((SelectColumnAttributeAs)eObject).getAttribute()).eContainer().equals(self)) continue;
            returnList.add((Object)attr);
        }
        return returnList;
    }

    public EList<ELOperation> getUsedOperations(ELClass self, DSemanticDiagram diagram) {
        EObject target = diagram.getTarget();
        BasicEList returnList = new BasicEList();
        TreeIterator contents = target.eAllContents();
        while (contents.hasNext()) {
            ELOperation oper;
            EObject eObject = (EObject)contents.next();
            if (!(eObject instanceof SelectDerivedColumnAs) || !(oper = ((SelectDerivedColumnAs)eObject).getAttribute()).eContainer().equals(self)) continue;
            returnList.add((Object)oper);
        }
        return returnList;
    }

    public EList<EOperation> getUsedInvokedOperations(EObject self, DSemanticDiagram diagram, DDiagramElement view) {
        BasicEList usedOperations = new BasicEList();
        EList<ClassAndFeaturePair> pairs = this.getListOfUsedClassAndFeaturePairs(diagram.getTarget());
        EList operation = self.eClass().getEOperations();
        for (EOperation eOperation : operation) {
            if (eOperation.getName().endsWith("_private") || eOperation.getName().contains("regScenario")) continue;
            boolean inList = false;
            for (ClassAndFeaturePair pair : pairs) {
                String theClassName = self.eClass().getName();
                String theSuperClassName = "NoSuperClass";
                EList theSuperClasses = self.eClass().getESuperTypes();
                if (theSuperClasses.size() > 0) {
                    theSuperClassName = ((EClass)theSuperClasses.get(0)).getName();
                }
                if (!eOperation.getName().equalsIgnoreCase(pair.attributeOrOperationName) || !theClassName.equalsIgnoreCase(pair.className) && !theSuperClassName.equalsIgnoreCase(pair.className)) continue;
                inList = true;
            }
            if (!inList) continue;
            usedOperations.add((Object)eOperation);
        }
        return usedOperations;
    }

    private EList<ClassAndFeaturePair> getListOfUsedClassAndFeaturePairs(EObject root) {
        BasicEList returnList = new BasicEList();
        EList<EObject> allObjects = this.getReferencedObjects(root);
        allObjects.add((Object)root);
        if (debug) {
            try {
                Files.writeString(logFilePath, (CharSequence)("getListOfUsedClassAndFeaturePairs" + root.eClass().getName()), StandardOpenOption.APPEND);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        for (EObject eObject : allObjects) {
            EList containedObjects = eObject.eContents();
            if (containedObjects.size() <= 0) continue;
            EClass objectsClass = ((EObject)containedObjects.get(0)).eClass();
            EList operations = objectsClass.getEOperations();
            for (EOperation operation : operations) {
                if (debug) {
                    try {
                        Files.writeString(logFilePath, (CharSequence)("operation = " + operation.getName()), StandardOpenOption.APPEND);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                EList annotations = operation.getEAnnotations();
                for (EAnnotation annotation : annotations) {
                    if (debug) {
                        try {
                            Files.writeString(logFilePath, (CharSequence)("annotation = " + annotation.toString()), StandardOpenOption.APPEND);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (annotation.getSource() != "dep") continue;
                    if (debug) {
                        try {
                            Files.writeString(logFilePath, (CharSequence)("annotation.getSource() = " + annotation.getSource()), StandardOpenOption.APPEND);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    EMap details = annotation.getDetails();
                    for (String key : details.keySet()) {
                        String[] sections;
                        block43: {
                            block42: {
                                if (debug) {
                                    try {
                                        Files.writeString(logFilePath, (CharSequence)("key = " + key), StandardOpenOption.APPEND);
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                if (debug) {
                                    try {
                                        Files.writeString(logFilePath, (CharSequence)("details.get(key) = " + (String)details.get((Object)key)), StandardOpenOption.APPEND);
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (Exception e1) {
                                        if (!debug) break block42;
                                        try {
                                            Files.writeString(logFilePath, (CharSequence)("error = " + e1.toString()), StandardOpenOption.APPEND);
                                        }
                                        catch (IOException iOException) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                            }
                            sections = ((String)details.get((Object)key)).split("\\.");
                            if (debug) {
                                try {
                                    Files.writeString(logFilePath, (CharSequence)("sections.length = " + sections.length), StandardOpenOption.APPEND);
                                    Files.writeString(logFilePath, (CharSequence)("sections[0] = " + sections[0]), StandardOpenOption.APPEND);
                                }
                                catch (Exception e1) {
                                    if (!debug) break block43;
                                    try {
                                        Files.writeString(logFilePath, (CharSequence)("error = " + e1.toString()), StandardOpenOption.APPEND);
                                    }
                                    catch (IOException iOException) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        }
                        if (debug) {
                            try {
                                Files.writeString(logFilePath, (CharSequence)("sections.length = " + sections.length), StandardOpenOption.APPEND);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (sections.length > 1) {
                            ClassAndFeaturePair classAndFeaturePair = new ClassAndFeaturePair();
                            if (debug) {
                                try {
                                    Files.writeString(logFilePath, (CharSequence)("(EClass)operation.eContainer() =" + (EClass)operation.eContainer()), StandardOpenOption.APPEND);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            String className = this.getEClassAssociatedWithReference((EClass)operation.eContainer(), sections[0]);
                            if (debug) {
                                try {
                                    Files.writeString(logFilePath, (CharSequence)("className = " + className), StandardOpenOption.APPEND);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            classAndFeaturePair.className = className;
                            classAndFeaturePair.attributeOrOperationName = sections[1];
                            returnList.add((Object)classAndFeaturePair);
                            continue;
                        }
                        System.out.println("couldnt split " + (String)details.get((Object)key));
                        if (!debug) continue;
                        try {
                            Files.writeString(logFilePath, (CharSequence)("couldnt split " + (String)details.get((Object)key)), StandardOpenOption.APPEND);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }
        return returnList;
    }

    private String getEClassAssociatedWithReference(EClass eClass, String refName) {
        String returnValue = null;
        EList references = eClass.getEReferences();
        if (debug) {
            try {
                Files.writeString(logFilePath, (CharSequence)("references.size = " + references.size()), StandardOpenOption.APPEND);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        for (EReference eReference : references) {
            String referenceName = eReference.getName();
            if (debug) {
                try {
                    Files.writeString(logFilePath, (CharSequence)("referenceName = " + referenceName), StandardOpenOption.APPEND);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (debug) {
                try {
                    Files.writeString(logFilePath, (CharSequence)("refName = " + refName), StandardOpenOption.APPEND);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (!referenceName.equalsIgnoreCase(refName)) continue;
            returnValue = eReference.getEType().getName();
            if (!debug) continue;
            try {
                Files.writeString(logFilePath, (CharSequence)("returnValue = " + returnValue), StandardOpenOption.APPEND);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return returnValue;
    }

    public EList<EAttribute> getUsedAttributeValues(EObject self, DSemanticDiagram diagram, DDiagramElement view) {
        BasicEList usedAttributes = new BasicEList();
        EList<ClassAndFeaturePair> pairs = this.getListOfUsedClassAndFeaturePairs(diagram.getTarget());
        EList attributes = self.eClass().getEAttributes();
        for (EAttribute eAttribute : attributes) {
            boolean inList = false;
            String theClassName = self.eClass().getName();
            String theSuperClassName = "NoSuperClass";
            EList theSuperClasses = self.eClass().getESuperTypes();
            if (theSuperClasses.size() > 0) {
                theSuperClassName = ((EClass)theSuperClasses.get(0)).getName();
            }
            for (ClassAndFeaturePair pair : pairs) {
                if (!eAttribute.getName().equalsIgnoreCase(pair.attributeOrOperationName) || !theClassName.equalsIgnoreCase(pair.className) && !theSuperClassName.equalsIgnoreCase(pair.className)) continue;
                inList = true;
            }
            if (!inList) continue;
            usedAttributes.add((Object)eAttribute);
        }
        return usedAttributes;
    }

    public EList<EObject> getUsedReferencedObjects(EObject self) {
        EList<EObject> referencedObjects = this.getReferencedObjects(self);
        BasicEList usedReferencedObjects = new BasicEList();
        EList<ClassAndFeaturePair> pairs = this.getListOfUsedClassAndFeaturePairs(self);
        for (EObject eObject : referencedObjects) {
            EList containedObjects = eObject.eContents();
            if (containedObjects.size() <= 0) continue;
            EClass objectsClass = ((EObject)containedObjects.get(0)).eClass();
            EList attributes = objectsClass.getEAttributes();
            int featureCount = 0;
            for (EAttribute eAttribute : attributes) {
                String theClassName = objectsClass.getName();
                String theSuperClassName = "NoSuperClass";
                EList theSuperClasses = objectsClass.getESuperTypes();
                if (theSuperClasses.size() > 0) {
                    theSuperClassName = ((EClass)theSuperClasses.get(0)).getName();
                }
                for (ClassAndFeaturePair pair : pairs) {
                    if (!eAttribute.getName().equalsIgnoreCase(pair.attributeOrOperationName) || !theClassName.equalsIgnoreCase(pair.className) && !theSuperClassName.equalsIgnoreCase(pair.className)) continue;
                    ++featureCount;
                }
            }
            EList operation = objectsClass.getEOperations();
            for (EOperation eOperation : operation) {
                String theClassName = objectsClass.getName();
                String theSuperClassName = "NoSuperClass";
                EList theSuperClasses = objectsClass.getESuperTypes();
                if (theSuperClasses.size() > 0) {
                    theSuperClassName = ((EClass)theSuperClasses.get(0)).getName();
                }
                if (eOperation.getName().endsWith("_private") || eOperation.getName().contains("regScenario")) continue;
                for (ClassAndFeaturePair pair : pairs) {
                    if (!eOperation.getName().equalsIgnoreCase(pair.attributeOrOperationName) || !theClassName.equalsIgnoreCase(pair.className) && !theSuperClassName.equalsIgnoreCase(pair.className)) continue;
                    ++featureCount;
                }
            }
            if (featureCount <= 0) continue;
            usedReferencedObjects.add((Object)eObject);
        }
        return usedReferencedObjects;
    }
}

