/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.negdep.onerror.srv.toomanyargs;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends NegativeDeploymentClient {
    private static final long serialVersionUID = 111L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_negdep_onerror_srv_toomanyarguments_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.negdep.onerror.srv.toomanyargs"});
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{NegativeDeploymentClient.class}), new String[]{"com.sun.ts.tests.websocket.negdep"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_negdep_onerror_srv_toomanyarguments_web");
    }

    @Test
    public void tooManyArgsOnErrorRemovesAllEndpointsTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "anything");
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"echo"}));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        try {
            this.invoke(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String response = this.getResponseAsString();
        if ("anything".equals(response)) {
            this.throwValidEndpointMustBeRemoved();
        }
    }

    @Test
    public void tooManyArgsOnErrorTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "anything");
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"invalid"}));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        try {
            this.invoke(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String response = this.getResponseAsString();
        if (response.contains("anything")) {
            this.throwValidEndpointMustBeRemoved();
        }
    }
}

