/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.security.annotations;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.BaseTckTest;
import servlet.tck.spec.security.annotations.DenyAllServlet;
import servlet.tck.spec.security.annotations.GuestPageTestServlet;
import servlet.tck.spec.security.annotations.PartialDDServlet;
import servlet.tck.spec.security.annotations.ServletSecTestServlet;
import servlet.tck.spec.security.annotations.UnProtectedTestServlet;
import servlet.tck.util.WebUtil;

public class AnnotationsTests
extends BaseTckTest {
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private static final String UNAUTH_USERNAME = "authuser";
    private static final String UNAUTH_PASSWORD = "authpassword";
    private static final String USER_PRINCIPAL_SEARCH = "The user principal is: ";
    private static final String REMOTE_USER_SEARCH = "getRemoteUser(): ";
    private String pageDeny = null;
    private String pageSec = null;
    private String pageGuest = null;
    private String pageUnprotected = null;
    private String pageTrans = null;
    private String pagePartial = null;
    private String username = null;
    private String password = null;
    private String unauthUsername = null;
    private String unauthPassword = null;
    private String realm = null;
    private WebUtil.Response response = null;
    private String request = null;

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_sec_annotations_web.war")).addClasses(new Class[]{DenyAllServlet.class, GuestPageTestServlet.class, PartialDDServlet.class, ServletSecTestServlet.class, UnProtectedTestServlet.class})).setWebXML(AnnotationsTests.class.getResource("servlet_sec_annotations_web.xml"));
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        super.setup(args, p);
        try {
            this.username = System.getProperty("tck.servlet.username", "j2ee");
            this.password = System.getProperty("tck.servlet.password", "j2ee");
            this.unauthUsername = System.getProperty("tck.servlet.unauth.username", "javajoe");
            this.unauthPassword = System.getProperty("tck.servlet.unauth.password", "javajoe");
            this.realm = System.getProperty("tck.servlet.realm", "");
            String pageServletBase = this.getContextRoot();
            String pageServletDeny = pageServletBase + "/ServletDenyAll";
            String pageServletSec = pageServletBase + "/ServletSecTest";
            String pageServletGuest = pageServletBase + "/GuestPageTest";
            String pageServletUnprotected = pageServletBase + "/UnProtectedTest";
            String pageTransport = pageServletBase + "/TransportServlet";
            String pagePartialDD = pageServletBase + "/PartialDDTest";
            this.pageSec = pageServletSec;
            this.pageDeny = pageServletDeny;
            this.pageGuest = pageServletGuest;
            this.pageUnprotected = pageServletUnprotected;
            this.pageTrans = pageTransport;
            this.pagePartial = pagePartialDD;
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    @Test
    public void test1() throws Exception {
        this.trace("testing DenyAll");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test1");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pageDeny));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            this.trace("we tested for Status Code=401 but we could have a 403 code, so check for that.");
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test1");
            ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pageDeny));
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.trace("test1 passed:  we were not allowed to perform GET on a servlet with DenyAll anno");
    }

    @Test
    public void test2() throws Exception {
        StringBuilder sb = new StringBuilder(100);
        sb.append(USER_PRINCIPAL_SEARCH).append(this.unauthUsername);
        this.trace("Sending request to resource with valid username/password, but not the right roles...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception ex) {
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
            ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageGuest));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
        }
        this.trace("Sending request to resource with valid username/password, but not the right roles...");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", sb.toString());
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.trace("Sending request to resource with valid username/password, but not the right roles...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test2");
            ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageGuest));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.trace("test2");
    }

    @Test
    public void test3() throws Exception {
        String invalidUser = "invalid";
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test3");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.trace("Class level annotation of Roles allowed overridden by method level permit all access.");
        this.trace("test3 passed.");
    }

    @Test
    public void test4() throws Exception {
        String invalidUser = "invalid";
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageSec));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageSec));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.trace("Class level setting of roles allowed was overridden by deny all access at method level.");
        this.trace("test4 passed.");
    }

    @Test
    public void test5() throws Exception {
        this.trace("Sending request to resource that uses the PermitAll annotation....");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "BasicSec/Test5");
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.unauthUsername);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.unauthPassword);
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pageUnprotected));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.trace("Class level PermitAll anno returned expected results");
        this.trace("test5 passed.");
    }

    @Test
    public void test6() throws Exception {
        this.trace("Sending request to resource where DD allows access to override any restricting annotation...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
        this.trace("Sending request to resource with valid username/password, but not the right roles...");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageGuest));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test6");
            ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pageGuest));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.trace("User successfully accessed the resource");
    }

    @Test
    public void test7() throws Exception {
        this.trace("testing http-method-omission");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test7");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pagePartial));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "401");
        try {
            this.invoke();
        }
        catch (Exception e) {
            this.trace("we tested for Status Code=401 but we could have a 403 code, so check for that.");
            ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test7");
            ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pagePartial));
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
            ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
            ((Properties)TEST_PROPS.get()).setProperty("status-code", "403");
            this.invoke();
        }
        this.trace("test7:  complete doGet() with no creds - now starting doPost");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test7");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("GET", this.pagePartial));
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_user", this.username);
        ((Properties)TEST_PROPS.get()).setProperty("basic_auth_passwd", this.password);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.trace("test7:  complete doGet() with creds - now starting doPost");
        ((Properties)TEST_PROPS.get()).setProperty("testname", "SecAnnotations/Test7");
        ((Properties)TEST_PROPS.get()).setProperty("request", AnnotationsTests.getRequestLine("POST", this.pagePartial));
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "200");
        this.invoke();
        this.trace("test7:  complete doPost() with no creds.");
        this.trace("test7 passed:  servlet with http-method-omission settings.");
    }

    private static String getRequestLine(String method, String path) {
        return method + " " + path + " HTTP/1.1";
    }

    private void trace(String message) {
        this.logger.debug("[Client]: {}", (Object)message);
    }
}

