/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import jdk.incubator.http.internal.websocket.OutgoingMessage;
import jdk.incubator.http.internal.websocket.RawChannel;

final class Transmitter {
    private final AtomicBoolean busy = new AtomicBoolean();
    private OutgoingMessage message;
    private Consumer<Exception> completionHandler;
    private final RawChannel channel;
    private final RawChannel.RawEvent event;

    Transmitter(RawChannel rawChannel) {
        this.channel = Objects.requireNonNull(rawChannel);
        this.event = this.createHandler();
    }

    void send(OutgoingMessage outgoingMessage, Consumer<Exception> consumer) {
        Objects.requireNonNull(outgoingMessage);
        Objects.requireNonNull(consumer);
        if (!this.busy.compareAndSet(false, true)) {
            throw new IllegalStateException();
        }
        this.send0(outgoingMessage, consumer);
    }

    private RawChannel.RawEvent createHandler() {
        return new RawChannel.RawEvent(){

            @Override
            public int interestOps() {
                return 4;
            }

            @Override
            public void handle() {
                Transmitter.this.send0(Transmitter.this.message, Transmitter.this.completionHandler);
            }
        };
    }

    private void send0(OutgoingMessage outgoingMessage, Consumer<Exception> consumer) {
        boolean bl = this.busy.get();
        assert (bl);
        try {
            boolean bl2 = outgoingMessage.sendTo(this.channel);
            if (bl2) {
                this.busy.set(false);
                consumer.accept(null);
            } else {
                this.message = outgoingMessage;
                this.completionHandler = consumer;
                try {
                    this.channel.registerEvent(this.event);
                }
                catch (IOException iOException) {
                    this.message = null;
                    this.completionHandler = null;
                    this.busy.set(false);
                    consumer.accept(iOException);
                }
            }
        }
        catch (IOException iOException) {
            this.busy.set(false);
            consumer.accept(iOException);
        }
    }
}

