/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import jdk.incubator.http.internal.hpack.BinaryRepresentationWriter;
import jdk.incubator.http.internal.hpack.BulkSizeUpdateWriter;
import jdk.incubator.http.internal.hpack.HeaderTable;
import jdk.incubator.http.internal.hpack.IndexedWriter;
import jdk.incubator.http.internal.hpack.LiteralNeverIndexedWriter;
import jdk.incubator.http.internal.hpack.LiteralWithIndexingWriter;
import jdk.incubator.http.internal.hpack.LiteralWriter;
import jdk.incubator.http.internal.hpack.SizeUpdateWriter;

public class Encoder {
    private static final boolean DEFAULT_HUFFMAN = true;
    private final IndexedWriter indexedWriter = new IndexedWriter();
    private final LiteralWriter literalWriter = new LiteralWriter();
    private final LiteralNeverIndexedWriter literalNeverIndexedWriter = new LiteralNeverIndexedWriter();
    private final LiteralWithIndexingWriter literalWithIndexingWriter = new LiteralWithIndexingWriter();
    private final SizeUpdateWriter sizeUpdateWriter = new SizeUpdateWriter();
    private final BulkSizeUpdateWriter bulkSizeUpdateWriter = new BulkSizeUpdateWriter();
    private BinaryRepresentationWriter writer;
    private final HeaderTable headerTable;
    private boolean encoding;
    private int maxCapacity;
    private int currCapacity;
    private int lastCapacity;
    private long minCapacity;
    private boolean capacityUpdate;
    private boolean configuredCapacityUpdate;

    public Encoder(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxCapacity >= 0: " + n);
        }
        this.minCapacity = Long.MAX_VALUE;
        this.currCapacity = -1;
        this.setMaxCapacity(n);
        this.headerTable = new HeaderTable(this.lastCapacity);
    }

    public void header(CharSequence charSequence, CharSequence charSequence2) throws IllegalStateException {
        this.header(charSequence, charSequence2, false);
    }

    public void header(CharSequence charSequence, CharSequence charSequence2, boolean bl) throws IllegalStateException {
        Objects.requireNonNull(charSequence, "name");
        Objects.requireNonNull(charSequence2, "value");
        HeaderTable headerTable = this.getHeaderTable();
        int n = headerTable.indexOf(charSequence, charSequence2);
        if (n > 0) {
            this.indexed(n);
        } else if (n < 0) {
            if (bl) {
                this.literalNeverIndexed(-n, charSequence2, true);
            } else {
                this.literal(-n, charSequence2, true);
            }
        } else if (bl) {
            this.literalNeverIndexed(charSequence, true, charSequence2, true);
        } else {
            this.literal(charSequence, true, charSequence2, true);
        }
    }

    public void setMaxCapacity(int n) {
        this.checkEncoding();
        if (n < 0) {
            throw new IllegalArgumentException("capacity >= 0: " + n);
        }
        int n2 = this.calculateCapacity(n);
        if (n2 < 0 || n2 > n) {
            throw new IllegalArgumentException(String.format("0 <= calculated <= capacity: calculated=%s, capacity=%s", n2, n));
        }
        this.capacityUpdate = true;
        this.maxCapacity = n;
        this.lastCapacity = n2;
        this.minCapacity = Math.min(this.minCapacity, (long)this.lastCapacity);
    }

    protected int calculateCapacity(int n) {
        return 0;
    }

    public final boolean encode(ByteBuffer byteBuffer) {
        if (!this.encoding) {
            throw new IllegalStateException("A header hasn't been set up");
        }
        if (!this.prependWithCapacityUpdate(byteBuffer)) {
            return false;
        }
        boolean bl = this.writer.write(this.headerTable, byteBuffer);
        if (bl) {
            this.writer.reset();
            this.encoding = false;
        }
        return bl;
    }

    private boolean prependWithCapacityUpdate(ByteBuffer byteBuffer) {
        if (this.capacityUpdate) {
            boolean bl;
            if (!this.configuredCapacityUpdate) {
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                if (this.minCapacity < (long)this.currCapacity) {
                    linkedList.add((int)this.minCapacity);
                    if (this.minCapacity != (long)this.lastCapacity) {
                        linkedList.add(this.lastCapacity);
                    }
                } else if (this.lastCapacity != this.currCapacity) {
                    linkedList.add(this.lastCapacity);
                }
                this.bulkSizeUpdateWriter.maxHeaderTableSizes(linkedList);
                this.configuredCapacityUpdate = true;
            }
            if (bl = this.bulkSizeUpdateWriter.write(this.headerTable, byteBuffer)) {
                this.minCapacity = this.lastCapacity;
                this.currCapacity = this.lastCapacity;
                this.bulkSizeUpdateWriter.reset();
                this.capacityUpdate = false;
                this.configuredCapacityUpdate = false;
            }
            return bl;
        }
        return true;
    }

    protected final void indexed(int n) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.indexedWriter.index(n);
    }

    protected final void literal(int n, CharSequence charSequence, boolean bl) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWriter.index(n).value(charSequence, bl);
    }

    protected final void literal(CharSequence charSequence, boolean bl, CharSequence charSequence2, boolean bl2) {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWriter.name(charSequence, bl).value(charSequence2, bl2);
    }

    protected final void literalNeverIndexed(int n, CharSequence charSequence, boolean bl) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalNeverIndexedWriter.index(n).value(charSequence, bl);
    }

    protected final void literalNeverIndexed(CharSequence charSequence, boolean bl, CharSequence charSequence2, boolean bl2) {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalNeverIndexedWriter.name(charSequence, bl).value(charSequence2, bl2);
    }

    protected final void literalWithIndexing(int n, CharSequence charSequence, boolean bl) throws IndexOutOfBoundsException {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWithIndexingWriter.index(n).value(charSequence, bl);
    }

    protected final void literalWithIndexing(CharSequence charSequence, boolean bl, CharSequence charSequence2, boolean bl2) {
        this.checkEncoding();
        this.encoding = true;
        this.writer = this.literalWithIndexingWriter.name(charSequence, bl).value(charSequence2, bl2);
    }

    protected final void sizeUpdate(int n) throws IllegalArgumentException {
        this.checkEncoding();
        if (n > this.maxCapacity) {
            throw new IllegalArgumentException(String.format("capacity <= maxCapacity: capacity=%s, maxCapacity=%s", n, this.maxCapacity));
        }
        this.writer = this.sizeUpdateWriter.maxHeaderTableSize(n);
    }

    protected final int getMaxCapacity() {
        return this.maxCapacity;
    }

    protected final HeaderTable getHeaderTable() {
        return this.headerTable;
    }

    protected final void checkEncoding() {
        if (this.encoding) {
            throw new IllegalStateException("Previous encoding operation hasn't finished yet");
        }
    }
}

