/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import java.io.IOException;
import java.io.Writer;

class AgentWriter
extends Writer {
    private byte type;
    private Agent.Task parent;
    private char[] buf = new char[1024];
    private int count = 0;

    AgentWriter(byte type, Agent.Task parent) {
        this.type = type;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(int ch) throws IOException {
        this.buf[this.count++] = (char)ch;
        if (this.count == this.buf.length) {
            try {
                this.parent.sendChars(this.type, this.buf, 0, this.count);
            }
            finally {
                this.count = 0;
            }
        }
    }

    @Override
    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    @Override
    public synchronized void write(char[] c, int off, int len) throws IOException {
        if (len < this.buf.length - this.count) {
            System.arraycopy(c, off, this.buf, this.count, len);
            this.count += len;
        } else {
            this.flush();
            if (len < this.buf.length) {
                System.arraycopy(c, off, this.buf, this.count, len);
                this.count += len;
            } else {
                this.parent.sendChars(this.type, c, off, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        if (this.count > 0) {
            switch (this.type) {
                case 76: {
                    this.type = (byte)108;
                    break;
                }
                case 82: {
                    this.type = (byte)114;
                }
            }
            try {
                this.parent.sendChars(this.type, this.buf, 0, this.count);
            }
            finally {
                this.count = 0;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

