/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._byte.maxinclusive.maxinclusive_4;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive4_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive4_ValidateCTTests test = new maxInclusive4_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final byte[] validValues = {(byte)-128, (byte)-70, (byte)-19};
    
    final byte[] invalidValues = {(byte)-18, (byte)0, (byte)70, (byte)127};
    
    JAXBElement<Byte> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "maxInclusive-4-1.xml";
        elemObj = (JAXBElement<Byte>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "maxInclusive-4-1.xml";
        elemObj = (JAXBElement<Byte>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteMaxInclusive4((byte)-10);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteMaxInclusive4((byte)-30);
        
        return testInvalid();
    }


}

