/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.usecases;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.usecases.CMBean2IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Properties;

@TransactionManagement(value=TransactionManagementType.CONTAINER)
@Stateless(name="CDIUseCasesCMBEAN2")
@Remote(value={CMBean2IF.class})
public class CMBean2
implements CMBean2IF {
    private static final long serialVersionUID = 1L;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    JMSContext context;
    @Inject
    @JMSConnectionFactory(value="jms/QueueConnectionFactory")
    JMSContext context2;
    @Resource(name="jms/MyConnectionFactory")
    ConnectionFactory cfactory;
    @Resource(name="jms/MY_QUEUE")
    Queue queue;
    @Resource(name="jms/MY_TOPIC")
    Topic topic;
    private static final System.Logger logger = System.getLogger(CMBean2.class.getName());

    @PostConstruct
    public void postConstruct() {
        System.out.println("CMBean2:postConstruct()");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        System.out.println("cfactory=" + this.cfactory);
        if (this.queue == null || this.topic == null || this.context == null || this.cfactory == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init(Properties p) {
        logger.log(System.Logger.Level.INFO, "CMBean2.init()");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean2.init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("CMBean2.init: failed");
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method2a() {
        logger.log(System.Logger.Level.INFO, "CMBean2.method2a(): context=" + this.context);
        logger.log(System.Logger.Level.INFO, "Sending message [Message 1]");
        this.context.createProducer().send((Destination)this.queue, "Message 1");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method2b() {
        logger.log(System.Logger.Level.INFO, "CMBean2.method2b(): context=" + this.context);
        logger.log(System.Logger.Level.INFO, "Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method3() {
        logger.log(System.Logger.Level.INFO, "CMBean2.method3(): context=" + this.context);
        logger.log(System.Logger.Level.INFO, "Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void method5() {
        logger.log(System.Logger.Level.INFO, "CMBean2.method5(): context=" + this.context);
        logger.log(System.Logger.Level.INFO, "Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void method6() {
        logger.log(System.Logger.Level.INFO, "CMBean2.method6(): context=" + this.context);
        logger.log(System.Logger.Level.INFO, "Sending message [Message 2]");
        this.context2.createProducer().send((Destination)this.queue, "Message 2");
    }
}

