/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.mdb;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.tests.jms.ee20.cditests.mdb.EjbClientIF;
import jakarta.ejb.EJB;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/cditestsmdb_web/ServletTest";
    @EJB(name="ejb/CDITestsMDBClntBean")
    static EjbClientIF ejbclient;
    private static final long serialVersionUID = 1L;
    long timeout;
    String user;
    String password;
    String mode;
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.hostname = System.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' is null");
            }
            try {
                this.portnum = Integer.parseInt(System.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in must be a number");
            }
            logger.log(System.Logger.Level.INFO, "AppClient DEBUG: ejbclient=" + ejbclient);
            if (ejbclient == null) {
                throw new Exception("setup failed: ejbclient injection failure");
            }
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @Test
    public void testCDIInjectionOfMDBWithQueueReplyFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            logger.log(System.Logger.Level.INFO, "testCDIInjectionOfMDBWithQueueReplyFromEjb");
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            boolean passEjb = ejbclient.echo("testCDIInjectionOfMDBWithQueueReplyFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
            passEjb = ejbclient.echo("testCDIInjectionOfMDBWithQueueReplyFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testCDIInjectionOfMDBWithQueueReplyFromEjb failed");
        }
    }

    @Test
    public void testCDIInjectionOfMDBWithTopicReplyFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            logger.log(System.Logger.Level.INFO, "testCDIInjectionOfMDBWithTopicReplyFromEjb");
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            boolean passEjb = ejbclient.echo("testCDIInjectionOfMDBWithTopicReplyFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
            passEjb = ejbclient.echo("testCDIInjectionOfMDBWithTopicReplyFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testCDIInjectionOfMDBWithTopicReplyFromEjb failed");
        }
    }

    static {
        logger = System.getLogger(ClientIT.class.getName());
    }
}

