/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToTopic;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanToTopic
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanToTopic.class.getName());
    private TopicConnectionFactory tFactory = null;
    private TopicConnection tConnection = null;
    private Topic topic = null;
    private TopicPublisher mPublisher = null;
    private TopicSession tSession = null;

    public MsgBeanToTopic() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanToTopic()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanToTopic-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "@MsgBeanToTopic - onMessage! " + msg);
        try {
            this.tConnection = this.tFactory.createTopicConnection();
            this.tConnection.start();
            logger.log(System.Logger.Level.TRACE, "started the connection !!");
            this.tSession = this.tConnection.createTopicSession(true, 0);
            if (msg.getStringProperty("MessageType").equals("TextMessage")) {
                this.sendATextMessage();
            } else if (msg.getStringProperty("MessageType").equals("BytesMessage")) {
                this.sendABytesMessage();
            } else if (msg.getStringProperty("MessageType").equals("MapMessage")) {
                this.sendAMapMessage();
            } else if (msg.getStringProperty("MessageType").equals("StreamMessage")) {
                this.sendAStreamMessage();
            } else if (msg.getStringProperty("MessageType").equals("ObjectMessage")) {
                this.sendAnObjectMessage();
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (this.tConnection != null) {
                    this.tConnection.close();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
            logger.log(System.Logger.Level.TRACE, "MsgBean initLogging OK.");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.INFO, "MsgBean initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    private void sendATextMessage() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean - sendATextMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mPublisher = this.tSession.createPublisher(this.topic);
            TextMessage msg = this.tSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setText(myMsg);
            msg.setStringProperty("MessageType", "TextMessageFromMsgBean");
            this.mPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendABytesMessage() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean - sendABytesMessage");
        try {
            byte aByte = 10;
            this.mPublisher = this.tSession.createPublisher(this.topic);
            BytesMessage msg = this.tSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeByte(aByte);
            msg.setStringProperty("MessageType", "BytesMessageFromMsgBean");
            this.mPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendAMapMessage() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean - sendAMapMessage");
        try {
            String myMsg = "I am sending a map message as requested";
            this.mPublisher = this.tSession.createPublisher(this.topic);
            MapMessage msg = this.tSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setString("MapMessage", myMsg);
            msg.setStringProperty("MessageType", "MapMessageFromMsgBean");
            this.mPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendAStreamMessage() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean - sendAStreamMessage");
        try {
            String myMsg = "I am sending a stream message as requested";
            this.mPublisher = this.tSession.createPublisher(this.topic);
            StreamMessage msg = this.tSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeString(myMsg);
            msg.setStringProperty("MessageType", "StreamMessageFromMsgBean");
            this.mPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendAnObjectMessage() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean - sendAnObjectMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mPublisher = this.tSession.createPublisher(this.topic);
            ObjectMessage msg = this.tSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setObject((Serializable)((Object)myMsg));
            msg.setStringProperty("MessageType", "ObjectMessageFromMsgBean");
            this.mPublisher.publish((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::remove()!!");
    }
}

