/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ3;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestQ3
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanMsgTestQ3.class.getName());
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;

    public MsgBeanMsgTestQ3() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanMsgTest3()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesQ3  - @MsgBeanMsgTest3-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                logger.log(System.Logger.Level.TRACE, "qFactory error");
            }
            logger.log(System.Logger.Level.TRACE, "got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                logger.log(System.Logger.Level.TRACE, "queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            if (this.queue == null) {
                logger.log(System.Logger.Level.TRACE, "queue error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "from jms.ee.mdb.mdb_msgTypesQ3 @onMessage!" + msg);
        try {
            logger.log(System.Logger.Level.TRACE, "onMessage will run TestCase: " + msg.getStringProperty("TestCase"));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                logger.log(System.Logger.Level.TRACE, "connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueTextTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueTextTestCreate - create the message");
                this.msgClearBodyQueueTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueTextTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueTextTest - read and verify the message");
                this.msgClearBodyQueueTextTest((TextMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueObjectTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueObjectTestCreate - create the message");
                this.msgClearBodyQueueObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueObjectTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueObjectTest - read and verify the message");
                this.msgClearBodyQueueObjectTest((ObjectMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueMapTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueMapTestCreate - create the message");
                this.msgClearBodyQueueMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueMapTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueMapTest - read and verify the message");
                this.msgClearBodyQueueMapTest((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueBytesTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueBytesTestCreate - create the message");
                this.msgClearBodyQueueBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueBytesTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueBytesTest - read and verify the message");
                this.msgClearBodyQueueBytesTest((BytesMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueStreamTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueStreamTestCreate - create the message");
                this.msgClearBodyQueueStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyQueueStreamTest - read and verify the message");
                this.msgClearBodyQueueStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgResetQueueTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgResetQueueTest - read and verify the message");
                this.msgResetQueueTest();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueStreamTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidQueueStreamTestCreate - read and verify the message");
                this.readNullCharNotValidQueueStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidQueueStreamTest - read and verify the message");
                this.readNullCharNotValidQueueStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueMapTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidQueueMapTestCreate - read and verify the message");
                this.readNullCharNotValidQueueMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueMapTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidQueueMapTest - read and verify the message");
                this.readNullCharNotValidQueueMapTest((MapMessage)msg);
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
                logger.log(System.Logger.Level.TRACE, "Do not have a method for this testcase: " + msg.getStringProperty("TestCase"));
            }
            logger.log(System.Logger.Level.TRACE, "@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void msgClearBodyQueueTextTestCreate() {
        try {
            TextMessage messageSent = null;
            messageSent = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("TestCase", "msgClearBodyQueueTextTest");
            logger.log(System.Logger.Level.TRACE, "sending a Text message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueObjectTestCreate() {
        try {
            ObjectMessage messageSentObjectMsg = null;
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, (Properties)this.p);
            messageSentObjectMsg.setObject((Serializable)((Object)"Initial message"));
            messageSentObjectMsg.setStringProperty("TestCase", "msgClearBodyQueueObjectTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueMapTestCreate() {
        try {
            MapMessage messageSentMapMessage = null;
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentMapMessage = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSentMapMessage, (Properties)this.p);
            messageSentMapMessage.setStringProperty("TestCase", "msgClearBodyQueueMapTest");
            messageSentMapMessage.setString("aString", "Initial message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueBytesTestCreate() {
        byte bValue = 127;
        try {
            BytesMessage messageSentBytesMessage = null;
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentBytesMessage = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
            messageSentBytesMessage.setStringProperty("TestCase", "msgClearBodyQueueBytesTest");
            messageSentBytesMessage.writeByte(bValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueStreamTestCreate() {
        try {
            StreamMessage messageSentStreamMessage = null;
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, (Properties)this.p);
            messageSentStreamMessage.setStringProperty("TestCase", "msgClearBodyQueueStreamTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueTextTest(TextMessage messageReceived) {
        String testCase = "msgClearBodyQueueTextTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Test TextMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceived.getText());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceived.clearBody();
            if (messageReceived.getText() == null) {
                logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TestCase").equals("msgClearBodyQueueTextTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Text properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Text properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write and read 2nd contents");
            messageReceived.setText("new data");
            if (messageReceived.getText().equals("new data")) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueObjectTest(ObjectMessage messageReceivedObjectMsg) {
        String testCase = "msgClearBodyQueueObjectTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Testing Object message");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedObjectMsg.getObject());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedObjectMsg.clearBody();
            if (messageReceivedObjectMsg.getObject() == null) {
                logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                pass = false;
            }
            if (messageReceivedObjectMsg.getStringProperty("TestCase").equals("msgClearBodyQueueObjectTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Object properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Object properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedObjectMsg.setObject((Serializable)((Object)"new stuff here!!!!!!"));
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            if (messageReceivedObjectMsg.getObject().equals("new stuff here!!!!!!")) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: ");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgClearBodyQueueMapTest(MapMessage messageReceivedMapMessage) {
        String testCase = "msgClearBodyQueueMapTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Test for MapMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedMapMessage.getString("aString"));
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedMapMessage.clearBody();
            if (messageReceivedMapMessage.getString("aString") == null) {
                logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                logger.log(System.Logger.Level.TRACE, "Contains: " + messageReceivedMapMessage.getString("aString"));
                pass = false;
            }
            if (messageReceivedMapMessage.getStringProperty("TestCase").equals("msgClearBodyQueueMapTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Map properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Map properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedMapMessage.setString("yes", "new stuff !!!!!");
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            if (messageReceivedMapMessage.getString("yes").equals("new stuff !!!!!")) {
                logger.log(System.Logger.Level.TRACE, "PASS:");
            } else {
                logger.log(System.Logger.Level.TRACE, "FAIL:");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueBytesTest(BytesMessage messageReceivedBytesMessage) {
        String testCase = "msgClearBodyQueueBytesTest";
        boolean pass = true;
        byte bValue2 = 22;
        try {
            logger.log(System.Logger.Level.TRACE, "Test BytesMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedBytesMessage.readByte());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedBytesMessage.clearBody();
            logger.log(System.Logger.Level.TRACE, "Bytes message body should now be empty and in writeonly mode");
            try {
                byte b = messageReceivedBytesMessage.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageNotReadableException not thrown as expected");
                pass = false;
            }
            catch (MessageNotReadableException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotReadableException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (messageReceivedBytesMessage.getStringProperty("TestCase").equals("msgClearBodyQueueBytesTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Bytes msg properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Bytes msg properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedBytesMessage.writeByte(bValue2);
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            messageReceivedBytesMessage.reset();
            if (messageReceivedBytesMessage.readByte() == bValue2) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueStreamTest(StreamMessage messageReceivedStreamMessage) {
        String testCase = "msgClearBodyQueueStreamTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Test StreamMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedStreamMessage.readString());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedStreamMessage.clearBody();
            logger.log(System.Logger.Level.TRACE, "Stream message body should now be empty and in writeonly mode");
            try {
                String s = messageReceivedStreamMessage.readString();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageNotReadableException should have been thrown");
                pass = false;
            }
            catch (MessageNotReadableException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotReadableException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (messageReceivedStreamMessage.getStringProperty("TestCase").equals("msgClearBodyQueueStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Stream msg properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Stream msg properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedStreamMessage.writeString("new data");
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            messageReceivedStreamMessage.reset();
            if (messageReceivedStreamMessage.readString().equals("new data")) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail:");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgResetQueueTest() {
        boolean pass = true;
        int nInt = 1000;
        String testCase = "msgResetQueueTest";
        try {
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            try {
                logger.log(System.Logger.Level.TRACE, "creating a Stream message");
                messageSentStreamMessage = this.qSession.createStreamMessage();
                JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, (Properties)this.p);
                messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetQueueTest1");
                messageSentStreamMessage.writeString("Testing...");
                logger.log(System.Logger.Level.TRACE, "reset stream message -  now  should be in readonly mode");
                messageSentStreamMessage.reset();
                messageSentStreamMessage.writeString("new data");
                logger.log(System.Logger.Level.TRACE, "Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.TRACE, "creating a Byte message");
                messageSentBytesMessage = this.qSession.createBytesMessage();
                JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetQueueTest2");
                messageSentBytesMessage.writeInt(nInt);
                logger.log(System.Logger.Level.TRACE, "reset Byte message -  now  should be in readonly mode");
                messageSentBytesMessage.reset();
                messageSentBytesMessage.writeInt(nInt);
                logger.log(System.Logger.Level.TRACE, "Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void readNullCharNotValidQueueMapTestCreate() {
        try {
            MapMessage mapSent = null;
            boolean pass = true;
            mapSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)mapSent, (Properties)this.p);
            mapSent.setStringProperty("TestCase", "readNullCharNotValidQueueMapTest");
            logger.log(System.Logger.Level.TRACE, "Write a null string to the map message object with mapMessage.setString");
            mapSent.setString("WriteANull", null);
            logger.log(System.Logger.Level.TRACE, " Send the message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)mapSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void readNullCharNotValidQueueStreamTestCreate() {
        try {
            StreamMessage messageSent = null;
            boolean pass = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("TestCase", "readNullCharNotValidQueueStreamTest");
            logger.log(System.Logger.Level.TRACE, "Write a null string to the map message object with streamMessage.setString");
            messageSent.writeString(null);
            logger.log(System.Logger.Level.TRACE, " Send the message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidQueueMapTest(MapMessage mapReceived) {
        String testCase = "readNullCharNotValidQueueMapTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a null  ");
            try {
                char c = mapReceived.getChar("WriteANull");
                logger.log(System.Logger.Level.TRACE, "Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidQueueStreamTest(StreamMessage messageReceived) {
        String testCase = "readNullCharNotValidQueueStreamTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a null  ");
            try {
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            logger.log(System.Logger.Level.TRACE, "Sending response message");
            logger.log(System.Logger.Level.TRACE, "==================================Test Results from: " + testCase);
            logger.log(System.Logger.Level.TRACE, "==================================Status: " + results);
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            logger.log(System.Logger.Level.TRACE, "Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            logger.log(System.Logger.Level.TRACE, "Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesQ3  In MsgBeanMsgTest3::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesQ3  In MsgBeanMsgTest3::remove()!!");
    }
}

