/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ1;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_Q_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_MSGQ1_Test")
    private static MDB_Q_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbBytesMsgNullStreamQTest() throws Exception {
        String testCase = "bytesMsgNullStreamQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to run bytesMsgNullStreamQTest");
            hr.askMDBToRunATest(testCase);
            if (!hr.checkOnResponse(testCase)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbBytesMsgNullStreamQTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbBytesMessageQTestsFullMsg() throws Exception {
        String testCase1 = "bytesMessageQTestsFullMsgCreate";
        String testCase2 = "bytesMessageQTestsFullMsg";
        try {
            System.out.println("client - run testcase bytesMessageQTestsFullMsgCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from bytesMessageQTestsFullMsg");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: bytesMessageQTestsFullMsg failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageFullMsgQTest() throws Exception {
        String testCase1 = "mapMessageFullMsgQTestCreate";
        String testCase2 = "mapMessageFullMsgQTest";
        try {
            System.out.println("client - run testcase mapMessageFullMsgQTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageFullMsgQTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageFullMsgQTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsBoolean() throws Exception {
        String testCase1 = "mapMessageConversionQTestsBooleanCreate";
        String testCase2 = "mapMessageConversionQTestsBoolean";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsBooleanCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsBoolean");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsBoolean failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsByte() throws Exception {
        String testCase1 = "mapMessageConversionQTestsByteCreate";
        String testCase2 = "mapMessageConversionQTestsByte";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsByteCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsByte");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsByte failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsShort() throws Exception {
        String testCase1 = "mapMessageConversionQTestsShortCreate";
        String testCase2 = "mapMessageConversionQTestsShort";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsShortCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsShort");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsShort failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsChar() throws Exception {
        String testCase1 = "mapMessageConversionQTestsCharCreate";
        String testCase2 = "mapMessageConversionQTestsChar";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsCharCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsChar");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsChar failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsInt() throws Exception {
        String testCase1 = "mapMessageConversionQTestsIntCreate";
        String testCase2 = "mapMessageConversionQTestsInt";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsIntCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsInt");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsInt failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsLong() throws Exception {
        String testCase1 = "mapMessageConversionQTestsLongCreate";
        String testCase2 = "mapMessageConversionQTestsLong";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsLongCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsLong");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsLong failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsFloat() throws Exception {
        String testCase1 = "mapMessageConversionQTestsFloatCreate";
        String testCase2 = "mapMessageConversionQTestsFloat";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsFloatCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsFloat");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsFloat failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsDouble() throws Exception {
        String testCase1 = "mapMessageConversionQTestsDoubleCreate";
        String testCase2 = "mapMessageConversionQTestsDouble";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsDoubleCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsDouble");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsDouble failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsString() throws Exception {
        String testCase1 = "mapMessageConversionQTestsStringCreate";
        String testCase2 = "mapMessageConversionQTestsString";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsStringCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsString");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsString failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsBytes() throws Exception {
        String testCase1 = "mapMessageConversionQTestsBytesCreate";
        String testCase2 = "mapMessageConversionQTestsBytes";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsBytesCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsBytes");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsBytes failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionQTestsInvFormatString() throws Exception {
        String testCase1 = "mapMessageConversionQTestsInvFormatStringCreate";
        String testCase2 = "mapMessageConversionQTestsInvFormatString";
        try {
            System.out.println("client - run testcase mapMessageConversionQTestsInvFormatStringCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionQTestsInvFormatString");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionQTestsInvFormatString failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

