/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejb.sessionQtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.commonee.Tests;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejb.sessionQtests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    @EJB(name="ejb/SessionTestsQ")
    private static Tests beanRef;

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (beanRef == null) {
                throw new Exception("@EJB injection failed");
            }
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            beanRef.initLogging(this.props);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    private void flushTheQueue() throws Exception {
        JmsTool tool = null;
        try {
            tool = new JmsTool(13, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Closing default Connection");
            tool.getDefaultConnection().close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error creating JmsTool and closing Connection", (Throwable)e);
        }
        finally {
            try {
                tool.flushDestination();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error flush Destination: ", (Throwable)e);
            }
        }
    }

    @Test
    public void simpleSendReceiveQueueTest() throws Exception {
        block12: {
            String testMessage = "Just a test";
            String messageReceived = null;
            try {
                beanRef.sendTextMessage_CQ(testName, testMessage);
                messageReceived = beanRef.receiveTextMessage_CQ();
                if (messageReceived != null) {
                    if (messageReceived.equals(testMessage)) {
                        logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived + "\"");
                        logger.log(System.Logger.Level.INFO, "Received correct message");
                        break block12;
                    }
                    throw new Exception("didn't get the right message");
                }
                throw new Exception("didn't get any message");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "simpleSendReceiveQueueTest failed: ", (Throwable)e);
                throw new Exception("simpleSendReceiveQueueTest failed !", e);
            }
            finally {
                try {
                    this.flushTheQueue();
                    if (null != beanRef) {
                        beanRef.remove();
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
                }
            }
        }
    }

    @Test
    public void selectorAndBrowserTests() throws Exception {
        String testMessage = "Just a test: selectorAndBrowserTests";
        boolean pass = true;
        Object messageReceived = null;
        try {
            beanRef.sendMessageP_CQ(testName, testMessage, false);
            beanRef.sendMessagePP_CQ(testName, testMessage, true, "TEST", "test");
            int msgNum = beanRef.browseTextMessage_CQ(2, testMessage);
            logger.log(System.Logger.Level.TRACE, "Default browser found " + msgNum + " messages");
            if (!beanRef.getQueue()) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueBrowser.getQueue test failed");
                pass = false;
            }
            msgNum = beanRef.browseMessageS_CQ(1, testMessage, "TEST = 'test'");
            logger.log(System.Logger.Level.TRACE, "Selective browser find " + msgNum + " messages");
            if (!beanRef.getSelector("TEST = 'test'")) {
                logger.log(System.Logger.Level.ERROR, "Error: QueueBrowser.getMessageSelector test failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("selectorAndBrowserTests Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("selectorAndBrowserTests");
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }
}

