/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicSubscriber;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedTopicSubscriberTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.closedTopicSubscriber.ClosedTopicSubscriberTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedTopicSubscriberTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    private void createAndCloseSubscriber() throws Exception {
        this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
        this.tool.getDefaultTopicConnection().start();
        logger.log(System.Logger.Level.TRACE, "Closing topic subscriber");
        this.tool.getDefaultTopicSubscriber().close();
        logger.log(System.Logger.Level.TRACE, "Subscriber closed");
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedTopicSubscriberCloseTest() throws Exception {
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberCloseTest", e);
        }
    }

    @Test
    public void closedTopicSubscriberGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberGetMessageSelectorTest", e);
        }
    }

    @Test
    public void closedTopicSubscriberReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberReceiveTest", e);
        }
    }

    @Test
    public void closedTopicSubscriberReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberReceiveTimeoutTest", e);
        }
    }

    @Test
    public void closedTopicSubscriberReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberReceiveNoWaitTest", e);
        }
    }

    @Test
    public void closedTopicSubscriberGetNoLocalTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberGetNoLocalTest", e);
        }
    }

    @Test
    public void closedTopicSubscriberGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSubscriber();
            logger.log(System.Logger.Level.TRACE, "Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicSubscriberGetTopicTest", e);
        }
    }
}

