/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicConnection;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedTopicConnectionTestsIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedTopicConnection.ClosedTopicConnectionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedTopicConnectionTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    private void createAndCloseConnection(int type, String user, String password) throws Exception {
        if (type == 1 || type == 3) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Closing queue Connection");
            this.tool.getDefaultTopicConnection().close();
        }
        logger.log(System.Logger.Level.TRACE, "Connection closed");
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            logger.log(System.Logger.Level.TRACE, "Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.TRACE, "Cleanup: Closing Topic and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedTopicConnectionCommitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(3, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call commit with closed connection.");
            try {
                this.tool.getDefaultTopicSession().commit();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicConnectionCommitTest");
        }
    }

    @Test
    public void closedTopicConnectionRollbackTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call rollback() with closed connection.");
            try {
                this.tool.getDefaultTopicSession().rollback();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionRollbackTest", e);
        }
    }

    @Test
    public void closedTopicConnectionRecoverTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call recover() with closed connection.");
            try {
                this.tool.getDefaultTopicSession().recover();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionRecoverTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicConnection().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCloseTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getClientID");
            try {
                String foo = this.tool.getDefaultTopicConnection().getClientID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetClientIDTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetMetaDataTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getMetaData");
            try {
                ConnectionMetaData foo = this.tool.getDefaultTopicConnection().getMetaData();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetMetaDataTest", e);
        }
    }

    @Test
    public void closedTopicConnectionStartTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call start");
            try {
                this.tool.getDefaultTopicConnection().start();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionStartTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateTopicSessionTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call createTopicSession");
            try {
                TopicSession foo = this.tool.getDefaultTopicConnection().createTopicSession(true, 1);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: wrong exception was returned:", (Throwable)e);
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTopicSessionTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSessionCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call close on closed session.");
            this.tool.getDefaultTopicSession().close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedTopicConnectionSessionCloseTest");
        }
    }

    @Test
    public void closedTopicConnectionCreateTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create topic with closed Connection.");
            try {
                Topic t = this.tool.getDefaultTopicSession().createTopic("closedTopicConnectionCreateTopicTest");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTopicTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateSubscriberTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create Subscriber with closed Connection.");
            try {
                TopicSubscriber tS = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateSubscriberTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateSubscriberMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create Receiver with closed Connection.");
            try {
                TopicSubscriber tS = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "TEST = 'test'", false);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateSubscriberMsgSelectorTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreatePublisherTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create Publisher with closed Connection.");
            try {
                TopicPublisher tP = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreatePublisherTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateTempTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create TemporaryTopic with closed connection.");
            try {
                TemporaryTopic tT = this.tool.getDefaultTopicSession().createTemporaryTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTempTopicTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create message with closed connection.");
            try {
                Message m = this.tool.getDefaultTopicSession().createMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateMessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateBytesMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create BytesMessage with closed connection.");
            try {
                BytesMessage m = this.tool.getDefaultTopicSession().createBytesMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateBytesMessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateMapMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create MapMessage with closed connection.");
            try {
                MapMessage m = this.tool.getDefaultTopicSession().createMapMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateMapMessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateObjectMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create ObjectMessage with closed connection.");
            try {
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage();
                if (m != null) {
                    logger.log(System.Logger.Level.TRACE, "m=" + m);
                }
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateObjectMessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateObject2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create ObjectMessage(object) with closed connection.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    logger.log(System.Logger.Level.TRACE, "m=" + m);
                }
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateObject2MessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateStreamMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create StreamMessage with closed connection.");
            try {
                StreamMessage m = this.tool.getDefaultTopicSession().createStreamMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateStreamMessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateTextMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultTopicSession().createTextMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateTextMessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionCreateText2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultTopicSession().createTextMessage("test message");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionCreateText2MessageTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetTransactedTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getTransacted() with closed connection.");
            try {
                boolean b = this.tool.getDefaultTopicSession().getTransacted();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetTransactedTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSubscriberCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSubscriberCloseTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetMessageSelectorTest", e);
        }
    }

    @Test
    public void closedTopicConnectionReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionReceiveTest", e);
        }
    }

    @Test
    public void closedTopicConnectionReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionReceiveTimeoutTest", e);
        }
    }

    @Test
    public void closedTopicConnectionReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionReceiveNoWaitTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetNoLocalTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetNoLocalTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSubscriberGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSubscriberGetTopicTest", e);
        }
    }

    @Test
    public void closedTopicConnectionPublisherCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicPublisher().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublisherCloseTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getDeliveryMode();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageTimestamp();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getPriority");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getPriority();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetPriorityTest", e);
        }
    }

    @Test
    public void closedTopicConnectionGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultTopicPublisher().getTimeToLive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionGetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setDeliveryMode");
            try {
                this.tool.getDefaultTopicPublisher().setDeliveryMode(2);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageID");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageID(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageTimestamp(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setPriority");
            try {
                this.tool.getDefaultTopicPublisher().setPriority(4);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetPriorityTest", e);
        }
    }

    @Test
    public void closedTopicConnectionSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setTimeToLive");
            try {
                this.tool.getDefaultTopicPublisher().setTimeToLive(0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionSetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedTopicConnectionPublisherGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicPublisher().getTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublisherGetTopicTest", e);
        }
    }

    @Test
    public void closedTopicConnectionPublish1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call publish(Message)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublish1Test", e);
        }
    }

    @Test
    public void closedTopicConnectionPublish2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(1, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call publish(Message,int,int,long)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicConnectionPublish2Test", e);
        }
    }
}

