/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.txtopictests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TxTopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejbjspservlet.txtopictests.TxTopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(TxTopicTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    public static final int TOPIC = 1;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void commitAckMsgTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            TopicSession tSess = null;
            TopicPublisher tPub = null;
            TopicSubscriber tSub = null;
            String msg = "test message for commitAckMsgTest";
            String subscriptionName = "commitAckMsgTopicTestSubscription";
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            tSess = this.tool.getDefaultTopicSession();
            tPub = this.tool.getDefaultTopicPublisher();
            tSub = tSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send first message");
            mSent = tSess.createTextMessage();
            mSent.setBooleanProperty("lastMessage", false);
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "commitAckMsgTopicTest1");
            tPub.publish((Message)mSent);
            tSess.commit();
            logger.log(System.Logger.Level.TRACE, "Send second message");
            mSent.setBooleanProperty("lastMessage", true);
            tPub.publish((Message)mSent);
            tSess.commit();
            logger.log(System.Logger.Level.TRACE, "Message sent. Receive with tx session, do not acknowledge.");
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            logger.log(System.Logger.Level.TRACE, "Received message: \"" + mReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Call commit() without calling acknowledge().");
            tSess.commit();
            logger.log(System.Logger.Level.TRACE, "Close session and create new one.");
            tSess.close();
            tSess = this.tool.getDefaultTopicConnection().createTopicSession(false, 1);
            tSub = tSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Received orignal message again. Was not acknowledged by commit().");
                throw new Exception("Message not acknowledged by commit");
            }
            if (mReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Pass: received proper message");
            }
            tSub.close();
            tSess.unsubscribe(subscriptionName);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("commitAckMsgTopicTest");
        }
    }

    @Test
    public void rollbackRecoverTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            TopicSession tSess = null;
            TopicPublisher tPub = null;
            TopicSubscriber tSub = null;
            String msg = "test message for rollbackRecoverTest";
            this.tool = new JmsTool(3, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSession().close();
            tSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 1);
            tPub = tSess.createPublisher(this.tool.getDefaultTopic());
            tSub = tSess.createSubscriber(this.tool.getDefaultTopic());
            this.tool.getDefaultTopicConnection().start();
            mSent = tSess.createTextMessage();
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "rollbackRecoverTopicTest");
            tPub.publish((Message)mSent);
            tSess.commit();
            logger.log(System.Logger.Level.TRACE, "Message sent. Receive with tx session, do not acknowledge.");
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            logger.log(System.Logger.Level.TRACE, "Received message: \"" + mReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Call rollback() without acknowledging message.");
            tSess.rollback();
            logger.log(System.Logger.Level.TRACE, "Attempt to receive message again");
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getText().equals(msg)) {
                throw new Exception("Received unexpected message");
            }
            logger.log(System.Logger.Level.INFO, "Received orignal message again. Was not acknowledged.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("rollbackRecoverTopicTest");
        }
    }

    @Test
    public void redeliveredFlagTxTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage sentMsg = null;
            TextMessage recMsg = null;
            this.tool = new JmsTool(3, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "publish and receive one message");
            sentMsg = this.tool.getDefaultTopicSession().createTextMessage();
            sentMsg.setText("test message for redelivered flag");
            sentMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "redeliveredFlagTxTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)sentMsg);
            this.tool.getDefaultTopicSession().commit();
            recMsg = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (recMsg == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive expected message!");
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.TRACE, "Message received. Check redelivered flag.");
            boolean redelivered = recMsg.getJMSRedelivered();
            logger.log(System.Logger.Level.TRACE, "redelivered = " + redelivered);
            if (redelivered) {
                throw new Exception("Message redelivered flag should be false");
            }
            logger.log(System.Logger.Level.TRACE, "calling rollback()");
            this.tool.getDefaultTopicSession().rollback();
            logger.log(System.Logger.Level.TRACE, "receive message again");
            recMsg = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.tool.getDefaultTopicSession().commit();
            redelivered = recMsg.getJMSRedelivered();
            logger.log(System.Logger.Level.TRACE, "redelivered flag = " + redelivered);
            if (!redelivered) {
                throw new Exception("Message redelivered flag should be true");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Error: " + e);
            throw new Exception("redeliveredFlagTxTopicTest", e);
        }
    }

    @Test
    public void transactionRollbackOnSessionCloseReceiveTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String subscriptionName = "TxTopicTestSubscription";
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            TopicSession newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 0);
            TopicSubscriber newSubscriber = newTopicSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnSessionCloseReceiveTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            logger.log(System.Logger.Level.TRACE, "Receive message and call close()");
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.close();
            logger.log(System.Logger.Level.TRACE, "Create new session and attempt to receive message");
            newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 0);
            newSubscriber = newTopicSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.commit();
            newSubscriber.close();
            newTopicSess.unsubscribe(subscriptionName);
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.TRACE, "Pass: received message again, previous tx was rolled back");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            e.printStackTrace();
            throw new Exception("transactionRollbackOnSessionCloseReceiveTopicTest", e);
        }
    }

    @Test
    public void transactionRollbackOnPublishTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String subscriptionName = "TxTopicTestSubscription";
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            TopicSubscriber tSub = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultTopicConnection().start();
            TopicSession newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 0);
            TopicPublisher newPublisher = newTopicSess.createPublisher(this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = newTopicSess.createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            logger.log(System.Logger.Level.TRACE, "Publish the  message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnPublishTopicTest");
            newPublisher.publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newTopicSess.commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            logger.log(System.Logger.Level.TRACE, "Publish a message, but then rollback");
            newPublisher.publish((Message)messageSent);
            newTopicSess.rollback();
            logger.log(System.Logger.Level.TRACE, "Publish 3rd message");
            messageSent.setBooleanProperty("lastMessage", true);
            newPublisher.publish((Message)messageSent);
            newTopicSess.commit();
            logger.log(System.Logger.Level.TRACE, "Attempt to receive last message only");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            this.tool.getDefaultTopicSession().commit();
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.TRACE, "Pass: last msg received, proper message was rolledback");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            e.printStackTrace();
            throw new Exception("transactionRollbackOnPublishTopicTest", e);
        }
    }

    @Test
    public void transactionRollbackOnRecTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(3, this.jmsUser, this.jmsPassword, lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultTopicConnection().start();
            TopicSession newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 1);
            TopicPublisher newPublisher = newTopicSess.createPublisher(this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = newTopicSess.createTextMessage();
            messageSent.setText("transaction message test");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnRecTopicTest");
            newPublisher.publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newTopicSess.commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            this.tool.getDefaultTopicSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            logger.log(System.Logger.Level.TRACE, "Publish the message and commit it");
            newPublisher.publish((Message)messageSent);
            newTopicSess.commit();
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Rollback after getting the message");
            this.tool.getDefaultTopicSession().rollback();
            logger.log(System.Logger.Level.TRACE, "Doing a second receive - getting messageReceived2 ");
            messageReceived2 = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Since the receive was not committed, I expect the message to still be there");
            if (messageReceived2 == null) {
                throw new Exception("Fail: message was not rolled back to the topic");
            }
            if (!messageReceived.getText().equals(messageReceived2.getText())) {
                throw new Exception("Did not receive expected message after not doing the commit");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Message2 text: \"" + messageReceived2.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Pass: Message was recovered");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnRecTopicTest");
        }
    }

    @Test
    public void txRollbackOnConnectionCloseReceiveTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String subscriptionName = "TxTopicTestSubscription";
            String clientID = null;
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            clientID = this.tool.getDefaultTopicConnection().getClientID();
            this.tool.getDefaultTopicSubscriber().close();
            TopicSubscriber tSub = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txRollbackOnConnectionCloseReceiveTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            this.tool.getDefaultTopicSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            logger.log(System.Logger.Level.TRACE, "send second message");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            logger.log(System.Logger.Level.TRACE, "Receive message");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Should have received second message");
            }
            logger.log(System.Logger.Level.TRACE, "Call connection.close()");
            this.tool.getDefaultTopicConnection().close();
            logger.log(System.Logger.Level.TRACE, "Create new connection and attempt to receive message");
            TopicConnection newConn = (TopicConnection)this.tool.getNewConnection(4, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newConn);
            String newClientID = newConn.getClientID();
            if (newClientID == null || !newClientID.equals(clientID)) {
                try {
                    newConn.setClientID(clientID);
                }
                catch (JMSException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    logger.log(System.Logger.Level.INFO, "Warning: cannot set client ID to match first connection.\nTest may not be able to use same durable subscription");
                }
            }
            TopicSession newTopicSess = newConn.createTopicSession(true, 0);
            TopicSubscriber newSubscriber = newTopicSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            newConn.start();
            logger.log(System.Logger.Level.TRACE, "receive message");
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.commit();
            newSubscriber.close();
            newTopicSess.unsubscribe(subscriptionName);
            newConn.close();
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.TRACE, "Pass: received message again, previous tx was rolled back");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            e.printStackTrace();
            throw new Exception("txRollbackOnConnectionCloseReceiveTopicTest", e);
        }
    }

    @Test
    public void commitRollbackMultiMsgsTest() throws Exception {
        boolean pass = true;
        int numMessages = 3;
        try {
            int i;
            TextMessage tempMsg = null;
            this.tool = new JmsTool(16, this.jmsUser, this.jmsPassword, this.mode);
            Destination destination = this.tool.getDefaultDestination();
            Session session = this.tool.getDefaultSession();
            Connection connection = this.tool.getDefaultConnection();
            MessageProducer producer = this.tool.getDefaultProducer();
            MessageConsumer consumer = this.tool.getDefaultConsumer();
            Topic topic = (Topic)destination;
            connection.start();
            logger.log(System.Logger.Level.INFO, "Send " + numMessages + " messages to Topic and call rollback()");
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            session.rollback();
            logger.log(System.Logger.Level.INFO, "Should not consume any messages in Topic since rollback() was called");
            tempMsg = (TextMessage)consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send " + numMessages + " messages to Topic and call commit()");
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            session.commit();
            logger.log(System.Logger.Level.INFO, "Should consume all messages in Topic since commit() was called");
            for (int msgCount = 1; msgCount <= numMessages; ++msgCount) {
                tempMsg = (TextMessage)consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Topic");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("commitRollbackMultiMsgsTest");
        }
        if (!pass) {
            throw new Exception("commitRollbackMultiMsgsTest failed");
        }
    }
}

