/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topicMsgHeaders;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class TopicHeaderTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.topicMsgHeaders.TopicHeaderTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        TopicHeaderTests theTests = new TopicHeaderTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        this.logTrace("Results: " + status[index]);
        return retcode;
    }

    public void msgHdrIDTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrIDTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDToopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedObjectMsg.getJMSMessageID());
            id = messageReceivedObjectMsg.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("ObjectMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            this.logTrace("Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedMapMessage.getJMSMessageID());
            id = messageReceivedMapMessage.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("MapMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            this.logTrace("Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedBytesMessage.getJMSMessageID());
            id = messageReceivedBytesMessage.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("BytesMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            this.logTrace("sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedStreamMessage.getJMSMessageID());
            id = messageReceivedStreamMessage.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("StreamMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDTopicTest");
            this.logTrace("sending a Text message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceived.getJMSMessageID());
            id = messageReceived.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("TextMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSMessageID returned from JMSMessageID");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrIDTopicTest");
        }
    }

    public void msgHdrTimeStampTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        Object id = null;
        try {
            TextMessage messageSent = null;
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Send ObjectMessage to TOPIC.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrTimeStampTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            long timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            long timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentObjectMsg.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentObjectMsg.getJMSTimestamp() && timeAfterSend >= messageSentObjectMsg.getJMSTimestamp()) {
                this.logTrace("Object Message TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from ObjectMessage");
                pass = false;
            }
            this.logTrace("Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            messageSentMapMessage.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentMapMessage.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentMapMessage.getJMSTimestamp() && timeAfterSend >= messageSentMapMessage.getJMSTimestamp()) {
                this.logTrace("MapMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from MapMessage");
                pass = false;
            }
            this.logTrace("Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentBytesMessage.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentBytesMessage.getJMSTimestamp() && timeAfterSend >= messageSentBytesMessage.getJMSTimestamp()) {
                this.logTrace("BytesMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from BytesMessage");
                pass = false;
            }
            this.logTrace("sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentStreamMessage.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentStreamMessage.getJMSTimestamp() && timeAfterSend >= messageSentStreamMessage.getJMSTimestamp()) {
                this.logTrace("StreamMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from StreamMessage");
                pass = false;
            }
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTopicTest");
            this.logTrace("sending a Text message");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSent.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSent.getJMSTimestamp() && timeAfterSend >= messageSent.getJMSTimestamp()) {
                this.logTrace("TextMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from TextMessage");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid TimeStamp returned from JMSTimeStamp");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrTimeStampTopicTest");
        }
    }

    public void msgHdrCorlIdTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String jmsCorrelationID = "test Correlation id";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            this.logTrace("Sending Text message to Topic ");
            messageSent.setJMSCorrelationID(jmsCorrelationID);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("jmsCorrelationID:  " + messageReceived.getJMSCorrelationID());
            if (messageReceived.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("Text Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                this.logTrace("pass");
            } else {
                pass = false;
                this.logMsg("Text Message Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrCorlIdTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentObjectMsg.setJMSCorrelationID(jmsCorrelationID);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("jmsCorrelationID:  " + messageReceivedObjectMsg.getJMSCorrelationID());
            if (messageReceivedObjectMsg.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("Object Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedObjectMsg.getJMSCorrelationID().equals(jmsCorrelationID)) {
                this.logTrace("pass");
            } else {
                pass = false;
                this.logMsg("Object Message Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentMapMessage.setJMSCorrelationID(jmsCorrelationID);
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("jmsCorrelationID:  " + messageReceivedMapMessage.getJMSCorrelationID());
            if (messageReceivedMapMessage.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("Map Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedMapMessage.getJMSCorrelationID().equals(jmsCorrelationID)) {
                this.logTrace("pass");
            } else {
                pass = false;
                this.logMsg("Map Message Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentBytesMessage.setJMSCorrelationID(jmsCorrelationID);
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("jmsCorrelationID:  " + messageReceivedBytesMessage.getJMSCorrelationID());
            if (messageReceivedBytesMessage.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("Bytes Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedBytesMessage.getJMSCorrelationID().equals(jmsCorrelationID)) {
                this.logTrace("pass");
            } else {
                pass = false;
                this.logMsg("Byte Message Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrCorlIdTopicTest");
            messageSentStreamMessage.setJMSCorrelationID(jmsCorrelationID);
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("Sending Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("jmsCorrelationID:  " + messageReceivedStreamMessage.getJMSCorrelationID());
            if (messageReceivedStreamMessage.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("Stream Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceivedStreamMessage.getJMSCorrelationID().equals(jmsCorrelationID)) {
                this.logTrace("pass");
            } else {
                pass = false;
                this.logMsg("Stream Message Error: JMSCorrelationID is incorrect");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSCorrelationID returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrCorlIdTopicTest");
        }
    }

    public void msgHdrReplyToTopicTest() throws Exception {
        boolean pass = true;
        Topic replyTopic = null;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            this.logTrace("Send Text message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field should have been null for this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSent.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            replyTopic = (Topic)messageReceived.getJMSReplyTo();
            this.logTrace("Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Text Message Failed");
                pass = false;
            }
            this.logTrace("Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrReplyToTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedObjectMsg.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentObjectMsg.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            replyTopic = (Topic)messageReceivedObjectMsg.getJMSReplyTo();
            this.logTrace("Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Object Message ReplyTo Failed");
                pass = false;
            }
            this.logTrace("Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedMapMessage.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentMapMessage.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Received Map message ");
            replyTopic = (Topic)messageReceivedMapMessage.getJMSReplyTo();
            this.logTrace("Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Map Message ReplyTo Failed");
                pass = false;
            }
            this.logTrace("Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedBytesMessage.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentBytesMessage.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Received Bytes message ");
            replyTopic = (Topic)messageReceivedBytesMessage.getJMSReplyTo();
            this.logTrace("Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Bytes Message ReplyTo Failed");
                pass = false;
            }
            this.logTrace("sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("Sending Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedStreamMessage.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentStreamMessage.setJMSReplyTo((Destination)this.tool.getDefaultTopic());
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Received Stream message ");
            replyTopic = (Topic)messageReceivedStreamMessage.getJMSReplyTo();
            this.logTrace("Topic name is " + replyTopic.getTopicName());
            if (replyTopic.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Stream Message ReplyTo Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid Replyto returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrReplyToTopicTest");
        }
    }

    public void msgHdrJMSTypeTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String type = "TESTMSG";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            this.logTrace("JMSType test - Send a Text message");
            messageSent.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceived.getJMSType());
            if (messageReceived.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Text Message Failed");
                pass = false;
            }
            this.logTrace("JMSType test - Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSTypeTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentObjectMsg.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedObjectMsg.getJMSType());
            if (messageReceivedObjectMsg.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Object Message JMSType Failed");
                pass = false;
            }
            this.logTrace("JMSType test - Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentMapMessage.setString("aString", "value");
            messageSentMapMessage.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedMapMessage.getJMSType());
            if (messageReceivedMapMessage.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Map Message JMSType Failed");
                pass = false;
            }
            this.logTrace("JMSType test - Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            messageSentBytesMessage.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedBytesMessage.getJMSType());
            if (messageReceivedBytesMessage.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Bytes Message JMSType Failed");
                pass = false;
            }
            this.logTrace("JMSType test - sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            messageSentStreamMessage.setJMSType(type);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedStreamMessage.getJMSType());
            if (messageReceivedStreamMessage.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Stream Message JMSType Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSType returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSTypeTopicTest");
        }
    }

    public void msgHdrJMSPriorityTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        int priority = 2;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            this.logTrace("JMSPriority test - Send a Text message");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceived.getJMSPriority());
            if (messageReceived.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Text Message Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSPriorityTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedObjectMsg.getJMSPriority());
            if (messageReceivedObjectMsg.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Object Message JMSPriority Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedMapMessage.getJMSPriority());
            if (messageReceivedMapMessage.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Map Message JMSPriority Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedBytesMessage.getJMSPriority());
            if (messageReceivedBytesMessage.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Bytes Message JMSPriority Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.tool.getDefaultTopicPublisher().setPriority(priority);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedStreamMessage.getJMSPriority());
            if (messageReceivedStreamMessage.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Stream Message JMSPriority Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSPriority returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSPriorityTopicTest");
        }
    }

    public void msgHdrJMSExpirationTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        long forever = 0L;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            this.logMsg("JMSExpiration test (set timetoLive=0) - Send TextMessage to Topic");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("JMSExpiration is " + messageReceived.getJMSExpiration());
            if (messageReceived.getJMSExpiration() == forever) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("TextMessage JMSExpiration Failed");
                this.logMsg("TextMessage.getJMSExpiration() returned  " + messageReceived.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timetoLive=60000) - Send TextMessage to Topic");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            long currentTime = System.currentTimeMillis();
            this.logMsg("JMSExpiration is " + messageReceived.getJMSExpiration());
            long timeLeftToExpiration = messageReceived.getJMSExpiration() - currentTime;
            this.logMsg("TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("TextMessage JMSExpiration Failed");
                this.logMsg("TextMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timeToLive=0) - Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSExpirationTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("JMSExpiration is " + messageReceivedObjectMsg.getJMSExpiration());
            if (messageReceivedObjectMsg.getJMSExpiration() == forever) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("ObjectMessage JMSExpiration Failed");
                this.logMsg("ObjectMessage.getJMSExpiration() returned  " + messageReceivedObjectMsg.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timetoLive=60000) - Send ObjectMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            this.logMsg("JMSExpiration is " + messageReceivedObjectMsg.getJMSExpiration());
            timeLeftToExpiration = messageReceivedObjectMsg.getJMSExpiration() - currentTime;
            this.logMsg("TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("ObjectMessage JMSExpiration Failed");
                this.logMsg("ObjectMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timeToLive=0) - Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("JMSExpiration is " + messageReceivedMapMessage.getJMSExpiration());
            if (messageReceivedMapMessage.getJMSExpiration() == forever) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("MapMessage JMSExpiration Failed");
                this.logMsg("MapMessage.getJMSExpiration() returned  " + messageReceivedMapMessage.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timetoLive=60000) - Send MapMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            this.logMsg("JMSExpiration is " + messageReceivedMapMessage.getJMSExpiration());
            timeLeftToExpiration = messageReceivedMapMessage.getJMSExpiration() - currentTime;
            this.logMsg("TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("MapMessage JMSExpiration Failed");
                this.logMsg("MapMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timeToLive=0) - Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("JMSExpiration is " + messageReceivedBytesMessage.getJMSExpiration());
            if (messageReceivedBytesMessage.getJMSExpiration() == forever) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("BytesMessage JMSExpiration Failed");
                this.logMsg("BytesMessage.getJMSExpiration() returned  " + messageReceivedBytesMessage.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timetoLive=60000) - Send BytesMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            this.logMsg("JMSExpiration is " + messageReceivedBytesMessage.getJMSExpiration());
            timeLeftToExpiration = messageReceivedBytesMessage.getJMSExpiration() - currentTime;
            this.logMsg("TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("BytesMessage JMSExpiration Failed");
                this.logMsg("BytesMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timeToLive=0) - sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSExpirationTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.tool.getDefaultTopicPublisher().setTimeToLive(forever);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("JMSExpiration is " + messageReceivedStreamMessage.getJMSExpiration());
            if (messageReceivedStreamMessage.getJMSExpiration() == forever) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("StreamMessage JMSExpiration Failed");
                this.logMsg("StreamMessage.getJMSExpiration() returned  " + messageReceivedStreamMessage.getJMSExpiration() + ", expected 0");
                pass = false;
            }
            this.logMsg("JMSExpiration test (set timetoLive=60000) - Send StreamMessage to Topic.");
            this.tool.getDefaultTopicPublisher().setTimeToLive(60000L);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            currentTime = System.currentTimeMillis();
            this.logMsg("JMSExpiration is " + messageReceivedStreamMessage.getJMSExpiration());
            timeLeftToExpiration = messageReceivedStreamMessage.getJMSExpiration() - currentTime;
            this.logMsg("TimeLeftToExpiration is " + timeLeftToExpiration);
            if (timeLeftToExpiration <= 60000L) {
                this.logMsg("Pass ");
            } else {
                this.logMsg("StreamMessage JMSExpiration Failed");
                this.logMsg("StreamMessage JMSExpiration timeLeftToExpiration=" + timeLeftToExpiration + ", expected <=60000");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSExpiration returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSExpirationTopicTest");
        }
    }

    public void msgHdrJMSDestinationTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        Topic replyDestination = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("publishing a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            this.logTrace("publish Text Message to Topic.");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceived.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                this.logTrace("Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                this.logMsg("Text Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Text Message Failed");
                pass = false;
            }
            this.logTrace("publish ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrIDQTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedObjectMsg.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                this.logTrace("Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                this.logMsg("Object Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Object Message Failed");
                pass = false;
            }
            this.logTrace("publish MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedMapMessage.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                this.logTrace("Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                this.logMsg("Map Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Map Message Failed");
                pass = false;
            }
            this.logTrace("publish BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedBytesMessage.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                this.logTrace("Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                this.logMsg("Bytes Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Bytes Message Failed");
                pass = false;
            }
            this.logTrace("publishing a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("publishing Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedStreamMessage.getJMSDestination());
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                this.logTrace("Topic name is " + replyDestination.getTopicName());
            }
            if (replyDestination == null) {
                pass = false;
                this.logMsg("Stream Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("Stream Message Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDestination returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDestinationTopicTest");
        }
    }

    public void msgHdrJMSDeliveryModeTopicTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("default delivery mode is 2");
            this.logMsg("persistent is: 2");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("publishing a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            this.logTrace("publish Text Message to Topic.");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("Text Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                this.logTrace("Text Message Pass ");
            }
            this.logTrace("publish ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"Test for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("Object Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                this.logTrace("Object Message Pass ");
            }
            this.logTrace("publish MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("Map Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                this.logTrace("Map Message Pass ");
            }
            this.logTrace("publish BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("Bytes Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                this.logTrace("Bytes Message Pass ");
            }
            this.logTrace("publishing a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("publishing Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("Stream Message Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                this.logTrace("Stream Message Pass ");
            }
            this.tool.getDefaultTopicPublisher().setDeliveryMode(1);
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("publishing a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            this.logTrace("publish Text Message to Topic.");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logMsg("Text Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                this.logTrace("Text Message Pass ");
            }
            this.logTrace("publish ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrJMSDeliveryModeTopicTest for Object Message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedObjectMsg != null) {
                this.logTrace("messageReceivedObjectMsg=" + messageReceivedObjectMsg);
            }
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logMsg("Object Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                this.logTrace("Object Message Pass ");
            }
            this.logTrace("publish MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentMapMessage.setString("aString", "value");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedMapMessage != null) {
                this.logTrace("messageReceivedMapMessage=" + messageReceivedMapMessage);
            }
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logMsg("Map Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                this.logTrace("Map Message Pass ");
            }
            this.logTrace("publish BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedBytesMessage != null) {
                this.logTrace("messageReceivedBytesMessage=" + messageReceivedBytesMessage);
            }
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logMsg("Bytes Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                this.logTrace("Bytes Message Pass ");
            }
            this.logTrace("publishing a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryModeTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("publishing Stream message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceivedStreamMessage != null) {
                this.logTrace("messageReceivedStreamMessage=" + messageReceivedStreamMessage);
            }
            this.logTrace("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logMsg("Stream Message Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            } else {
                this.logTrace("Stream Message Pass ");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDeliveryModeTopicTest");
        }
    }
}

