/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.orderby;

import ee.jakarta.tck.persistence.core.annotations.orderby.ZipCode;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import java.io.Serializable;

@Embeddable
public class Address
implements Serializable {
    protected String street;
    protected String city;
    protected String state;
    protected ZipCode zipcode;

    public Address() {
    }

    public Address(String street, String city, String state) {
        this.street = street;
        this.city = city;
        this.state = state;
    }

    public Address(String street, String city, String state, ZipCode zip) {
        this.street = street;
        this.city = city;
        this.state = state;
        this.zipcode = zip;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Embedded
    public ZipCode getZipCode() {
        return this.zipcode;
    }

    public void setZipCode(ZipCode zipcode) {
        this.zipcode = zipcode;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof Address)) {
            return result;
        }
        Address other = (Address)o;
        if (this.getStreet().equals(other.getStreet()) && this.getCity().equals(other.getCity()) && this.getState().equals(other.getState()) && this.getZipCode().getZip().equals(other.getZipCode().getZip())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int myHash = this.getStreet().hashCode() + this.getCity().hashCode() + this.getState().hashCode() + this.getZipCode().getZip().hashCode();
        return myHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("street: " + this.getStreet());
        result.append(", city: " + this.getCity());
        result.append(", state: " + this.getState());
        result.append(", zip: " + this.getZipCode().getZip());
        result.append("]");
        return result.toString();
    }
}

