/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle;

import com.sun.ts.tests.common.vehicle.EmptyVehicleRunner;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.appmanaged.AppManagedVehicleRunner;
import com.sun.ts.tests.common.vehicle.appmanagedNoTx.AppManagedNoTxVehicleRunner;
import com.sun.ts.tests.common.vehicle.connectorservlet.ConnectorServletVehicleRunner;
import com.sun.ts.tests.common.vehicle.customvehicle.CustomVehicleRunner;
import com.sun.ts.tests.common.vehicle.ejb.EJBVehicleRunner;
import com.sun.ts.tests.common.vehicle.ejblitejsf.EJBLiteJSFVehicleRunner;
import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteSecuredWebVehicleRunner;
import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteWebVehicleRunner;
import com.sun.ts.tests.common.vehicle.jsp.JSPVehicleRunner;
import com.sun.ts.tests.common.vehicle.pmservlet.PMServletVehicleRunner;
import com.sun.ts.tests.common.vehicle.puservlet.PUServletVehicleRunner;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicleRunner;
import com.sun.ts.tests.common.vehicle.stateful3.Stateful3VehicleRunner;
import com.sun.ts.tests.common.vehicle.stateless3.Stateless3VehicleRunner;
import com.sun.ts.tests.common.vehicle.wsejb.WSEJBVehicleRunner;
import com.sun.ts.tests.common.vehicle.wsservlet.WSServletVehicleRunner;

public final class VehicleRunnerFactory {
    private static final System.Logger logger = System.getLogger(VehicleRunnerFactory.class.getName());
    private static VehicleRunnable ejbRunner;
    private static VehicleRunnable servletRunner;
    private static VehicleRunnable jspRunner;
    private static VehicleRunnable ejbLiteJsfRunner;
    private static VehicleRunnable ejbLiteJspRunner;
    private static VehicleRunnable ejbLiteSecuredJspRunner;
    private static VehicleRunnable emptyRunner;
    private static VehicleRunnable stateless3Runner;
    private static VehicleRunnable stateful3Runner;
    private static VehicleRunnable appmanagedRunner;
    private static VehicleRunnable appmanagedNoTxRunner;
    private static VehicleRunnable wsejbRunner;
    private static VehicleRunnable wsservletRunner;
    private static VehicleRunnable pmservletRunner;
    private static VehicleRunnable puservletRunner;
    private static VehicleRunnable connectorServletRunner;
    private static VehicleRunnable customVehicleRunner;
    private static VehicleRunnable webRunner;

    private VehicleRunnerFactory() {
    }

    private static VehicleRunnable getEJBRunner() {
        if (ejbRunner == null) {
            try {
                ejbRunner = (VehicleRunnable)EJBVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ejbRunner;
    }

    private static VehicleRunnable getServletRunner() {
        if (servletRunner == null) {
            try {
                servletRunner = (VehicleRunnable)ServletVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return servletRunner;
    }

    private static VehicleRunnable getJSPRunner() {
        if (jspRunner == null) {
            try {
                jspRunner = (VehicleRunnable)JSPVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return jspRunner;
    }

    private static VehicleRunnable getEJBLiteJSFRunner() {
        if (ejbLiteJsfRunner == null) {
            try {
                ejbLiteJsfRunner = (VehicleRunnable)EJBLiteJSFVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ejbLiteJsfRunner;
    }

    private static VehicleRunnable getEJBLiteWebRunner() {
        if (ejbLiteJspRunner == null) {
            try {
                ejbLiteJspRunner = (VehicleRunnable)EJBLiteWebVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ejbLiteJspRunner;
    }

    private static VehicleRunnable getEJBLiteSecuredWebRunner() {
        if (ejbLiteSecuredJspRunner == null) {
            try {
                ejbLiteSecuredJspRunner = (VehicleRunnable)EJBLiteSecuredWebVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ejbLiteSecuredJspRunner;
    }

    private static VehicleRunnable getWebRunner() {
        if (webRunner == null) {
            try {
                webRunner = (VehicleRunnable)EJBLiteSecuredWebVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return webRunner;
    }

    private static VehicleRunnable getEmptyRunner() {
        if (emptyRunner == null) {
            try {
                emptyRunner = (VehicleRunnable)EmptyVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return emptyRunner;
    }

    private static VehicleRunnable getStateless3Runner() {
        if (stateless3Runner == null) {
            try {
                stateless3Runner = (VehicleRunnable)Stateless3VehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return stateless3Runner;
    }

    private static VehicleRunnable getStateful3Runner() {
        if (stateful3Runner == null) {
            try {
                stateful3Runner = (VehicleRunnable)Stateful3VehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return stateful3Runner;
    }

    private static VehicleRunnable getAppManagedRunner() {
        if (appmanagedRunner == null) {
            try {
                appmanagedRunner = (VehicleRunnable)AppManagedVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return appmanagedRunner;
    }

    private static VehicleRunnable getAppManagedNoTxRunner() {
        if (appmanagedNoTxRunner == null) {
            try {
                appmanagedNoTxRunner = (VehicleRunnable)AppManagedNoTxVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return appmanagedNoTxRunner;
    }

    private static VehicleRunnable getWSEJBRunner() {
        if (wsejbRunner == null) {
            try {
                wsejbRunner = (VehicleRunnable)WSEJBVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return wsejbRunner;
    }

    private static VehicleRunnable getWSServletRunner() {
        if (wsservletRunner == null) {
            try {
                wsservletRunner = (VehicleRunnable)WSServletVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return wsservletRunner;
    }

    private static VehicleRunnable getPMServletRunner() {
        if (pmservletRunner == null) {
            try {
                pmservletRunner = (VehicleRunnable)PMServletVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return pmservletRunner;
    }

    private static VehicleRunnable getPUServletRunner() {
        if (puservletRunner == null) {
            try {
                puservletRunner = (VehicleRunnable)PUServletVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return puservletRunner;
    }

    private static VehicleRunnable getConnectorServletRunner() {
        if (connectorServletRunner == null) {
            try {
                connectorServletRunner = (VehicleRunnable)ConnectorServletVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return connectorServletRunner;
    }

    private static VehicleRunnable getCustomVehicleRunner() {
        if (customVehicleRunner == null) {
            try {
                customVehicleRunner = (VehicleRunnable)CustomVehicleRunner.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return customVehicleRunner;
    }

    public static VehicleRunnable getVehicleRunner(String vtype) {
        if (vtype.equalsIgnoreCase("ejb")) {
            return VehicleRunnerFactory.getEJBRunner();
        }
        if (vtype.equalsIgnoreCase("servlet")) {
            return VehicleRunnerFactory.getServletRunner();
        }
        if (vtype.equalsIgnoreCase("jsp")) {
            return VehicleRunnerFactory.getJSPRunner();
        }
        if (vtype.equalsIgnoreCase("web")) {
            return VehicleRunnerFactory.getWebRunner();
        }
        if (vtype.equalsIgnoreCase("stateless3")) {
            return VehicleRunnerFactory.getStateless3Runner();
        }
        if (vtype.equalsIgnoreCase("stateful3")) {
            return VehicleRunnerFactory.getStateful3Runner();
        }
        if (vtype.equalsIgnoreCase("appmanaged")) {
            return VehicleRunnerFactory.getAppManagedRunner();
        }
        if (vtype.equalsIgnoreCase("appmanagedNoTx")) {
            return VehicleRunnerFactory.getAppManagedNoTxRunner();
        }
        if (vtype.equalsIgnoreCase("wsejb")) {
            return VehicleRunnerFactory.getWSEJBRunner();
        }
        if (vtype.equalsIgnoreCase("wsservlet")) {
            return VehicleRunnerFactory.getWSServletRunner();
        }
        if (vtype.equalsIgnoreCase("pmservlet")) {
            return VehicleRunnerFactory.getPMServletRunner();
        }
        if (vtype.equalsIgnoreCase("puservlet")) {
            return VehicleRunnerFactory.getPUServletRunner();
        }
        if (vtype.equalsIgnoreCase("connectorservlet")) {
            return VehicleRunnerFactory.getConnectorServletRunner();
        }
        if (vtype.equalsIgnoreCase("customvehicle")) {
            return VehicleRunnerFactory.getCustomVehicleRunner();
        }
        if (vtype.equalsIgnoreCase("ejblitejsf")) {
            return VehicleRunnerFactory.getEJBLiteJSFRunner();
        }
        if (vtype.equalsIgnoreCase("ejblitejsp") || vtype.equalsIgnoreCase("ejbliteservlet") || vtype.equalsIgnoreCase("ejbliteservlet2") || vtype.equalsIgnoreCase("ejbliteservletcal")) {
            return VehicleRunnerFactory.getEJBLiteWebRunner();
        }
        if (vtype.equalsIgnoreCase("ejblitesecuredjsp")) {
            return VehicleRunnerFactory.getEJBLiteSecuredWebRunner();
        }
        if (!(vtype.equalsIgnoreCase("appclient") || vtype.equalsIgnoreCase("wsappclient") || vtype.equalsIgnoreCase("standalone"))) {
            logger.log(System.Logger.Level.WARNING, "Invalid vehicle {" + vtype + "}. Will run test directly.");
        }
        return VehicleRunnerFactory.getEmptyRunner();
    }
}

