/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet18;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient18
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet18";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private ResultSet oRes = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient18 theTests = new resultSetClient18();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt04() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            int oExtVal = Integer.parseInt(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getInt returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the Maximum Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt05() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.setMsg("get the Minimum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            int oExtVal = Integer.parseInt(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getInt returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the Minimum Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetInt06() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(NullValue)");
            this.msg.setMsg("get the Null value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getInt method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the value zero", "test getInt Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt07() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.setMsg("get the Maximum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            int oExtVal = Integer.parseInt(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getInt returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the Maximum Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt08() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.setMsg("get the Minimum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            int oExtVal = Integer.parseInt(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getInt returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the Minimum Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetInt09() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(NullValue)");
            this.msg.setMsg("get the Null value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getInt method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the value zero", "test getInt Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt10() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Real_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            int intVal = 1000;
            float oSuppVal = new Integer(intVal).floatValue();
            this.pstmt.setFloat(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt");
            this.msg.setMsg("get the value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.addOutputMsg("" + intVal, "" + oRetVal);
            if ((float)oRetVal == (float)intVal) {
                this.msg.setMsg("getInt returns the desired Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the desired Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetInt12() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(NullValue)");
            this.msg.setMsg("get the Null value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getInt method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the value zero", "test getInt Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt16() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Float_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            double oSuppVal = Double.parseDouble(sSuppVal);
            this.pstmt.setDouble(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.setMsg("get the Maximum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            int oExtVal = Integer.parseInt(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getInt returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the Maximum Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInt17() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Float_Tab_Min_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            double oSuppVal = Double.parseDouble(sSuppVal);
            this.pstmt.setDouble(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            int oExtVal = Integer.parseInt(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getInt returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the Minimum Value", "test getInt Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetInt18() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getInt(NullValue)");
            this.msg.setMsg("get the Null value from the table using getInt Method");
            int oRetVal = this.oRes.getInt(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getInt method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getInt did not return the value zero", "test getInt Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getInt is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

