/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt14;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient14
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt14";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private CallableStatement cstmt = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        callStmtClient14 theTests = new callStmtClient14();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbmd = this.conn.getMetaData();
                this.stmt = this.conn.createStatement();
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject121() throws Exception {
        Double maxFloatVal = null;
        Integer maxIntegerVal = null;
        Double rFloatVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Float to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            maxFloatVal = new Double(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 6);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Float_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rFloatVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(maxFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject122() throws Exception {
        Double minFloatVal = null;
        Integer minIntegerVal = null;
        Double rFloatVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Float to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            minFloatVal = new Double(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 6);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(minFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject123() throws Exception {
        Double maxDoubleVal = null;
        Integer maxIntegerVal = null;
        Double rDoubleVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Double to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            maxDoubleVal = new Double(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 8);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Double_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(maxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject124() throws Exception {
        Double minDoubleVal = null;
        Integer minIntegerVal = null;
        Double rDoubleVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Double to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            minDoubleVal = new Double(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 8);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(minDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject125() throws Exception {
        BigDecimal maxDecimalVal = null;
        BigDecimal rDecimalVal = null;
        Integer maxIntegerVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Decimal to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            maxDecimalVal = new BigDecimal(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 3, 15);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(maxDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject126() throws Exception {
        BigDecimal minDecimalVal = null;
        BigDecimal rDecimalVal = null;
        Integer minIntegerVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Max(?)}");
            this.msg.setMsg("extract the Minimum Value of Decimal to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minDecimalVal = new BigDecimal(sminStringVal);
            minIntegerVal = new Integer(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 3, 15);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Max", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(minDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject127() throws Exception {
        BigDecimal maxNumericVal = null;
        BigDecimal rNumericVal = null;
        Integer maxIntegerVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Numeric to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxNumericVal = new BigDecimal(smaxStringVal);
            maxIntegerVal = new Integer(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 2, 15);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxNumericVal, "" + rNumericVal);
            if (rNumericVal.compareTo(maxNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject128() throws Exception {
        BigDecimal minNumericVal = null;
        BigDecimal rNumericVal = null;
        Integer minIntegerVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Max(?)}");
            this.msg.setMsg("extract the Minimum Value of Numeric to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minNumericVal = new BigDecimal(sminStringVal);
            minIntegerVal = new Integer(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 2, 15);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Max", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minNumericVal, "" + rNumericVal);
            if (rNumericVal.compareTo(minNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject131() throws Exception {
        String maxStringVal = null;
        String rStringVal = null;
        Integer maxIntegerVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Integer, to be Updated for NULL value of Char Table");
            maxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.trim();
            maxIntegerVal = new Integer(maxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject132() throws Exception {
        String maxStringVal = null;
        String rStringVal = null;
        Integer maxIntegerVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Integer, to be Updated for NULL value of Char Table");
            maxStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            maxStringVal = maxStringVal.trim();
            maxIntegerVal = new Integer(maxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject133() throws Exception {
        Integer maxIntegerVal = null;
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Integer, to be Updated for NULL value of Varchar Table");
            maxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.trim();
            maxIntegerVal = new Integer(maxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 12);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject134() throws Exception {
        Integer maxIntegerVal = null;
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Integer, to be Updated for NULL value of Varchar Table");
            maxStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            maxStringVal = maxStringVal.trim();
            maxIntegerVal = new Integer(maxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 12);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject135() throws Exception {
        String maxStringVal = null;
        Integer maxIntegerVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Integer, to be Updated for NULL value of Longvarchar Table");
            maxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.trim();
            maxIntegerVal = new Integer(maxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, -1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject136() throws Exception {
        String maxStringVal = null;
        Integer maxIntegerVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Integer, to be Updated for NULL value of Longvarchar Table");
            maxStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            maxStringVal = maxStringVal.trim();
            maxIntegerVal = new Integer(maxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, -1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject137() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_In_Min(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            Integer maxIntegerVal = new Integer(smaxStringVal);
            Long maxLongVal = new Long(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxLongVal, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Tinyint_Query_Min", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            Object oIntegerVal = this.rs.getObject(1);
            Integer rIntegerVal = new Integer(oIntegerVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.compareTo(maxIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value", "test setObject failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject138() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            Integer minIntegerVal = new Integer(sminStringVal);
            Long minLongVal = new Long(sminStringVal);
            this.cstmt.setObject(1, (Object)minLongVal, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oIntegerVal = this.rs.getObject(1);
            Integer rIntegerVal = new Integer(oIntegerVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.compareTo(minIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value ", "test setObject failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject139() throws Exception {
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_In_Min(?)}");
            this.msg.setMsg("extract the Minimum Value to be Updated");
            smaxStringVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            Integer maxIntegerVal = new Integer(smaxStringVal);
            Long maxLongVal = new Long(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxLongVal, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            Object oIntegerVal = this.rs.getObject(1);
            Integer rIntegerVal = new Integer(oIntegerVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.compareTo(maxIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value ", "test setObject failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject140() throws Exception {
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value to be Updated");
            sminStringVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            Integer minIntegerVal = new Integer(sminStringVal);
            Long minLongVal = new Long(sminStringVal);
            this.cstmt.setObject(1, (Object)minLongVal, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oIntegerVal = this.rs.getObject(1);
            Integer rIntegerVal = new Integer(oIntegerVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.compareTo(minIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter value ");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter value ", "test setObject failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

