/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.schema30;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.common.schema30.Address;
import ee.jakarta.tck.persistence.common.schema30.Address_;
import ee.jakarta.tck.persistence.common.schema30.Alias;
import ee.jakarta.tck.persistence.common.schema30.Alias_;
import ee.jakarta.tck.persistence.common.schema30.Country;
import ee.jakarta.tck.persistence.common.schema30.Country_;
import ee.jakarta.tck.persistence.common.schema30.CreditCard;
import ee.jakarta.tck.persistence.common.schema30.CreditCard_;
import ee.jakarta.tck.persistence.common.schema30.CriteriaEntity;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Department;
import ee.jakarta.tck.persistence.common.schema30.Department_;
import ee.jakarta.tck.persistence.common.schema30.Employee;
import ee.jakarta.tck.persistence.common.schema30.Employee_;
import ee.jakarta.tck.persistence.common.schema30.HardwareProduct;
import ee.jakarta.tck.persistence.common.schema30.HardwareProduct_;
import ee.jakarta.tck.persistence.common.schema30.Info;
import ee.jakarta.tck.persistence.common.schema30.Info_;
import ee.jakarta.tck.persistence.common.schema30.LineItem;
import ee.jakarta.tck.persistence.common.schema30.LineItemException;
import ee.jakarta.tck.persistence.common.schema30.LineItem_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Order_;
import ee.jakarta.tck.persistence.common.schema30.Phone;
import ee.jakarta.tck.persistence.common.schema30.Phone_;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.Product_;
import ee.jakarta.tck.persistence.common.schema30.ShelfLife;
import ee.jakarta.tck.persistence.common.schema30.ShelfLife_;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct_;
import ee.jakarta.tck.persistence.common.schema30.Spouse;
import ee.jakarta.tck.persistence.common.schema30.Spouse_;
import ee.jakarta.tck.persistence.common.schema30.Trim;
import ee.jakarta.tck.persistence.common.schema30.Trim_;
import java.io.Serializable;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;

public abstract class Util
extends PMClientBase {
    protected final Phone[] phone = new Phone[50];
    protected final Address[] address = new Address[50];
    protected final Country[] country = new Country[20];
    protected final CreditCard[] creditCard = new CreditCard[24];
    protected final LineItem[] lineItem = new LineItem[60];
    protected final Spouse[] spouse = new Spouse[6];
    protected final Info[] info = new Info[6];
    protected final Customer[] customerRef = new Customer[20];
    protected final Order[] orderRef = new Order[20];
    protected final Alias[] aliasRef = new Alias[30];
    protected final Product[] productRef = new Product[18];
    protected final HardwareProduct[] hardwareRef = new HardwareProduct[10];
    protected final SoftwareProduct[] softwareRef = new SoftwareProduct[10];
    protected final ShelfLife[] shelfRef = new ShelfLife[20];
    protected final Department[] deptRef = new Department[5];
    protected final Employee[] empRef = new Employee[10];
    protected final Trim[] trimRef = new Trim[20];
    private static final Class[] schema30classes = new Class[]{Address_.class, Address.class, Alias_.class, Alias.class, Country_.class, Country.class, CreditCard_.class, CreditCard.class, CriteriaEntity.class, Customer_.class, Customer.class, Department_.class, Department.class, Employee_.class, Employee.class, HardwareProduct_.class, HardwareProduct.class, Info_.class, Info.class, LineItem_.class, LineItem.class, LineItemException.class, Order_.class, Order.class, Phone_.class, Phone.class, Product_.class, Product.class, ShelfLife_.class, ShelfLife.class, SoftwareProduct_.class, SoftwareProduct.class, Spouse_.class, Spouse.class, Trim_.class, Trim.class};

    public static Class[] getSchema30classes() {
        return schema30classes;
    }

    public static String[] concat(String[] first, String[] second) {
        String[] both = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, both, first.length, second.length);
        return both;
    }

    public String toString(Collection c) {
        StringBuilder result = new StringBuilder();
        if (c != null) {
            result.append(Arrays.toString(c.toArray()));
        } else {
            result.append("null");
        }
        return result.toString();
    }

    @Override
    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void createTrimData() throws Exception {
        this.logTrace("createTrimData");
        this.getEntityTransaction().begin();
        try {
            this.trimRef[0] = new Trim("1", "Alan E. Frechette");
            this.trimRef[1] = new Trim("2", "Arthur D. Frechette");
            this.trimRef[2] = new Trim("3", "Shelly D. McGowan");
            this.trimRef[3] = new Trim("4", "Robert E. Bissett");
            this.trimRef[4] = new Trim("5", "Stephen S. D'Milla");
            this.trimRef[5] = new Trim("6", "Karen R. Tegan");
            this.trimRef[6] = new Trim("7", "Stephen J. Caruso");
            this.trimRef[7] = new Trim("8", "Irene M. Caruso");
            this.trimRef[8] = new Trim("9", "William P. Keaton");
            this.trimRef[9] = new Trim("10", "Kate P. Hudson");
            this.trimRef[10] = new Trim("11", "Jonathan K. Smith");
            this.trimRef[11] = new Trim("12", "Douglas A. Donahue");
            this.trimRef[12] = new Trim("13", "Kellie A. Sanborn");
            this.trimRef[13] = new Trim("14", "Margaret Mills");
            this.trimRef[14] = new Trim("15", "Sonya C. Sanders");
            this.trimRef[15] = new Trim("16", "Jack B. Grace");
            this.trimRef[16] = new Trim("17", "Ron F. Bender");
            this.trimRef[17] = new Trim("18", "Lisa M. Presley");
            this.trimRef[18] = new Trim("19", " David R. Vincent ");
            for (Trim t : this.trimRef) {
                if (t == null) continue;
                this.getEntityManager().persist((Object)t);
                this.logTrace("persisted trim " + t);
                this.doFlush();
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createTrimData failed:", e);
        }
    }

    public void createProductData() throws Exception {
        this.logTrace("createProductData");
        this.getEntityTransaction().begin();
        try {
            this.productRef[0] = new Product("1", "Java 2 Unleashed Programming", 54.95, 100, 987654321L);
            this.productRef[0].setWareHouse("WH1");
            this.productRef[1] = new Product("2", "Java 2 Network Programming", 37.95, 100, 876543219L);
            this.productRef[1].setWareHouse("WH1");
            this.productRef[2] = new Product("3", "CORBA Programming", 44.95, 55, 765432198L);
            this.productRef[2].setWareHouse("WH1");
            this.productRef[3] = new Product("4", "WEB Programming with JSP's & Servlet's", 33.95, 25, 654321987L);
            this.productRef[3].setWareHouse("WH1");
            this.productRef[4] = new Product("5", "Dell Laptop PC", 1095.95, 50, 543219876L);
            this.productRef[4].setWareHouse("WH2");
            this.productRef[5] = new Product("6", "Compaq Laptop PC", 995.95, 33, 432198765L);
            this.productRef[5].setWareHouse("WH2");
            this.productRef[6] = new Product("7", "Toshiba Laptop PC", 1210.95, 22, 321987654L);
            this.productRef[6].setWareHouse("WH2");
            this.productRef[7] = new Product("8", "Gateway Laptop PC", 1100.95, 11, 219876543L);
            this.productRef[7].setWareHouse("WH2");
            this.productRef[8] = new Product("9", "Free Samples", 0.0, 10, 0L);
            this.productRef[8].setWareHouse("WH3");
            this.productRef[9] = new Product("10", "Designing Enterprise Applications", 39.95, 500, 123456789L);
            this.productRef[9].setWareHouse("WH3");
            this.productRef[10] = new Product("11", "Complete Guide to XML", 38.85, 300, 234567891L);
            this.productRef[10].setWareHouse("WH3");
            this.productRef[11] = new Product("12", "Programming for Dummies", 24.95, 45, 345678912L);
            this.productRef[11].setWareHouse("WH3");
            this.productRef[12] = new Product("13", "Introduction to Java", 60.95, 95, 456789123L);
            this.productRef[12].setWareHouse("WH3");
            this.productRef[13] = new Product("14", "Ultra System", 5095.95, 250, 567891234L);
            this.productRef[13].setWareHouse("WH4");
            this.productRef[14] = new Product("15", "Very Best Tutorial", 25.99, 0, 678912345L);
            this.productRef[14].setWareHouse("WH4");
            this.productRef[15] = new Product("16", "Home Grown Programming Examples", 10.95, 25, 789123456L);
            this.productRef[15].setWareHouse("WH4");
            this.productRef[16] = new Product("17", "Programming in ANSI C", 23.95, 10, 891234567L);
            this.productRef[16].setWareHouse("WH4");
            this.productRef[17] = new Product("18", "Trial Software", 10.0, 75, 912345678L);
            this.productRef[17].setWareHouse("WH5");
            for (Product p : this.productRef) {
                if (p == null) continue;
                this.getEntityManager().persist((Object)p);
                this.logTrace("persisting product " + p);
                this.doFlush();
            }
            Date d1 = this.getSQLDate("2000-02-14");
            Date d2 = this.getSQLDate("2001-06-27");
            Date d3 = this.getSQLDate("2002-07-07");
            Date d4 = this.getSQLDate("2003-03-03");
            Date d5 = this.getSQLDate("2004-04-10");
            Date d6 = this.getSQLDate("2005-02-18");
            Date d7 = this.getSQLDate("2000-09-17");
            Date d8 = this.getSQLDate("2001-11-14");
            Date d9 = this.getSQLDate("2002-10-04");
            Date d10 = this.getSQLDate("2003-01-25");
            this.logTrace("create ShelfLife Data");
            this.shelfRef[0] = new ShelfLife(d1, null);
            this.shelfRef[1] = new ShelfLife(d2, null);
            this.shelfRef[2] = new ShelfLife(d3, null);
            this.shelfRef[3] = new ShelfLife(d4, null);
            this.shelfRef[4] = new ShelfLife(d5, null);
            this.shelfRef[5] = new ShelfLife(null, null);
            this.shelfRef[6] = new ShelfLife(null, d6);
            this.shelfRef[7] = new ShelfLife(null, d7);
            this.shelfRef[8] = new ShelfLife(d8, d9);
            this.shelfRef[9] = new ShelfLife(null, d10);
            this.logTrace("create Hardware Data");
            this.hardwareRef[0] = new HardwareProduct();
            this.hardwareRef[0].setId("19");
            this.hardwareRef[0].setName("Gateway E Series");
            this.hardwareRef[0].setPrice(600.0);
            this.hardwareRef[0].setQuantity(25);
            this.hardwareRef[0].setPartNumber(238945678L);
            this.hardwareRef[0].setShelfLife(this.shelfRef[0]);
            this.hardwareRef[0].setWareHouse("Columbia");
            this.hardwareRef[0].setModelNumber(2578);
            this.getEntityManager().persist((Object)this.hardwareRef[0]);
            this.hardwareRef[1] = new HardwareProduct();
            this.hardwareRef[1].setId("20");
            this.hardwareRef[1].setName("Java Desktop Systems");
            this.hardwareRef[1].setPrice(890.0);
            this.hardwareRef[1].setQuantity(50);
            this.hardwareRef[1].setPartNumber(304506708L);
            this.hardwareRef[1].setModelNumber(10050);
            this.hardwareRef[1].setWareHouse("Lowell");
            this.getEntityManager().persist((Object)this.hardwareRef[1]);
            this.hardwareRef[2] = new HardwareProduct();
            this.hardwareRef[2].setId("21");
            this.hardwareRef[2].setName("Dell Inspiron");
            this.hardwareRef[2].setPrice(1100.0);
            this.hardwareRef[2].setQuantity(5);
            this.hardwareRef[2].setPartNumber(373767373L);
            this.hardwareRef[2].setModelNumber(576);
            this.hardwareRef[2].setWareHouse("Richmond");
            this.hardwareRef[2].setShelfLife(this.shelfRef[1]);
            this.getEntityManager().persist((Object)this.hardwareRef[2]);
            this.hardwareRef[3] = new HardwareProduct();
            this.hardwareRef[3].setId("22");
            this.hardwareRef[3].setName("Toshiba");
            this.hardwareRef[3].setPrice(250.0);
            this.hardwareRef[3].setQuantity(40);
            this.hardwareRef[3].setPartNumber(285764839L);
            this.hardwareRef[3].setModelNumber(464);
            this.hardwareRef[3].setWareHouse("Richmond");
            this.getEntityManager().persist((Object)this.hardwareRef[3]);
            this.hardwareRef[4] = new HardwareProduct();
            this.hardwareRef[4].setId("23");
            this.hardwareRef[4].setName("SunBlade");
            this.hardwareRef[4].setPrice(450.0);
            this.hardwareRef[4].setQuantity(80);
            this.hardwareRef[4].setPartNumber(987290102L);
            this.hardwareRef[4].setModelNumber(104);
            this.getEntityManager().persist((Object)this.hardwareRef[4]);
            this.hardwareRef[5] = new HardwareProduct();
            this.hardwareRef[5].setId("24");
            this.hardwareRef[5].setName("Opteron");
            this.hardwareRef[5].setPrice(800.0);
            this.hardwareRef[5].setQuantity(33);
            this.hardwareRef[5].setPartNumber(725109484L);
            this.hardwareRef[5].setModelNumber(40);
            this.hardwareRef[5].setWareHouse("Lowell");
            this.hardwareRef[5].setShelfLife(this.shelfRef[2]);
            this.getEntityManager().persist((Object)this.hardwareRef[5]);
            this.hardwareRef[6] = new HardwareProduct();
            this.hardwareRef[6].setId("25");
            this.hardwareRef[6].setName("Sun Enterprise");
            this.hardwareRef[6].setPrice(15000.0);
            this.hardwareRef[6].setQuantity(100);
            this.hardwareRef[6].setPartNumber(773620626L);
            this.hardwareRef[6].setModelNumber(10000);
            this.getEntityManager().persist((Object)this.hardwareRef[6]);
            this.hardwareRef[7] = new HardwareProduct();
            this.hardwareRef[7].setId("26");
            this.hardwareRef[7].setName("Dell Dimension");
            this.hardwareRef[7].setPrice(950.0);
            this.hardwareRef[7].setQuantity(70);
            this.hardwareRef[7].setPartNumber(927262628L);
            this.hardwareRef[7].setModelNumber(3000);
            this.getEntityManager().persist((Object)this.hardwareRef[7]);
            this.hardwareRef[8] = new HardwareProduct();
            this.hardwareRef[8].setId("27");
            this.hardwareRef[8].setName("Dell Dimension");
            this.hardwareRef[8].setPrice(795.0);
            this.hardwareRef[8].setQuantity(20);
            this.hardwareRef[8].setPartNumber(482726166L);
            this.hardwareRef[8].setModelNumber(2368);
            this.hardwareRef[8].setShelfLife(this.shelfRef[3]);
            this.hardwareRef[8].setWareHouse("Columbia");
            this.getEntityManager().persist((Object)this.hardwareRef[8]);
            this.hardwareRef[9] = new HardwareProduct();
            this.hardwareRef[9].setId("28");
            this.hardwareRef[9].setName("SunBlade");
            this.hardwareRef[9].setPrice(1000.0);
            this.hardwareRef[9].setQuantity(20);
            this.hardwareRef[9].setPartNumber(312010108L);
            this.hardwareRef[9].setModelNumber(64);
            this.hardwareRef[9].setShelfLife(this.shelfRef[4]);
            this.getEntityManager().persist((Object)this.hardwareRef[9]);
            this.doFlush();
            this.logTrace("create Software Data");
            this.softwareRef[0] = new SoftwareProduct();
            this.softwareRef[0].setId("29");
            this.softwareRef[0].setName("SunOS 9");
            this.softwareRef[0].setPrice(500.0);
            this.softwareRef[0].setQuantity(500);
            this.softwareRef[0].setPartNumber(837373379L);
            this.softwareRef[0].setRevisionNumber(1.0);
            this.softwareRef[0].setShelfLife(this.shelfRef[5]);
            this.getEntityManager().persist((Object)this.softwareRef[0]);
            this.softwareRef[1] = new SoftwareProduct();
            this.softwareRef[1].setId("30");
            this.softwareRef[1].setName("Patch 590-009");
            this.softwareRef[1].setPrice(55.0);
            this.softwareRef[1].setQuantity(23);
            this.softwareRef[1].setPartNumber(285764891L);
            this.softwareRef[1].setRevisionNumber(1.1);
            this.getEntityManager().persist((Object)this.softwareRef[1]);
            this.softwareRef[2] = new SoftwareProduct();
            this.softwareRef[2].setId("31");
            this.softwareRef[2].setName("NetBeans");
            this.softwareRef[2].setPrice(35.0);
            this.softwareRef[2].setQuantity(15);
            this.softwareRef[2].setPartNumber(174983901L);
            this.softwareRef[2].setRevisionNumber(4.0);
            this.softwareRef[2].setShelfLife(this.shelfRef[6]);
            this.softwareRef[2].setWareHouse("Lowell");
            this.getEntityManager().persist((Object)this.softwareRef[2]);
            this.softwareRef[3] = new SoftwareProduct();
            this.softwareRef[3].setId("32");
            this.softwareRef[3].setName("J2SE");
            this.softwareRef[3].setPrice(150.0);
            this.softwareRef[3].setQuantity(100);
            this.softwareRef[3].setPartNumber(173479765L);
            this.softwareRef[3].setRevisionNumber(5.0);
            this.softwareRef[3].setShelfLife(this.shelfRef[7]);
            this.getEntityManager().persist((Object)this.softwareRef[3]);
            this.softwareRef[4] = new SoftwareProduct();
            this.softwareRef[4].setId("33");
            this.softwareRef[4].setName("Creator");
            this.softwareRef[4].setPrice(125.0);
            this.softwareRef[4].setQuantity(60);
            this.softwareRef[4].setPartNumber(847651234L);
            this.softwareRef[4].setRevisionNumber(4.0);
            this.softwareRef[4].setShelfLife(this.shelfRef[8]);
            this.getEntityManager().persist((Object)this.softwareRef[4]);
            this.softwareRef[5] = new SoftwareProduct();
            this.softwareRef[5].setId("34");
            this.softwareRef[5].setName("Java Programming Examples");
            this.softwareRef[5].setPrice(175.0);
            this.softwareRef[5].setQuantity(200);
            this.softwareRef[5].setPartNumber(376512908L);
            this.softwareRef[5].setRevisionNumber(1.5);
            this.getEntityManager().persist((Object)this.softwareRef[5]);
            this.softwareRef[6] = new SoftwareProduct();
            this.softwareRef[6].setId("35");
            this.softwareRef[6].setName("Tutorial");
            this.softwareRef[6].setPrice(250.0);
            this.softwareRef[6].setQuantity(35);
            this.softwareRef[6].setPartNumber(837462890L);
            this.softwareRef[6].setRevisionNumber(1.4);
            this.softwareRef[6].setWareHouse(null);
            this.getEntityManager().persist((Object)this.softwareRef[6]);
            this.softwareRef[7] = new SoftwareProduct();
            this.softwareRef[7].setId("36");
            this.softwareRef[7].setName("Testing Tools");
            this.softwareRef[7].setPrice(300.0);
            this.softwareRef[7].setQuantity(20);
            this.softwareRef[7].setPartNumber(372615467L);
            this.softwareRef[7].setRevisionNumber(1.0);
            this.getEntityManager().persist((Object)this.softwareRef[7]);
            this.softwareRef[8] = new SoftwareProduct();
            this.softwareRef[8].setId("37");
            this.softwareRef[8].setName("Patch 395-478");
            this.softwareRef[8].setPrice(55.0);
            this.softwareRef[8].setQuantity(25);
            this.softwareRef[8].setPartNumber(847628901L);
            this.softwareRef[8].setRevisionNumber(1.1);
            this.softwareRef[8].setShelfLife(this.shelfRef[9]);
            this.softwareRef[8].setWareHouse("Lowell");
            this.getEntityManager().persist((Object)this.softwareRef[8]);
            this.softwareRef[9] = new SoftwareProduct();
            this.softwareRef[9].setId("38");
            this.softwareRef[9].setName("Appserver 8");
            this.softwareRef[9].setPrice(0.0);
            this.softwareRef[9].setQuantity(150);
            this.softwareRef[9].setPartNumber(873657891L);
            this.softwareRef[9].setRevisionNumber(1.1);
            this.getEntityManager().persist((Object)this.softwareRef[9]);
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createProductData failed:", e);
        }
    }

    private void createAddressData() throws Exception {
        this.logTrace("createAddressData");
        this.address[0] = new Address("1", "1 Oak Road", "Bedford", "MA", "02155");
        this.address[1] = new Address("2", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[2] = new Address("3", "10 Griffin Road", "Lexington", "MA", "02277");
        this.address[3] = new Address("4", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[4] = new Address("5", "125 Moxy Lane", "Swansea", "MA", "11345");
        this.address[5] = new Address("6", "1 Network Drive", "Burlington", "MA", "11345");
        this.address[6] = new Address("7", "2654 Brookline Avenue", "Brookline", "MA", "11678");
        this.address[7] = new Address("8", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[8] = new Address("9", "100 Forrest Drive", "Hudson", "NH", "78654");
        this.address[9] = new Address("10", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[10] = new Address("11", "200 Elliot Road", "Nashua", "NH", "65447");
        this.address[11] = new Address("12", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[12] = new Address("13", "634 Goldstar Road", "Peabody", "MA", "88444");
        this.address[13] = new Address("14", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[14] = new Address("15", "100 Forrest Drive", "Peabody", "MA", "88444");
        this.address[15] = new Address("16", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[16] = new Address("17", "18 Rosewood Avenue", null, "MA", "87653");
        this.address[17] = new Address("18", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[18] = new Address("19", null, "Belmont", "VT", "23083");
        this.address[19] = new Address("20", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[20] = new Address("21", "3212 Boston Road", "Chelmsford", "MA", "01824");
        this.address[21] = new Address("22", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[22] = new Address("23", "212 Edgewood Drive", "Claremont", "NH", "58976");
        this.address[23] = new Address("24", "1 Network Drive", "Burlington", null, "00252");
        this.address[24] = new Address("25", "47 Skyline Drive", "Attleboro", "MA", "76656");
        this.address[25] = new Address("26", "1 Network Drive", "Burlington", "MA", null);
        this.address[26] = new Address("27", "4 Rangeway Road", "Lawrence", "RI", "53026");
        this.address[27] = new Address("28", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[28] = new Address("29", "48 Sears Street", "Boston", "MA", "02110");
        this.address[29] = new Address("30", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[30] = new Address("31", "1240 Davis Drive", "Northwood", "NH", "03260");
        this.address[31] = new Address("32", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[32] = new Address("33", "455 James Avenue", "Roslindale", "NY", "57550");
        this.address[33] = new Address("34", "1 Network Drive", "Burlington", "MA", "00252");
        this.address[34] = new Address("35", "8 Beverly Lane", "Burlington", "MA", "00252");
        this.address[35] = new Address("36", "1 Network Drive", "Burlington", "MA", "00252");
    }

    public void createCustomerData() throws Exception {
        this.logTrace("createCustomerData");
        this.createAddressData();
        this.getEntityTransaction().begin();
        try {
            this.country[0] = new Country("United States", "USA");
            this.country[1] = new Country("United States", "USA");
            this.country[2] = new Country("United States", "USA");
            this.country[3] = new Country("United States", "USA");
            this.country[4] = new Country("United States", "USA");
            this.country[5] = new Country("United States", "USA");
            this.country[6] = new Country("United States", "USA");
            this.country[7] = new Country("United States", "USA");
            this.country[8] = new Country("United States", "USA");
            this.country[9] = new Country("United States", "USA");
            this.country[10] = new Country("England", "GBR");
            this.country[11] = new Country("Ireland", "IRE");
            this.country[12] = new Country("China", "CHA");
            this.country[13] = new Country("Japan", "JPN");
            this.country[14] = new Country("United States", "USA");
            this.country[15] = new Country("England", "GBR");
            this.country[16] = new Country("Ireland", "IRE");
            this.country[17] = new Country("China", "CHA");
            this.country[18] = new Country("China", "CHA");
            this.country[19] = new Country("China", "CHA");
            this.customerRef[0] = new Customer("1", "Alan E. Frechette", this.address[0], this.address[1], this.country[0]);
            this.customerRef[1] = new Customer("2", "Arthur D. Frechette", this.address[2], this.address[3], this.country[1]);
            this.customerRef[2] = new Customer("3", "Shelly D. McGowan", this.address[4], this.address[5], this.country[2]);
            this.customerRef[3] = new Customer("4", "Robert E. Bissett", this.address[6], this.address[7], this.country[3]);
            this.customerRef[4] = new Customer("5", "Stephen S. D'Milla", this.address[8], this.address[9], this.country[4]);
            this.customerRef[5] = new Customer("6", "Karen R. Tegan", this.address[10], this.address[11], this.country[5]);
            this.customerRef[6] = new Customer("7", "Stephen J. Caruso", this.address[12], this.address[13], this.country[6]);
            this.customerRef[7] = new Customer("8", "Irene M. Caruso", this.address[14], this.address[15], this.country[7]);
            this.customerRef[8] = new Customer("9", "William P. Keaton", this.address[16], this.address[17], this.country[8]);
            this.customerRef[9] = new Customer("10", "Kate P. Hudson", this.address[18], this.address[19], this.country[9]);
            this.customerRef[10] = new Customer("11", "Jonathan K. Smith", this.address[20], this.address[21], this.country[10]);
            this.customerRef[11] = new Customer("12", null, this.address[22], this.address[23], this.country[11]);
            this.customerRef[12] = new Customer("13", "Douglas A. Donahue", this.address[24], this.address[25], this.country[12]);
            this.customerRef[13] = new Customer("14", "Kellie A. Sanborn", this.address[26], this.address[27], this.country[13]);
            this.customerRef[14] = new Customer("15", "Margaret Mills", this.address[28], this.address[29], this.country[14]);
            this.customerRef[15] = new Customer("16", "Sonya C. Sanders", this.address[30], this.address[31], this.country[15]);
            this.customerRef[16] = new Customer("17", "Jack B. Grace", this.address[32], this.address[33], this.country[16]);
            this.customerRef[17] = new Customer("18", "Ron F. Bender", this.address[34], this.address[35], this.country[17]);
            this.customerRef[18] = new Customer("19", "Lisa M. Presley", this.country[18]);
            this.customerRef[19] = new Customer("20", " David R. Vincent", this.country[19]);
            for (Customer customer : this.customerRef) {
                if (customer == null) continue;
                this.getEntityManager().persist((Object)customer);
                this.logTrace("persisting customer " + customer);
                this.doFlush();
            }
            this.info[0] = new Info();
            this.info[0].setId("1");
            this.info[0].setStreet("634 Goldstar Road");
            this.info[0].setCity("Peabody");
            this.info[0].setState("MA");
            this.info[0].setZip("88444");
            this.info[1] = new Info();
            this.info[1].setId("2");
            this.info[1].setStreet("3212 Boston Road");
            this.info[1].setCity("Chelmsford");
            this.info[1].setState("MA");
            this.info[1].setZip("01824");
            this.info[2] = new Info();
            this.info[2].setId("3");
            this.info[2].setStreet("47 Skyline Drive");
            this.info[2].setCity("Attleboro");
            this.info[2].setState("MA");
            this.info[2].setZip("76656");
            this.info[3] = new Info();
            this.info[3].setId("4");
            this.info[3].setStreet(null);
            this.info[3].setCity("Belmont");
            this.info[3].setState("VT");
            this.info[3].setZip("23083");
            this.info[4] = new Info();
            this.info[4].setId("5");
            this.info[4].setStreet("212 Edgewood Drive");
            this.info[4].setCity("Claremont");
            this.info[4].setState("NH");
            this.info[4].setZip("58976");
            this.info[5] = new Info();
            this.info[5].setId("6");
            this.info[5].setStreet("11 Richmond Lane");
            this.info[5].setCity("Chatham");
            this.info[5].setState("NJ");
            this.info[5].setZip("65490");
            this.spouse[0] = new Spouse("1", "Kathleen", "Jones", "Porter", "034-58-0988", this.info[0], this.customerRef[6]);
            this.spouse[1] = new Spouse("2", "Judith", "Connors", "McCall", "074-22-6431", this.info[1], this.customerRef[10]);
            this.spouse[2] = new Spouse("3", "Linda", "Kelly", "Morrison", "501-22-5940", this.info[2], this.customerRef[12]);
            this.spouse[3] = new Spouse("4", "Thomas", null, "Mullen", "210-23-3456", this.info[3], this.customerRef[9]);
            this.spouse[4] = new Spouse("5", "Mitchell", null, "Jackson", "476-44-3349", this.info[4], this.customerRef[11]);
            this.spouse[5] = new Spouse("6", "Cynthia", "White", "Allen", "508-908-7765", this.info[5]);
            for (Serializable serializable : this.spouse) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisting spouse " + (Spouse)serializable);
                this.doFlush();
            }
            this.customerRef[6].setSpouse(this.spouse[0]);
            this.getEntityManager().merge((Object)this.customerRef[6]);
            this.customerRef[9].setSpouse(this.spouse[3]);
            this.getEntityManager().merge((Object)this.customerRef[9]);
            this.customerRef[10].setSpouse(this.spouse[1]);
            this.getEntityManager().merge((Object)this.customerRef[10]);
            this.customerRef[11].setSpouse(this.spouse[4]);
            this.getEntityManager().merge((Object)this.customerRef[11]);
            this.customerRef[12].setSpouse(this.spouse[2]);
            this.getEntityManager().merge((Object)this.customerRef[12]);
            this.doFlush();
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createCustomerData failed:", e);
        }
    }

    public void createAliasOnlyData() throws Exception {
        this.logTrace("createAliasOnlyData");
        this.getEntityTransaction().begin();
        try {
            this.aliasRef[0] = new Alias("1", "aef");
            this.aliasRef[1] = new Alias("2", "al");
            this.aliasRef[2] = new Alias("3", "fish");
            this.aliasRef[3] = new Alias("4", "twin");
            this.aliasRef[4] = new Alias("5", "adf");
            this.aliasRef[5] = new Alias("6", "art");
            this.aliasRef[6] = new Alias("7", "sdm");
            this.aliasRef[7] = new Alias("8", "sh_ll");
            this.aliasRef[8] = new Alias("9", "reb");
            this.aliasRef[9] = new Alias("10", "bobby");
            this.aliasRef[10] = new Alias("11", "bb");
            this.aliasRef[11] = new Alias("12", "ssd");
            this.aliasRef[12] = new Alias("13", "steved");
            this.aliasRef[13] = new Alias("14", "stevie");
            this.aliasRef[14] = new Alias("15", "");
            this.aliasRef[15] = new Alias("16", "");
            this.aliasRef[16] = new Alias("17", "sjc");
            this.aliasRef[17] = new Alias("18", "stevec");
            this.aliasRef[18] = new Alias("19", "imc");
            this.aliasRef[19] = new Alias("20", "iris");
            this.aliasRef[20] = new Alias("21", "bro");
            this.aliasRef[21] = new Alias("22", "sis");
            this.aliasRef[22] = new Alias("23", "kell");
            this.aliasRef[23] = new Alias("24", "bill");
            this.aliasRef[24] = new Alias("25", "suzy");
            this.aliasRef[25] = new Alias("26", "jon");
            this.aliasRef[26] = new Alias("27", "jk");
            this.aliasRef[27] = new Alias("28", "kellieann");
            this.aliasRef[28] = new Alias("29", "smitty");
            this.aliasRef[29] = new Alias("30", null);
            for (Alias a : this.aliasRef) {
                if (a == null) continue;
                this.getEntityManager().persist((Object)a);
                this.logTrace("persisting alias " + a);
                this.doFlush();
            }
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createAliasOnlyData failed:", e);
        }
    }

    public void createAliasData() throws Exception {
        this.logTrace("createAliasData");
        this.createAliasOnlyData();
        this.getEntityTransaction().begin();
        try {
            this.aliasRef[0].getCustomers().add(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.aliasRef[0]);
            this.aliasRef[1].getCustomers().add(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.aliasRef[1]);
            this.aliasRef[2].getCustomers().add(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.aliasRef[2]);
            this.aliasRef[3].getCustomers().add(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.aliasRef[3]);
            this.aliasRef[2].getCustomers().add(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.aliasRef[2]);
            this.aliasRef[3].getCustomers().add(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.aliasRef[3]);
            this.aliasRef[4].getCustomers().add(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.aliasRef[4]);
            this.aliasRef[5].getCustomers().add(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.aliasRef[5]);
            this.aliasRef[6].getCustomers().add(this.customerRef[2]);
            this.getEntityManager().merge((Object)this.aliasRef[6]);
            this.aliasRef[7].getCustomers().add(this.customerRef[2]);
            this.getEntityManager().merge((Object)this.aliasRef[7]);
            this.aliasRef[8].getCustomers().add(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.aliasRef[8]);
            this.aliasRef[9].getCustomers().add(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.aliasRef[9]);
            this.aliasRef[10].getCustomers().add(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.aliasRef[10]);
            this.aliasRef[11].getCustomers().add(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.aliasRef[11]);
            this.aliasRef[12].getCustomers().add(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.aliasRef[12]);
            this.aliasRef[13].getCustomers().add(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.aliasRef[13]);
            this.aliasRef[13].getCustomers().add(this.customerRef[6]);
            this.getEntityManager().merge((Object)this.aliasRef[13]);
            this.aliasRef[16].getCustomers().add(this.customerRef[6]);
            this.getEntityManager().merge((Object)this.aliasRef[16]);
            this.aliasRef[17].getCustomers().add(this.customerRef[6]);
            this.getEntityManager().merge((Object)this.aliasRef[17]);
            this.aliasRef[18].getCustomers().add(this.customerRef[7]);
            this.getEntityManager().merge((Object)this.aliasRef[18]);
            this.aliasRef[19].getCustomers().add(this.customerRef[7]);
            this.getEntityManager().merge((Object)this.aliasRef[19]);
            this.doFlush();
            this.aliasRef[23].getCustomers().add(this.customerRef[8]);
            this.getEntityManager().merge((Object)this.aliasRef[23]);
            this.aliasRef[21].getCustomers().add(this.customerRef[9]);
            this.getEntityManager().merge((Object)this.aliasRef[21]);
            this.aliasRef[29].getCustomers().add(this.customerRef[9]);
            this.getEntityManager().merge((Object)this.aliasRef[29]);
            this.aliasRef[25].getCustomers().add(this.customerRef[10]);
            this.getEntityManager().merge((Object)this.aliasRef[25]);
            this.aliasRef[26].getCustomers().add(this.customerRef[10]);
            this.getEntityManager().merge((Object)this.aliasRef[26]);
            this.aliasRef[28].getCustomers().add(this.customerRef[10]);
            this.getEntityManager().merge((Object)this.aliasRef[28]);
            this.aliasRef[24].getCustomers().add(this.customerRef[11]);
            this.getEntityManager().merge((Object)this.aliasRef[24]);
            this.aliasRef[20].getCustomers().add(this.customerRef[12]);
            this.getEntityManager().merge((Object)this.aliasRef[20]);
            this.aliasRef[22].getCustomers().add(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.aliasRef[22]);
            this.aliasRef[27].getCustomers().add(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.aliasRef[27]);
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createAliasData failed:", e);
        }
    }

    public void createOrderData() throws Exception {
        this.logTrace("createOrderData");
        this.getEntityTransaction().begin();
        try {
            this.creditCard[0] = new CreditCard("1", "1234-2567-1222-9999", "VISA", "04/02", true, 5579.0);
            this.creditCard[1] = new CreditCard("2", "3455-9876-1221-0060", "MCARD", "10/03", false, 15000.0);
            this.creditCard[2] = new CreditCard("3", "1210-1449-2200-3254", "AXP", "11/02", true, 3000.0);
            this.creditCard[3] = new CreditCard("4", "0002-1221-0078-0890", "VISA", "05/03", true, 8000.0);
            this.creditCard[4] = new CreditCard("5", "1987-5555-8733-0011", "VISA", "05/03", true, 2500.0);
            this.creditCard[5] = new CreditCard("6", "0000-0011-2200-3087", "MCARD", "11/02", true, 23000.0);
            this.creditCard[6] = new CreditCard("7", "3341-7610-8880-9910", "AXP", "10/04", true, 13000.0);
            this.creditCard[7] = new CreditCard("8", "2222-3333-4444-5555", "MCARD", "12/03", true, 2000.0);
            this.creditCard[8] = new CreditCard("9", "8888-2222-0090-1348", "AXP", "01/02", true, 4500.0);
            this.creditCard[9] = new CreditCard("10", "1762-5094-8769-3117", "VISA", "06/01", true, 14000.0);
            this.creditCard[10] = new CreditCard("11", "1234-1234-1234-9999", "MCARD", "09/03", true, 7000.0);
            this.creditCard[11] = new CreditCard("12", "9876-9876-1234-5678", "VISA", "04/04", false, 1000.0);
            this.creditCard[12] = new CreditCard("13", "7777-8888-9999-0012", "MCARD", "01/02", true, 3500.0);
            this.creditCard[13] = new CreditCard("14", "9099-8808-7718-4455", "AXP", "03/05", true, 4400.0);
            this.creditCard[14] = new CreditCard("15", "7653-7901-2397-1768", "AXP", "02/04", true, 5000.0);
            this.creditCard[15] = new CreditCard("16", "8760-8618-9263-3322", "VISA", "04/05", false, 750.0);
            this.creditCard[16] = new CreditCard("17", "9870-2309-6754-3210", "MCARD", "03/03", true, 500.0);
            this.creditCard[17] = new CreditCard("18", "8746-8754-9090-1234", "AXP", "08/04", false, 1500.0);
            this.creditCard[18] = new CreditCard("19", "8736-0980-8765-4869", "MCARD", "09/02", true, 5500.0);
            this.creditCard[19] = new CreditCard("20", "6745-0979-0970-2345", "VISA", "02/05", true, 1400.0);
            this.creditCard[20] = new CreditCard("21", "8033-5896-9901-4566", "AXP", "09/07", true, 400.0);
            this.creditCard[21] = new CreditCard("22", "4390-5671-4385-0091", "MCARD", "03/06", false, 7400.0);
            this.creditCard[22] = new CreditCard("23", "3456-0909-3434-2134", "VISA", "04/08", true, 9500.0);
            this.creditCard[23] = new CreditCard("24", "5643-2090-4569-2323", "MCARD", "01/06", false, 1000.0);
            for (CreditCard creditCard : this.creditCard) {
                if (creditCard == null) continue;
                this.getEntityManager().persist((Object)creditCard);
                this.logTrace("persisting creditCard " + creditCard);
                this.doFlush();
            }
            this.lineItem[0] = new LineItem("1", 1);
            this.lineItem[1] = new LineItem("2", 1);
            this.lineItem[2] = new LineItem("3", 1);
            this.lineItem[3] = new LineItem("4", 1);
            this.lineItem[4] = new LineItem("5", 1);
            this.lineItem[5] = new LineItem("6", 1);
            this.lineItem[6] = new LineItem("7", 1);
            this.lineItem[7] = new LineItem("8", 1);
            this.lineItem[8] = new LineItem("9", 1);
            this.lineItem[9] = new LineItem("10", 1);
            this.lineItem[10] = new LineItem("11", 1);
            this.lineItem[11] = new LineItem("12", 1);
            this.lineItem[12] = new LineItem("13", 1);
            this.lineItem[13] = new LineItem("14", 1);
            this.lineItem[14] = new LineItem("15", 1);
            this.lineItem[15] = new LineItem("16", 1);
            this.lineItem[16] = new LineItem("17", 1);
            this.lineItem[17] = new LineItem("18", 1);
            this.lineItem[18] = new LineItem("19", 1);
            this.lineItem[19] = new LineItem("20", 1);
            this.lineItem[20] = new LineItem("21", 1);
            this.lineItem[21] = new LineItem("22", 1);
            this.lineItem[22] = new LineItem("23", 1);
            this.lineItem[23] = new LineItem("24", 1);
            this.lineItem[24] = new LineItem("25", 1);
            this.lineItem[25] = new LineItem("26", 1);
            this.lineItem[26] = new LineItem("27", 1);
            this.lineItem[27] = new LineItem("28", 1);
            this.lineItem[28] = new LineItem("29", 1);
            this.lineItem[29] = new LineItem("30", 5);
            this.lineItem[30] = new LineItem("31", 3);
            this.lineItem[31] = new LineItem("32", 8);
            this.lineItem[32] = new LineItem("33", 1);
            this.lineItem[33] = new LineItem("34", 1);
            this.lineItem[34] = new LineItem("35", 6);
            this.lineItem[35] = new LineItem("36", 1);
            this.lineItem[36] = new LineItem("37", 2);
            this.lineItem[37] = new LineItem("38", 3);
            this.lineItem[38] = new LineItem("39", 5);
            this.lineItem[39] = new LineItem("40", 3);
            this.lineItem[40] = new LineItem("41", 2);
            this.lineItem[41] = new LineItem("42", 1);
            this.lineItem[42] = new LineItem("43", 1);
            this.lineItem[43] = new LineItem("44", 3);
            this.lineItem[44] = new LineItem("45", 1);
            this.lineItem[45] = new LineItem("46", 2);
            this.lineItem[46] = new LineItem("47", 3);
            this.lineItem[47] = new LineItem("48", 3);
            this.lineItem[48] = new LineItem("49", 4);
            this.lineItem[49] = new LineItem("50", 5);
            this.lineItem[50] = new LineItem("51", 2);
            this.lineItem[51] = new LineItem("52", 1);
            this.lineItem[52] = new LineItem("53", 3);
            this.lineItem[53] = new LineItem("54", 1);
            this.lineItem[54] = new LineItem("55", 3);
            this.lineItem[55] = new LineItem("56", 1);
            for (Serializable serializable : this.lineItem) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisting lineItem " + (LineItem)serializable);
                this.doFlush();
            }
            this.orderRef[0] = new Order("1", this.customerRef[0]);
            this.orderRef[1] = new Order("2", this.customerRef[1]);
            this.orderRef[2] = new Order("3", this.customerRef[2]);
            this.orderRef[3] = new Order("4", this.customerRef[3]);
            this.orderRef[4] = new Order("5", this.customerRef[4]);
            this.orderRef[5] = new Order("6", this.customerRef[5]);
            this.orderRef[6] = new Order("7", this.customerRef[6]);
            this.orderRef[7] = new Order("8", this.customerRef[7]);
            this.orderRef[8] = new Order("9", this.customerRef[3]);
            this.orderRef[9] = new Order("10", this.customerRef[8]);
            this.orderRef[10] = new Order("11", this.customerRef[9]);
            this.orderRef[11] = new Order("12", this.customerRef[10]);
            this.orderRef[12] = new Order("13", this.customerRef[11]);
            this.orderRef[13] = new Order("14", this.customerRef[12]);
            this.orderRef[14] = new Order("15", this.customerRef[13]);
            this.orderRef[15] = new Order("16", this.customerRef[13]);
            this.orderRef[16] = new Order("17", this.customerRef[14]);
            this.orderRef[17] = new Order("18", this.customerRef[15]);
            this.orderRef[18] = new Order("19");
            this.orderRef[19] = new Order("20");
            for (Serializable serializable : this.orderRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisting order " + (Order)serializable);
                this.doFlush();
            }
            this.lineItem[0].setProduct(this.productRef[0]);
            this.lineItem[0].setOrder(this.orderRef[0]);
            this.getEntityManager().merge((Object)this.lineItem[0]);
            this.lineItem[1].setProduct(this.productRef[1]);
            this.lineItem[1].setOrder(this.orderRef[0]);
            this.getEntityManager().merge((Object)this.lineItem[1]);
            this.lineItem[2].setProduct(this.productRef[7]);
            this.lineItem[2].setOrder(this.orderRef[0]);
            this.getEntityManager().merge((Object)this.lineItem[2]);
            this.lineItem[28].setProduct(this.productRef[8]);
            this.lineItem[28].setOrder(this.orderRef[0]);
            this.getEntityManager().merge((Object)this.lineItem[28]);
            this.orderRef[0].getLineItemsCollection().add(this.lineItem[0]);
            this.orderRef[0].getLineItemsCollection().add(this.lineItem[1]);
            this.orderRef[0].getLineItemsCollection().add(this.lineItem[2]);
            this.orderRef[0].setSampleLineItem(this.lineItem[28]);
            double totalPrice = this.productRef[0].getPrice() + this.productRef[1].getPrice() + this.productRef[7].getPrice() + this.productRef[8].getPrice();
            this.orderRef[0].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[0]);
            this.creditCard[1].setOrder(this.orderRef[0]);
            this.creditCard[1].setCustomer(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.creditCard[1]);
            this.doFlush();
            this.lineItem[3].setProduct(this.productRef[0]);
            this.lineItem[3].setOrder(this.orderRef[1]);
            this.getEntityManager().merge((Object)this.lineItem[3]);
            this.lineItem[4].setProduct(this.productRef[1]);
            this.lineItem[4].setOrder(this.orderRef[1]);
            this.getEntityManager().merge((Object)this.lineItem[4]);
            this.lineItem[5].setProduct(this.productRef[2]);
            this.lineItem[5].setOrder(this.orderRef[1]);
            this.getEntityManager().merge((Object)this.lineItem[5]);
            this.lineItem[6].setProduct(this.productRef[3]);
            this.lineItem[6].setOrder(this.orderRef[1]);
            this.getEntityManager().merge((Object)this.lineItem[6]);
            this.lineItem[7].setProduct(this.productRef[4]);
            this.lineItem[7].setOrder(this.orderRef[1]);
            this.getEntityManager().merge((Object)this.lineItem[7]);
            this.orderRef[1].getLineItemsCollection().add(this.lineItem[3]);
            this.orderRef[1].getLineItemsCollection().add(this.lineItem[4]);
            this.orderRef[1].getLineItemsCollection().add(this.lineItem[5]);
            this.orderRef[1].getLineItemsCollection().add(this.lineItem[6]);
            this.orderRef[1].getLineItemsCollection().add(this.lineItem[7]);
            totalPrice = this.productRef[0].getPrice() + this.productRef[1].getPrice() + this.productRef[2].getPrice() + this.productRef[3].getPrice() + this.productRef[4].getPrice();
            this.orderRef[1].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[1]);
            this.creditCard[3].setOrder(this.orderRef[1]);
            this.creditCard[3].setCustomer(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.creditCard[3]);
            this.doFlush();
            this.lineItem[8].setProduct(this.productRef[2]);
            this.lineItem[8].setOrder(this.orderRef[2]);
            this.getEntityManager().merge((Object)this.lineItem[8]);
            this.lineItem[9].setProduct(this.productRef[5]);
            this.lineItem[9].setOrder(this.orderRef[2]);
            this.getEntityManager().merge((Object)this.lineItem[9]);
            this.orderRef[2].getLineItemsCollection().add(this.lineItem[8]);
            this.orderRef[2].getLineItemsCollection().add(this.lineItem[9]);
            totalPrice = this.productRef[2].getPrice() + this.productRef[5].getPrice();
            this.orderRef[2].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[2]);
            this.creditCard[4].setOrder(this.orderRef[2]);
            this.creditCard[4].setCustomer(this.customerRef[2]);
            this.getEntityManager().merge((Object)this.creditCard[4]);
            this.doFlush();
            this.lineItem[10].setProduct(this.productRef[6]);
            this.lineItem[10].setOrder(this.orderRef[3]);
            this.getEntityManager().merge((Object)this.lineItem[10]);
            this.orderRef[3].getLineItemsCollection().add(this.lineItem[10]);
            totalPrice = this.productRef[6].getPrice();
            this.orderRef[3].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[3]);
            this.creditCard[5].setOrder(this.orderRef[3]);
            this.creditCard[5].setCustomer(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.creditCard[5]);
            this.doFlush();
            this.lineItem[11].setProduct(this.productRef[0]);
            this.lineItem[11].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[11]);
            this.lineItem[12].setProduct(this.productRef[1]);
            this.lineItem[12].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[12]);
            this.lineItem[13].setProduct(this.productRef[2]);
            this.lineItem[13].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[13]);
            this.lineItem[14].setProduct(this.productRef[3]);
            this.lineItem[14].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[14]);
            this.lineItem[15].setProduct(this.productRef[4]);
            this.lineItem[15].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[15]);
            this.lineItem[16].setProduct(this.productRef[5]);
            this.lineItem[16].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[16]);
            this.lineItem[17].setProduct(this.productRef[6]);
            this.lineItem[17].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[17]);
            this.lineItem[18].setProduct(this.productRef[7]);
            this.lineItem[18].setOrder(this.orderRef[4]);
            this.getEntityManager().merge((Object)this.lineItem[18]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[11]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[12]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[13]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[14]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[15]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[16]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[17]);
            this.orderRef[4].getLineItemsCollection().add(this.lineItem[18]);
            totalPrice = this.productRef[0].getPrice() + this.productRef[1].getPrice() + this.productRef[2].getPrice() + this.productRef[3].getPrice() + this.productRef[4].getPrice() + this.productRef[5].getPrice() + this.productRef[6].getPrice() + this.productRef[7].getPrice();
            this.orderRef[4].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[4]);
            this.creditCard[7].setOrder(this.orderRef[4]);
            this.creditCard[7].setCustomer(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.creditCard[7]);
            this.doFlush();
            this.lineItem[19].setProduct(this.productRef[3]);
            this.lineItem[19].setOrder(this.orderRef[5]);
            this.getEntityManager().merge((Object)this.lineItem[19]);
            this.lineItem[20].setProduct(this.productRef[6]);
            this.lineItem[20].setOrder(this.orderRef[5]);
            this.getEntityManager().merge((Object)this.lineItem[20]);
            this.lineItem[29].setProduct(this.productRef[8]);
            this.lineItem[29].setOrder(this.orderRef[5]);
            this.getEntityManager().merge((Object)this.lineItem[29]);
            this.orderRef[5].getLineItemsCollection().add(this.lineItem[19]);
            this.orderRef[5].getLineItemsCollection().add(this.lineItem[20]);
            this.orderRef[5].setSampleLineItem(this.lineItem[29]);
            totalPrice = this.productRef[3].getPrice() + this.productRef[6].getPrice() + this.productRef[8].getPrice();
            this.orderRef[5].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[5]);
            this.creditCard[10].setOrder(this.orderRef[5]);
            this.creditCard[10].setCustomer(this.customerRef[5]);
            this.getEntityManager().merge((Object)this.creditCard[10]);
            this.doFlush();
            this.lineItem[21].setProduct(this.productRef[2]);
            this.lineItem[21].setOrder(this.orderRef[6]);
            this.getEntityManager().merge((Object)this.lineItem[21]);
            this.lineItem[22].setProduct(this.productRef[3]);
            this.lineItem[22].setOrder(this.orderRef[6]);
            this.getEntityManager().merge((Object)this.lineItem[22]);
            this.lineItem[23].setProduct(this.productRef[7]);
            this.lineItem[23].setOrder(this.orderRef[6]);
            this.getEntityManager().merge((Object)this.lineItem[23]);
            this.orderRef[6].getLineItemsCollection().add(this.lineItem[21]);
            this.orderRef[6].getLineItemsCollection().add(this.lineItem[22]);
            this.orderRef[6].getLineItemsCollection().add(this.lineItem[23]);
            totalPrice = this.productRef[2].getPrice() + this.productRef[3].getPrice() + this.productRef[7].getPrice();
            this.orderRef[6].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[6]);
            this.creditCard[11].setOrder(this.orderRef[6]);
            this.creditCard[11].setCustomer(this.customerRef[6]);
            this.getEntityManager().merge((Object)this.creditCard[11]);
            this.doFlush();
            this.lineItem[24].setProduct(this.productRef[0]);
            this.lineItem[24].setOrder(this.orderRef[7]);
            this.getEntityManager().merge((Object)this.lineItem[24]);
            this.lineItem[25].setProduct(this.productRef[4]);
            this.lineItem[25].setOrder(this.orderRef[7]);
            this.getEntityManager().merge((Object)this.lineItem[25]);
            this.orderRef[7].getLineItemsCollection().add(this.lineItem[24]);
            this.orderRef[7].getLineItemsCollection().add(this.lineItem[25]);
            totalPrice = this.productRef[0].getPrice() + this.productRef[4].getPrice();
            this.orderRef[7].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[7]);
            this.creditCard[13].setOrder(this.orderRef[7]);
            this.creditCard[13].setCustomer(this.customerRef[7]);
            this.getEntityManager().merge((Object)this.creditCard[13]);
            this.doFlush();
            this.lineItem[26].setProduct(this.productRef[0]);
            this.lineItem[26].setOrder(this.orderRef[8]);
            this.getEntityManager().merge((Object)this.lineItem[26]);
            this.lineItem[27].setProduct(this.productRef[1]);
            this.lineItem[27].setOrder(this.orderRef[8]);
            this.getEntityManager().merge((Object)this.lineItem[27]);
            this.orderRef[8].getLineItemsCollection().add(this.lineItem[26]);
            this.orderRef[8].getLineItemsCollection().add(this.lineItem[27]);
            totalPrice = this.productRef[0].getPrice() + this.productRef[1].getPrice();
            this.orderRef[8].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[8]);
            this.creditCard[6].setOrder(this.orderRef[8]);
            this.creditCard[6].setCustomer(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.creditCard[6]);
            this.doFlush();
            this.lineItem[30].setProduct(this.productRef[9]);
            this.lineItem[30].setOrder(this.orderRef[9]);
            this.getEntityManager().merge((Object)this.lineItem[30]);
            this.lineItem[31].setProduct(this.productRef[16]);
            this.lineItem[31].setOrder(this.orderRef[9]);
            this.getEntityManager().merge((Object)this.lineItem[31]);
            this.orderRef[9].getLineItemsCollection().add(this.lineItem[30]);
            this.orderRef[9].getLineItemsCollection().add(this.lineItem[31]);
            totalPrice = this.productRef[9].getPrice() + this.productRef[16].getPrice();
            this.orderRef[9].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[9]);
            this.creditCard[14].setOrder(this.orderRef[9]);
            this.creditCard[14].setCustomer(this.customerRef[8]);
            this.getEntityManager().merge((Object)this.creditCard[14]);
            this.doFlush();
            this.lineItem[32].setProduct(this.productRef[13]);
            this.lineItem[32].setOrder(this.orderRef[10]);
            this.getEntityManager().merge((Object)this.lineItem[32]);
            this.orderRef[10].getLineItemsCollection().add(this.lineItem[32]);
            totalPrice = this.productRef[13].getPrice();
            this.orderRef[10].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[10]);
            this.creditCard[15].setOrder(this.orderRef[10]);
            this.creditCard[15].setCustomer(this.customerRef[9]);
            this.getEntityManager().merge((Object)this.creditCard[15]);
            this.doFlush();
            this.lineItem[33].setProduct(this.productRef[10]);
            this.lineItem[33].setOrder(this.orderRef[11]);
            this.getEntityManager().merge((Object)this.lineItem[33]);
            this.lineItem[34].setProduct(this.productRef[12]);
            this.lineItem[34].setOrder(this.orderRef[11]);
            this.getEntityManager().merge((Object)this.lineItem[34]);
            this.orderRef[11].getLineItemsCollection().add(this.lineItem[33]);
            this.orderRef[11].getLineItemsCollection().add(this.lineItem[34]);
            totalPrice = this.productRef[10].getPrice() + this.productRef[12].getPrice();
            this.orderRef[11].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[11]);
            this.creditCard[16].setOrder(this.orderRef[11]);
            this.creditCard[16].setCustomer(this.customerRef[10]);
            this.getEntityManager().merge((Object)this.creditCard[16]);
            this.doFlush();
            this.lineItem[35].setProduct(this.productRef[17]);
            this.lineItem[35].setOrder(this.orderRef[12]);
            this.getEntityManager().merge((Object)this.lineItem[35]);
            this.orderRef[12].getLineItemsCollection().add(this.lineItem[35]);
            totalPrice = this.productRef[17].getPrice();
            this.orderRef[12].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[12]);
            this.creditCard[17].setOrder(this.orderRef[12]);
            this.creditCard[17].setCustomer(this.customerRef[11]);
            this.getEntityManager().merge((Object)this.creditCard[17]);
            this.doFlush();
            this.lineItem[36].setProduct(this.productRef[7]);
            this.lineItem[36].setOrder(this.orderRef[13]);
            this.getEntityManager().merge((Object)this.lineItem[36]);
            this.lineItem[37].setProduct(this.productRef[14]);
            this.lineItem[37].setOrder(this.orderRef[13]);
            this.getEntityManager().merge((Object)this.lineItem[37]);
            this.lineItem[38].setProduct(this.productRef[15]);
            this.lineItem[38].setOrder(this.orderRef[13]);
            this.getEntityManager().merge((Object)this.lineItem[38]);
            this.orderRef[13].getLineItemsCollection().add(this.lineItem[36]);
            this.orderRef[13].getLineItemsCollection().add(this.lineItem[37]);
            this.orderRef[13].getLineItemsCollection().add(this.lineItem[38]);
            totalPrice = this.productRef[7].getPrice() + this.productRef[14].getPrice() + this.productRef[15].getPrice();
            this.orderRef[13].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[13]);
            this.creditCard[18].setOrder(this.orderRef[13]);
            this.creditCard[18].setCustomer(this.customerRef[12]);
            this.getEntityManager().merge((Object)this.creditCard[18]);
            this.doFlush();
            this.lineItem[39].setProduct(this.productRef[1]);
            this.lineItem[39].setOrder(this.orderRef[14]);
            this.getEntityManager().merge((Object)this.lineItem[39]);
            this.lineItem[40].setProduct(this.productRef[2]);
            this.lineItem[40].setOrder(this.orderRef[14]);
            this.getEntityManager().merge((Object)this.lineItem[40]);
            this.lineItem[41].setProduct(this.productRef[12]);
            this.lineItem[41].setOrder(this.orderRef[14]);
            this.getEntityManager().merge((Object)this.lineItem[41]);
            this.lineItem[42].setProduct(this.productRef[15]);
            this.lineItem[42].setOrder(this.orderRef[14]);
            this.getEntityManager().merge((Object)this.lineItem[42]);
            this.orderRef[14].getLineItemsCollection().add(this.lineItem[39]);
            this.orderRef[14].getLineItemsCollection().add(this.lineItem[40]);
            this.orderRef[14].getLineItemsCollection().add(this.lineItem[41]);
            this.orderRef[14].getLineItemsCollection().add(this.lineItem[42]);
            totalPrice = this.productRef[1].getPrice() + this.productRef[2].getPrice() + this.productRef[12].getPrice() + this.productRef[15].getPrice();
            this.orderRef[14].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[14]);
            this.creditCard[19].setOrder(this.orderRef[14]);
            this.creditCard[19].setCustomer(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.creditCard[19]);
            this.doFlush();
            this.lineItem[43].setProduct(this.productRef[13]);
            this.lineItem[43].setOrder(this.orderRef[15]);
            this.getEntityManager().merge((Object)this.lineItem[43]);
            this.orderRef[15].getLineItemsCollection().add(this.lineItem[43]);
            totalPrice = this.productRef[13].getPrice();
            this.orderRef[15].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[15]);
            this.creditCard[19].setOrder(this.orderRef[15]);
            this.creditCard[19].setCustomer(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.creditCard[19]);
            this.doFlush();
            this.lineItem[44].setProduct(this.hardwareRef[0]);
            this.lineItem[44].setOrder(this.orderRef[16]);
            this.getEntityManager().merge((Object)this.lineItem[44]);
            this.lineItem[45].setProduct(this.hardwareRef[1]);
            this.lineItem[45].setOrder(this.orderRef[16]);
            this.getEntityManager().merge((Object)this.lineItem[45]);
            this.lineItem[46].setProduct(this.softwareRef[0]);
            this.lineItem[46].setOrder(this.orderRef[16]);
            this.getEntityManager().merge((Object)this.lineItem[46]);
            this.orderRef[16].getLineItemsCollection().add(this.lineItem[44]);
            this.orderRef[16].getLineItemsCollection().add(this.lineItem[45]);
            this.orderRef[16].getLineItemsCollection().add(this.lineItem[46]);
            totalPrice = this.hardwareRef[0].getPrice() + this.hardwareRef[1].getPrice() + this.softwareRef[0].getPrice();
            this.orderRef[16].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[16]);
            this.creditCard[20].setOrder(this.orderRef[16]);
            this.creditCard[20].setCustomer(this.customerRef[14]);
            this.getEntityManager().merge((Object)this.creditCard[20]);
            this.doFlush();
            this.lineItem[47].setProduct(this.hardwareRef[2]);
            this.lineItem[47].setOrder(this.orderRef[17]);
            this.getEntityManager().merge((Object)this.lineItem[47]);
            this.lineItem[48].setProduct(this.softwareRef[1]);
            this.lineItem[48].setOrder(this.orderRef[17]);
            this.getEntityManager().merge((Object)this.lineItem[48]);
            this.lineItem[49].setProduct(this.hardwareRef[3]);
            this.lineItem[49].setOrder(this.orderRef[17]);
            this.getEntityManager().merge((Object)this.lineItem[49]);
            this.lineItem[50].setProduct(this.softwareRef[2]);
            this.lineItem[50].setOrder(this.orderRef[17]);
            this.getEntityManager().merge((Object)this.lineItem[50]);
            this.orderRef[17].getLineItemsCollection().add(this.lineItem[47]);
            this.orderRef[17].getLineItemsCollection().add(this.lineItem[48]);
            this.orderRef[17].getLineItemsCollection().add(this.lineItem[49]);
            this.orderRef[17].getLineItemsCollection().add(this.lineItem[50]);
            totalPrice = this.hardwareRef[2].getPrice() + this.hardwareRef[3].getPrice() + this.softwareRef[1].getPrice() + this.softwareRef[2].getPrice();
            this.orderRef[17].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[17]);
            this.creditCard[21].setOrder(this.orderRef[17]);
            this.creditCard[21].setCustomer(this.customerRef[15]);
            this.getEntityManager().merge((Object)this.creditCard[21]);
            this.doFlush();
            this.lineItem[51].setProduct(this.hardwareRef[4]);
            this.lineItem[51].setOrder(this.orderRef[18]);
            this.getEntityManager().merge((Object)this.lineItem[51]);
            this.lineItem[52].setProduct(this.softwareRef[3]);
            this.lineItem[52].setOrder(this.orderRef[18]);
            this.getEntityManager().merge((Object)this.lineItem[52]);
            this.lineItem[53].setProduct(this.softwareRef[4]);
            this.lineItem[53].setOrder(this.orderRef[18]);
            this.getEntityManager().merge((Object)this.lineItem[53]);
            this.orderRef[18].getLineItemsCollection().add(this.lineItem[51]);
            this.orderRef[18].getLineItemsCollection().add(this.lineItem[52]);
            this.orderRef[18].getLineItemsCollection().add(this.lineItem[53]);
            totalPrice = this.hardwareRef[4].getPrice() + this.softwareRef[3].getPrice() + this.softwareRef[4].getPrice();
            this.orderRef[18].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[18]);
            this.creditCard[22].setOrder(this.orderRef[18]);
            this.creditCard[22].setCustomer(this.customerRef[16]);
            this.getEntityManager().merge((Object)this.creditCard[22]);
            this.doFlush();
            this.lineItem[54].setProduct(this.hardwareRef[5]);
            this.lineItem[54].setOrder(this.orderRef[19]);
            this.getEntityManager().merge((Object)this.lineItem[54]);
            this.lineItem[55].setProduct(this.softwareRef[5]);
            this.lineItem[55].setOrder(this.orderRef[19]);
            this.getEntityManager().merge((Object)this.lineItem[55]);
            this.orderRef[19].getLineItemsCollection().add(this.lineItem[54]);
            this.orderRef[19].getLineItemsCollection().add(this.lineItem[55]);
            totalPrice = this.hardwareRef[5].getPrice() + this.softwareRef[5].getPrice();
            this.orderRef[19].setTotalPrice(totalPrice);
            this.getEntityManager().merge((Object)this.orderRef[19]);
            this.creditCard[23].setOrder(this.orderRef[19]);
            this.creditCard[23].setCustomer(this.customerRef[17]);
            this.getEntityManager().merge((Object)this.creditCard[23]);
            this.doFlush();
            this.orderRef[0].setCustomer(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.orderRef[0]);
            this.creditCard[0].setCustomer(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.creditCard[0]);
            this.creditCard[1].setCustomer(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.creditCard[1]);
            this.creditCard[2].setCustomer(this.customerRef[0]);
            this.getEntityManager().merge((Object)this.creditCard[2]);
            this.doFlush();
            this.orderRef[1].setCustomer(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.orderRef[1]);
            this.creditCard[3].setCustomer(this.customerRef[1]);
            this.getEntityManager().merge((Object)this.creditCard[3]);
            this.doFlush();
            this.orderRef[2].setCustomer(this.customerRef[2]);
            this.getEntityManager().merge((Object)this.orderRef[2]);
            this.creditCard[4].setCustomer(this.customerRef[2]);
            this.getEntityManager().merge((Object)this.creditCard[4]);
            this.doFlush();
            this.orderRef[3].setCustomer(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.orderRef[3]);
            this.creditCard[5].setCustomer(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.creditCard[5]);
            this.creditCard[6].setCustomer(this.customerRef[3]);
            this.getEntityManager().merge((Object)this.creditCard[6]);
            this.doFlush();
            this.orderRef[4].setCustomer(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.orderRef[4]);
            this.creditCard[7].setCustomer(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.creditCard[7]);
            this.creditCard[8].setCustomer(this.customerRef[4]);
            this.getEntityManager().merge((Object)this.creditCard[8]);
            this.doFlush();
            this.orderRef[5].setCustomer(this.customerRef[5]);
            this.getEntityManager().merge((Object)this.orderRef[5]);
            this.creditCard[9].setCustomer(this.customerRef[5]);
            this.getEntityManager().merge((Object)this.creditCard[9]);
            this.creditCard[10].setCustomer(this.customerRef[5]);
            this.getEntityManager().merge((Object)this.creditCard[10]);
            this.doFlush();
            this.orderRef[6].setCustomer(this.customerRef[6]);
            this.getEntityManager().merge((Object)this.orderRef[6]);
            this.creditCard[11].setCustomer(this.customerRef[6]);
            this.getEntityManager().merge((Object)this.creditCard[11]);
            this.doFlush();
            this.orderRef[7].setCustomer(this.customerRef[7]);
            this.getEntityManager().merge((Object)this.orderRef[7]);
            this.creditCard[12].setCustomer(this.customerRef[7]);
            this.getEntityManager().merge((Object)this.creditCard[12]);
            this.creditCard[13].setCustomer(this.customerRef[7]);
            this.getEntityManager().merge((Object)this.creditCard[13]);
            this.doFlush();
            this.orderRef[9].setCustomer(this.customerRef[8]);
            this.getEntityManager().merge((Object)this.orderRef[9]);
            this.creditCard[14].setCustomer(this.customerRef[8]);
            this.getEntityManager().merge((Object)this.creditCard[14]);
            this.doFlush();
            this.orderRef[10].setCustomer(this.customerRef[9]);
            this.getEntityManager().merge((Object)this.orderRef[10]);
            this.creditCard[15].setCustomer(this.customerRef[9]);
            this.getEntityManager().merge((Object)this.creditCard[15]);
            this.doFlush();
            this.orderRef[11].setCustomer(this.customerRef[10]);
            this.getEntityManager().merge((Object)this.orderRef[11]);
            this.creditCard[16].setCustomer(this.customerRef[10]);
            this.getEntityManager().merge((Object)this.creditCard[16]);
            this.doFlush();
            this.orderRef[12].setCustomer(this.customerRef[11]);
            this.getEntityManager().merge((Object)this.orderRef[12]);
            this.creditCard[17].setCustomer(this.customerRef[11]);
            this.getEntityManager().merge((Object)this.creditCard[17]);
            this.doFlush();
            this.orderRef[13].setCustomer(this.customerRef[12]);
            this.getEntityManager().merge((Object)this.orderRef[13]);
            this.creditCard[18].setCustomer(this.customerRef[12]);
            this.getEntityManager().merge((Object)this.creditCard[18]);
            this.doFlush();
            this.orderRef[14].setCustomer(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.orderRef[14]);
            this.orderRef[15].setCustomer(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.orderRef[15]);
            this.creditCard[19].setCustomer(this.customerRef[13]);
            this.getEntityManager().merge((Object)this.creditCard[19]);
            this.doFlush();
            this.orderRef[16].setCustomer(this.customerRef[14]);
            this.getEntityManager().merge((Object)this.orderRef[16]);
            this.creditCard[20].setCustomer(this.customerRef[14]);
            this.getEntityManager().merge((Object)this.creditCard[20]);
            this.doFlush();
            this.orderRef[17].setCustomer(this.customerRef[15]);
            this.getEntityManager().merge((Object)this.orderRef[17]);
            this.creditCard[21].setCustomer(this.customerRef[15]);
            this.getEntityManager().merge((Object)this.creditCard[21]);
            this.doFlush();
            this.orderRef[18].setCustomer(this.customerRef[16]);
            this.getEntityManager().merge((Object)this.orderRef[18]);
            this.creditCard[22].setCustomer(this.customerRef[16]);
            this.getEntityManager().merge((Object)this.creditCard[22]);
            this.doFlush();
            this.orderRef[19].setCustomer(this.customerRef[17]);
            this.getEntityManager().merge((Object)this.orderRef[19]);
            this.creditCard[23].setCustomer(this.customerRef[17]);
            this.getEntityManager().merge((Object)this.creditCard[23]);
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createOrderData failed:", e);
        }
    }

    public void createDepartmentEmployeeData() throws Exception {
        this.logTrace("createDepartmentEmployeeData");
        this.getEntityTransaction().begin();
        try {
            this.logTrace("Create 2 Departments");
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            this.logTrace("Start to persist departments ");
            for (Department dept : this.deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department " + dept.getName());
            }
            this.logTrace("Create 5 employees");
            this.empRef[0] = new Employee(1, "Alan", "Frechette");
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette");
            this.empRef[1].setDepartment(this.deptRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan");
            this.empRef[2].setDepartment(this.deptRef[0]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett");
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla");
            this.empRef[4].setDepartment(this.deptRef[0]);
            HashMap<String, Employee> link = new HashMap<String, Employee>();
            link.put(this.empRef[0].getLastName(), this.empRef[0]);
            link.put(this.empRef[2].getLastName(), this.empRef[2]);
            link.put(this.empRef[4].getLastName(), this.empRef[4]);
            this.deptRef[0].setLastNameEmployees(link);
            HashMap<String, Employee> link1 = new HashMap<String, Employee>();
            link1.put(this.empRef[1].getLastName(), this.empRef[1]);
            link1.put(this.empRef[3].getLastName(), this.empRef[3]);
            this.deptRef[1].setLastNameEmployees(link1);
            this.logTrace("Start to persist employees ");
            for (Employee emp : this.empRef) {
                if (emp == null) continue;
                this.getEntityManager().persist((Object)emp);
                this.logTrace("persisted employee " + emp.getId());
            }
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createDepartmentEmployeeData failed:", e);
        }
    }

    public void createPhoneData() throws Exception {
        this.logTrace("createPhoneData");
        this.getEntityTransaction().begin();
        try {
            this.phone[0] = new Phone("1", "617", "664-8122", this.address[0]);
            this.phone[1] = new Phone("2", "781", "442-8122", this.address[1]);
            this.phone[2] = new Phone("3", "508", "662-7117", this.address[2]);
            this.phone[3] = new Phone("4", "781", "442-4488", this.address[3]);
            this.phone[4] = new Phone("5", "992", "223-8888", this.address[4]);
            this.phone[5] = new Phone("6", "781", "442-1134", this.address[5]);
            this.phone[6] = new Phone("7", "442", "883-1597", this.address[6]);
            this.phone[7] = new Phone("8", "781", "442-6699", this.address[7]);
            this.phone[8] = new Phone("9", "603", "777-7890", this.address[8]);
            this.phone[9] = new Phone("10", "781", "442-2323", this.address[9]);
            this.phone[10] = new Phone("11", "603", "889-2355", this.address[10]);
            this.phone[11] = new Phone("12", "781", "442-9876", this.address[11]);
            this.phone[12] = new Phone("13", "222", "767-3124", this.address[12]);
            this.phone[13] = new Phone("14", "781", "442-1111", this.address[13]);
            this.phone[14] = new Phone("15", "222", "767-8898", this.address[14]);
            this.phone[15] = new Phone("16", "781", "442-4444", this.address[15]);
            this.phone[16] = new Phone("17", null, "564-9087", this.address[16]);
            this.phone[17] = new Phone("18", "781", "442-5341", this.address[17]);
            this.phone[18] = new Phone("19", null, null, this.address[18]);
            this.phone[19] = new Phone("20", "781", "442-1585", this.address[19]);
            this.phone[20] = new Phone("21", "207", "532-6354", this.address[20]);
            this.phone[21] = new Phone("22", "781", "442-0845", this.address[21]);
            this.phone[22] = new Phone("23", "913", null, this.address[22]);
            this.phone[23] = new Phone("24", "781", "442-7465", this.address[23]);
            this.phone[24] = new Phone("25", "678", "663-6091", this.address[24]);
            this.phone[25] = new Phone("26", "781", "442-2139", this.address[25]);
            this.phone[26] = new Phone("27", "890", "670-9138", this.address[26]);
            this.phone[27] = new Phone("28", "781", "442-0230", this.address[27]);
            this.phone[28] = new Phone("29", "450", "876-9087", this.address[28]);
            this.phone[29] = new Phone("30", "781", "442-6766", this.address[29]);
            this.phone[30] = new Phone("31", "908", "458-0980", this.address[30]);
            this.phone[31] = new Phone("32", "781", "442-6251", this.address[31]);
            this.phone[32] = new Phone("33", "432", "435-0909", this.address[32]);
            this.phone[33] = new Phone("34", "781", "442-8790", this.address[33]);
            this.phone[34] = new Phone("35", "415", "355-9008", this.address[34]);
            this.phone[35] = new Phone("36", "781", "442-2879", this.address[35]);
            for (Phone p : this.phone) {
                if (p == null) continue;
                this.getEntityManager().persist((Object)p);
                this.logTrace("persisting phone " + p);
                this.doFlush();
            }
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("createPhoneData failed:", e);
        }
    }

    public void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM FKS_ANOOP_CNOOP").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM FKS_ALIAS_CUSTOMER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ALIAS_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CREDITCARD_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM SPOUSE_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INFO_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONE_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("UPDATE ORDER_TABLE SET FK4_FOR_CUSTOMER_TABLE= NULL").executeUpdate();
            this.getEntityManager().createNativeQuery("UPDATE LINEITEM_TABLE SET FK_FOR_PRODUCT_TABLE= NULL, FK1_FOR_ORDER_TABLE=NULL").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUSTOMER_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ORDER_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM LINEITEM_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM TRIM_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CRITERIA_TEST_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
            this.logTrace("done removeTestData");
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("PMClientBase.setup");
        this.myProps = p;
        this.persistenceUnitName = p.getProperty("persistence.unit.name");
        this.logTrace("Persistence Unit Name =" + this.persistenceUnitName);
        this.secondPersistenceUnitName = p.getProperty("persistence.unit.name.2");
        this.logTrace("Second Persistence Unit Name =" + this.secondPersistenceUnitName);
        if ("jakartaEE".equalsIgnoreCase(p.getProperty("platform.mode"))) {
            this.logTrace("platform.mode is set to " + p.getProperty("platform.mode") + ", so tests are running in JakartaEE environment.");
        } else if ("standalone".equalsIgnoreCase(p.getProperty("platform.mode"))) {
            this.logTrace("platform.mode is set to " + p.getProperty("platform.mode") + ", so tests are running in J2SE environment standalone mode.persistence.unit.name is set to " + this.persistenceUnitName);
        } else {
            this.logMsg("WARNING: platform.mode is set to " + p.getProperty("platform.mode") + ", an invalid value.");
        }
        this.cachingSupported = Boolean.parseBoolean(p.getProperty("persistence.second.level.caching.supported", "true"));
        this.displayProperties(p);
    }

    public void setupProductData(String[] args, Properties p) throws Exception {
        this.logTrace("setupProductData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createProductData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupProductData failed:", e);
        }
    }

    public void setupTrimData(String[] args, Properties p) throws Exception {
        this.logTrace("setupTrimData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTrimData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupTrimData failed:", e);
        }
    }

    public void setupCustomerData(String[] args, Properties p) throws Exception {
        this.logTrace("setupCustomerData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createCustomerData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupCustomerData failed:", e);
        }
    }

    public void setupAliasData(String[] args, Properties p) throws Exception {
        this.logTrace("setupAliasData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createCustomerData();
            this.createAliasData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupAliasData failed:", e);
        }
    }

    public void setupAliasOnlyData(String[] args, Properties p) throws Exception {
        this.logTrace("setupAliasOnlyData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createAliasOnlyData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupAliasOnlyData failed:", e);
        }
    }

    public void setupDepartmentEmployeeData(String[] args, Properties p) throws Exception {
        this.logTrace("setupDepartmentEmployeeData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createDepartmentEmployeeData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupDepartmentEmployeeData failed:", e);
        }
    }

    public void setupPhoneData(String[] args, Properties p) throws Exception {
        this.logTrace("setupPhoneData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createCustomerData();
            this.createPhoneData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupCustomerData failed:", e);
        }
    }

    public void setupOrderData(String[] args, Properties p) throws Exception {
        this.logTrace("setupOrderData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createCustomerData();
            this.createProductData();
            this.createOrderData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupCustomerData failed:", e);
        }
    }
}

