/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.StringBeanMessageHandler;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnError;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/annotatedtext", decoders={StringBeanTextDecoder.class})
public class WSCAnnotatedTextServerEndpoint {
    private static final System.Logger logger = System.getLogger(WSCAnnotatedTextServerEndpoint.class.getName());

    @OnOpen
    public void onOpen(Session session) {
        session.addMessageHandler(StringBean.class, (MessageHandler.Whole)new StringBeanMessageHandler(session));
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }
}

